/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.algorithm.sequence;

import oracle.javatools.compare.CompareDifference;
import oracle.javatools.compare.ContributorKind;

public class DifferenceBlock
extends CompareDifference {
    public static final int TYPE_NOCHANGE = 0;
    public static final int TYPE_CHANGE = 2;
    protected int _firstStart;
    protected int _firstLength;
    protected int _secondStart;
    protected int _secondLength;
    protected int _ancestorStart;
    protected int _ancestorLength;
    int _kind;
    private Object _id;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        $assertionsDisabled = DifferenceBlock.class.desiredAssertionStatus() ^ true;
    }

    public DifferenceBlock(int n) {
        this.setKind(n);
    }

    void setKind(int n) {
        this._kind = n;
    }

    public int getKind() {
        return this._kind;
    }

    public void setId(Object object) {
        this._id = object;
    }

    public Object getId() {
        return this._id;
    }

    public boolean isAddition(ContributorKind contributorKind, ContributorKind contributorKind2) {
        return this.getKind() == 2 && this.getLength(contributorKind) == 0 && this.getLength(contributorKind2) > 0;
    }

    public boolean isRemoval(ContributorKind contributorKind, ContributorKind contributorKind2) {
        return this.getKind() == 2 && this.getLength(contributorKind) > 0 && this.getLength(contributorKind2) == 0;
    }

    public boolean isChange(ContributorKind contributorKind, ContributorKind contributorKind2) {
        return this.getKind() == 2 && this.getLength(contributorKind) > 0 && this.getLength(contributorKind2) > 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Kind=");
        stringBuffer.append(this._kind == 2 ? "TYPE_CHANGE" : "TYPE_NOCHANGE");
        stringBuffer.append("; Id=");
        stringBuffer.append(this._id);
        stringBuffer.append("; 1 Start=");
        stringBuffer.append(String.valueOf(this.getStart(ContributorKind.FIRST)));
        stringBuffer.append("; 1 Length=");
        stringBuffer.append(String.valueOf(this.getLength(ContributorKind.FIRST)));
        stringBuffer.append("; 2 Start=");
        stringBuffer.append(String.valueOf(this.getStart(ContributorKind.SECOND)));
        stringBuffer.append("; 2 Length=");
        stringBuffer.append(String.valueOf(this.getLength(ContributorKind.SECOND)));
        stringBuffer.append("; A Start=");
        stringBuffer.append(String.valueOf(this.getStart(ContributorKind.ANCESTOR)));
        stringBuffer.append("; A Length=");
        stringBuffer.append(String.valueOf(this.getLength(ContributorKind.ANCESTOR)));
        stringBuffer.append(";");
        return stringBuffer.toString();
    }

    public int getMaxLength() {
        return Math.max(Math.max(this._firstLength, this._secondLength), this._ancestorLength);
    }

    public void setFirstStart(int n) {
        this._firstStart = n;
    }

    public void setFirstLength(int n) {
        this._firstLength = n;
    }

    public void setSecondStart(int n) {
        this._secondStart = n;
    }

    public void setSecondLength(int n) {
        this._secondLength = n;
    }

    public void setAncestorStart(int n) {
        this._ancestorStart = n;
    }

    public void setAncestorLength(int n) {
        this._ancestorLength = n;
    }

    public int getStart(ContributorKind contributorKind) {
        if (contributorKind == ContributorKind.ANCESTOR) {
            return this._ancestorStart;
        }
        if (contributorKind == ContributorKind.FIRST) {
            return this._firstStart;
        }
        if (contributorKind == ContributorKind.SECOND) {
            return this._secondStart;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return -1;
    }

    public int getLength(ContributorKind contributorKind) {
        if (contributorKind == ContributorKind.ANCESTOR) {
            return this._ancestorLength;
        }
        if (contributorKind == ContributorKind.FIRST) {
            return this._firstLength;
        }
        if (contributorKind == ContributorKind.SECOND) {
            return this._secondLength;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return -1;
    }

    public Object clone() {
        DifferenceBlock differenceBlock = new DifferenceBlock(this._kind);
        differenceBlock.setId(this._id);
        differenceBlock.setFirstStart(this._firstStart);
        differenceBlock.setFirstLength(this._firstLength);
        differenceBlock.setSecondStart(this._secondStart);
        differenceBlock.setSecondLength(this._secondLength);
        differenceBlock.setAncestorStart(this._ancestorStart);
        differenceBlock.setAncestorLength(this._ancestorLength);
        return differenceBlock;
    }
}

