/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.algorithm.sequence;

import java.util.ArrayList;
import oracle.javatools.compare.CompareAlgorithm;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareFailedException;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.algorithm.sequence.DifferenceBlock;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareContributor;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareModel;

public class SequenceCompareAlgorithm
implements CompareAlgorithm {
    public boolean canCompare(CompareContributor compareContributor, CompareContributor compareContributor2) {
        return compareContributor instanceof SequenceCompareContributor && compareContributor2 instanceof SequenceCompareContributor;
    }

    public CompareModel compare(CompareContributor compareContributor, CompareContributor compareContributor2) throws CompareFailedException {
        SequenceCompareContributor sequenceCompareContributor = (SequenceCompareContributor)compareContributor;
        SequenceCompareContributor sequenceCompareContributor2 = (SequenceCompareContributor)compareContributor2;
        DifferenceBlock[] differenceBlockArray = this.getDifferences(sequenceCompareContributor, sequenceCompareContributor2);
        if (differenceBlockArray == null) {
            throw new CompareFailedException("");
        }
        return new SequenceCompareModel(sequenceCompareContributor, sequenceCompareContributor2, differenceBlockArray);
    }

    private void dumpBlocks(DifferenceBlock[] differenceBlockArray) {
        int n = 0;
        while (n < differenceBlockArray.length) {
            DifferenceBlock differenceBlock = differenceBlockArray[n];
            System.err.println(n + ": " + differenceBlock._kind + " (" + differenceBlock._firstStart + ", " + differenceBlock._firstLength + " ) => (" + differenceBlock._secondStart + ", " + differenceBlock._secondLength + " )");
            ++n;
        }
    }

    protected DifferenceBlock[] getDifferences(SequenceCompareContributor sequenceCompareContributor, SequenceCompareContributor sequenceCompareContributor2) {
        int n;
        int n2 = sequenceCompareContributor2.getLength();
        int n3 = sequenceCompareContributor.getLength();
        if (n3 == n2 && n2 == 1) {
            if (!sequenceCompareContributor.equal(0, sequenceCompareContributor2, 0)) {
                DifferenceBlock[] differenceBlockArray = new DifferenceBlock[]{new DifferenceBlock(2)};
                differenceBlockArray[0].setFirstStart(0);
                differenceBlockArray[0].setFirstLength(1);
                differenceBlockArray[0].setSecondStart(0);
                differenceBlockArray[0].setSecondLength(1);
                return differenceBlockArray;
            }
            return new DifferenceBlock[0];
        }
        int n4 = 2 * Math.max(n2, n3);
        int n5 = n4 / 2;
        int[] nArray = new int[n4 + 1];
        LinkedDifferenceBlock[] linkedDifferenceBlockArray = new LinkedDifferenceBlock[n4 + 1];
        int n6 = 0;
        while (n6 < n2 && n6 < n3 && this.equal(sequenceCompareContributor2, n6, sequenceCompareContributor, n6)) {
            ++n6;
        }
        nArray[n5] = n6;
        linkedDifferenceBlockArray[n5] = null;
        int n7 = n6 == n2 ? n5 + 1 : n5 - 1;
        int n8 = n = n6 == n3 ? n5 - 1 : n5 + 1;
        if (n7 > n) {
            return new DifferenceBlock[0];
        }
        int n9 = 1;
        while (n9 < n4) {
            int n10 = n7;
            while (n10 <= n) {
                LinkedDifferenceBlock linkedDifferenceBlock;
                if (n10 == n5 - n9 || n10 != n5 + n9 && nArray[n10 + 1] >= nArray[n10 - 1]) {
                    n6 = nArray[n10 + 1] + 1;
                    linkedDifferenceBlock = new LinkedDifferenceBlock(linkedDifferenceBlockArray[n10 + 1], 1);
                } else {
                    n6 = nArray[n10 - 1];
                    linkedDifferenceBlock = new LinkedDifferenceBlock(linkedDifferenceBlockArray[n10 - 1], 0);
                }
                int n11 = n6 + n10 - n5;
                linkedDifferenceBlock.setLeftStart(n11);
                linkedDifferenceBlock.setRightStart(n6);
                linkedDifferenceBlockArray[n10] = linkedDifferenceBlock;
                while (n6 < n2 && n11 < n3 && this.equal(sequenceCompareContributor2, n6, sequenceCompareContributor, n11)) {
                    ++n6;
                    ++n11;
                }
                nArray[n10] = n6;
                if (n6 == n2 && n11 == n3) {
                    return this.coalesceDiffs(linkedDifferenceBlockArray[n10]);
                }
                if (n6 == n2) {
                    n7 = n10 + 2;
                }
                if (n11 == n3) {
                    n = n10 - 2;
                }
                n10 += 2;
            }
            --n7;
            ++n;
            ++n9;
        }
        return null;
    }

    private void dumpBlocks(LinkedDifferenceBlock linkedDifferenceBlock) {
        do {
            System.err.print(linkedDifferenceBlock.getKind() == 0 ? "INS: (" : "DEL: (");
            System.err.print(LinkedDifferenceBlock.ra$_firstStart(linkedDifferenceBlock) + ", " + LinkedDifferenceBlock.ra$_secondStart(linkedDifferenceBlock));
            System.err.println(")");
        } while ((linkedDifferenceBlock = LinkedDifferenceBlock.ra$_next(linkedDifferenceBlock)) != null);
    }

    private DifferenceBlock[] coalesceDiffs(LinkedDifferenceBlock linkedDifferenceBlock) {
        LinkedDifferenceBlock linkedDifferenceBlock2 = this.reverse(linkedDifferenceBlock);
        ArrayList<DifferenceBlock> arrayList = new ArrayList<DifferenceBlock>();
        DifferenceBlock differenceBlock = null;
        while (linkedDifferenceBlock2 != null) {
            differenceBlock = new DifferenceBlock(2);
            if (LinkedDifferenceBlock.ra$_kind(linkedDifferenceBlock2) == 0) {
                differenceBlock._secondStart = LinkedDifferenceBlock.ra$_secondStart(linkedDifferenceBlock2) + 1;
                differenceBlock._firstStart = LinkedDifferenceBlock.ra$_firstStart(linkedDifferenceBlock2);
                LinkedDifferenceBlock linkedDifferenceBlock3 = linkedDifferenceBlock2;
                do {
                    linkedDifferenceBlock2 = linkedDifferenceBlock2.getNext();
                    ++differenceBlock._firstLength;
                } while (linkedDifferenceBlock2 != null && LinkedDifferenceBlock.ra$_kind(linkedDifferenceBlock2) == 0 && LinkedDifferenceBlock.ra$_secondStart(linkedDifferenceBlock2) == LinkedDifferenceBlock.ra$_secondStart(linkedDifferenceBlock3));
            } else {
                boolean bl;
                differenceBlock._secondStart = LinkedDifferenceBlock.ra$_secondStart(linkedDifferenceBlock2);
                differenceBlock._firstStart = LinkedDifferenceBlock.ra$_firstStart(linkedDifferenceBlock2);
                LinkedDifferenceBlock linkedDifferenceBlock4 = linkedDifferenceBlock2;
                do {
                    linkedDifferenceBlock4 = linkedDifferenceBlock2;
                    linkedDifferenceBlock2 = linkedDifferenceBlock2.getNext();
                    ++differenceBlock._secondLength;
                } while (linkedDifferenceBlock2 != null && LinkedDifferenceBlock.ra$_kind(linkedDifferenceBlock2) == 1 && LinkedDifferenceBlock.ra$_secondStart(linkedDifferenceBlock2) == LinkedDifferenceBlock.ra$_secondStart(linkedDifferenceBlock4) + 1);
                boolean bl2 = bl = linkedDifferenceBlock2 != null && LinkedDifferenceBlock.ra$_kind(linkedDifferenceBlock2) == 0 && LinkedDifferenceBlock.ra$_secondStart(linkedDifferenceBlock2) == LinkedDifferenceBlock.ra$_secondStart(linkedDifferenceBlock4);
                if (bl) {
                    LinkedDifferenceBlock linkedDifferenceBlock5 = linkedDifferenceBlock2;
                    do {
                        linkedDifferenceBlock2 = linkedDifferenceBlock2.getNext();
                        ++differenceBlock._firstLength;
                    } while (linkedDifferenceBlock2 != null && LinkedDifferenceBlock.ra$_kind(linkedDifferenceBlock2) == 0 && LinkedDifferenceBlock.ra$_secondStart(linkedDifferenceBlock2) == LinkedDifferenceBlock.ra$_secondStart(linkedDifferenceBlock5));
                } else {
                    differenceBlock._firstLength = 0;
                }
                ++differenceBlock._firstStart;
            }
            --differenceBlock._secondStart;
            --differenceBlock._firstStart;
            arrayList.add(differenceBlock);
        }
        return arrayList.toArray(new DifferenceBlock[0]);
    }

    private LinkedDifferenceBlock reverse(LinkedDifferenceBlock linkedDifferenceBlock) {
        LinkedDifferenceBlock linkedDifferenceBlock2 = linkedDifferenceBlock;
        LinkedDifferenceBlock linkedDifferenceBlock3 = null;
        while (linkedDifferenceBlock2 != null) {
            LinkedDifferenceBlock linkedDifferenceBlock4 = linkedDifferenceBlock3;
            linkedDifferenceBlock3 = linkedDifferenceBlock2;
            linkedDifferenceBlock2 = linkedDifferenceBlock2.getNext();
            linkedDifferenceBlock3.setNext(linkedDifferenceBlock4);
        }
        return linkedDifferenceBlock3;
    }

    private boolean equal(SequenceCompareContributor sequenceCompareContributor, int n, SequenceCompareContributor sequenceCompareContributor2, int n2) {
        return sequenceCompareContributor.equal(n, sequenceCompareContributor2, n2);
    }

    private class LinkedDifferenceBlock {
        public static final int INSERT = 0;
        public static final int DELETE = 1;
        private LinkedDifferenceBlock _next;
        private int _kind;
        private int _firstStart;
        private int _secondStart;

        LinkedDifferenceBlock() {
        }

        LinkedDifferenceBlock(LinkedDifferenceBlock linkedDifferenceBlock, int n) {
            this._kind = n;
            this._next = linkedDifferenceBlock;
        }

        int getKind() {
            return this._kind;
        }

        void setKind(int n) {
            this._kind = n;
        }

        void setLeftStart(int n) {
            this._firstStart = n;
        }

        void setRightStart(int n) {
            this._secondStart = n;
        }

        LinkedDifferenceBlock getNext() {
            return this._next;
        }

        void setNext(LinkedDifferenceBlock linkedDifferenceBlock) {
            this._next = linkedDifferenceBlock;
        }

        static int ra$_kind(LinkedDifferenceBlock linkedDifferenceBlock) {
            return linkedDifferenceBlock._kind;
        }

        static int ra$_secondStart(LinkedDifferenceBlock linkedDifferenceBlock) {
            return linkedDifferenceBlock._secondStart;
        }

        static int ra$_firstStart(LinkedDifferenceBlock linkedDifferenceBlock) {
            return linkedDifferenceBlock._firstStart;
        }

        static LinkedDifferenceBlock ra$_next(LinkedDifferenceBlock linkedDifferenceBlock) {
            return linkedDifferenceBlock._next;
        }
    }
}

