/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.algorithm.sequence;

import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareDifference;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareType;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.algorithm.sequence.DifferenceBlock;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareContributor;

public class SequenceCompareModel
implements CompareModel {
    private CompareType _type;
    private final SequenceCompareContributor first;
    private final SequenceCompareContributor second;
    private DifferenceBlock[] differences;

    public SequenceCompareModel(SequenceCompareContributor sequenceCompareContributor, SequenceCompareContributor sequenceCompareContributor2, DifferenceBlock[] differenceBlockArray) {
        this.first = sequenceCompareContributor;
        this.second = sequenceCompareContributor2;
        this.differences = differenceBlockArray;
    }

    public void setType(CompareType compareType) {
        this._type = compareType;
    }

    public CompareType getType() {
        return this._type;
    }

    public CompareContributor getContributor(ContributorKind contributorKind) {
        if (contributorKind == ContributorKind.FIRST) {
            return this.first;
        }
        if (contributorKind == ContributorKind.SECOND) {
            return this.second;
        }
        if (contributorKind == ContributorKind.ANCESTOR) {
            return null;
        }
        throw new IllegalArgumentException();
    }

    public CompareDifference[] getDifferences() {
        return this.getDifferenceBlocks();
    }

    public DifferenceBlock[] getDifferenceBlocks() {
        return this.differences;
    }

    public int[] getDifferenceTypeCounts() {
        ContributorKind contributorKind = ContributorKind.FIRST;
        ContributorKind contributorKind2 = ContributorKind.SECOND;
        int[] nArray = new int[3];
        int n = this.differences.length;
        int n2 = 0;
        while (n2 < n) {
            DifferenceBlock differenceBlock = this.differences[n2];
            if (differenceBlock.isAddition(contributorKind, contributorKind2)) {
                nArray[0] = nArray[0] + 1;
            }
            if (differenceBlock.isRemoval(contributorKind, contributorKind2)) {
                nArray[1] = nArray[1] + 1;
            }
            if (differenceBlock.isChange(contributorKind, contributorKind2)) {
                nArray[2] = nArray[2] + 1;
            }
            ++n2;
        }
        return nArray;
    }

    public int getDifferenceCount() {
        return this.differences.length;
    }

    public int getConflictCount() {
        return 0;
    }

    public int getResolvedCount() {
        return 0;
    }
}

