/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.algorithm.text;

import java.util.ArrayList;
import java.util.Collection;
import oracle.javatools.compare.CompareFailedException;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.algorithm.sequence.DifferenceBlock;
import oracle.javatools.compare.algorithm.text.TextCompareAlgorithm;
import oracle.javatools.compare.algorithm.text.TextCompareContributor;
import oracle.javatools.compare.algorithm.text.TextCompareModel;
import oracle.javatools.compare.algorithm.text.TextLineContributor;

public final class InlineCompareModel {
    private Collection _matchedLines;

    public static InlineCompareModel buildModel(TextCompareModel textCompareModel, DifferenceBlock differenceBlock) throws CompareFailedException {
        InlineCompareModel inlineCompareModel = new InlineCompareModel();
        if (differenceBlock.getLength(ContributorKind.FIRST) == differenceBlock.getLength(ContributorKind.SECOND)) {
            inlineCompareModel.buildTrivialModel(textCompareModel, differenceBlock);
        } else {
            inlineCompareModel.buildLineMatchedModel(textCompareModel, differenceBlock);
        }
        return inlineCompareModel;
    }

    private void buildLineMatchedModel(TextCompareModel textCompareModel, DifferenceBlock differenceBlock) throws CompareFailedException {
        int n = differenceBlock.getStart(ContributorKind.FIRST);
        int n2 = differenceBlock.getStart(ContributorKind.SECOND);
        this._matchedLines = new ArrayList();
        int n3 = n;
        while (n3 < n + differenceBlock.getLength(ContributorKind.FIRST)) {
            MatchedLine matchedLine = null;
            int n4 = n2;
            while (n4 < n2 + differenceBlock.getLength(ContributorKind.SECOND)) {
                matchedLine = this.findMatch(textCompareModel, n3, n4);
                if (matchedLine != null) {
                    this._matchedLines.add(matchedLine);
                    n2 = n4 + 1;
                    break;
                }
                ++n4;
            }
            ++n3;
        }
    }

    private MatchedLine findMatch(TextCompareModel textCompareModel, int n, int n2) throws CompareFailedException {
        TextCompareAlgorithm textCompareAlgorithm = new TextCompareAlgorithm();
        TextLineContributor textLineContributor = this.createContributor(textCompareModel, ContributorKind.FIRST, n);
        TextLineContributor textLineContributor2 = this.createContributor(textCompareModel, ContributorKind.SECOND, n2);
        if (textLineContributor.getLength() <= 0 || textLineContributor2.getLength() <= 0) {
            return null;
        }
        TextCompareModel textCompareModel2 = (TextCompareModel)textCompareAlgorithm.compare(textLineContributor, textLineContributor2);
        int n3 = 0;
        int n4 = 0;
        DifferenceBlock[] differenceBlockArray = textCompareModel2.getDifferenceBlocks();
        int n5 = 0;
        while (n5 < differenceBlockArray.length) {
            DifferenceBlock differenceBlock = differenceBlockArray[n5];
            n3 += differenceBlock.getLength(ContributorKind.FIRST);
            n4 += differenceBlock.getLength(ContributorKind.SECOND);
            ++n5;
        }
        double d = (double)n3 / (double)textLineContributor.getLength();
        double d2 = (double)n4 / (double)textLineContributor2.getLength();
        if (d >= 0.5 || d2 >= 0.5) {
            return null;
        }
        return new MatchedLine(n, n2, differenceBlockArray);
    }

    private void buildTrivialModel(TextCompareModel textCompareModel, DifferenceBlock differenceBlock) throws CompareFailedException {
        int n = differenceBlock.getStart(ContributorKind.FIRST);
        int n2 = differenceBlock.getStart(ContributorKind.SECOND);
        TextCompareAlgorithm textCompareAlgorithm = new TextCompareAlgorithm();
        this._matchedLines = new ArrayList();
        int n3 = 0;
        while (n3 < differenceBlock.getLength(ContributorKind.FIRST)) {
            TextLineContributor textLineContributor = this.createContributor(textCompareModel, ContributorKind.FIRST, n += n3);
            TextLineContributor textLineContributor2 = this.createContributor(textCompareModel, ContributorKind.SECOND, n2 += n3);
            if (textLineContributor.getLength() > 0 && textLineContributor2.getLength() > 0) {
                TextCompareModel textCompareModel2 = (TextCompareModel)textCompareAlgorithm.compare(textLineContributor, textLineContributor2);
                this._matchedLines.add(new MatchedLine(n, n2, textCompareModel2.getDifferenceBlocks()));
            }
            ++n3;
        }
    }

    private TextLineContributor createContributor(TextCompareModel textCompareModel, ContributorKind contributorKind, int n) {
        return new TextLineContributor((TextCompareContributor)textCompareModel.getContributor(contributorKind), n);
    }

    public Collection getMatchedLines() {
        return this._matchedLines;
    }

    public static class MatchedLine {
        private int _firstContributorLine;
        private int _secondContributorLine;
        private DifferenceBlock[] _differences;

        MatchedLine(int n, int n2, DifferenceBlock[] differenceBlockArray) {
            this._firstContributorLine = n;
            this._secondContributorLine = n2;
            this._differences = differenceBlockArray;
        }

        public int getLine(ContributorKind contributorKind) {
            if (contributorKind == ContributorKind.FIRST) {
                return this._firstContributorLine;
            }
            return this._secondContributorLine;
        }

        public DifferenceBlock[] getDifferences() {
            return this._differences;
        }
    }
}

