/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.algorithm.text;

import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.algorithm.sequence.DifferenceBlock;

public class OffsetDifferenceBlock
extends DifferenceBlock {
    public static final int TYPE_NOCHANGE = 0;
    public static final int TYPE_CHANGE = 2;
    private final TextBuffer _firstTextBuffer;
    private final TextBuffer _secondTextBuffer;
    private final TextBuffer _ancestorTextBuffer;
    private OffsetMark _firstStartOffset;
    private OffsetMark _firstEndOffset;
    private OffsetMark _secondStartOffset;
    private OffsetMark _secondEndOffset;
    private OffsetMark _ancestorStartOffset;
    private OffsetMark _ancestorEndOffset;
    private boolean _resolved;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        $assertionsDisabled = OffsetDifferenceBlock.class.desiredAssertionStatus() ^ true;
    }

    public OffsetDifferenceBlock(int n, TextBuffer textBuffer, TextBuffer textBuffer2, TextBuffer textBuffer3) {
        super(n);
        this._firstTextBuffer = textBuffer;
        this._secondTextBuffer = textBuffer2;
        this._ancestorTextBuffer = textBuffer3;
        this._firstStart = -1;
        this._firstLength = -1;
        this._secondStart = -1;
        this._secondLength = -1;
        this._ancestorStart = -1;
        this._ancestorLength = -1;
    }

    public boolean isConflict() {
        return true;
    }

    public boolean isResolved() {
        return this._resolved;
    }

    public void setResolved(boolean bl) {
        this._resolved = bl;
    }

    public int getMaxLength() {
        return Math.max(Math.max(this.getLength(ContributorKind.FIRST), this.getLength(ContributorKind.SECOND)), this.getLength(ContributorKind.ANCESTOR));
    }

    public void evaluateOffets() {
        if (this._firstStartOffset == null && this._firstStart >= 0) {
            this._firstStartOffset = this._firstTextBuffer.addOffsetMark(this._firstTextBuffer.getLineMap().getLineStartOffset(this._firstStart), false);
        }
        if (this._firstEndOffset == null && this._firstStart >= 0 && this._firstLength >= 0) {
            this._firstEndOffset = this._firstTextBuffer.addOffsetMark(this._firstTextBuffer.getLineMap().getLineStartOffset(this._firstStart + this._firstLength), false);
        }
        if (this._secondStartOffset == null && this._secondStart >= 0) {
            this._secondStartOffset = this._secondTextBuffer.addOffsetMark(this._secondTextBuffer.getLineMap().getLineStartOffset(this._secondStart), false);
        }
        if (this._secondEndOffset == null && this._secondStart >= 0 && this._secondLength >= 0) {
            this._secondEndOffset = this._secondTextBuffer.addOffsetMark(this._secondTextBuffer.getLineMap().getLineStartOffset(this._secondStart + this._secondLength), false);
        }
        if (this._ancestorStartOffset == null && this._ancestorStart >= 0) {
            this._ancestorStartOffset = this._ancestorTextBuffer.addOffsetMark(this._ancestorTextBuffer.getLineMap().getLineStartOffset(this._ancestorStart), false);
        }
        if (this._ancestorEndOffset == null && this._ancestorStart >= 0 && this._ancestorLength >= 0) {
            this._ancestorEndOffset = this._ancestorTextBuffer.addOffsetMark(this._ancestorTextBuffer.getLineMap().getLineStartOffset(this._ancestorStart + this._ancestorLength), false);
        }
    }

    public void resetStart(ContributorKind contributorKind) {
        if (contributorKind == ContributorKind.ANCESTOR && this._ancestorStartOffset != null) {
            this._ancestorTextBuffer.removeOffsetMark(this._ancestorStartOffset);
            this._ancestorStartOffset = null;
        }
        if (contributorKind == ContributorKind.FIRST && this._secondStartOffset != null) {
            this._secondTextBuffer.removeOffsetMark(this._secondStartOffset);
            this._secondStartOffset = null;
        }
        if (contributorKind == ContributorKind.SECOND && this._firstStartOffset != null) {
            this._firstTextBuffer.removeOffsetMark(this._firstStartOffset);
            this._firstStartOffset = null;
        }
    }

    public void resetLength(ContributorKind contributorKind) {
        if (contributorKind == ContributorKind.ANCESTOR && this._ancestorEndOffset != null) {
            this._ancestorTextBuffer.removeOffsetMark(this._ancestorEndOffset);
            this._ancestorEndOffset = null;
        }
        if (contributorKind == ContributorKind.FIRST && this._secondEndOffset != null) {
            this._secondTextBuffer.removeOffsetMark(this._secondEndOffset);
            this._secondEndOffset = null;
        }
        if (contributorKind == ContributorKind.SECOND && this._firstEndOffset != null) {
            this._firstTextBuffer.removeOffsetMark(this._firstEndOffset);
            this._firstEndOffset = null;
        }
    }

    public void setStart(ContributorKind contributorKind, int n) {
        if (contributorKind == ContributorKind.ANCESTOR) {
            this.setAncestorStart(n);
        }
        if (contributorKind == ContributorKind.FIRST) {
            this.setFirstStart(n);
        }
        if (contributorKind == ContributorKind.SECOND) {
            this.setSecondStart(n);
        }
    }

    public void setLength(ContributorKind contributorKind, int n) {
        if (contributorKind == ContributorKind.ANCESTOR) {
            this.setAncestorLength(n);
        }
        if (contributorKind == ContributorKind.FIRST) {
            this.setFirstLength(n);
        }
        if (contributorKind == ContributorKind.SECOND) {
            this.setSecondLength(n);
        }
    }

    public int getStart(ContributorKind contributorKind) {
        if (contributorKind == ContributorKind.ANCESTOR) {
            return this._ancestorStartOffset != null ? this._ancestorTextBuffer.getLineMap().getLineFromOffset(this._ancestorStartOffset.getOffset()) : this._ancestorStart;
        }
        if (contributorKind == ContributorKind.FIRST) {
            return this._firstStartOffset != null ? this._firstTextBuffer.getLineMap().getLineFromOffset(this._firstStartOffset.getOffset()) : this._firstStart;
        }
        if (contributorKind == ContributorKind.SECOND) {
            return this._secondStartOffset != null ? this._secondTextBuffer.getLineMap().getLineFromOffset(this._secondStartOffset.getOffset()) : this._secondStart;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return -1;
    }

    public int getLength(ContributorKind contributorKind) {
        if (contributorKind == ContributorKind.ANCESTOR) {
            return this._ancestorEndOffset != null ? this._ancestorTextBuffer.getLineMap().getLineFromOffset(this._ancestorEndOffset.getOffset()) - this.getStart(ContributorKind.ANCESTOR) : this._ancestorLength;
        }
        if (contributorKind == ContributorKind.FIRST) {
            return this._firstEndOffset != null ? this._firstTextBuffer.getLineMap().getLineFromOffset(this._firstEndOffset.getOffset()) - this.getStart(ContributorKind.FIRST) : this._firstLength;
        }
        if (contributorKind == ContributorKind.SECOND) {
            return this._secondEndOffset != null ? this._secondTextBuffer.getLineMap().getLineFromOffset(this._secondEndOffset.getOffset()) - this.getStart(ContributorKind.SECOND) : this._secondLength;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return -1;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Kind=");
        stringBuffer.append(this.getKind() == 2 ? "TYPE_CHANGE" : "TYPE_NOCHANGE");
        stringBuffer.append("; Id=");
        stringBuffer.append(this.getId());
        stringBuffer.append("; 1 Start=");
        stringBuffer.append(String.valueOf(this.getStart(ContributorKind.FIRST)));
        stringBuffer.append("; 1 Length=");
        stringBuffer.append(String.valueOf(this.getLength(ContributorKind.FIRST)));
        stringBuffer.append("; 2 Start=");
        stringBuffer.append(String.valueOf(this.getStart(ContributorKind.SECOND)));
        stringBuffer.append("; 2 Length=");
        stringBuffer.append(String.valueOf(this.getLength(ContributorKind.SECOND)));
        stringBuffer.append("; A Start=");
        stringBuffer.append(String.valueOf(this.getStart(ContributorKind.ANCESTOR)));
        stringBuffer.append("; A Length=");
        stringBuffer.append(String.valueOf(this.getLength(ContributorKind.ANCESTOR)));
        stringBuffer.append("; Resolved=");
        stringBuffer.append(String.valueOf(this._resolved));
        stringBuffer.append(";");
        return stringBuffer.toString();
    }

    public Object clone() {
        OffsetDifferenceBlock offsetDifferenceBlock = new OffsetDifferenceBlock(this.getKind(), this._firstTextBuffer, this._secondTextBuffer, this._ancestorTextBuffer);
        offsetDifferenceBlock.setId(this.getId());
        offsetDifferenceBlock.setFirstStart(this.getStart(ContributorKind.FIRST));
        offsetDifferenceBlock.setFirstLength(this.getLength(ContributorKind.FIRST));
        offsetDifferenceBlock.setSecondStart(this.getStart(ContributorKind.SECOND));
        offsetDifferenceBlock.setSecondLength(this.getLength(ContributorKind.SECOND));
        offsetDifferenceBlock.setAncestorStart(this.getStart(ContributorKind.ANCESTOR));
        offsetDifferenceBlock.setAncestorLength(this.getLength(ContributorKind.ANCESTOR));
        offsetDifferenceBlock.setResolved(this._resolved);
        return offsetDifferenceBlock;
    }

    public static final OffsetDifferenceBlock[] createOffsetDifferenceBlocks(DifferenceBlock[] differenceBlockArray, TextBuffer textBuffer, TextBuffer textBuffer2, TextBuffer textBuffer3) {
        OffsetDifferenceBlock[] offsetDifferenceBlockArray = new OffsetDifferenceBlock[differenceBlockArray.length];
        int n = 0;
        while (n < offsetDifferenceBlockArray.length) {
            offsetDifferenceBlockArray[n] = new OffsetDifferenceBlock(differenceBlockArray[n].getKind(), textBuffer, textBuffer2, textBuffer3);
            offsetDifferenceBlockArray[n].setId(differenceBlockArray[n].getId());
            offsetDifferenceBlockArray[n].setFirstStart(differenceBlockArray[n].getStart(ContributorKind.FIRST));
            offsetDifferenceBlockArray[n].setFirstLength(differenceBlockArray[n].getLength(ContributorKind.FIRST));
            offsetDifferenceBlockArray[n].setSecondStart(differenceBlockArray[n].getStart(ContributorKind.SECOND));
            offsetDifferenceBlockArray[n].setSecondLength(differenceBlockArray[n].getLength(ContributorKind.SECOND));
            offsetDifferenceBlockArray[n].setAncestorStart(differenceBlockArray[n].getStart(ContributorKind.ANCESTOR));
            offsetDifferenceBlockArray[n].setAncestorLength(differenceBlockArray[n].getLength(ContributorKind.ANCESTOR));
            ++n;
        }
        return offsetDifferenceBlockArray;
    }
}

