/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.algorithm.text;

import java.awt.EventQueue;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.undo.UndoableEdit;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.compare.CompareHints;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.algorithm.sequence.DifferenceBlock;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareContributor;
import oracle.javatools.compare.algorithm.text.TextCompareElement;

public abstract class TextCompareContributor
extends SequenceCompareContributor {
    private List _changeListeners;
    private TextBufferListener _bufferListener;
    private Boolean _ignoreWhitespace;

    protected void addTextBufferListeners() {
        this._bufferListener = new 2();
        this.getTextBuffer().addTextBufferListener(this._bufferListener);
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this._changeListeners == null) {
            this._changeListeners = new ArrayList();
        }
        this._changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (this._changeListeners != null) {
            this._changeListeners.remove(changeListener);
        }
    }

    protected void fireChangeEvent() {
        if (this._changeListeners != null) {
            ChangeEvent changeEvent = null;
            Iterator iterator = this._changeListeners.iterator();
            while (iterator.hasNext()) {
                if (changeEvent == null) {
                    changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)iterator.next()).stateChanged(changeEvent);
            }
        }
    }

    public final void setIgnoreWhitespace(boolean bl) {
        this._ignoreWhitespace = new Boolean(bl);
    }

    public final boolean getIgnoreWhitespace() {
        if (this._ignoreWhitespace != null) {
            return this._ignoreWhitespace;
        }
        return CompareHints.isIgnoreWhiteSpace();
    }

    public abstract TextBuffer getTextBuffer();

    public int getLength() {
        this.getTextBuffer().readLock();
        try {
            if (this.getTextBuffer().getLength() == 0) {
                int n = 0;
                this.getTextBuffer().readUnlock();
                return n;
            }
            int n = this.getTextBuffer().getLineMap().getLineCount();
            this.getTextBuffer().readUnlock();
            return n;
        }
        catch (Throwable throwable) {
            this.getTextBuffer().readUnlock();
            throw throwable;
        }
    }

    public boolean equal(int n, SequenceCompareContributor sequenceCompareContributor, int n2) {
        TextCompareContributor textCompareContributor = (TextCompareContributor)sequenceCompareContributor;
        int n3 = this.getTextBuffer().getLineMap().getLineStartOffset(n);
        int n4 = textCompareContributor.getTextBuffer().getLineMap().getLineStartOffset(n2);
        int n5 = this.getTextBuffer().getLineMap().getLineEndOffset(n);
        int n6 = textCompareContributor.getTextBuffer().getLineMap().getLineEndOffset(n2);
        n5 = Math.min(n5, this.getTextBuffer().getLength());
        n6 = Math.min(n6, textCompareContributor.getTextBuffer().getLength());
        if (!this.getIgnoreWhitespace() && n6 - n4 != n5 - n3) {
            boolean bl = false;
            return bl;
        }
        int n7 = n3;
        int n8 = n4;
        while (n7 < n5 || n8 < n6) {
            char c;
            char c2 = n7 < n5 ? this.getTextBuffer().getChar(n7) : (char)'\u0000';
            char c3 = c = n8 < n6 ? textCompareContributor.getTextBuffer().getChar(n8) : (char)'\u0000';
            if (this.getIgnoreWhitespace()) {
                if (TextCompareContributor.isWhitespace(c2)) {
                    ++n7;
                    continue;
                }
                if (TextCompareContributor.isWhitespace(c)) {
                    ++n8;
                    continue;
                }
            }
            if (c2 != c) {
                boolean bl = false;
                return bl;
            }
            ++n7;
            ++n8;
        }
        boolean bl = true;
        return bl;
    }

    private static final boolean isWhitespace(char c) {
        return c == ' ' || c == '\t';
    }

    public TextCompareElement getElement(DifferenceBlock differenceBlock, ContributorKind contributorKind) {
        int n = this.getTextBuffer().getLineMap().getLineStartOffset(differenceBlock.getStart(contributorKind));
        int n2 = this.getTextBuffer().getLineMap().getLineEndOffset(differenceBlock.getStart(contributorKind) + differenceBlock.getLength(contributorKind) - 1);
        char[] cArray = this.getTextBuffer().getChars(n, n2 - n);
        return new 1(this, cArray);
    }

    public UndoableEdit deleteElement(int n, int n2) {
        int n3 = this.getTextBuffer().getLineMap().getLineStartOffset(n);
        int n4 = this.getTextBuffer().getLineMap().getLineEndOffset(n2);
        this.getTextBuffer().remove(n3, n4 - n3);
        return null;
    }

    public UndoableEdit insertElement(int n, boolean bl, TextCompareElement textCompareElement) {
        int n2 = !bl ? this.getTextBuffer().getLineMap().getLineStartOffset(n) : this.getTextBuffer().getLineMap().getLineEndOffset(n);
        this.getTextBuffer().insert(n2, textCompareElement.getChars());
        return null;
    }

    public UndoableEdit replaceElement(int n, int n2, TextCompareElement textCompareElement) {
        int n3 = this.getTextBuffer().getLineMap().getLineStartOffset(n);
        int n4 = this.getTextBuffer().getLineMap().getLineEndOffset(n2);
        this.getTextBuffer().remove(n3, n4 - n3);
        this.getTextBuffer().insert(n3, textCompareElement.getChars());
        return null;
    }

    static PropertyChangeSupport mav$getPropertyChangeSupport(TextCompareContributor textCompareContributor) {
        return textCompareContributor.getPropertyChangeSupport();
    }

    public final class 2
    implements TextBufferListener {
        public void attributeUpdate(TextBuffer textBuffer, int n) {
            if (n != 5) {
                return;
            }
            if (TextCompareContributor.mav$getPropertyChangeSupport(TextCompareContributor.this) == null) {
                return;
            }
            boolean bl = TextCompareContributor.this.getTextBuffer().isModified();
            this.firePropertyChange("modified", bl ^ true, bl);
        }

        private void firePropertyChange(String string, Object object, Object object2) {
            if (!EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(new 1(this, string, object, object2));
                return;
            }
            TextCompareContributor.mav$getPropertyChangeSupport(TextCompareContributor.this).firePropertyChange(string, object, object2);
        }

        public void removeUpdate(TextBuffer textBuffer, int n, int n2, char[] cArray) {
            TextCompareContributor.this.fireChangeEvent();
        }

        public void insertUpdate(TextBuffer textBuffer, int n, int n2, char[] cArray) {
            TextCompareContributor.this.fireChangeEvent();
        }

        static void mav$firePropertyChange(2 var0, String string, Object object, Object object2) {
            var0.firePropertyChange(string, object, object2);
        }

        public final class 1
        implements Runnable {
            private final /* synthetic */ String v$propertyName;
            private final /* synthetic */ Object v$oldValue;
            private final /* synthetic */ Object v$newValue;
            final /* synthetic */ 2 this$0;

            public void run() {
                2.mav$firePropertyChange(this.this$0, this.v$propertyName, this.v$oldValue, this.v$newValue);
            }

            public 1(2 var1_1, String string, Object object, Object object2) {
                this.v$newValue = object2;
                this.v$oldValue = object;
                this.v$propertyName = string;
                this.this$0 = var1_1;
            }
        }
    }

    public final class 1
    extends TextCompareElement {
        private final /* synthetic */ char[] v$chars;
        final /* synthetic */ TextCompareContributor this$0;

        public char[] getChars() {
            return this.v$chars;
        }

        public 1(TextCompareContributor textCompareContributor, char[] cArray) {
            this.v$chars = cArray;
            this.this$0 = textCompareContributor;
        }
    }
}

