/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.algorithm.text;

import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareDifference;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareType;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.algorithm.sequence.DifferenceBlock;
import oracle.javatools.compare.algorithm.text.OffsetDifferenceBlock;

public class TextCompareModel
implements CompareModel {
    private CompareType _type;
    private final CompareContributor _firstContributor;
    private final CompareContributor _secondContributor;
    private final CompareContributor _ancestor;
    private DifferenceBlock[] _differences;

    public TextCompareModel(CompareContributor compareContributor, CompareContributor compareContributor2, DifferenceBlock[] differenceBlockArray) {
        this(compareContributor, compareContributor2, null, differenceBlockArray);
    }

    public TextCompareModel(CompareContributor compareContributor, CompareContributor compareContributor2, CompareContributor compareContributor3, DifferenceBlock[] differenceBlockArray) {
        this._firstContributor = compareContributor;
        this._secondContributor = compareContributor2;
        this._ancestor = compareContributor3;
        this._differences = differenceBlockArray;
    }

    public void setType(CompareType compareType) {
        this._type = compareType;
    }

    public CompareType getType() {
        return this._type;
    }

    public TextCompareModel createInstance(DifferenceBlock[] differenceBlockArray) {
        TextCompareModel textCompareModel = new TextCompareModel(this._firstContributor, this._secondContributor, this._ancestor, differenceBlockArray);
        textCompareModel.setType(this._type);
        return textCompareModel;
    }

    public CompareContributor getContributor(ContributorKind contributorKind) {
        if (contributorKind == ContributorKind.FIRST) {
            return this._firstContributor;
        }
        if (contributorKind == ContributorKind.SECOND) {
            return this._secondContributor;
        }
        if (contributorKind == ContributorKind.ANCESTOR) {
            return this._ancestor;
        }
        throw new IllegalArgumentException("Unknown contributor kind: " + contributorKind);
    }

    public int getDifferenceCount() {
        return this._differences.length;
    }

    public int[] getDifferenceTypeCounts() {
        int[] nArray = new int[3];
        int n = 0;
        while (n < this._differences.length) {
            DifferenceBlock differenceBlock = this._differences[n];
            if (differenceBlock.isAddition(ContributorKind.FIRST, ContributorKind.SECOND)) {
                nArray[0] = nArray[0] + 1;
            }
            if (differenceBlock.isRemoval(ContributorKind.FIRST, ContributorKind.SECOND)) {
                nArray[1] = nArray[1] + 1;
            }
            if (differenceBlock.isChange(ContributorKind.FIRST, ContributorKind.SECOND)) {
                nArray[2] = nArray[2] + 1;
            }
            ++n;
        }
        return nArray;
    }

    public CompareDifference[] getDifferences() {
        return this.getDifferenceBlocks();
    }

    public DifferenceBlock[] getDifferenceBlocks() {
        return this._differences;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this._differences.length) {
            stringBuffer.append("CB");
            stringBuffer.append(String.valueOf(n));
            stringBuffer.append(": ");
            stringBuffer.append(this._differences[n].toString());
            stringBuffer.append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    public int getConflictCount() {
        int n = 0;
        int n2 = 0;
        while (n2 < this._differences.length) {
            if (this._differences[n2].isConflict()) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public int getResolvedCount() {
        int n = 0;
        int n2 = 0;
        while (n2 < this._differences.length) {
            if (this._differences[n2].isResolved()) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public void evaluateOffsets() {
        int n = 0;
        while (n < this._differences.length) {
            if (this._differences[n] instanceof OffsetDifferenceBlock) {
                ((OffsetDifferenceBlock)this._differences[n]).evaluateOffets();
            }
            ++n;
        }
    }
}

