/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.algorithm.text;

import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareContributor;
import oracle.javatools.compare.algorithm.text.TextCompareContributor;

final class TextLineContributor
extends TextCompareContributor {
    private final int _line;
    private final TextBuffer _buffer;

    TextLineContributor(TextCompareContributor textCompareContributor, int n) {
        this._buffer = textCompareContributor.getTextBuffer();
        this._line = n;
    }

    public String toString() {
        try {
            this.getTextBuffer().readLock();
            int n = this.getTextBuffer().getLineMap().getLineStartOffset(this.getLineNumber());
            String string = new String(this.getTextBuffer().getChars(n, this.getLength()));
            this.getTextBuffer().readUnlock();
            return string;
        }
        catch (Throwable throwable) {
            this.getTextBuffer().readUnlock();
            throw throwable;
        }
    }

    public int getLength() {
        this.getTextBuffer().readLock();
        try {
            int n = this.getTextBuffer().getLineMap().getLineEndOffset(this.getLineNumber());
            if (this.getTextBuffer().getChar(n - 1) == '\n') {
                --n;
            }
            int n2 = n - this.getTextBuffer().getLineMap().getLineStartOffset(this.getLineNumber());
            this.getTextBuffer().readUnlock();
            return n2;
        }
        catch (Throwable throwable) {
            this.getTextBuffer().readUnlock();
            throw throwable;
        }
    }

    public boolean equal(int n, SequenceCompareContributor sequenceCompareContributor, int n2) {
        TextLineContributor textLineContributor = (TextLineContributor)sequenceCompareContributor;
        this.getTextBuffer().readLock();
        textLineContributor.getTextBuffer().readLock();
        try {
            int n3 = n + this.getTextBuffer().getLineMap().getLineStartOffset(this.getLineNumber());
            int n4 = n2 + textLineContributor.getTextBuffer().getLineMap().getLineStartOffset(textLineContributor.getLineNumber());
            char c = this.getTextBuffer().getChar(n3);
            char c2 = textLineContributor.getTextBuffer().getChar(n4);
            boolean bl = c == c2;
            this.getTextBuffer().readUnlock();
            textLineContributor.getTextBuffer().readUnlock();
            return bl;
        }
        catch (Throwable throwable) {
            this.getTextBuffer().readUnlock();
            textLineContributor.getTextBuffer().readUnlock();
            throw throwable;
        }
    }

    public TextBuffer getTextBuffer() {
        return this._buffer;
    }

    private int getLineNumber() {
        return this._line;
    }
}

