/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.view.plain;

import java.awt.Component;
import javax.swing.Action;
import javax.swing.JScrollPane;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.compare.CompareMode;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareView;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.algorithm.sequence.DifferenceBlock;
import oracle.javatools.compare.algorithm.text.TextCompareContributor;
import oracle.javatools.compare.algorithm.text.TextCompareModel;
import oracle.javatools.compare.view.EditorPaneView;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.PopupManager;

public final class PlainCompareView
implements EditorPaneView,
CompareView {
    private final BasicEditorPane _editorPane;
    private CompareModel _model;
    private JScrollPane _scrollPane;

    void $init$() {
        this._editorPane = new BasicEditorPane();
        this._scrollPane = new JScrollPane(this._editorPane);
    }

    public PlainCompareView(CompareMode compareMode) {
        this.$init$();
        if (compareMode != CompareMode.TWO_WAY_COMPARE) {
            throw new IllegalArgumentException();
        }
        this._editorPane.setEditable(false);
    }

    public void setModel(CompareModel compareModel) {
        TextCompareModel textCompareModel = (TextCompareModel)compareModel;
        TextBuffer textBuffer = TextBufferFactory.createTextBuffer();
        String string = this.getChanges(textCompareModel);
        textBuffer.append(string.toCharArray());
        this._editorPane.setDocument(new BasicDocument(".txt", textBuffer));
        this._model = textCompareModel;
    }

    public CompareModel getModel() {
        return this._model;
    }

    public Component getGUI() {
        return this._scrollPane;
    }

    private String getChanges(TextCompareModel textCompareModel) {
        TextCompareContributor textCompareContributor = (TextCompareContributor)textCompareModel.getContributor(ContributorKind.FIRST);
        TextCompareContributor textCompareContributor2 = (TextCompareContributor)textCompareModel.getContributor(ContributorKind.SECOND);
        try {
            textCompareContributor.getTextBuffer().readLock();
            textCompareContributor2.getTextBuffer().readLock();
            LineMap lineMap = textCompareContributor.getTextBuffer().getLineMap();
            LineMap lineMap2 = textCompareContributor2.getTextBuffer().getLineMap();
            StringBuffer stringBuffer = new StringBuffer();
            DifferenceBlock[] differenceBlockArray = textCompareModel.getDifferenceBlocks();
            int n = 0;
            while (n < differenceBlockArray.length) {
                DifferenceBlock differenceBlock = differenceBlockArray[n];
                int n2 = differenceBlock.getStart(ContributorKind.FIRST) + 1;
                int n3 = differenceBlock.getStart(ContributorKind.FIRST) + differenceBlock.getLength(ContributorKind.FIRST);
                int n4 = differenceBlock.getStart(ContributorKind.SECOND) + 1;
                int n5 = differenceBlock.getStart(ContributorKind.SECOND) + differenceBlock.getLength(ContributorKind.SECOND);
                if (differenceBlock.isAddition(ContributorKind.FIRST, ContributorKind.SECOND) || n2 == n3) {
                    stringBuffer.append(String.valueOf(n3));
                } else {
                    PlainCompareView.appendRange(stringBuffer, n2, n3);
                }
                stringBuffer.append(PlainCompareView.getTypeChar(differenceBlock));
                if (differenceBlock.isRemoval(ContributorKind.FIRST, ContributorKind.SECOND) || n4 == n5) {
                    stringBuffer.append(String.valueOf(n5));
                } else {
                    PlainCompareView.appendRange(stringBuffer, n4, n5);
                }
                stringBuffer.append("\n");
                if (differenceBlock.isAddition(ContributorKind.FIRST, ContributorKind.SECOND)) {
                    PlainCompareView.appendLines(stringBuffer, lineMap2, differenceBlock.getStart(ContributorKind.SECOND), differenceBlock.getLength(ContributorKind.SECOND), '>');
                } else if (differenceBlock.isChange(ContributorKind.FIRST, ContributorKind.SECOND)) {
                    PlainCompareView.appendLines(stringBuffer, lineMap, differenceBlock.getStart(ContributorKind.FIRST), differenceBlock.getLength(ContributorKind.FIRST), '<');
                    stringBuffer.append("---\n");
                    PlainCompareView.appendLines(stringBuffer, lineMap2, differenceBlock.getStart(ContributorKind.SECOND), differenceBlock.getLength(ContributorKind.SECOND), '>');
                } else {
                    PlainCompareView.appendLines(stringBuffer, lineMap, differenceBlock.getStart(ContributorKind.FIRST), differenceBlock.getLength(ContributorKind.FIRST), '<');
                }
                ++n;
            }
            String string = stringBuffer.toString();
            textCompareContributor.getTextBuffer().readUnlock();
            textCompareContributor2.getTextBuffer().readUnlock();
            return string;
        }
        catch (Throwable throwable) {
            textCompareContributor.getTextBuffer().readUnlock();
            textCompareContributor2.getTextBuffer().readUnlock();
            throw throwable;
        }
    }

    private static void appendLines(StringBuffer stringBuffer, LineMap lineMap, int n, int n2, char c) {
        int n3 = n;
        while (n3 < n + n2) {
            stringBuffer.append(c);
            stringBuffer.append(" ");
            int n4 = lineMap.getLineStartOffset(n3);
            int n5 = lineMap.getLineEndOffset(n3);
            stringBuffer.append(lineMap.getTextBuffer().getChars(n4, n5 - n4));
            ++n3;
        }
    }

    private static void appendRange(StringBuffer stringBuffer, int n, int n2) {
        stringBuffer.append(String.valueOf(n));
        stringBuffer.append(",");
        stringBuffer.append(String.valueOf(n2));
    }

    private static char getTypeChar(DifferenceBlock differenceBlock) {
        if (differenceBlock.isAddition(ContributorKind.FIRST, ContributorKind.SECOND)) {
            return 'a';
        }
        if (differenceBlock.isChange(ContributorKind.FIRST, ContributorKind.SECOND)) {
            return 'c';
        }
        return 'd';
    }

    public void addPopupManager(PopupManager popupManager) {
    }

    public void removePopupManager(PopupManager popupManager) {
    }

    public BasicEditorPane[] getEditorPanes() {
        return new BasicEditorPane[]{this._editorPane};
    }

    public BasicEditorPane getCurrentEditorPane() {
        if (this._editorPane.hasFocus()) {
            return this._editorPane;
        }
        return null;
    }

    public Action[] getEditActions() {
        return null;
    }
}

