/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.view.wedge;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import javax.swing.UIManager;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.algorithm.sequence.DifferenceBlock;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareContributor;
import oracle.javatools.compare.algorithm.text.TextCompareModel;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.highlight.HighlightedText;
import oracle.javatools.editor.highlight.SimpleLinePainter;
import oracle.javatools.editor.plugins.EditorPlugin;

final class EditorHighlighter
implements EditorPlugin {
    private static final int HIGHLIGHT_STYLE_PRIORITY = 10;
    static final String ADDITION_HIGHLIGHT_STYLE = "compare-addition";
    static final String DELETION_HIGHLIGHT_STYLE = "compare-deletion";
    static final String UPDATE_HIGHLIGHT_STYLE = "compare-update";
    static final String CONFLICT_HIGHLIGHT_STYLE = "compare-conflict";
    static final String MERGED_HIGHLIGHT_STYLE = "compare-merged";
    static final String UNCHOSEN_HIGHLIGHT_STYLE = "compare-unchosen";
    static final String BLOCK_SEPARATOR_STYLE = "compare-separator";
    static final String SELECTED_BLOCK_SEPARATOR_STYLE = "compare-separator-selected";
    private HashMap _mapBlockToUnderlines;
    private boolean _suppressSelectedSeparators;
    private HighlightLayer _highlightLayer;
    private HighlightLayer _separatorLayer;

    static {
        HighlightStyle highlightStyle;
        HighlightStyle highlightStyle2;
        HighlightStyle highlightStyle3;
        HighlightStyle highlightStyle4;
        HighlightStyle highlightStyle5;
        HighlightStyle highlightStyle6;
        HighlightStyle highlightStyle7;
        HighlightRegistry highlightRegistry = EditorProperties.getProperties().getHighlightRegistry();
        HighlightStyle highlightStyle8 = highlightRegistry.lookupStyle(ADDITION_HIGHLIGHT_STYLE);
        if (highlightStyle8 == null) {
            highlightRegistry.createStyle(ADDITION_HIGHLIGHT_STYLE, "Compare added block", 10, null, new Color(206, 255, 206));
        }
        if ((highlightStyle7 = highlightRegistry.lookupStyle(DELETION_HIGHLIGHT_STYLE)) == null) {
            highlightRegistry.createStyle(DELETION_HIGHLIGHT_STYLE, "Compare removed block", 10, null, new Color(255, 206, 206));
        }
        if ((highlightStyle6 = highlightRegistry.lookupStyle(UPDATE_HIGHLIGHT_STYLE)) == null) {
            highlightRegistry.createStyle(UPDATE_HIGHLIGHT_STYLE, "Compare changed block", 10, null, new Color(206, 206, 255));
        }
        if ((highlightStyle5 = highlightRegistry.lookupStyle(CONFLICT_HIGHLIGHT_STYLE)) == null) {
            highlightRegistry.createStyle(CONFLICT_HIGHLIGHT_STYLE, "Compare conflict block", 10, null, new Color(255, 206, 206));
        }
        if ((highlightStyle4 = highlightRegistry.lookupStyle(MERGED_HIGHLIGHT_STYLE)) == null) {
            highlightRegistry.createStyle(MERGED_HIGHLIGHT_STYLE, "Compare merged block", 10, null, new Color(206, 255, 206));
        }
        if ((highlightStyle3 = highlightRegistry.lookupStyle(UNCHOSEN_HIGHLIGHT_STYLE)) == null) {
            highlightRegistry.createStyle(UNCHOSEN_HIGHLIGHT_STYLE, "Compare unchosen block", 10, null, new Color(220, 220, 220));
        }
        if ((highlightStyle2 = highlightRegistry.lookupStyle(BLOCK_SEPARATOR_STYLE)) == null) {
            highlightRegistry.createStyle(BLOCK_SEPARATOR_STYLE, "Compare Difference Block", true, 10, 0, UIManager.getColor("controlShadow"));
            highlightRegistry.modifyStyleUnderline(BLOCK_SEPARATOR_STYLE, new DiffBlockUnderlinePainter(null), UIManager.getColor("controlShadow"));
        }
        if ((highlightStyle = highlightRegistry.lookupStyle(SELECTED_BLOCK_SEPARATOR_STYLE)) == null) {
            highlightRegistry.createStyle(SELECTED_BLOCK_SEPARATOR_STYLE, "Compare Selected Block", true, 10, 0, Color.BLACK);
            highlightRegistry.modifyStyleUnderline(SELECTED_BLOCK_SEPARATOR_STYLE, new DiffBlockUnderlinePainter(null), Color.BLACK);
        }
    }

    public void install(BasicEditorPane basicEditorPane) {
        this._highlightLayer = basicEditorPane.createHighlightLayer();
        this._separatorLayer = basicEditorPane.createHighlightLayer();
        this._mapBlockToUnderlines = new HashMap();
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
        if (this._highlightLayer != null) {
            basicEditorPane.destroyHighlightLayer(this._highlightLayer);
            basicEditorPane.destroyHighlightLayer(this._separatorLayer);
            this._highlightLayer = null;
            this._separatorLayer = null;
            this._mapBlockToUnderlines = null;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    void setDifferences(TextCompareModel textCompareModel, DifferenceBlock differenceBlock, ContributorKind contributorKind, ContributorKind contributorKind2, boolean bl) {
        this._highlightLayer.removeAllHighlights();
        this._separatorLayer.removeAllHighlights();
        this._mapBlockToUnderlines.clear();
        DifferenceBlock[] differenceBlockArray = textCompareModel.getDifferenceBlocks();
        int n = 0;
        while (n < differenceBlockArray.length) {
            HighlightStyle highlightStyle = EditorHighlighter.getStyle(textCompareModel, differenceBlockArray[n], contributorKind, contributorKind2, bl);
            int n2 = differenceBlockArray[n].getStart(contributorKind);
            int n3 = differenceBlockArray[n].getLength(contributorKind);
            if (highlightStyle != null) {
                int n4 = n2;
                while (n4 < n2 + n3) {
                    this._highlightLayer.addLineHighlight(highlightStyle, n4);
                    ++n4;
                }
            }
            this.addBlockBorders(differenceBlockArray[n], contributorKind, differenceBlockArray[n] == differenceBlock);
            ++n;
        }
    }

    private void addBlockBorders(DifferenceBlock differenceBlock, ContributorKind contributorKind, boolean bl) {
        int n = differenceBlock.getStart(contributorKind);
        int n2 = differenceBlock.getLength(contributorKind);
        HighlightedText[] highlightedTextArray = new HighlightedText[2];
        if (n > 0) {
            highlightedTextArray[0] = this._separatorLayer.addLineHighlight(this.getSeparatorStyle(bl), n - 1);
        }
        if (n2 > 0) {
            highlightedTextArray[1] = this._separatorLayer.addLineHighlight(this.getSeparatorStyle(bl), n + n2 - 1);
        }
        this._mapBlockToUnderlines.put(differenceBlock, highlightedTextArray);
    }

    void updateBlockBorders(DifferenceBlock differenceBlock, ContributorKind contributorKind, boolean bl) {
        int n = differenceBlock.getStart(contributorKind);
        int n2 = differenceBlock.getLength(contributorKind);
        HighlightedText[] highlightedTextArray = (HighlightedText[])this._mapBlockToUnderlines.get(differenceBlock);
        if (highlightedTextArray == null) {
            return;
        }
        if (highlightedTextArray[0] != null) {
            this._separatorLayer.changeLineHighlight(highlightedTextArray[0], this.getSeparatorStyle(bl), n - 1);
        }
        if (highlightedTextArray[1] != null) {
            this._separatorLayer.changeLineHighlight(highlightedTextArray[1], this.getSeparatorStyle(bl), n + n2 - 1);
        }
    }

    void setSuppressSelectedSeparators(boolean bl) {
        this._suppressSelectedSeparators = bl;
    }

    HighlightStyle getSeparatorStyle(boolean bl) {
        if (!bl || this._suppressSelectedSeparators) {
            return EditorProperties.getProperties().getHighlightRegistry().lookupStyle(BLOCK_SEPARATOR_STYLE);
        }
        return EditorProperties.getProperties().getHighlightRegistry().lookupStyle(SELECTED_BLOCK_SEPARATOR_STYLE);
    }

    public void addLineHighlight(String string, int n) {
        this._highlightLayer.addLineHighlight(EditorProperties.getProperties().getHighlightRegistry().lookupStyle(string), n);
    }

    private static HighlightStyle getStyle(TextCompareModel textCompareModel, DifferenceBlock differenceBlock, ContributorKind contributorKind, ContributorKind contributorKind2, boolean bl) {
        String string;
        if (differenceBlock.isConflict()) {
            string = differenceBlock.isResolved() ? EditorHighlighter.getResolvedStyle(textCompareModel, differenceBlock, contributorKind) : CONFLICT_HIGHLIGHT_STYLE;
        } else if (differenceBlock.isChange(contributorKind, contributorKind2)) {
            string = UPDATE_HIGHLIGHT_STYLE;
        } else if (bl && differenceBlock.isAddition(contributorKind2, contributorKind)) {
            string = DELETION_HIGHLIGHT_STYLE;
        } else if (!bl && differenceBlock.isAddition(contributorKind2, contributorKind)) {
            string = ADDITION_HIGHLIGHT_STYLE;
        } else {
            return null;
        }
        return EditorProperties.getProperties().getHighlightRegistry().lookupStyle(string);
    }

    private static String getResolvedStyle(TextCompareModel textCompareModel, DifferenceBlock differenceBlock, ContributorKind contributorKind) {
        if (contributorKind != null && contributorKind != ContributorKind.ANCESTOR && !EditorHighlighter.equal(textCompareModel, differenceBlock, contributorKind, ContributorKind.ANCESTOR)) {
            return UNCHOSEN_HIGHLIGHT_STYLE;
        }
        return MERGED_HIGHLIGHT_STYLE;
    }

    private static boolean equal(TextCompareModel textCompareModel, DifferenceBlock differenceBlock, ContributorKind contributorKind, ContributorKind contributorKind2) {
        int n = differenceBlock.getStart(contributorKind);
        int n2 = differenceBlock.getLength(contributorKind);
        int n3 = differenceBlock.getStart(contributorKind2);
        if (n2 != differenceBlock.getLength(contributorKind2)) {
            return false;
        }
        SequenceCompareContributor sequenceCompareContributor = (SequenceCompareContributor)textCompareModel.getContributor(contributorKind);
        SequenceCompareContributor sequenceCompareContributor2 = (SequenceCompareContributor)textCompareModel.getContributor(contributorKind2);
        int n4 = n;
        int n5 = n3;
        while (n4 < n + n2) {
            if (!sequenceCompareContributor.equal(n4, sequenceCompareContributor2, n5)) {
                return false;
            }
            ++n4;
            ++n5;
        }
        return true;
    }

    static HighlightStyle getStyle(TextCompareModel textCompareModel, DifferenceBlock differenceBlock, ContributorKind contributorKind, ContributorKind contributorKind2, ContributorKind contributorKind3) {
        String string = null;
        if (differenceBlock.isConflict()) {
            string = differenceBlock.isResolved() ? EditorHighlighter.getResolvedStyle(textCompareModel, differenceBlock, contributorKind3) : CONFLICT_HIGHLIGHT_STYLE;
        } else if (differenceBlock.isAddition(contributorKind, contributorKind2)) {
            string = ADDITION_HIGHLIGHT_STYLE;
        } else if (differenceBlock.isRemoval(contributorKind, contributorKind2)) {
            string = DELETION_HIGHLIGHT_STYLE;
        } else if (differenceBlock.isChange(contributorKind, contributorKind2)) {
            string = UPDATE_HIGHLIGHT_STYLE;
        }
        if (string == null) {
            return null;
        }
        return EditorProperties.getProperties().getHighlightRegistry().lookupStyle(string);
    }

    EditorHighlighter() {
    }

    private static class DiffBlockUnderlinePainter
    extends SimpleLinePainter {
        private DiffBlockUnderlinePainter() {
            super(1, 2);
        }

        DiffBlockUnderlinePainter(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

