/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.view.wedge;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.util.Collection;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.algorithm.sequence.DifferenceBlock;
import oracle.javatools.compare.algorithm.text.InlineCompareModel;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.plugins.EditorPlugin;

public class InlineDiffHighlighter
implements EditorPlugin {
    private static final int PRIORITY = 105;
    static final String ADDITION_STYLE = "inline-compare-addition";
    static final String DELETION_STYLE = "inline-compare-deletion";
    static final String CHANGE_STYLE = "inline-compare-update";
    private HighlightLayer _hiliteLayer;
    private final ContributorKind _contributor;

    static {
        HighlightStyle highlightStyle;
        HighlightStyle highlightStyle2;
        HighlightRegistry highlightRegistry = EditorProperties.getProperties().getHighlightRegistry();
        HighlightStyle highlightStyle3 = highlightRegistry.lookupStyle(ADDITION_STYLE);
        if (highlightStyle3 == null) {
            highlightRegistry.createStyle(ADDITION_STYLE, "Compare Inline Added Characters", 105, null, new Color(206, 255, 206));
        }
        if ((highlightStyle2 = highlightRegistry.lookupStyle(DELETION_STYLE)) == null) {
            highlightRegistry.createStyle(DELETION_STYLE, "Compare Inline Removed Characters", 105, null, new Color(255, 206, 206));
        }
        if ((highlightStyle = highlightRegistry.lookupStyle(CHANGE_STYLE)) == null) {
            highlightRegistry.createStyle(CHANGE_STYLE, "Compare Inline Changed Characters", 105, null, new Color(255, 255, 255));
        }
    }

    public InlineDiffHighlighter(ContributorKind contributorKind) {
        this._contributor = contributorKind;
    }

    public void install(BasicEditorPane basicEditorPane) {
        this._hiliteLayer = basicEditorPane.createHighlightLayer();
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
        if (this._hiliteLayer != null) {
            basicEditorPane.destroyHighlightLayer(this._hiliteLayer);
            this._hiliteLayer = null;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    public void setModel(InlineCompareModel inlineCompareModel, TextBuffer textBuffer) {
        Collection collection = inlineCompareModel.getMatchedLines();
        for (InlineCompareModel.MatchedLine matchedLine : collection) {
            int n = matchedLine.getLine(this._contributor);
            int n2 = textBuffer.getLineMap().getLineStartOffset(n);
            DifferenceBlock[] differenceBlockArray = matchedLine.getDifferences();
            int n3 = 0;
            while (n3 < differenceBlockArray.length) {
                DifferenceBlock differenceBlock = differenceBlockArray[n3];
                int n4 = n2 + differenceBlock.getStart(this._contributor);
                int n5 = n2 + differenceBlock.getStart(this._contributor) + differenceBlock.getLength(this._contributor);
                HighlightStyle highlightStyle = this.getStyle(differenceBlock);
                if (highlightStyle != null) {
                    this._hiliteLayer.addHighlight(highlightStyle, n4, n5);
                }
                ++n3;
            }
        }
    }

    private HighlightStyle getStyle(DifferenceBlock differenceBlock) {
        HighlightRegistry highlightRegistry = EditorProperties.getProperties().getHighlightRegistry();
        if (differenceBlock.isChange(ContributorKind.FIRST, ContributorKind.SECOND)) {
            return highlightRegistry.lookupStyle(CHANGE_STYLE);
        }
        if (this._contributor == ContributorKind.FIRST && differenceBlock.isRemoval(this._contributor, ContributorKind.SECOND)) {
            return highlightRegistry.lookupStyle(DELETION_STYLE);
        }
        if (this._contributor == ContributorKind.SECOND && differenceBlock.isAddition(ContributorKind.FIRST, this._contributor)) {
            return highlightRegistry.lookupStyle(ADDITION_STYLE);
        }
        return null;
    }
}

