/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.view.wedge;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.MatteBorder;
import oracle.javatools.compare.view.wedge.SplitPanelLayout;
import oracle.javatools.resource.CompareResource;
import oracle.javatools.util.BundleLoader;

final class SplitPanel
extends JPanel {
    private final JComponent _leftSplitter;
    private final JComponent _centerSplitter;
    private final SplitPanelLayout _layout = new SplitPanelLayout();
    static final int SPLITTER_WIDTH = 50;
    private static final int SPLITTER_HEIGHT = 20;

    public SplitPanel() {
        this.setLayout(this._layout);
        this._leftSplitter = this.createSplitter();
        this._centerSplitter = this.createSplitter();
        this.add((Component)this._leftSplitter, "leftSplitTop");
        this.add((Component)this._centerSplitter, "centerSplitTop");
        this.registerMouseHandler(this._leftSplitter, false);
        this.registerMouseHandler(this._centerSplitter, true);
        this.updateSplitterToolTips();
    }

    private JComponent createSplitter() {
        JLabel jLabel = new JLabel(new ImageIcon(CompareResource.class.getResource("/oracle/javatools/icons/images/splitter.gif")));
        jLabel.setPreferredSize(new Dimension(50, 20));
        jLabel.setCursor(Cursor.getPredefinedCursor(11));
        MatteBorder matteBorder = BorderFactory.createMatteBorder(0, 1, 0, 1, UIManager.getColor("controlShadow"));
        jLabel.setBorder(matteBorder);
        return jLabel;
    }

    private ImageIcon getIcon(String string) {
        return new ImageIcon(CompareResource.class.getResource(string));
    }

    private static ResourceBundle getBundle() {
        return BundleLoader.getBundle("oracle.javatools.resource.CompareResource");
    }

    private void registerMouseHandler(Component component, boolean bl) {
        SplitterMouseHandler splitterMouseHandler = new SplitterMouseHandler(component, bl);
        component.addMouseListener(splitterMouseHandler);
        component.addMouseMotionListener(splitterMouseHandler);
    }

    private void updateSplitterToolTips() {
        String string = null;
        string = this._layout.isEven() ? SplitPanel.getBundle().getString("WEDGE_SPLITTER_CENTERED_TOOLTIP") : SplitPanel.getBundle().getString("WEDGE_SPLITTER_OFFCENTER_TOOLTIP");
        this._leftSplitter.setToolTipText(string);
        this._centerSplitter.setToolTipText(string);
    }

    public void setThreePaneMode(boolean bl) {
        this._layout.setThreePaneMode(bl);
    }

    public boolean isThreePaneMode() {
        return this._layout.isThreePaneMode();
    }

    void moveSplitter(Component component, int n, boolean bl) {
        this._layout.moveSplitter(component, n, bl);
        this.revalidate();
        this.updateSplitterToolTips();
    }

    public static void main(String[] stringArray) {
        SplitPanel splitPanel = new SplitPanel();
        SplitPanel.addLabel(splitPanel, "leftGutter", Color.RED);
        SplitPanel.addLabel(splitPanel, "leftTitle", Color.GREEN);
        SplitPanel.addLabel(splitPanel, "leftEditor", Color.BLUE);
        SplitPanel.addLabel(splitPanel, "leftSplit", Color.MAGENTA);
        SplitPanel.addLabel(splitPanel, "centerTitle", Color.YELLOW);
        SplitPanel.addLabel(splitPanel, "centerEditor", Color.GRAY);
        SplitPanel.addLabel(splitPanel, "centerSplit", Color.PINK);
        SplitPanel.addLabel(splitPanel, "rightTitle", Color.RED);
        SplitPanel.addLabel(splitPanel, "rightEditor", Color.GREEN);
        SplitPanel.addLabel(splitPanel, "rightGutter", Color.BLUE);
        SplitPanel.addLabel(splitPanel, "rightScrollbar", Color.CYAN);
        SplitPanel.addLabel(splitPanel, "rightOverview", Color.MAGENTA);
        splitPanel.setThreePaneMode(false);
        JFrame jFrame = new JFrame();
        jFrame.setContentPane(splitPanel);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    private static void addLabel(Container container, String string, Color color) {
        JLabel jLabel = new JLabel();
        jLabel.setOpaque(true);
        jLabel.setBackground(color);
        jLabel.setText(string);
        container.add((Component)jLabel, string);
    }

    static SplitPanelLayout ra$_layout(SplitPanel splitPanel) {
        return splitPanel._layout;
    }

    static void mav$updateSplitterToolTips(SplitPanel splitPanel) {
        splitPanel.updateSplitterToolTips();
    }

    private class SplitterMouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private final Component _splitter;
        private final boolean _isCenter;

        public SplitterMouseHandler(Component component, boolean bl) {
            this._splitter = component;
            this._isCenter = bl;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1) {
                SplitPanel.ra$_layout(SplitPanel.this).resetSplitters();
                SplitPanel.this.invalidate();
                SplitPanel.this.validate();
                SplitPanel.mav$updateSplitterToolTips(SplitPanel.this);
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            SplitPanel.ra$_layout(SplitPanel.this).moveSplitter(this._splitter, mouseEvent.getPoint(), this._isCenter);
            SplitPanel.this.revalidate();
            SplitPanel.mav$updateSplitterToolTips(SplitPanel.this);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }
}

