/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.view.wedge;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

final class SplitPanelLayout
implements LayoutManager {
    public static final String LEFT_GUTTER = "leftGutter";
    public static final String LEFT_TITLE = "leftTitle";
    public static final String LEFT_EDITOR = "leftEditor";
    public static final String LEFT_SPLIT_TOP = "leftSplitTop";
    public static final String LEFT_SPLIT = "leftSplit";
    public static final String CENTER_TITLE = "centerTitle";
    public static final String CENTER_EDITOR = "centerEditor";
    public static final String CENTER_SPLIT_TOP = "centerSplitTop";
    public static final String CENTER_SPLIT = "centerSplit";
    public static final String RIGHT_TITLE = "rightTitle";
    public static final String RIGHT_EDITOR = "rightEditor";
    public static final String RIGHT_GUTTER = "rightGutter";
    public static final String RIGHT_SCROLLBAR = "rightScrollbar";
    public static final String RIGHT_OVERVIEW = "rightOverview";
    public static final String SPLITTER_LOCATION_PROPERTY = "lastSplitterLocation";
    private static final Dimension DIM_ZERO = new Dimension(0, 0);
    private final Map _componentMap;
    private float _leftEditorWeight;
    private float _centerEditorWeight;
    private float _rightEditorWeight;
    private boolean _isThreePaneMode;

    void $init$() {
        this._componentMap = new HashMap();
    }

    public SplitPanelLayout() {
        this.$init$();
        this.setThreePaneMode(false);
    }

    void resetSplitters() {
        this.setThreePaneMode(this.isThreePaneMode());
    }

    boolean isThreePaneMode() {
        return this._isThreePaneMode;
    }

    public void setThreePaneMode(boolean bl) {
        if (bl) {
            this._leftEditorWeight = 0.33333334f;
            this._centerEditorWeight = 0.33333334f;
            this._rightEditorWeight = 0.33333334f;
        } else {
            this._leftEditorWeight = 0.5f;
            this._rightEditorWeight = 0.5f;
            this._centerEditorWeight = 0.0f;
        }
        this.setComponentVisible(CENTER_EDITOR, bl);
        this.setComponentVisible(CENTER_TITLE, bl);
        this.setComponentVisible(CENTER_SPLIT_TOP, bl);
        this.setComponentVisible(CENTER_SPLIT, bl);
        this._isThreePaneMode = bl;
    }

    boolean isEven() {
        return this._leftEditorWeight == this._rightEditorWeight && (!this._isThreePaneMode || this._rightEditorWeight == this._centerEditorWeight);
    }

    private void setComponentVisible(String string, boolean bl) {
        Component component = this.getComponent(string);
        if (component != null) {
            component.setVisible(bl);
        }
    }

    void moveSplitter(Component component, Point point, boolean bl) {
        int n = component.getLocationOnScreen().x + point.x;
        int n2 = n - component.getWidth() / 2;
        int n3 = n2 - component.getParent().getLocationOnScreen().x;
        this._moveSplitter(component, n3, bl);
    }

    void moveSplitter(Component component, int n, boolean bl) {
        this._moveSplitter(component, n -= component.getWidth() / 2, bl);
    }

    private void _moveSplitter(Component component, int n, boolean bl) {
        String string;
        int n2 = this.getTotalEditorWidth(component.getParent().getSize(), new Sizes(null));
        String string2 = string = bl ? CENTER_EDITOR : LEFT_EDITOR;
        String string3 = bl ? LEFT_EDITOR : (this.isThreePaneMode() ? RIGHT_EDITOR : CENTER_EDITOR);
        Point point = this.getLocation(string);
        Dimension dimension = this.getSize(string);
        int n3 = n - (point.x + dimension.width);
        int n4 = Math.max(0, dimension.width + n3);
        int n5 = n2 - n4 - this.getSize((String)string3).width;
        if (n5 < 0) {
            n4 -= Math.abs(n5);
            n5 = 0;
        }
        float f = (float)n4 / (float)n2;
        float f2 = (float)n5 / (float)n2;
        if (this.isThreePaneMode()) {
            if (bl) {
                this._centerEditorWeight = f;
                this._rightEditorWeight = f2;
            } else {
                this._leftEditorWeight = f;
                this._centerEditorWeight = f2;
            }
        } else {
            this._leftEditorWeight = f;
            this._rightEditorWeight = f2;
        }
    }

    private Point getLocation(String string) {
        Component component = this.getComponent(string);
        if (component == null || !component.isVisible()) {
            return new Point(0, 0);
        }
        return component.getLocation();
    }

    private Dimension getSize(String string) {
        Component component = this.getComponent(string);
        if (component == null || !component.isVisible()) {
            return DIM_ZERO;
        }
        return component.getSize();
    }

    Component getComponent(String string) {
        return (Component)this._componentMap.get(string);
    }

    private Dimension getPreferredSize(String string) {
        Component component = this.getComponent(string);
        if (component == null || !component.isVisible()) {
            return DIM_ZERO;
        }
        return component.getPreferredSize();
    }

    public void addLayoutComponent(String string, Component component) {
        this._componentMap.put(string, component);
    }

    public void removeLayoutComponent(Component component) {
        Iterator iterator = this._componentMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Component component2 = (Component)this._componentMap.get(string);
            if (component2 != component) continue;
            iterator.remove();
            return;
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        return DIM_ZERO;
    }

    private static int max(int[] nArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            n = Math.max(n, nArray[n2]);
            ++n2;
        }
        return n;
    }

    private static final void setBounds(Component component, int n, int n2, int n3, int n4) {
        if (component != null && component.isVisible()) {
            component.setBounds(n, n2, n3, n4);
        }
    }

    private int getTopHeight(Sizes sizes) {
        return SplitPanelLayout.max(new int[]{sizes.leftTitleSize.height, sizes.leftSplitTopSize.height, sizes.centerTitleSize.height, sizes.centerSplitTopSize.height, sizes.rightTitleSize.height});
    }

    public Dimension preferredLayoutSize(Container container) {
        Sizes sizes = new Sizes(null);
        int n = sizes.leftGutterSize.width + Math.max(sizes.leftTitleSize.width, sizes.leftEditorSize.width) + Math.max(sizes.leftSplitTopSize.width, sizes.leftSplitSize.width) + Math.max(sizes.centerTitleSize.width, sizes.centerEditorSize.width) + Math.max(sizes.centerSplitTopSize.width, sizes.centerSplitSize.width) + Math.max(sizes.rightTitleSize.width, sizes.rightEditorSize.width) + sizes.rightGutterSize.width + sizes.rightScrollbarSize.width + sizes.rightOverviewSize.width;
        int n2 = this.getTopHeight(sizes) + SplitPanelLayout.max(new int[]{sizes.leftGutterSize.height, sizes.leftEditorSize.height, sizes.leftSplitSize.height, sizes.centerEditorSize.height, sizes.centerSplitSize.height, sizes.rightEditorSize.height, sizes.rightGutterSize.height, sizes.rightScrollbarSize.height, sizes.rightOverviewSize.height});
        return new Dimension(n, n2);
    }

    private int getTotalEditorWidth(Dimension dimension, Sizes sizes) {
        return dimension.width - (sizes.leftGutterSize.width + this.getLeftSplitWidth(sizes) + this.getCenterSplitWidth(sizes) + sizes.rightGutterSize.width + sizes.rightScrollbarSize.width + sizes.rightOverviewSize.width);
    }

    private int getLeftSplitWidth(Sizes sizes) {
        return Math.max(sizes.leftSplitTopSize.width, sizes.leftSplitSize.width);
    }

    private int getCenterSplitWidth(Sizes sizes) {
        return Math.max(sizes.centerSplitTopSize.width, sizes.centerSplitSize.width);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Sizes sizes = new Sizes(null);
            Dimension dimension = container.getSize();
            int n = this.getLeftSplitWidth(sizes);
            int n2 = this.getCenterSplitWidth(sizes);
            int n3 = this.getTotalEditorWidth(dimension, sizes);
            float f = n3;
            int n4 = (int)(this._leftEditorWeight * f);
            int n5 = (int)(this._centerEditorWeight * f);
            int n6 = (int)(this._rightEditorWeight * f);
            int n7 = this.getTopHeight(sizes);
            int n8 = dimension.height - n7;
            int n9 = 0;
            SplitPanelLayout.setBounds(this.getComponent(LEFT_GUTTER), n9, n7, sizes.leftGutterSize.width, n8);
            int n10 = 0;
            if (dimension.width > sizes.leftGutterSize.width + n4 + n + n5 + n2 + n6 + sizes.rightGutterSize.width + sizes.rightScrollbarSize.width + sizes.rightOverviewSize.width) {
                n10 = 1;
            }
            SplitPanelLayout.setBounds(this.getComponent(LEFT_TITLE), n9 += sizes.leftGutterSize.width, 0, n4, n7);
            SplitPanelLayout.setBounds(this.getComponent(LEFT_EDITOR), n9, n7, n4 + n10, n8);
            SplitPanelLayout.setBounds(this.getComponent(LEFT_SPLIT_TOP), n9 += n4 + n10, 0, n, n7);
            SplitPanelLayout.setBounds(this.getComponent(LEFT_SPLIT), n9, n7, n, n8);
            SplitPanelLayout.setBounds(this.getComponent(CENTER_TITLE), n9 += n, 0, n5, n7);
            SplitPanelLayout.setBounds(this.getComponent(CENTER_EDITOR), n9, n7, n5, n8);
            SplitPanelLayout.setBounds(this.getComponent(CENTER_SPLIT_TOP), n9 += n5, 0, n2, n7);
            SplitPanelLayout.setBounds(this.getComponent(CENTER_SPLIT), n9, n7, n2, n8);
            SplitPanelLayout.setBounds(this.getComponent(RIGHT_TITLE), n9 += n2, 0, n6, n7);
            SplitPanelLayout.setBounds(this.getComponent(RIGHT_EDITOR), n9, n7, n6, n8);
            SplitPanelLayout.setBounds(this.getComponent(RIGHT_GUTTER), n9 += n6, n7, sizes.rightGutterSize.width, n8);
            SplitPanelLayout.setBounds(this.getComponent(RIGHT_SCROLLBAR), n9 += sizes.rightGutterSize.width, n7, sizes.rightScrollbarSize.width, n8);
            SplitPanelLayout.setBounds(this.getComponent(RIGHT_OVERVIEW), n9 += sizes.rightScrollbarSize.width, n7, sizes.rightOverviewSize.width, n8);
            this.fireSplitterLocationChanged(this.getComponent(LEFT_SPLIT_TOP));
            this.fireSplitterLocationChanged(this.getComponent(CENTER_SPLIT_TOP));
        }
    }

    private void fireSplitterLocationChanged(Component component) {
        if (!(component instanceof JComponent)) {
            return;
        }
        JComponent jComponent = (JComponent)component;
        Object object = jComponent.getClientProperty(SPLITTER_LOCATION_PROPERTY);
        int n = jComponent.getLocation().x + jComponent.getWidth() / 2;
        int n2 = object != null ? (Integer)object : 0;
        jComponent.firePropertyChange(SPLITTER_LOCATION_PROPERTY, n2, n);
    }

    public static void main(String[] stringArray) {
        JPanel jPanel = new JPanel();
        SplitPanelLayout splitPanelLayout = new SplitPanelLayout();
        jPanel.setLayout(splitPanelLayout);
        SplitPanelLayout.addLabel(jPanel, LEFT_GUTTER, Color.RED);
        SplitPanelLayout.addLabel(jPanel, LEFT_TITLE, Color.GREEN);
        SplitPanelLayout.addLabel(jPanel, LEFT_EDITOR, Color.BLUE);
        SplitPanelLayout.addLabel(jPanel, LEFT_SPLIT_TOP, Color.CYAN);
        SplitPanelLayout.addLabel(jPanel, LEFT_SPLIT, Color.MAGENTA);
        SplitPanelLayout.addLabel(jPanel, CENTER_TITLE, Color.YELLOW);
        SplitPanelLayout.addLabel(jPanel, CENTER_EDITOR, Color.GRAY);
        SplitPanelLayout.addLabel(jPanel, CENTER_SPLIT_TOP, Color.ORANGE);
        SplitPanelLayout.addLabel(jPanel, CENTER_SPLIT, Color.PINK);
        SplitPanelLayout.addLabel(jPanel, RIGHT_TITLE, Color.RED);
        SplitPanelLayout.addLabel(jPanel, RIGHT_EDITOR, Color.GREEN);
        SplitPanelLayout.addLabel(jPanel, RIGHT_GUTTER, Color.BLUE);
        SplitPanelLayout.addLabel(jPanel, RIGHT_SCROLLBAR, Color.CYAN);
        SplitPanelLayout.addLabel(jPanel, RIGHT_OVERVIEW, Color.MAGENTA);
        JFrame jFrame = new JFrame();
        jFrame.setContentPane(jPanel);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    private static void addLabel(Container container, String string, Color color) {
        JLabel jLabel = new JLabel();
        jLabel.setOpaque(true);
        jLabel.setBackground(color);
        jLabel.setText(string);
        container.add((Component)jLabel, string);
    }

    static Dimension mav$getPreferredSize(SplitPanelLayout splitPanelLayout, String string) {
        return splitPanelLayout.getPreferredSize(string);
    }

    private class Sizes {
        Dimension leftGutterSize;
        Dimension leftTitleSize;
        Dimension leftEditorSize;
        Dimension leftSplitTopSize;
        Dimension leftSplitSize;
        Dimension centerTitleSize;
        Dimension centerEditorSize;
        Dimension centerSplitTopSize;
        Dimension centerSplitSize;
        Dimension rightTitleSize;
        Dimension rightEditorSize;
        Dimension rightGutterSize;
        Dimension rightScrollbarSize;
        Dimension rightOverviewSize;

        void $init$() {
            this.leftGutterSize = SplitPanelLayout.mav$getPreferredSize(SplitPanelLayout.this, SplitPanelLayout.LEFT_GUTTER);
            this.leftTitleSize = SplitPanelLayout.mav$getPreferredSize(SplitPanelLayout.this, SplitPanelLayout.LEFT_TITLE);
            this.leftEditorSize = SplitPanelLayout.mav$getPreferredSize(SplitPanelLayout.this, SplitPanelLayout.LEFT_EDITOR);
            this.leftSplitTopSize = SplitPanelLayout.mav$getPreferredSize(SplitPanelLayout.this, SplitPanelLayout.LEFT_SPLIT_TOP);
            this.leftSplitSize = SplitPanelLayout.mav$getPreferredSize(SplitPanelLayout.this, SplitPanelLayout.LEFT_SPLIT);
            this.centerTitleSize = SplitPanelLayout.mav$getPreferredSize(SplitPanelLayout.this, SplitPanelLayout.CENTER_TITLE);
            this.centerEditorSize = SplitPanelLayout.mav$getPreferredSize(SplitPanelLayout.this, SplitPanelLayout.CENTER_EDITOR);
            this.centerSplitTopSize = SplitPanelLayout.mav$getPreferredSize(SplitPanelLayout.this, SplitPanelLayout.CENTER_SPLIT_TOP);
            this.centerSplitSize = SplitPanelLayout.mav$getPreferredSize(SplitPanelLayout.this, SplitPanelLayout.CENTER_SPLIT_TOP);
            this.rightTitleSize = SplitPanelLayout.mav$getPreferredSize(SplitPanelLayout.this, SplitPanelLayout.RIGHT_TITLE);
            this.rightEditorSize = SplitPanelLayout.mav$getPreferredSize(SplitPanelLayout.this, SplitPanelLayout.RIGHT_EDITOR);
            this.rightGutterSize = SplitPanelLayout.mav$getPreferredSize(SplitPanelLayout.this, SplitPanelLayout.RIGHT_GUTTER);
            this.rightScrollbarSize = SplitPanelLayout.mav$getPreferredSize(SplitPanelLayout.this, SplitPanelLayout.RIGHT_SCROLLBAR);
            this.rightOverviewSize = SplitPanelLayout.mav$getPreferredSize(SplitPanelLayout.this, SplitPanelLayout.RIGHT_OVERVIEW);
        }

        private Sizes() {
            this.$init$();
        }

        Sizes(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

