/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.view.wedge;

import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.algorithm.sequence.DifferenceBlock;
import oracle.javatools.compare.algorithm.text.TextCompareContributor;
import oracle.javatools.compare.algorithm.text.TextCompareModel;
import oracle.javatools.compare.view.wedge.EditorHighlighter;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorKit;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;

public class TextPane
extends BasicEditorPane
implements PropertyChangeListener {
    private TextCompareModel _model;
    private final ContributorKind _contributor;
    private ContributorKind _adjacentContributor;
    private EditorHighlighter _highlightPlugin;
    private boolean _isPredecessor;
    private DifferenceBlock _currentBlock;

    protected TextPane(ContributorKind contributorKind) {
        this._contributor = contributorKind;
        this.setEditorKit(new BasicEditorKit());
        if (contributorKind == ContributorKind.FIRST) {
            this.setMargin(new Insets(0, 2, 2, 0));
        } else {
            this.setMargin(new Insets(0, 0, 2, 2));
        }
        this.setThreePaneMode(false);
        this.addPropertyChangeListener(this);
        this.setBorder(null);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("style-registry")) {
            this.setStyleRegistry(EditorProperties.getProperties().getStyleRegistry());
            this.updateColors();
        }
    }

    EditorHighlighter getBlockHighlighter() {
        return this._highlightPlugin;
    }

    void setThreePaneMode(boolean bl) {
        if (bl) {
            boolean bl2 = this._isPredecessor = this._contributor == ContributorKind.ANCESTOR;
            this._adjacentContributor = this._contributor == ContributorKind.FIRST ? ContributorKind.ANCESTOR : (this._contributor == ContributorKind.SECOND ? ContributorKind.ANCESTOR : null);
        } else {
            this._isPredecessor = this._contributor == ContributorKind.FIRST;
            ContributorKind contributorKind = this._adjacentContributor = this._contributor == ContributorKind.FIRST ? ContributorKind.SECOND : ContributorKind.FIRST;
        }
        if (this._model != null) {
            this.updateModel(this._model);
        }
    }

    void setCurrentBlock(DifferenceBlock differenceBlock) {
        if (this._currentBlock != null && this._highlightPlugin != null) {
            this._highlightPlugin.updateBlockBorders(this._currentBlock, this._contributor, false);
        }
        this._currentBlock = differenceBlock;
        if (differenceBlock != null && this._highlightPlugin != null) {
            this._highlightPlugin.updateBlockBorders(differenceBlock, this._contributor, true);
        }
    }

    protected final TextCompareContributor getContributor() {
        return (TextCompareContributor)this._model.getContributor(this._contributor);
    }

    protected final ContributorKind getContributorKind() {
        return this._contributor;
    }

    protected final TextCompareModel getModel() {
        return this._model;
    }

    final void setModel(TextCompareModel textCompareModel) {
        if (textCompareModel == null || this._model != textCompareModel) {
            this.cleanUp();
        }
        if (textCompareModel != null) {
            this._model = textCompareModel;
            this.installModel();
        }
    }

    final void updateModel(TextCompareModel textCompareModel) {
        this._model = textCompareModel;
        if (this._highlightPlugin != null) {
            this._highlightPlugin.setDifferences(textCompareModel, this._currentBlock, this.getContributorKind(), this._adjacentContributor, this._isPredecessor);
        }
    }

    protected void installHighlights() {
        this._highlightPlugin = this.createBlockHighlighter();
        this.installPlugin(this._highlightPlugin);
        this._highlightPlugin.setDifferences(this.getModel(), this._currentBlock, this.getContributorKind(), this._adjacentContributor, this._isPredecessor);
    }

    protected void cleanUp() {
        if (this._highlightPlugin != null) {
            this.deinstallPlugin(this._highlightPlugin);
            this._highlightPlugin = null;
        }
        this._model = null;
    }

    protected BasicDocument createDocument(TextBuffer textBuffer) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("x.");
        stringBuffer.append(this.getContributor().getType());
        return new BasicDocument(stringBuffer.toString(), textBuffer);
    }

    protected void installModel() {
        if (this.getContributor() != null) {
            this.setDocument(this.createDocument(this.getContributor().getTextBuffer()));
            this.installHighlights();
        }
    }

    protected EditorHighlighter createBlockHighlighter() {
        return new EditorHighlighter();
    }
}

