/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.view.wedge;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.undo.UndoableEdit;
import oracle.bali.ewt.util.MenuUtils;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareDifference;
import oracle.javatools.compare.CompareFailedException;
import oracle.javatools.compare.CompareHintListener;
import oracle.javatools.compare.CompareHints;
import oracle.javatools.compare.CompareMode;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareModelFactory;
import oracle.javatools.compare.CompareType;
import oracle.javatools.compare.CompareView;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.EditableContributor;
import oracle.javatools.compare.algorithm.sequence.DifferenceBlock;
import oracle.javatools.compare.algorithm.text.InlineCompareModel;
import oracle.javatools.compare.algorithm.text.OffsetDifferenceBlock;
import oracle.javatools.compare.algorithm.text.TextCompareContributor;
import oracle.javatools.compare.algorithm.text.TextCompareElement;
import oracle.javatools.compare.algorithm.text.TextCompareModel;
import oracle.javatools.compare.view.CustomHorizontalScrollView;
import oracle.javatools.compare.view.EditorPaneView;
import oracle.javatools.compare.view.NavigableView;
import oracle.javatools.compare.view.StatusView;
import oracle.javatools.compare.view.wedge.EditorHighlighter;
import oracle.javatools.compare.view.wedge.InlineDiffHighlighter;
import oracle.javatools.compare.view.wedge.SplitPanel;
import oracle.javatools.compare.view.wedge.SplitPanelLayout;
import oracle.javatools.compare.view.wedge.TextPane;
import oracle.javatools.compare.view.wedge.WedgeCompareMemento;
import oracle.javatools.compare.view.wedge.WedgeEdit;
import oracle.javatools.compare.view.wedge.WedgeEditEvent;
import oracle.javatools.compare.view.wedge.WedgeEditListener;
import oracle.javatools.compare.view.wedge.WedgeToolTipProvider;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.PopupManager;
import oracle.javatools.editor.ToolTipProvider;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.resource.CompareResource;
import oracle.javatools.util.BundleLoader;

public class WedgeCompareView
implements StatusView,
ToolTipProvider,
CustomHorizontalScrollView,
EditorPaneView,
NavigableView,
CompareView {
    public static final String SPLITTER_LOCATION_PROPERTY = "lastSplitterLocation";
    public static final int SPLITTER_WIDTH = 50;
    private static final int EDIT_UPDATE_DELAY = 500;
    private static final int WEDGE_EDGE_SIZE = 16;
    private static final int OVERVIEW_WIDTH = new JScrollBar((int)1).getPreferredSize().width;
    private static final String PROPERTY_UNDO_MOMENTO = "wedgeCompareUndoMemento";
    private static final String PROPERTY_REDO_MOMENTO = "wedgeCompareRedoMemento";
    private WedgeCompareMemento _currentMemento;
    private ContributorListener _contributorListener;
    private final CustomViewport _leftGutter;
    private final CustomViewport _rightGutter;
    private final CustomViewport _leftEditor;
    private final CustomViewport _rightEditor;
    private CustomViewport _centerEditor;
    private CompareHintListener _compareHintListener;
    private final JLabel _leftTitle;
    private final JLabel _rightTitle;
    private final JLabel _centerTitle;
    private JPanel _horizontalScrollPanel;
    private final JScrollBar _verticalScrollbar;
    private final SplitPanel _panel;
    private final TextPane _leftPane;
    private final TextPane _rightPane;
    private TextPane _centerPane;
    private InlineDiffHighlighter _leftInlineHilite;
    private InlineDiffHighlighter _rightInlineHilite;
    private InlineDiffHighlighter _centerInlineHilite;
    private WedgeDiffGutter _diffGutter;
    private WedgeDiffGutter _threePaneLeftDiffGutter;
    private final LineGutterPlugin _leftGutterPlugin;
    private final LineGutterPlugin _rightGutterPlugin;
    private int _textPaneFontHeight;
    private TextCompareModel _model;
    private OverviewComponent _overview;
    private boolean _verticalScrollLock;
    private JPanel _verticalScrollPanel;
    private CardLayout _verticalScrollCardLayout;
    private static final String GUI_VERTICAL_SCROLLBAR = "verticalScrollbar";
    private static final String GUI_VERTICAL_SPACER = "verticalSpacer";
    private boolean _editLocked;
    private Icon _editRemoveIcon;
    private Icon _editLeftIcon;
    private Icon _editRightIcon;
    private Boolean _showInlineCharDiffs;
    private final CompareMode _mode;
    private WedgeToolTipProvider _toolTipProvider;
    private JScrollPane _leftScrollPane;
    private JScrollPane _rightScrollPane;
    private JScrollPane _centerScrollPane;
    private DifferenceBlock _currentBlock;
    private TextPane _currentTextPane;
    private final Collection _undoableEditListeners;
    private final Collection _positionChangeListeners;
    private final Collection _statusListeners;
    private Timer _editTimer;

    void $init$() {
        this._leftGutter = new CustomViewport();
        this._rightGutter = new CustomViewport();
        this._leftEditor = new CustomViewport(ContributorKind.FIRST);
        this._rightEditor = new CustomViewport(ContributorKind.SECOND);
        this._compareHintListener = null;
        this._leftTitle = new JLabel();
        this._rightTitle = new JLabel();
        this._centerTitle = new JLabel();
        this._verticalScrollbar = new JScrollBar(1);
        this._panel = new SplitPanel();
        this._leftPane = new TextPane(ContributorKind.FIRST);
        this._rightPane = new TextPane(ContributorKind.SECOND);
        this._leftInlineHilite = null;
        this._rightInlineHilite = null;
        this._centerInlineHilite = null;
        this._leftGutterPlugin = new LineGutterPlugin();
        this._rightGutterPlugin = new LineGutterPlugin();
        this._overview = new OverviewComponent(ContributorKind.FIRST, ContributorKind.SECOND);
        this._verticalScrollLock = false;
        this._editLocked = false;
        this._editRemoveIcon = null;
        this._editLeftIcon = null;
        this._editRightIcon = null;
        this._undoableEditListeners = new ArrayList();
        this._positionChangeListeners = new ArrayList();
        this._statusListeners = new ArrayList();
    }

    public static final int calculateRightEditorInset() {
        WedgeCompareView wedgeCompareView = new WedgeCompareView();
        int n = 0;
        n += wedgeCompareView._overview.getPreferredSize().width;
        return n += wedgeCompareView._verticalScrollbar.getPreferredSize().width;
    }

    public WedgeCompareView() {
        this(CompareMode.TWO_WAY_COMPARE);
    }

    public WedgeCompareView(CompareMode compareMode) {
        this.$init$();
        this._mode = compareMode;
        if (compareMode == CompareMode.TWO_WAY_COMPARE) {
            this._diffGutter = new WedgeDiffGutter(ContributorKind.FIRST, ContributorKind.SECOND);
            this._threePaneLeftDiffGutter = null;
            this._centerEditor = null;
            this._centerPane = null;
            this.setThreePaneMode(false);
        }
        if (compareMode == CompareMode.THREE_WAY_MERGE) {
            this._diffGutter = new WedgeDiffGutter(ContributorKind.FIRST, ContributorKind.ANCESTOR);
            this._threePaneLeftDiffGutter = new WedgeDiffGutter(ContributorKind.ANCESTOR, ContributorKind.SECOND);
            this._centerEditor = new CustomViewport(ContributorKind.ANCESTOR);
            this._centerPane = new TextPane(ContributorKind.ANCESTOR);
            this.setThreePaneMode(true);
        }
        this._leftScrollPane = this.createHorizontalScrollPane(this._leftEditor);
        this._rightScrollPane = this.createHorizontalScrollPane(this._rightEditor);
        if (this._centerEditor != null) {
            this._centerScrollPane = this.createHorizontalScrollPane(this._centerEditor);
        }
        6 var2_2 = new 6();
        this._leftScrollPane.getHorizontalScrollBar().addAdjustmentListener(var2_2);
        this._rightScrollPane.getHorizontalScrollBar().addAdjustmentListener(var2_2);
        if (this._centerScrollPane != null) {
            this._centerScrollPane.getHorizontalScrollBar().addAdjustmentListener(var2_2);
        }
        this._panel.add((Component)this._leftGutter, "leftGutter");
        this._panel.add((Component)this._rightGutter, "rightGutter");
        this._panel.add((Component)this._leftScrollPane, "leftEditor");
        this._panel.add((Component)this._rightScrollPane, "rightEditor");
        this._panel.add((Component)this._leftTitle, "leftTitle");
        this._panel.add((Component)this._centerTitle, "centerTitle");
        if (this._centerEditor != null) {
            this._panel.add((Component)this._centerScrollPane, "centerEditor");
        }
        this._panel.add((Component)this._rightTitle, "rightTitle");
        this._panel.add((Component)this._diffGutter, "leftSplit");
        if (this._threePaneLeftDiffGutter != null) {
            this._panel.add((Component)this._threePaneLeftDiffGutter, "centerSplit");
        }
        this._panel.add((Component)this._overview, "rightOverview");
        JPanel jPanel = new JPanel();
        jPanel.setBackground(UIManager.getColor("control"));
        jPanel.setBorder(BorderFactory.createLineBorder(UIManager.getColor("controlDkShadow")));
        this._verticalScrollCardLayout = new CardLayout();
        this._verticalScrollPanel = new JPanel(this._verticalScrollCardLayout);
        this._verticalScrollPanel.add((Component)this._verticalScrollbar, GUI_VERTICAL_SCROLLBAR);
        this._verticalScrollPanel.add((Component)jPanel, GUI_VERTICAL_SPACER);
        this._panel.add((Component)this._verticalScrollPanel, "rightScrollbar");
        5 var4_4 = new 5();
        this._leftScrollPane.addMouseWheelListener(var4_4);
        this._rightScrollPane.addMouseWheelListener(var4_4);
        if (this._centerScrollPane != null) {
            this._centerScrollPane.addMouseWheelListener(var4_4);
        }
        this._overview.setBorder(BorderFactory.createEmptyBorder(UIManager.getInt("ScrollBar.width"), 3, UIManager.getInt("ScrollBar.width"), 3));
        this._leftGutter.setView(this._leftGutterPlugin);
        this._rightGutter.setView(this._rightGutterPlugin);
        this._leftEditor.setView(this._leftPane);
        this._rightEditor.setView(this._rightPane);
        if (this._centerEditor != null) {
            this._centerEditor.setView(this._centerPane);
        }
        this._leftEditor.setBackground(this._leftPane.getBackground());
        this._rightEditor.setBackground(this._leftEditor.getBackground());
        if (this._centerEditor != null) {
            this._centerEditor.setBackground(this._leftEditor.getBackground());
        }
        this._rightGutterPlugin.setLocation(4);
        Color color = UIManager.getColor("controlShadow");
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, color), BorderFactory.createEmptyBorder(2, 5, 2, 5));
        this._leftTitle.setBorder(compoundBorder);
        this._centerTitle.setBorder(compoundBorder);
        this._rightTitle.setBorder(compoundBorder);
        this.updateFontMetrics();
        this._verticalScrollbar.addAdjustmentListener(new 4());
        AutoScrollChangeListener autoScrollChangeListener = new AutoScrollChangeListener(null);
        this._leftEditor.addChangeListener(autoScrollChangeListener);
        this._rightEditor.addChangeListener(autoScrollChangeListener);
        if (this._centerEditor != null) {
            this._centerEditor.addChangeListener(autoScrollChangeListener);
        }
        OverviewComponentMouseHandler overviewComponentMouseHandler = new OverviewComponentMouseHandler(null);
        this._overview.addMouseMotionListener(overviewComponentMouseHandler);
        this._overview.addMouseListener(overviewComponentMouseHandler);
        CentralGutterMouseHandler centralGutterMouseHandler = new CentralGutterMouseHandler(null);
        this._diffGutter.addMouseListener(centralGutterMouseHandler);
        if (this._threePaneLeftDiffGutter != null) {
            this._threePaneLeftDiffGutter.addMouseListener(centralGutterMouseHandler);
        }
        BlockActivationListener blockActivationListener = new BlockActivationListener(null);
        this._leftPane.addFocusListener(blockActivationListener);
        this._leftPane.addCaretListener(blockActivationListener);
        this._rightPane.addFocusListener(blockActivationListener);
        this._rightPane.addCaretListener(blockActivationListener);
        if (this._centerPane != null) {
            this._centerPane.addFocusListener(blockActivationListener);
            this._centerPane.addCaretListener(blockActivationListener);
        }
        this._leftPane.addToolTipProvider(this);
        this._rightPane.addToolTipProvider(this);
        if (this._centerPane != null) {
            this._centerPane.addToolTipProvider(this);
        }
        PositionListener positionListener = new PositionListener(null);
        this._leftPane.addFocusListener(positionListener);
        this._leftPane.addCaretListener(positionListener);
        this._rightPane.addFocusListener(positionListener);
        this._rightPane.addCaretListener(positionListener);
        if (this._centerPane != null) {
            this._centerPane.addFocusListener(positionListener);
            this._centerPane.addCaretListener(positionListener);
        }
        this._currentTextPane = this._leftPane;
    }

    private JScrollPane createHorizontalScrollPane(Component component) {
        JScrollPane jScrollPane = new JScrollPane(component, 21, 30);
        jScrollPane.setAutoscrolls(true);
        jScrollPane.setWheelScrollingEnabled(false);
        jScrollPane.setBorder(null);
        return jScrollPane;
    }

    public Component getLeftOrCenterSplitter() {
        return ((SplitPanelLayout)this._panel.getLayout()).getComponent("leftSplitTop");
    }

    public Component getRightSplitter() {
        return ((SplitPanelLayout)this._panel.getLayout()).getComponent("centerSplitTop");
    }

    public void setSplitterLocation(Component component, int n) {
        this._panel.moveSplitter(component, n, component == this.getRightSplitter());
    }

    public int getSplitterLocation(Component component) {
        return component.getLocation().x + 25;
    }

    private void clearInlineHighLighters() {
        if (this._leftInlineHilite != null) {
            this._leftPane.deinstallPlugin(this._leftInlineHilite);
            this._rightPane.deinstallPlugin(this._rightInlineHilite);
            this._leftInlineHilite = null;
            this._rightInlineHilite = null;
        }
    }

    private void repaintEditors() {
        EventQueue.invokeLater(new 3());
    }

    public void setToolTipProvider(WedgeToolTipProvider wedgeToolTipProvider) {
        this._toolTipProvider = wedgeToolTipProvider;
    }

    public String getToolTipText(BasicEditorPane basicEditorPane, MouseEvent mouseEvent, int n) {
        if (this._toolTipProvider == null) {
            return null;
        }
        TextPane textPane = (TextPane)basicEditorPane;
        ContributorKind contributorKind = this.getContributorForPane(textPane);
        DifferenceBlock differenceBlock = this.getBlockAtRealLine(textPane, this.getContributor(contributorKind).getTextBuffer().getLineMap().getLineFromOffset(n));
        return differenceBlock != null ? this._toolTipProvider.getToolTipText(contributorKind, differenceBlock) : null;
    }

    public void addWedgeEditListener(WedgeEditListener wedgeEditListener) {
        this.addWedgeEditListener(ContributorKind.FIRST, wedgeEditListener);
        this.addWedgeEditListener(ContributorKind.SECOND, wedgeEditListener);
        if (this.getContributor(ContributorKind.ANCESTOR) != null) {
            this.addWedgeEditListener(ContributorKind.ANCESTOR, wedgeEditListener);
        }
    }

    public void addWedgeEditListener(ContributorKind contributorKind, WedgeEditListener wedgeEditListener) {
        Document document = this.getDocument(contributorKind);
        if (!(document instanceof BasicDocument)) {
            return;
        }
        EditListenerAdapter editListenerAdapter = new EditListenerAdapter(contributorKind, wedgeEditListener);
        this._undoableEditListeners.add(editListenerAdapter);
        BasicDocument basicDocument = (BasicDocument)document;
        basicDocument.addUndoableEditListener(editListenerAdapter);
    }

    public void removeWedgeEditListener(WedgeEditListener wedgeEditListener) {
        this.removeWedgeEditListener(ContributorKind.FIRST, wedgeEditListener);
        this.removeWedgeEditListener(ContributorKind.SECOND, wedgeEditListener);
        if (this.getContributor(ContributorKind.ANCESTOR) != null) {
            this.removeWedgeEditListener(ContributorKind.ANCESTOR, wedgeEditListener);
        }
    }

    public void removeWedgeEditListener(ContributorKind contributorKind, WedgeEditListener wedgeEditListener) {
        Document document = this.getDocument(contributorKind);
        if (!(document instanceof BasicDocument)) {
            return;
        }
        BasicDocument basicDocument = (BasicDocument)document;
        for (EditListenerAdapter editListenerAdapter : this._undoableEditListeners) {
            if (editListenerAdapter.getContributorKind() != contributorKind || editListenerAdapter.getWedgeEditListener() != wedgeEditListener) continue;
            basicDocument.removeUndoableEditListener(editListenerAdapter);
        }
    }

    private WedgeEditListener[] getWedgeEditListeners() {
        LinkedHashSet<WedgeEditListener> linkedHashSet = new LinkedHashSet<WedgeEditListener>();
        EditListenerAdapter[] editListenerAdapterArray = this._undoableEditListeners.toArray(new EditListenerAdapter[0]);
        int n = 0;
        while (n < editListenerAdapterArray.length) {
            linkedHashSet.add(editListenerAdapterArray[n].getWedgeEditListener());
            ++n;
        }
        return linkedHashSet.toArray(new WedgeEditListener[0]);
    }

    private void fireWedgeEditEvent(WedgeEditEvent wedgeEditEvent) {
        WedgeEditListener[] wedgeEditListenerArray = this.getWedgeEditListeners();
        int n = wedgeEditListenerArray.length - 1;
        while (n >= 0) {
            wedgeEditListenerArray[n].wedgeEditHappened(wedgeEditEvent);
            --n;
        }
        this.fireStatusEvent();
    }

    public void addStatusListener(ChangeListener changeListener) {
        this._statusListeners.add(changeListener);
    }

    public void removeStatusListener(ChangeListener changeListener) {
        this._statusListeners.remove(changeListener);
    }

    private void fireStatusEvent() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Iterator iterator = this._statusListeners.iterator();
        while (iterator.hasNext()) {
            ((ChangeListener)iterator.next()).stateChanged(changeEvent);
        }
    }

    private void updateCurrentMemento() {
        this._currentMemento = this.createMemento();
    }

    private ContributorKind getContributor(Document document) {
        if (document == this.getDocument(ContributorKind.FIRST)) {
            return ContributorKind.FIRST;
        }
        if (document == this.getDocument(ContributorKind.SECOND)) {
            return ContributorKind.SECOND;
        }
        if (document == this.getDocument(ContributorKind.ANCESTOR)) {
            return ContributorKind.ANCESTOR;
        }
        throw new IllegalStateException();
    }

    public WedgeCompareMemento createMemento() {
        if (this._mode != CompareMode.THREE_WAY_MERGE) {
            return null;
        }
        WedgeCompareMemento wedgeCompareMemento = new WedgeCompareMemento();
        try {
            wedgeCompareMemento.setDifferences(CompareDifference.cloneDifferences(this._model.getDifferenceBlocks()));
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        return wedgeCompareMemento;
    }

    public void setMemento(WedgeCompareMemento wedgeCompareMemento) {
        if (this._mode != CompareMode.THREE_WAY_MERGE) {
            return;
        }
        try {
            CompareDifference[] compareDifferenceArray = CompareDifference.cloneDifferences(wedgeCompareMemento.getDifferences());
            DifferenceBlock[] differenceBlockArray = new DifferenceBlock[compareDifferenceArray.length];
            System.arraycopy(compareDifferenceArray, 0, differenceBlockArray, 0, compareDifferenceArray.length);
            TextCompareModel textCompareModel = this._model.createInstance(differenceBlockArray);
            textCompareModel.evaluateOffsets();
            this.updateModel(textCompareModel);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
    }

    private boolean isThreePaneMode() {
        return this._panel.isThreePaneMode();
    }

    private void setThreePaneMode(boolean bl) {
        this._leftPane.setThreePaneMode(bl);
        this._rightPane.setThreePaneMode(bl);
        if (this._centerPane != null) {
            this._centerPane.setThreePaneMode(bl);
        }
        this._panel.setThreePaneMode(bl);
    }

    private void setCurrentBlock(DifferenceBlock differenceBlock) {
        if (this._currentBlock != differenceBlock) {
            this._currentBlock = differenceBlock;
            this._leftPane.setCurrentBlock(differenceBlock);
            this._rightPane.setCurrentBlock(differenceBlock);
            if (this._centerPane != null) {
                this._centerPane.setCurrentBlock(differenceBlock);
            }
            this._diffGutter.repaint();
            if (this._threePaneLeftDiffGutter != null) {
                this._threePaneLeftDiffGutter.repaint();
            }
            if (this.isShowInlineCharDiffs()) {
                this.clearInlineHighLighters();
                if (this._centerPane != null && this._centerInlineHilite != null) {
                    this._centerPane.deinstallPlugin(this._centerInlineHilite);
                    this._centerInlineHilite = null;
                }
                if (differenceBlock != null && differenceBlock.getKind() == 2) {
                    this.showInlineDifferences(differenceBlock);
                }
            }
        }
    }

    private void showInlineDifferences(DifferenceBlock differenceBlock) {
        try {
            InlineCompareModel inlineCompareModel = InlineCompareModel.buildModel((TextCompareModel)this.getModel(), differenceBlock);
            this._leftInlineHilite = new InlineDiffHighlighter(ContributorKind.FIRST);
            this._rightInlineHilite = new InlineDiffHighlighter(ContributorKind.SECOND);
            if (this._centerPane != null) {
                this._centerInlineHilite = new InlineDiffHighlighter(ContributorKind.ANCESTOR);
            }
            this._leftPane.installPlugin(this._leftInlineHilite);
            this._rightPane.installPlugin(this._rightInlineHilite);
            if (this._centerInlineHilite != null) {
                this._centerPane.installPlugin(this._centerInlineHilite);
            }
            this._leftInlineHilite.setModel(inlineCompareModel, this.getContributor(ContributorKind.FIRST).getTextBuffer());
            this._rightInlineHilite.setModel(inlineCompareModel, this.getContributor(ContributorKind.SECOND).getTextBuffer());
            if (this._centerInlineHilite != null) {
                this._centerInlineHilite.setModel(inlineCompareModel, this.getContributor(ContributorKind.ANCESTOR).getTextBuffer());
            }
        }
        catch (CompareFailedException compareFailedException) {
            compareFailedException.printStackTrace();
        }
    }

    private DifferenceBlock getBlockAtRealLine(TextPane textPane, int n) {
        ContributorKind contributorKind = this.getContributorForPane(textPane);
        Iterator iterator = this.getDiffBlockIterator();
        while (iterator.hasNext()) {
            DifferenceBlock differenceBlock = (DifferenceBlock)iterator.next();
            if (n < differenceBlock.getStart(contributorKind) || n >= differenceBlock.getStart(contributorKind) + Math.max(1, differenceBlock.getLength(contributorKind))) continue;
            if (differenceBlock.getKind() == 0) {
                return null;
            }
            return differenceBlock;
        }
        return null;
    }

    private void updateCurrentBlock() {
        int n;
        if (this._currentTextPane == null) {
            return;
        }
        LineMap lineMap = this.getContributor(this.getContributorForPane(this._currentTextPane)).getTextBuffer().getLineMap();
        int n2 = lineMap.getLineFromOffset(this._currentTextPane.getSelectionStart());
        if (n2 == (n = lineMap.getLineFromOffset(this._currentTextPane.getSelectionEnd()))) {
            this.setCurrentBlock(this.getBlockAtRealLine(this._currentTextPane, n2));
        } else {
            DifferenceBlock differenceBlock;
            DifferenceBlock differenceBlock2;
            if (lineMap.getLineStartOffset(n) == this._currentTextPane.getSelectionEnd()) {
                n = Math.max(n2, n - 1);
            }
            this.setCurrentBlock((differenceBlock2 = this.getBlockAtRealLine(this._currentTextPane, n2)) == (differenceBlock = this.getBlockAtRealLine(this._currentTextPane, n)) ? differenceBlock2 : null);
        }
    }

    private ResourceBundle getBundle() {
        return BundleLoader.getBundle("oracle.javatools.resource.CompareResource");
    }

    public void setEditLocked(boolean bl) {
        this._editLocked = bl;
        this._leftPane.setEditable(bl ? false : this.getContributor(ContributorKind.FIRST) instanceof EditableContributor && ((EditableContributor)((Object)this.getContributor(ContributorKind.FIRST))).isEditable());
        this._rightPane.setEditable(bl ? false : this.getContributor(ContributorKind.SECOND) instanceof EditableContributor && ((EditableContributor)((Object)this.getContributor(ContributorKind.SECOND))).isEditable());
        if (this._centerPane == null) {
            return;
        }
        if (this.getContributor(ContributorKind.ANCESTOR) == null) {
            this._centerPane.setEditable(false);
        } else {
            this._centerPane.setEditable(bl ? false : this.getContributor(ContributorKind.ANCESTOR) instanceof EditableContributor && ((EditableContributor)((Object)this.getContributor(ContributorKind.ANCESTOR))).isEditable());
        }
    }

    public boolean isEditLocked() {
        return this._editLocked;
    }

    private void updateFontMetrics() {
        this._textPaneFontHeight = this._leftPane.getFontMetrics(this._leftPane.getFont()).getHeight();
    }

    private void moveCaretToBlock(DifferenceBlock differenceBlock, ContributorKind contributorKind) {
        TextCompareContributor textCompareContributor = this.getContributor(contributorKind);
        if (textCompareContributor == null) {
            return;
        }
        LineMap lineMap = textCompareContributor.getTextBuffer().getLineMap();
        if (this.canSelectBlockOnMoveCaret(differenceBlock, contributorKind)) {
            int n = lineMap.getLineEndOffset(differenceBlock.getStart(contributorKind) + differenceBlock.getLength(contributorKind) - 1);
            int n2 = lineMap.getLineStartOffset(differenceBlock.getStart(contributorKind));
            this.getTextPane(contributorKind).setCaretPosition(n);
            this.getTextPane(contributorKind).moveCaretPosition(n2);
        } else {
            this.getTextPane(contributorKind).setCaretPosition(lineMap.getLineStartOffset(differenceBlock.getStart(contributorKind)));
        }
    }

    private boolean canSelectBlockOnMoveCaret(DifferenceBlock differenceBlock, ContributorKind contributorKind) {
        if (this.isShowInlineCharDiffs() || differenceBlock.getLength(contributorKind) <= 0) {
            return false;
        }
        return this.getTextPane(contributorKind) == this._currentTextPane;
    }

    private boolean isTextPaneFocusOwner() {
        return this._leftPane.isFocusOwner() || this._rightPane.isFocusOwner() || this._centerPane != null && this._centerPane.isFocusOwner();
    }

    private TextPane getTextPane(ContributorKind contributorKind) {
        if (contributorKind == ContributorKind.FIRST) {
            return this._leftPane;
        }
        if (contributorKind == ContributorKind.SECOND) {
            return this._rightPane;
        }
        if (contributorKind == ContributorKind.ANCESTOR) {
            return this._centerPane;
        }
        return null;
    }

    private CustomViewport getViewPort(ContributorKind contributorKind) {
        if (contributorKind == ContributorKind.FIRST) {
            return this._leftEditor;
        }
        if (contributorKind == ContributorKind.SECOND) {
            return this._rightEditor;
        }
        if (contributorKind == ContributorKind.ANCESTOR) {
            return this._centerEditor;
        }
        return null;
    }

    private CustomViewport getGutterViewportFor(JViewport jViewport) {
        if (jViewport == this._leftEditor) {
            return this._leftGutter;
        }
        if (jViewport == this._rightEditor) {
            return this._rightGutter;
        }
        return null;
    }

    private ContributorKind getContributorForViewPort(JViewport jViewport) {
        if (jViewport == this._leftEditor) {
            return ContributorKind.FIRST;
        }
        if (jViewport == this._rightEditor) {
            return ContributorKind.SECOND;
        }
        if (this._centerEditor != null && jViewport == this._centerEditor) {
            return ContributorKind.ANCESTOR;
        }
        return null;
    }

    private void horizontalScrollTo(Object object, int n) {
        ArrayList<JScrollBar> arrayList = new ArrayList<JScrollBar>();
        arrayList.add(this._leftScrollPane.getHorizontalScrollBar());
        arrayList.add(this._rightScrollPane.getHorizontalScrollBar());
        if (this._centerScrollPane != null) {
            arrayList.add(this._centerScrollPane.getHorizontalScrollBar());
        }
        for (JScrollBar jScrollBar : arrayList) {
            if (jScrollBar == object) continue;
            jScrollBar.setValue(Math.min(jScrollBar.getMaximum(), n));
        }
    }

    private void verticalScrollTo(int n) {
        if (this._verticalScrollLock) {
            return;
        }
        try {
            this._verticalScrollLock = true;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            Iterator iterator = this.getDiffBlockIterator();
            while (iterator.hasNext()) {
                DifferenceBlock differenceBlock = (DifferenceBlock)iterator.next();
                int n6 = differenceBlock.getMaxLength();
                n2 += differenceBlock.getLength(ContributorKind.FIRST);
                n3 += differenceBlock.getLength(ContributorKind.SECOND);
                n4 += differenceBlock.getLength(ContributorKind.ANCESTOR);
                if ((n5 += n6) < n) continue;
                int n7 = n5 - n;
                n2 -= Math.min(differenceBlock.getLength(ContributorKind.FIRST), n7);
                n3 -= Math.min(differenceBlock.getLength(ContributorKind.SECOND), n7);
                n4 -= Math.min(differenceBlock.getLength(ContributorKind.ANCESTOR), n7);
                break;
            }
            int n8 = n2 * this._textPaneFontHeight;
            int n9 = n3 * this._textPaneFontHeight;
            int n10 = n4 * this._textPaneFontHeight;
            CustomViewport customViewport = this.getViewPort(ContributorKind.FIRST);
            CustomViewport customViewport2 = this.getViewPort(ContributorKind.SECOND);
            CustomViewport customViewport3 = this.getViewPort(ContributorKind.ANCESTOR);
            customViewport.setViewPositionImpl(new Point(customViewport.getViewPosition().x, n8));
            customViewport2.setViewPositionImpl(new Point(customViewport2.getViewPosition().x, n9));
            if (customViewport3 != null) {
                customViewport3.setViewPositionImpl(new Point(customViewport3.getViewPosition().x, n10));
            }
            this._diffGutter.repaint();
            if (this._threePaneLeftDiffGutter != null) {
                this._threePaneLeftDiffGutter.repaint();
            }
            this._verticalScrollbar.setValue(n);
        }
        finally {
            this._verticalScrollLock = false;
        }
    }

    protected void updateOnEdit() {
        try {
            CompareModel compareModel = this.getModel();
            if (this._mode == CompareMode.TWO_WAY_COMPARE) {
                compareModel = CompareModelFactory.createCompareModel(this.getModel().getContributor(ContributorKind.FIRST), this.getModel().getContributor(ContributorKind.SECOND), this.getModel().getType());
            }
            this.updateModel(compareModel);
        }
        catch (CompareFailedException compareFailedException) {
            compareFailedException.printStackTrace();
        }
    }

    private void updateModel(CompareModel compareModel) {
        this._currentBlock = null;
        this._model = (TextCompareModel)compareModel;
        this.updateTextPaneModel(this._leftPane);
        this.updateTextPaneModel(this._rightPane);
        if (this._centerPane != null) {
            this.updateTextPaneModel(this._centerPane);
        }
        this._diffGutter.repaint();
        if (this._threePaneLeftDiffGutter != null) {
            this._threePaneLeftDiffGutter.repaint();
        }
        this._overview.repaint();
        this.updateCurrentBlock();
        this.updateCurrentMemento();
        this.fireStatusEvent();
    }

    private void updateTextPaneModel(TextPane textPane) {
        int n = textPane.getCaret().getDot();
        int n2 = textPane.getSelectionStart();
        int n3 = textPane.getSelectionEnd();
        this._verticalScrollLock = true;
        if (n3 <= n2) {
            textPane.setSelectionStart(n);
            textPane.setSelectionEnd(n);
        } else {
            textPane.setSelectionStart(n2);
            textPane.setSelectionEnd(n3);
        }
        this._verticalScrollLock = false;
        textPane.updateModel(this._model);
    }

    public void setModel(CompareModel compareModel) {
        if (this._model == null && compareModel != null) {
            2 var2_2 = new 2();
            this._leftPane.installPlugin(var2_2);
            this.addCompareHintListener();
        }
        if (this._model != null) {
            this._leftPane.deinstallPlugin(this._leftGutterPlugin);
            this._rightPane.deinstallPlugin(this._rightGutterPlugin);
            this.getContributor(ContributorKind.FIRST).removePropertyChangeListener(this._contributorListener);
            this.getContributor(ContributorKind.SECOND).removePropertyChangeListener(this._contributorListener);
            this.getContributor(ContributorKind.FIRST).removeChangeListener(this._contributorListener);
            this.getContributor(ContributorKind.SECOND).removeChangeListener(this._contributorListener);
            if (this.getContributor(ContributorKind.ANCESTOR) != null) {
                this.getContributor(ContributorKind.ANCESTOR).removePropertyChangeListener(this._contributorListener);
                this.getContributor(ContributorKind.ANCESTOR).removeChangeListener(this._contributorListener);
            }
            this._contributorListener = null;
        }
        this._currentBlock = null;
        this._model = (TextCompareModel)compareModel;
        this._leftPane.setModel(this._model);
        this._rightPane.setModel(this._model);
        if (this._centerPane != null) {
            this._centerPane.setModel(this._model);
        }
        if (compareModel != null) {
            this._leftPane.installPlugin(this._leftGutterPlugin);
            this._rightPane.installPlugin(this._rightGutterPlugin);
            this.setEditLocked(false);
            this.updateTitles();
            this._contributorListener = new ContributorListener(null);
            this.getContributor(ContributorKind.FIRST).addPropertyChangeListener(this._contributorListener);
            this.getContributor(ContributorKind.SECOND).addPropertyChangeListener(this._contributorListener);
            this.getContributor(ContributorKind.FIRST).addChangeListener(this._contributorListener);
            this.getContributor(ContributorKind.SECOND).addChangeListener(this._contributorListener);
            if (this.getContributor(ContributorKind.ANCESTOR) != null) {
                this.getContributor(ContributorKind.ANCESTOR).addPropertyChangeListener(this._contributorListener);
                this.getContributor(ContributorKind.ANCESTOR).addChangeListener(this._contributorListener);
            }
            this._diffGutter.repaint();
            if (this._threePaneLeftDiffGutter != null) {
                this._threePaneLeftDiffGutter.repaint();
            }
            this._overview.repaint();
        }
        if (compareModel == null) {
            this._horizontalScrollPanel = null;
            CompareHints.removeListener(this._compareHintListener);
            this._compareHintListener = null;
        }
        if (compareModel != null && compareModel.getType() == CompareType.DIRECTORY) {
            this._leftGutterPlugin.setShowLineNumbers(2);
            this._rightGutterPlugin.setShowLineNumbers(2);
            this._leftPane.setEditable(false);
            this._rightPane.setEditable(false);
            if (this._centerPane != null) {
                this._centerPane.setEditable(false);
            }
            this._leftPane.getBlockHighlighter().setSuppressSelectedSeparators(true);
            this._rightPane.getBlockHighlighter().setSuppressSelectedSeparators(true);
            if (this._centerPane != null) {
                this._centerPane.getBlockHighlighter().setSuppressSelectedSeparators(true);
            }
        }
        this.updateCurrentMemento();
        this.fireStatusEvent();
    }

    private void addCompareHintListener() {
        if (this._compareHintListener == null) {
            this._compareHintListener = new HintListener(null);
        }
        CompareHints.addListener(this._compareHintListener);
    }

    private void updateTitles() {
        this.updateTitle(this.getModel().getContributor(ContributorKind.FIRST), this._leftTitle);
        this.updateTitle(this.getModel().getContributor(ContributorKind.SECOND), this._rightTitle);
        this.updateTitle(this.getModel().getContributor(ContributorKind.ANCESTOR), this._centerTitle);
    }

    private void updateTitle(CompareContributor compareContributor, JLabel jLabel) {
        if (compareContributor == null) {
            return;
        }
        boolean bl = true;
        boolean bl2 = false;
        if (compareContributor instanceof EditableContributor) {
            if (!this.isEditLocked()) {
                bl = ((EditableContributor)((Object)compareContributor)).isEditable() ^ true;
            }
            bl2 = ((EditableContributor)((Object)compareContributor)).isModified();
        }
        String string = null;
        String string2 = null;
        if (bl) {
            string = MessageFormat.format(this.getBundle().getString("TITLE_READ_ONLY"), compareContributor.getShortLabel());
            string2 = MessageFormat.format(this.getBundle().getString("TOOLTIP_READ_ONLY"), compareContributor.getLongLabel());
        } else if (bl2) {
            string = compareContributor.getShortLabel();
            string2 = MessageFormat.format(this.getBundle().getString("TOOLTIP_MODIFIED"), compareContributor.getLongLabel());
        } else {
            string = MessageFormat.format(this.getBundle().getString("TITLE_EDITABLE"), compareContributor.getShortLabel());
            string2 = MessageFormat.format(this.getBundle().getString("TOOLTIP_EDITABLE"), compareContributor.getLongLabel());
        }
        jLabel.setText(string);
        jLabel.setToolTipText(string2);
        Font font = UIManager.getFont("Label.font");
        if (bl2) {
            jLabel.setFont(new Font(font.getName(), 2, font.getSize()));
        } else {
            jLabel.setFont(font);
        }
    }

    public CompareModel getModel() {
        return this._model;
    }

    public Component getGUI() {
        return this._panel;
    }

    private TextCompareContributor getContributor(ContributorKind contributorKind) {
        return (TextCompareContributor)this._model.getContributor(contributorKind);
    }

    private int getLineCount(ContributorKind contributorKind) {
        TextCompareContributor textCompareContributor = this.getContributor(contributorKind);
        if (textCompareContributor == null) {
            return 0;
        }
        return textCompareContributor.getTextBuffer().getLineMap().getLineCount();
    }

    public Document getDocument(ContributorKind contributorKind) {
        return this.getTextPane(contributorKind).getDocument();
    }

    private Iterator getDiffBlockIterator() {
        DiffBlockIterator diffBlockIterator = new DiffBlockIterator(null);
        diffBlockIterator.reset();
        return diffBlockIterator;
    }

    private int getVirtualLineForReal(int n, ContributorKind contributorKind) {
        int n2 = 0;
        int n3 = 0;
        if (n == 0) {
            return 0;
        }
        Iterator iterator = this.getDiffBlockIterator();
        while (iterator.hasNext()) {
            DifferenceBlock differenceBlock = (DifferenceBlock)iterator.next();
            n2 += differenceBlock.getMaxLength();
            if ((n3 += differenceBlock.getLength(contributorKind)) < n) continue;
            int n4 = n3 - n;
            return n2 -= Math.min(n4, differenceBlock.getLength(contributorKind));
        }
        return -1;
    }

    private void updateVerticalScrollbar() {
        int n = this.getVirtualHeightLines();
        this._verticalScrollbar.setMaximum(n);
        int n2 = this._leftScrollPane.getViewport().getViewRect().height / this._textPaneFontHeight;
        this._verticalScrollbar.setVisibleAmount(n2);
        this._verticalScrollbar.setBlockIncrement(n2 - 1);
        if (n2 < n) {
            this._verticalScrollCardLayout.show(this._verticalScrollPanel, GUI_VERTICAL_SCROLLBAR);
        } else {
            this._verticalScrollCardLayout.show(this._verticalScrollPanel, GUI_VERTICAL_SPACER);
        }
        this._overview.setMasked(this.getModel().getDifferenceCount() == 0 || n2 >= n);
    }

    private int getVirtualHeightLines() {
        int n = 0;
        Iterator iterator = this.getDiffBlockIterator();
        while (iterator.hasNext()) {
            DifferenceBlock differenceBlock = (DifferenceBlock)iterator.next();
            n += differenceBlock.getMaxLength();
        }
        return n;
    }

    private boolean isEditable(ContributorKind contributorKind) {
        return !this.isEditLocked() && this.getContributor(contributorKind) instanceof EditableContributor && ((EditableContributor)((Object)this.getContributor(contributorKind))).isEditable();
    }

    private boolean hasDefaultEditAction(ContributorKind contributorKind, ContributorKind contributorKind2) {
        if (contributorKind == ContributorKind.ANCESTOR && contributorKind2 == ContributorKind.FIRST) {
            return false;
        }
        return this.isEditable(contributorKind2) || this.isEditable(contributorKind);
    }

    private Action getDefaultEditAction(DifferenceBlock differenceBlock, ContributorKind contributorKind, ContributorKind contributorKind2) {
        if (!this.hasDefaultEditAction(contributorKind, contributorKind2)) {
            return null;
        }
        if (this.isEditable(contributorKind2)) {
            if (differenceBlock.isChange(contributorKind, contributorKind2)) {
                return new ReplaceBlockAction(differenceBlock, contributorKind, contributorKind2);
            }
            if (differenceBlock.getLength(contributorKind2) == 0 || this._model != null && this._model.getType() == CompareType.TEXT) {
                return new InsertBlockAction(differenceBlock, contributorKind, contributorKind2);
            }
        }
        if (this.isEditable(contributorKind)) {
            return new DeleteBlockAction(contributorKind, differenceBlock);
        }
        return null;
    }

    private Icon getDefaultEditActionIcon(DifferenceBlock differenceBlock, ContributorKind contributorKind, ContributorKind contributorKind2, boolean bl) {
        if (!this.hasDefaultEditAction(contributorKind, contributorKind2)) {
            return null;
        }
        if (this.isEditable(contributorKind2) && (differenceBlock.isChange(contributorKind, contributorKind2) || differenceBlock.getLength(contributorKind2) == 0 || this._model != null && this._model.getType() == CompareType.TEXT)) {
            if (bl) {
                if (this._editLeftIcon == null) {
                    this._editLeftIcon = new ImageIcon(CompareResource.class.getResource("/oracle/javatools/icons/images/editright.gif"));
                }
                return this._editLeftIcon;
            }
            if (this._editRightIcon == null) {
                this._editRightIcon = new ImageIcon(CompareResource.class.getResource("/oracle/javatools/icons/images/editleft.gif"));
            }
            return this._editRightIcon;
        }
        if (this.isEditable(contributorKind)) {
            if (this._editRemoveIcon == null) {
                this._editRemoveIcon = new ImageIcon(CompareResource.class.getResource("/oracle/javatools/icons/images/editremove.gif"));
            }
            return this._editRemoveIcon;
        }
        return null;
    }

    public Action[] getEditActions() {
        if (this._currentBlock == null) {
            return null;
        }
        if (!this.isTextPaneFocusOwner()) {
            return null;
        }
        ContributorKind contributorKind = this.getContributorForPane(this.getCurrentTextPane());
        return this.getEditActions(this._currentBlock, contributorKind, this.getAdjacentContributor(contributorKind));
    }

    private ContributorKind getAdjacentContributor(ContributorKind contributorKind) {
        ContributorKind contributorKind2 = this.getLeftAdjacentContributor(contributorKind);
        return contributorKind2 != null ? contributorKind2 : this.getRightAdjacentContributor(contributorKind);
    }

    private ContributorKind getLeftAdjacentContributor(ContributorKind contributorKind) {
        if (this._diffGutter != null && WedgeDiffGutter.mav$getRightContributor(this._diffGutter) == contributorKind) {
            return WedgeDiffGutter.mav$getLeftContributor(this._diffGutter);
        }
        if (this._threePaneLeftDiffGutter != null && WedgeDiffGutter.mav$getRightContributor(this._threePaneLeftDiffGutter) == contributorKind) {
            return WedgeDiffGutter.mav$getLeftContributor(this._threePaneLeftDiffGutter);
        }
        return null;
    }

    private ContributorKind getRightAdjacentContributor(ContributorKind contributorKind) {
        if (this._diffGutter != null && WedgeDiffGutter.mav$getLeftContributor(this._diffGutter) == contributorKind) {
            return WedgeDiffGutter.mav$getRightContributor(this._diffGutter);
        }
        if (this._threePaneLeftDiffGutter != null && WedgeDiffGutter.mav$getLeftContributor(this._threePaneLeftDiffGutter) == contributorKind) {
            return WedgeDiffGutter.mav$getRightContributor(this._threePaneLeftDiffGutter);
        }
        return null;
    }

    private Action[] getEditActions(DifferenceBlock differenceBlock, ContributorKind contributorKind, ContributorKind contributorKind2) {
        ArrayList<AbstractAction> arrayList = new ArrayList<AbstractAction>();
        if (this.isEditable(contributorKind) && differenceBlock.getLength(contributorKind) > 0) {
            arrayList.add(new DeleteBlockAction(contributorKind, differenceBlock));
        }
        if (contributorKind2 != null && this.isEditable(contributorKind2)) {
            arrayList.add(null);
            if (differenceBlock.isChange(contributorKind, contributorKind2)) {
                arrayList.add(new ReplaceBlockAction(differenceBlock, contributorKind, contributorKind2));
            }
            if (differenceBlock.getLength(contributorKind2) == 0 || this._model != null && this._model.getType() == CompareType.TEXT) {
                arrayList.add(new InsertBlockAction(differenceBlock, contributorKind, contributorKind2));
            }
        }
        if (arrayList.size() > 0 && arrayList.get(arrayList.size() - 1) == null) {
            arrayList.remove(arrayList.size() - 1);
        }
        if (contributorKind2 != null && (this.isEditable(contributorKind) || this.isEditable(contributorKind2))) {
            int n;
            arrayList.add(null);
            if (differenceBlock.isConflict() && !differenceBlock.isResolved() && differenceBlock instanceof OffsetDifferenceBlock) {
                arrayList.add(new MarkResolvedAction((OffsetDifferenceBlock)differenceBlock));
            }
            if ((n = this._model.getConflictCount()) > 0 && this._model.getResolvedCount() < n) {
                arrayList.add(new MarkAllResolvedAction(this._model));
            }
        }
        if (arrayList.size() > 0 && arrayList.get(arrayList.size() - 1) == null) {
            arrayList.remove(arrayList.size() - 1);
        }
        if (arrayList.size() > 0 && arrayList.get(0) == null) {
            arrayList.remove(0);
        }
        return arrayList.toArray(new Action[0]);
    }

    public void deleteBlock(DifferenceBlock differenceBlock, ContributorKind contributorKind) {
        TextCompareContributor textCompareContributor = this.getContributor(contributorKind);
        TextPane textPane = this.getTextPane(contributorKind);
        UndoableEdit undoableEdit = null;
        try {
            textPane.beginEdit(new EditDescriptor(this.getBundle().getString("REMOVE_ACTION_NAME")));
            TextBuffer textBuffer = textCompareContributor.getTextBuffer();
            int n = differenceBlock.getStart(contributorKind);
            int n2 = differenceBlock.getStart(contributorKind) + differenceBlock.getLength(contributorKind) - 1;
            int n3 = textBuffer.getLineMap().getLineStartOffset(n);
            MergeEditState mergeEditState = this.mergePreEdit(differenceBlock, contributorKind, 0);
            undoableEdit = textCompareContributor.deleteElement(n, n2);
            this.mergePostEdit(differenceBlock, contributorKind, mergeEditState);
            this.getTextPane(contributorKind).requestFocus();
            this._verticalScrollLock = true;
            this.getTextPane(contributorKind).setCaretPosition(n3);
            this._verticalScrollLock = false;
        }
        catch (Throwable throwable) {
            textPane.endEdit(false, undoableEdit);
            this.mergeEndEdit(differenceBlock, contributorKind);
            throw throwable;
        }
        textPane.endEdit(false, undoableEdit);
        this.mergeEndEdit(differenceBlock, contributorKind);
    }

    public void insertBlockCopy(DifferenceBlock differenceBlock, ContributorKind contributorKind, ContributorKind contributorKind2) {
        TextCompareContributor textCompareContributor = this.getContributor(contributorKind2);
        TextPane textPane = this.getTextPane(contributorKind2);
        TextCompareElement textCompareElement = this.getContributor(contributorKind).getElement(differenceBlock, contributorKind);
        UndoableEdit undoableEdit = null;
        try {
            boolean bl;
            int n;
            textPane.beginEdit(new EditDescriptor(this.getBundle().getString("INSERT_ACTION_NAME")));
            TextBuffer textBuffer = textCompareContributor.getTextBuffer();
            if (differenceBlock.getLength(contributorKind2) == 0) {
                n = differenceBlock.getStart(contributorKind2);
                bl = false;
            } else {
                n = differenceBlock.getStart(contributorKind2) + differenceBlock.getLength(contributorKind2) - 1;
                bl = true;
            }
            int n2 = !bl ? textBuffer.getLineMap().getLineStartOffset(n) : textBuffer.getLineMap().getLineEndOffset(n);
            MergeEditState mergeEditState = this.mergePreEdit(differenceBlock, contributorKind2, differenceBlock.getLength(contributorKind) + differenceBlock.getLength(contributorKind2));
            undoableEdit = textCompareContributor.insertElement(n, bl, textCompareElement);
            this.mergePostEdit(differenceBlock, contributorKind2, mergeEditState);
            this.getTextPane(contributorKind2).requestFocus();
            this._verticalScrollLock = true;
            this.getTextPane(contributorKind2).setCaretPosition(n2);
            this.getTextPane(contributorKind2).moveCaretPosition(n2 + textCompareElement.getChars().length);
            this._verticalScrollLock = false;
        }
        catch (Throwable throwable) {
            textPane.endEdit(false, undoableEdit);
            this.mergeEndEdit(differenceBlock, contributorKind2);
            throw throwable;
        }
        textPane.endEdit(false, undoableEdit);
        this.mergeEndEdit(differenceBlock, contributorKind2);
    }

    public void replaceBlock(DifferenceBlock differenceBlock, ContributorKind contributorKind, ContributorKind contributorKind2) {
        TextCompareContributor textCompareContributor = this.getContributor(contributorKind2);
        TextPane textPane = this.getTextPane(contributorKind2);
        TextCompareElement textCompareElement = this.getContributor(contributorKind).getElement(differenceBlock, contributorKind);
        UndoableEdit undoableEdit = null;
        try {
            textPane.beginEdit(new EditDescriptor(this.getBundle().getString("REPLACE_ACTION_NAME")));
            TextBuffer textBuffer = textCompareContributor.getTextBuffer();
            int n = differenceBlock.getStart(contributorKind2);
            int n2 = differenceBlock.getStart(contributorKind2) + differenceBlock.getLength(contributorKind2) - 1;
            int n3 = textBuffer.getLineMap().getLineStartOffset(n);
            MergeEditState mergeEditState = this.mergePreEdit(differenceBlock, contributorKind2, differenceBlock.getLength(contributorKind));
            undoableEdit = textCompareContributor.replaceElement(n, n2, textCompareElement);
            this.mergePostEdit(differenceBlock, contributorKind2, mergeEditState);
            this.getTextPane(contributorKind2).requestFocus();
            this._verticalScrollLock = true;
            this.getTextPane(contributorKind2).setCaretPosition(n3);
            this.getTextPane(contributorKind2).moveCaretPosition(n3 + textCompareElement.getChars().length);
            this._verticalScrollLock = false;
        }
        catch (Throwable throwable) {
            textPane.endEdit(false, undoableEdit);
            this.mergeEndEdit(differenceBlock, contributorKind2);
            throw throwable;
        }
        textPane.endEdit(false, undoableEdit);
        this.mergeEndEdit(differenceBlock, contributorKind2);
    }

    private MergeEditState mergePreEdit(DifferenceBlock differenceBlock, ContributorKind contributorKind, int n) {
        if (!(differenceBlock instanceof OffsetDifferenceBlock)) {
            return null;
        }
        OffsetDifferenceBlock offsetDifferenceBlock = (OffsetDifferenceBlock)differenceBlock;
        MergeEditState mergeEditState = new MergeEditState(offsetDifferenceBlock.getStart(contributorKind), n);
        this.getTextPane(contributorKind).putClientProperty(PROPERTY_UNDO_MOMENTO, this.createMemento());
        offsetDifferenceBlock.resetStart(contributorKind);
        offsetDifferenceBlock.resetLength(contributorKind);
        return mergeEditState;
    }

    private void mergePostEdit(DifferenceBlock differenceBlock, ContributorKind contributorKind, MergeEditState mergeEditState) {
        if (!(differenceBlock instanceof OffsetDifferenceBlock)) {
            return;
        }
        OffsetDifferenceBlock offsetDifferenceBlock = (OffsetDifferenceBlock)differenceBlock;
        offsetDifferenceBlock.setStart(contributorKind, mergeEditState.getStartLine());
        offsetDifferenceBlock.setLength(contributorKind, mergeEditState.getLength());
        offsetDifferenceBlock.evaluateOffets();
        offsetDifferenceBlock.setResolved(true);
        this.getTextPane(contributorKind).putClientProperty(PROPERTY_REDO_MOMENTO, this.createMemento());
    }

    private void mergeEndEdit(DifferenceBlock differenceBlock, ContributorKind contributorKind) {
        if (!(differenceBlock instanceof OffsetDifferenceBlock)) {
            return;
        }
        this.updateCurrentMemento();
        EventQueue.invokeLater(new 1(this, contributorKind));
    }

    public void goToDifference(DifferenceBlock differenceBlock) {
        this.goToDifference(differenceBlock, true);
    }

    private void goToDifference(DifferenceBlock differenceBlock, boolean bl) {
        int n = this._leftEditor.getViewRect().height / this._textPaneFontHeight;
        int n2 = Math.max(0, differenceBlock.getStart(ContributorKind.FIRST));
        int n3 = this.getVirtualLineForReal(n2, ContributorKind.FIRST);
        if (this._verticalScrollbar.isVisible()) {
            this.verticalScrollTo(n3);
        }
        this.moveCaretToBlock(differenceBlock, ContributorKind.FIRST);
        this.moveCaretToBlock(differenceBlock, ContributorKind.SECOND);
        this.moveCaretToBlock(differenceBlock, ContributorKind.ANCESTOR);
    }

    public boolean goToInitialDifference() {
        if (this._model.getDifferences().length == 0) {
            return false;
        }
        this.goToDifference(this._model.getDifferenceBlocks()[0], false);
        return true;
    }

    public boolean goToFirstDifference() {
        if (this._model.getDifferences().length == 0) {
            return false;
        }
        this.goToDifference(this._model.getDifferenceBlocks()[0]);
        return true;
    }

    public boolean goToLastDifference() {
        if (this._model.getDifferenceBlocks().length == 0) {
            return false;
        }
        this.goToDifference(this._model.getDifferenceBlocks()[this._model.getDifferenceBlocks().length - 1]);
        return true;
    }

    public boolean goToPreviousDifference() {
        DifferenceBlock differenceBlock = this.getPreviousDifference();
        if (differenceBlock != null) {
            this.goToDifference(differenceBlock);
            return true;
        }
        return false;
    }

    private DifferenceBlock getPreviousDifference() {
        TextPane textPane = this.getCurrentTextPane();
        if (textPane == null) {
            return null;
        }
        ContributorKind contributorKind = this.getContributorForPane(textPane);
        int n = this.getCurrentCaretLine(contributorKind);
        int n2 = this._model.getDifferences().length - 1;
        while (n2 >= 0) {
            DifferenceBlock differenceBlock = this._model.getDifferenceBlocks()[n2];
            if (differenceBlock.getStart(contributorKind) != n && differenceBlock.getStart(contributorKind) + differenceBlock.getLength(contributorKind) <= n) {
                return differenceBlock;
            }
            --n2;
        }
        return null;
    }

    public boolean hasNavigableDifferences() {
        return this.getModel().getDifferenceCount() > 0;
    }

    public boolean hasPreviousDifference() {
        return this.getPreviousDifference() != null;
    }

    public boolean goToNextDifference() {
        DifferenceBlock differenceBlock = this.getNextDifference();
        if (differenceBlock != null) {
            this.goToDifference(differenceBlock);
            return true;
        }
        return false;
    }

    private DifferenceBlock getNextDifference() {
        TextPane textPane = this.getCurrentTextPane();
        if (textPane == null) {
            return null;
        }
        ContributorKind contributorKind = this.getContributorForPane(textPane);
        int n = this.getCurrentCaretLine(contributorKind);
        int n2 = 0;
        while (n2 < this._model.getDifferences().length) {
            DifferenceBlock differenceBlock = this._model.getDifferenceBlocks()[n2];
            if (differenceBlock.getStart(contributorKind) > n) {
                return differenceBlock;
            }
            ++n2;
        }
        return null;
    }

    public boolean hasNextDifference() {
        return this.getNextDifference() != null;
    }

    public void addPositionListener(ChangeListener changeListener) {
        this._positionChangeListeners.add(changeListener);
    }

    public void removePositionListener(ChangeListener changeListener) {
        this._positionChangeListeners.remove(changeListener);
    }

    private void firePositionChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        ChangeListener[] changeListenerArray = this._positionChangeListeners.toArray(new ChangeListener[0]);
        int n = changeListenerArray.length - 1;
        while (n >= 0) {
            changeListenerArray[n].stateChanged(changeEvent);
            --n;
        }
    }

    public void setShowInlineDiffs(boolean bl) {
        this._showInlineCharDiffs = new Boolean(bl);
    }

    public boolean isShowInlineCharDiffs() {
        if (this._showInlineCharDiffs == null) {
            return CompareHints.isShowCharDifferences();
        }
        return this._showInlineCharDiffs;
    }

    private int getCurrentCaretLine(ContributorKind contributorKind) {
        TextPane textPane = this.getTextPane(contributorKind);
        return this.getContributor(contributorKind).getTextBuffer().getLineMap().getLineFromOffset(textPane.getCaretPosition());
    }

    private TextPane getCurrentTextPane() {
        return this._currentTextPane;
    }

    private ContributorKind getContributorForPane(TextPane textPane) {
        if (textPane == this._leftPane) {
            return ContributorKind.FIRST;
        }
        if (textPane == this._rightPane) {
            return ContributorKind.SECOND;
        }
        if (textPane == this._centerPane && this._centerPane != null) {
            return ContributorKind.ANCESTOR;
        }
        throw new IllegalStateException();
    }

    public void addPopupManager(PopupManager popupManager) {
        this._leftPane.addPopupManager(popupManager);
        this._rightPane.addPopupManager(popupManager);
        if (this._centerPane != null) {
            this._centerPane.addPopupManager(popupManager);
        }
    }

    public void removePopupManager(PopupManager popupManager) {
        this._leftPane.removePopupManager(popupManager);
        this._rightPane.removePopupManager(popupManager);
        if (this._centerPane != null) {
            this._centerPane.removePopupManager(popupManager);
        }
    }

    public BasicEditorPane[] getEditorPanes() {
        if (this._centerPane == null) {
            return new BasicEditorPane[]{this._leftPane, this._rightPane};
        }
        return new BasicEditorPane[]{this._leftPane, this._rightPane, this._centerPane};
    }

    public BasicEditorPane getCurrentEditorPane() {
        return this.getCurrentTextPane();
    }

    public Component getHorizontalScrollComponent() {
        if (this._horizontalScrollPanel == null) {
            this._horizontalScrollPanel = new JPanel();
        }
        return this._horizontalScrollPanel;
    }

    static TextPane mav$getTextPane(WedgeCompareView wedgeCompareView, ContributorKind contributorKind) {
        return wedgeCompareView.getTextPane(contributorKind);
    }

    static int ra$_textPaneFontHeight(WedgeCompareView wedgeCompareView) {
        return wedgeCompareView._textPaneFontHeight;
    }

    static int mav$getVirtualLineForReal(WedgeCompareView wedgeCompareView, int n, ContributorKind contributorKind) {
        return wedgeCompareView.getVirtualLineForReal(n, contributorKind);
    }

    static void mav$verticalScrollTo(WedgeCompareView wedgeCompareView, int n) {
        wedgeCompareView.verticalScrollTo(n);
    }

    static void mav$horizontalScrollTo(WedgeCompareView wedgeCompareView, Object object, int n) {
        wedgeCompareView.horizontalScrollTo(object, n);
    }

    static JScrollBar ra$_verticalScrollbar(WedgeCompareView wedgeCompareView) {
        return wedgeCompareView._verticalScrollbar;
    }

    static void mav$repaintEditors(WedgeCompareView wedgeCompareView) {
        wedgeCompareView.repaintEditors();
    }

    static CustomViewport ra$_leftEditor(WedgeCompareView wedgeCompareView) {
        return wedgeCompareView._leftEditor;
    }

    static CustomViewport ra$_rightEditor(WedgeCompareView wedgeCompareView) {
        return wedgeCompareView._rightEditor;
    }

    static CustomViewport ra$_centerEditor(WedgeCompareView wedgeCompareView) {
        return wedgeCompareView._centerEditor;
    }

    static ContributorKind mav$getContributor(WedgeCompareView wedgeCompareView, Document document) {
        return wedgeCompareView.getContributor(document);
    }

    static WedgeCompareMemento ra$_currentMemento(WedgeCompareView wedgeCompareView) {
        return wedgeCompareView._currentMemento;
    }

    static void mav$updateCurrentMemento(WedgeCompareView wedgeCompareView) {
        wedgeCompareView.updateCurrentMemento();
    }

    static void mav$fireStatusEvent(WedgeCompareView wedgeCompareView) {
        wedgeCompareView.fireStatusEvent();
    }

    static void mav$updateCurrentBlock(WedgeCompareView wedgeCompareView) {
        wedgeCompareView.updateCurrentBlock();
    }

    static void mav$setCurrentBlock(WedgeCompareView wedgeCompareView, DifferenceBlock differenceBlock) {
        wedgeCompareView.setCurrentBlock(differenceBlock);
    }

    static TextPane ra$_currentTextPane(WedgeCompareView wedgeCompareView) {
        return wedgeCompareView._currentTextPane;
    }

    static void wa$_currentTextPane(WedgeCompareView wedgeCompareView, TextPane textPane) {
        wedgeCompareView._currentTextPane = textPane;
    }

    static TextPane ra$_leftPane(WedgeCompareView wedgeCompareView) {
        return wedgeCompareView._leftPane;
    }

    static TextPane ra$_centerPane(WedgeCompareView wedgeCompareView) {
        return wedgeCompareView._centerPane;
    }

    static TextPane ra$_rightPane(WedgeCompareView wedgeCompareView) {
        return wedgeCompareView._rightPane;
    }

    static void mav$firePositionChanged(WedgeCompareView wedgeCompareView) {
        wedgeCompareView.firePositionChanged();
    }

    static boolean ra$_verticalScrollLock(WedgeCompareView wedgeCompareView) {
        return wedgeCompareView._verticalScrollLock;
    }

    static ContributorKind mav$getContributorForViewPort(WedgeCompareView wedgeCompareView, JViewport jViewport) {
        return wedgeCompareView.getContributorForViewPort(jViewport);
    }

    static void mav$updateVerticalScrollbar(WedgeCompareView wedgeCompareView) {
        wedgeCompareView.updateVerticalScrollbar();
    }

    static CustomViewport mav$getGutterViewportFor(WedgeCompareView wedgeCompareView, JViewport jViewport) {
        return wedgeCompareView.getGutterViewportFor(jViewport);
    }

    static void mav$updateFontMetrics(WedgeCompareView wedgeCompareView) {
        wedgeCompareView.updateFontMetrics();
    }

    static void mav$clearInlineHighLighters(WedgeCompareView wedgeCompareView) {
        wedgeCompareView.clearInlineHighLighters();
    }

    static DifferenceBlock ra$_currentBlock(WedgeCompareView wedgeCompareView) {
        return wedgeCompareView._currentBlock;
    }

    static void wa$_currentBlock(WedgeCompareView wedgeCompareView, DifferenceBlock differenceBlock) {
        wedgeCompareView._currentBlock = differenceBlock;
    }

    static Timer ra$_editTimer(WedgeCompareView wedgeCompareView) {
        return wedgeCompareView._editTimer;
    }

    static void wa$_editTimer(WedgeCompareView wedgeCompareView, Timer timer) {
        wedgeCompareView._editTimer = timer;
    }

    static void mav$updateTitles(WedgeCompareView wedgeCompareView) {
        wedgeCompareView.updateTitles();
    }

    static TextCompareModel ra$_model(WedgeCompareView wedgeCompareView) {
        return wedgeCompareView._model;
    }

    static int mav$getLineCount(WedgeCompareView wedgeCompareView, ContributorKind contributorKind) {
        return wedgeCompareView.getLineCount(contributorKind);
    }

    static CustomViewport mav$getViewPort(WedgeCompareView wedgeCompareView, ContributorKind contributorKind) {
        return wedgeCompareView.getViewPort(contributorKind);
    }

    static Icon mav$getDefaultEditActionIcon(WedgeCompareView wedgeCompareView, DifferenceBlock differenceBlock, ContributorKind contributorKind, ContributorKind contributorKind2, boolean bl) {
        return wedgeCompareView.getDefaultEditActionIcon(differenceBlock, contributorKind, contributorKind2, bl);
    }

    static boolean mav$hasDefaultEditAction(WedgeCompareView wedgeCompareView, ContributorKind contributorKind, ContributorKind contributorKind2) {
        return wedgeCompareView.hasDefaultEditAction(contributorKind, contributorKind2);
    }

    static Action mav$getDefaultEditAction(WedgeCompareView wedgeCompareView, DifferenceBlock differenceBlock, ContributorKind contributorKind, ContributorKind contributorKind2) {
        return wedgeCompareView.getDefaultEditAction(differenceBlock, contributorKind, contributorKind2);
    }

    static Iterator mav$getDiffBlockIterator(WedgeCompareView wedgeCompareView) {
        return wedgeCompareView.getDiffBlockIterator();
    }

    static WedgeDiffGutter ra$_diffGutter(WedgeCompareView wedgeCompareView) {
        return wedgeCompareView._diffGutter;
    }

    static Action[] mav$getEditActions(WedgeCompareView wedgeCompareView, DifferenceBlock differenceBlock, ContributorKind contributorKind, ContributorKind contributorKind2) {
        return wedgeCompareView.getEditActions(differenceBlock, contributorKind, contributorKind2);
    }

    static int mav$getVirtualHeightLines(WedgeCompareView wedgeCompareView) {
        return wedgeCompareView.getVirtualHeightLines();
    }

    static TextCompareContributor mav$getContributor(WedgeCompareView wedgeCompareView, ContributorKind contributorKind) {
        return wedgeCompareView.getContributor(contributorKind);
    }

    static ResourceBundle mav$getBundle(WedgeCompareView wedgeCompareView) {
        return wedgeCompareView.getBundle();
    }

    static int ra$OVERVIEW_WIDTH() {
        return OVERVIEW_WIDTH;
    }

    static void mav$updateModel(WedgeCompareView wedgeCompareView, CompareModel compareModel) {
        wedgeCompareView.updateModel(compareModel);
    }

    static void mav$fireWedgeEditEvent(WedgeCompareView wedgeCompareView, WedgeEditEvent wedgeEditEvent) {
        wedgeCompareView.fireWedgeEditEvent(wedgeEditEvent);
    }

    private class CustomViewport
    extends JViewport {
        private final ContributorKind _contributorKind;

        CustomViewport() {
            this(null);
        }

        CustomViewport(ContributorKind contributorKind) {
            this._contributorKind = contributorKind;
        }

        public void setViewPosition(Point point) {
            point.y = this.getViewPosition().y;
            super.setViewPosition(point);
        }

        public void scrollRectToVisible(Rectangle rectangle) {
            super.scrollRectToVisible(rectangle);
            if (this._contributorKind == null) {
                return;
            }
            TextPane textPane = WedgeCompareView.mav$getTextPane(WedgeCompareView.this, this._contributorKind);
            Rectangle rectangle2 = null;
            try {
                rectangle2 = textPane.modelToView(textPane.getCaret().getDot());
            }
            catch (BadLocationException badLocationException) {
                return;
            }
            Rectangle rectangle3 = textPane.getVisibleRect();
            if (rectangle2 == null || rectangle3.contains(rectangle2)) {
                return;
            }
            if (rectangle2.y < rectangle3.y || rectangle2.y > rectangle3.y + rectangle3.height) {
                int n = rectangle2.y / WedgeCompareView.ra$_textPaneFontHeight(WedgeCompareView.this);
                int n2 = WedgeCompareView.mav$getVirtualLineForReal(WedgeCompareView.this, n, this._contributorKind);
                WedgeCompareView.mav$verticalScrollTo(WedgeCompareView.this, n2);
            }
            if (rectangle2.x < rectangle3.x || rectangle2.x > rectangle3.x + rectangle3.width) {
                WedgeCompareView.mav$horizontalScrollTo(WedgeCompareView.this, null, rectangle2.x);
            }
        }

        void setViewPositionImpl(Point point) {
            super.setViewPosition(point);
        }
    }

    public final class 6
    implements AdjustmentListener {
        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            JScrollBar jScrollBar = (JScrollBar)adjustmentEvent.getSource();
            WedgeCompareView.mav$horizontalScrollTo(WedgeCompareView.this, jScrollBar, jScrollBar.getValue());
        }
    }

    public final class 5
    implements MouseWheelListener {
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (mouseWheelEvent.getScrollType() == 0) {
                int n = mouseWheelEvent.getUnitsToScroll() * WedgeCompareView.ra$_verticalScrollbar(WedgeCompareView.this).getUnitIncrement();
                WedgeCompareView.ra$_verticalScrollbar(WedgeCompareView.this).setValue(WedgeCompareView.ra$_verticalScrollbar(WedgeCompareView.this).getValue() + n);
            }
        }
    }

    public final class 4
    implements AdjustmentListener {
        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            WedgeCompareView.mav$verticalScrollTo(WedgeCompareView.this, adjustmentEvent.getValue());
            WedgeCompareView.mav$repaintEditors(WedgeCompareView.this);
        }
    }

    public final class 3
    implements Runnable {
        public void run() {
            WedgeCompareView.ra$_leftEditor(WedgeCompareView.this).repaint();
            WedgeCompareView.ra$_rightEditor(WedgeCompareView.this).repaint();
            if (WedgeCompareView.ra$_centerEditor(WedgeCompareView.this) != null) {
                WedgeCompareView.ra$_centerEditor(WedgeCompareView.this).repaint();
            }
        }
    }

    private class EditListenerAdapter
    implements UndoableEditListener {
        private final ContributorKind _contributor;
        private final WedgeEditListener _l;

        EditListenerAdapter(ContributorKind contributorKind, WedgeEditListener wedgeEditListener) {
            this._contributor = contributorKind;
            this._l = wedgeEditListener;
        }

        ContributorKind getContributorKind() {
            return this._contributor;
        }

        WedgeEditListener getWedgeEditListener() {
            return this._l;
        }

        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            if (!undoableEditEvent.getEdit().isSignificant()) {
                return;
            }
            ContributorKind contributorKind = WedgeCompareView.mav$getContributor(WedgeCompareView.this, (Document)undoableEditEvent.getSource());
            WedgeCompareMemento wedgeCompareMemento = (WedgeCompareMemento)WedgeCompareView.mav$getTextPane(WedgeCompareView.this, contributorKind).getClientProperty(WedgeCompareView.PROPERTY_UNDO_MOMENTO);
            WedgeCompareMemento wedgeCompareMemento2 = (WedgeCompareMemento)WedgeCompareView.mav$getTextPane(WedgeCompareView.this, contributorKind).getClientProperty(WedgeCompareView.PROPERTY_REDO_MOMENTO);
            if (wedgeCompareMemento == null) {
                wedgeCompareMemento = WedgeCompareView.ra$_currentMemento(WedgeCompareView.this);
            }
            if (wedgeCompareMemento2 == null) {
                wedgeCompareMemento2 = WedgeCompareView.this.createMemento();
            }
            WedgeCompareView.mav$updateCurrentMemento(WedgeCompareView.this);
            this._l.wedgeEditHappened(new WedgeEditEvent(WedgeCompareView.this, 1, contributorKind, new WedgeEdit(undoableEditEvent.getEdit(), WedgeCompareView.this, wedgeCompareMemento, wedgeCompareMemento2)));
            WedgeCompareView.mav$fireStatusEvent(WedgeCompareView.this);
        }
    }

    private class BlockActivationListener
    implements CaretListener,
    FocusListener {
        public void focusGained(FocusEvent focusEvent) {
            TextPane textPane = (TextPane)focusEvent.getSource();
            boolean bl = textPane != WedgeCompareView.ra$_currentTextPane(WedgeCompareView.this);
            WedgeCompareView.wa$_currentTextPane(WedgeCompareView.this, textPane);
            WedgeCompareView.mav$updateCurrentBlock(WedgeCompareView.this);
            if (!bl) {
                return;
            }
            if (WedgeCompareView.ra$_currentTextPane(WedgeCompareView.this) != WedgeCompareView.ra$_leftPane(WedgeCompareView.this)) {
                this.clearSelection(WedgeCompareView.ra$_leftPane(WedgeCompareView.this));
            }
            if (WedgeCompareView.ra$_centerPane(WedgeCompareView.this) != null && WedgeCompareView.ra$_currentTextPane(WedgeCompareView.this) != WedgeCompareView.ra$_centerPane(WedgeCompareView.this)) {
                this.clearSelection(WedgeCompareView.ra$_centerPane(WedgeCompareView.this));
            }
            if (WedgeCompareView.ra$_currentTextPane(WedgeCompareView.this) != WedgeCompareView.ra$_rightPane(WedgeCompareView.this)) {
                this.clearSelection(WedgeCompareView.ra$_rightPane(WedgeCompareView.this));
            }
        }

        private void clearSelection(TextPane textPane) {
            textPane.select(textPane.getCaretPosition(), textPane.getCaretPosition());
        }

        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary() && !(focusEvent.getOppositeComponent() instanceof TextPane)) {
                WedgeCompareView.mav$setCurrentBlock(WedgeCompareView.this, null);
            }
        }

        public void caretUpdate(CaretEvent caretEvent) {
            WedgeCompareView.mav$updateCurrentBlock(WedgeCompareView.this);
        }

        private BlockActivationListener() {
        }

        BlockActivationListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class PositionListener
    implements CaretListener,
    FocusListener {
        private final Timer _positionTimer;

        void $init$() {
            this._positionTimer = new Timer(250, new 1());
            this._positionTimer.setRepeats(false);
        }

        public void focusGained(FocusEvent focusEvent) {
            this.resetTimer();
        }

        public void focusLost(FocusEvent focusEvent) {
            this.resetTimer();
        }

        public void caretUpdate(CaretEvent caretEvent) {
            this.resetTimer();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void resetTimer() {
            Timer timer = this._positionTimer;
            synchronized (timer) {
                this._positionTimer.restart();
            }
        }

        private PositionListener() {
            this.$init$();
        }

        PositionListener(1 var2_2) {
            this();
        }

        static Timer ra$_positionTimer(PositionListener positionListener) {
            return positionListener._positionTimer;
        }

        public final class 1
        implements ActionListener {
            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                Timer timer = PositionListener.ra$_positionTimer(PositionListener.this);
                synchronized (timer) {
                    WedgeCompareView.mav$firePositionChanged(WedgeCompareView.this);
                    PositionListener.ra$_positionTimer(PositionListener.this).stop();
                }
            }
        }
    }

    private class AutoScrollChangeListener
    implements ChangeListener {
        private final Point _scratchPoint;

        void $init$() {
            this._scratchPoint = new Point();
        }

        public void stateChanged(ChangeEvent changeEvent) {
            CustomViewport customViewport = (CustomViewport)changeEvent.getSource();
            if (!WedgeCompareView.ra$_verticalScrollLock(WedgeCompareView.this)) {
                int n = customViewport.getViewPosition().y % WedgeCompareView.ra$_textPaneFontHeight(WedgeCompareView.this);
                if (n != 0) {
                    this._scratchPoint.x = customViewport.getViewPosition().x;
                    this._scratchPoint.y = customViewport.getViewPosition().y + (WedgeCompareView.ra$_textPaneFontHeight(WedgeCompareView.this) - n);
                    customViewport.setViewPositionImpl(this._scratchPoint);
                    return;
                }
                int n2 = customViewport.getViewPosition().y / WedgeCompareView.ra$_textPaneFontHeight(WedgeCompareView.this);
                int n3 = WedgeCompareView.mav$getVirtualLineForReal(WedgeCompareView.this, n2, WedgeCompareView.mav$getContributorForViewPort(WedgeCompareView.this, customViewport));
                WedgeCompareView.mav$verticalScrollTo(WedgeCompareView.this, n3);
            }
            WedgeCompareView.mav$updateVerticalScrollbar(WedgeCompareView.this);
            CustomViewport customViewport2 = WedgeCompareView.mav$getGutterViewportFor(WedgeCompareView.this, customViewport);
            if (customViewport2 != null) {
                this._scratchPoint.x = 0;
                this._scratchPoint.y = customViewport.getViewPosition().y;
                customViewport2.setViewPositionImpl(this._scratchPoint);
            }
        }

        private AutoScrollChangeListener() {
            this.$init$();
        }

        AutoScrollChangeListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    public final class 2
    implements EditorPlugin {
        public void install(BasicEditorPane basicEditorPane) {
        }

        public void deinstall(BasicEditorPane basicEditorPane) {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("editor-font")) {
                WedgeCompareView.mav$updateFontMetrics(WedgeCompareView.this);
                WedgeCompareView.this.getGUI().repaint();
            }
        }
    }

    private class HintListener
    implements CompareHintListener {
        public void CompareHintUpdated(String string) {
            if (!WedgeCompareView.this.isShowInlineCharDiffs()) {
                WedgeCompareView.mav$clearInlineHighLighters(WedgeCompareView.this);
            }
            DifferenceBlock differenceBlock = WedgeCompareView.ra$_currentBlock(WedgeCompareView.this);
            WedgeCompareView.wa$_currentBlock(WedgeCompareView.this, null);
            WedgeCompareView.mav$setCurrentBlock(WedgeCompareView.this, differenceBlock);
            WedgeCompareView.mav$repaintEditors(WedgeCompareView.this);
        }

        private HintListener() {
        }

        HintListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class ContributorListener
    implements ChangeListener,
    PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("modified".equals(string) || "editable".equals(string)) {
                WedgeCompareView.mav$updateTitles(WedgeCompareView.this);
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (WedgeCompareView.ra$_editTimer(WedgeCompareView.this) == null) {
                WedgeCompareView.wa$_editTimer(WedgeCompareView.this, new Timer(500, new 1()));
                WedgeCompareView.ra$_editTimer(WedgeCompareView.this).setRepeats(false);
            }
            if (WedgeCompareView.ra$_editTimer(WedgeCompareView.this).isRunning()) {
                WedgeCompareView.ra$_editTimer(WedgeCompareView.this).restart();
            } else {
                WedgeCompareView.ra$_editTimer(WedgeCompareView.this).start();
            }
        }

        private ContributorListener() {
        }

        ContributorListener(1 var2_2) {
            this();
        }

        public final class oracle.javatools.compare.view.wedge.WedgeCompareView$ContributorListener$1
        implements ActionListener {
            public void actionPerformed(ActionEvent actionEvent) {
                EventQueue.invokeLater(new 1());
                WedgeCompareView.ra$_editTimer(WedgeCompareView.this).stop();
            }

            public final class 1
            implements Runnable {
                public void run() {
                    WedgeCompareView.this.updateOnEdit();
                }
            }
        }
    }

    private class DiffBlockIterator
    implements Iterator {
        private int _index;
        private final DifferenceBlock _gapBlock;
        private DifferenceBlock _next;
        private DifferenceBlock _prev;

        void $init$() {
            this._index = 0;
            this._gapBlock = new DifferenceBlock(0);
            this._next = null;
            this._prev = this._gapBlock;
        }

        void reset() {
            this._index = WedgeCompareView.ra$_model(WedgeCompareView.this).getDifferences().length == 0 ? -1 : 0;
            this._gapBlock.setFirstStart(0);
            this._gapBlock.setFirstLength(0);
            this._gapBlock.setSecondStart(0);
            this._gapBlock.setSecondLength(0);
            this._gapBlock.setAncestorStart(0);
            this._gapBlock.setAncestorLength(0);
            this._next = null;
            if (this._index == -1) {
                this._gapBlock.setFirstLength(WedgeCompareView.mav$getLineCount(WedgeCompareView.this, ContributorKind.FIRST));
                this._gapBlock.setSecondLength(WedgeCompareView.mav$getLineCount(WedgeCompareView.this, ContributorKind.SECOND));
                this._gapBlock.setAncestorLength(WedgeCompareView.mav$getLineCount(WedgeCompareView.this, ContributorKind.ANCESTOR));
                this._next = this._gapBlock;
            }
        }

        public void remove() {
            throw new UnsupportedOperationException("Unsupported");
        }

        public boolean hasNext() {
            return this._next != null || this._index >= 0 && this._index < WedgeCompareView.ra$_model(WedgeCompareView.this).getDifferences().length;
        }

        public Object next() {
            if (this._next != null) {
                DifferenceBlock differenceBlock = this._next;
                this._next = null;
                this._prev = differenceBlock;
                return differenceBlock;
            }
            DifferenceBlock differenceBlock = WedgeCompareView.ra$_model(WedgeCompareView.this).getDifferenceBlocks()[this._index];
            int n = differenceBlock.getStart(ContributorKind.FIRST) - (this._prev.getStart(ContributorKind.FIRST) + this._prev.getLength(ContributorKind.FIRST));
            int n2 = differenceBlock.getStart(ContributorKind.SECOND) - (this._prev.getStart(ContributorKind.SECOND) + this._prev.getLength(ContributorKind.SECOND));
            int n3 = differenceBlock.getStart(ContributorKind.ANCESTOR) - (this._prev.getStart(ContributorKind.ANCESTOR) + this._prev.getLength(ContributorKind.ANCESTOR));
            if (n > 0 || n2 > 0 || n3 > 0) {
                this._gapBlock.setFirstStart(this._prev.getStart(ContributorKind.FIRST) + this._prev.getLength(ContributorKind.FIRST));
                this._gapBlock.setFirstLength(n);
                this._gapBlock.setSecondStart(this._prev.getStart(ContributorKind.SECOND) + this._prev.getLength(ContributorKind.SECOND));
                this._gapBlock.setSecondLength(n2);
                this._gapBlock.setAncestorStart(this._prev.getStart(ContributorKind.ANCESTOR) + this._prev.getLength(ContributorKind.ANCESTOR));
                this._gapBlock.setAncestorLength(n3);
                this._prev = this._gapBlock;
                return this._gapBlock;
            }
            if (this._index == WedgeCompareView.ra$_model(WedgeCompareView.this).getDifferences().length - 1) {
                this._gapBlock.setFirstStart(differenceBlock.getStart(ContributorKind.FIRST) + differenceBlock.getLength(ContributorKind.FIRST));
                this._gapBlock.setFirstLength(WedgeCompareView.mav$getLineCount(WedgeCompareView.this, ContributorKind.FIRST) - (differenceBlock.getStart(ContributorKind.FIRST) + differenceBlock.getLength(ContributorKind.FIRST)));
                this._gapBlock.setSecondStart(differenceBlock.getStart(ContributorKind.SECOND) + differenceBlock.getLength(ContributorKind.SECOND));
                this._gapBlock.setSecondLength(WedgeCompareView.mav$getLineCount(WedgeCompareView.this, ContributorKind.SECOND) - (differenceBlock.getStart(ContributorKind.SECOND) + differenceBlock.getLength(ContributorKind.SECOND)));
                this._gapBlock.setAncestorStart(differenceBlock.getStart(ContributorKind.ANCESTOR) + differenceBlock.getLength(ContributorKind.ANCESTOR));
                this._gapBlock.setAncestorLength(WedgeCompareView.mav$getLineCount(WedgeCompareView.this, ContributorKind.ANCESTOR) - (differenceBlock.getStart(ContributorKind.ANCESTOR) + differenceBlock.getLength(ContributorKind.ANCESTOR)));
                if (this._gapBlock.getLength(ContributorKind.SECOND) > 0 || this._gapBlock.getLength(ContributorKind.FIRST) > 0 || this._gapBlock.getLength(ContributorKind.ANCESTOR) > 0) {
                    this._next = this._gapBlock;
                }
            }
            this._prev = differenceBlock;
            ++this._index;
            return differenceBlock;
        }

        private DiffBlockIterator() {
            this.$init$();
        }

        DiffBlockIterator(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class WedgeDiffGutter
    extends JComponent {
        private Rectangle _gutterBounds;
        private final ContributorKind _leftContributor;
        private final ContributorKind _rightContributor;

        void $init$() {
            this._gutterBounds = new Rectangle();
        }

        WedgeDiffGutter(ContributorKind contributorKind, ContributorKind contributorKind2) {
            this.$init$();
            this._leftContributor = contributorKind;
            this._rightContributor = contributorKind2;
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        private ContributorKind getLeftContributor() {
            return this._leftContributor;
        }

        private ContributorKind getRightContributor() {
            return this._rightContributor;
        }

        private ContributorKind getContributorAtPoint(Point point) {
            if (point.x <= 16) {
                return this._leftContributor;
            }
            if (point.x >= WedgeCompareView.ra$_diffGutter(WedgeCompareView.this).getWidth() - 16) {
                return this._rightContributor;
            }
            return null;
        }

        private DifferenceBlock getBlockAtPoint(Point point) {
            ContributorKind contributorKind = this.getContributorAtPoint(point);
            if (contributorKind == null) {
                return null;
            }
            int n = WedgeCompareView.mav$getViewPort((WedgeCompareView)WedgeCompareView.this, (ContributorKind)contributorKind).getViewPosition().y / WedgeCompareView.ra$_textPaneFontHeight(WedgeCompareView.this);
            int n2 = n + point.y / WedgeCompareView.ra$_textPaneFontHeight(WedgeCompareView.this);
            Iterator iterator = WedgeCompareView.mav$getDiffBlockIterator(WedgeCompareView.this);
            while (iterator.hasNext()) {
                DifferenceBlock differenceBlock = (DifferenceBlock)iterator.next();
                if (differenceBlock.getStart(contributorKind) > n2 || differenceBlock.getStart(contributorKind) + differenceBlock.getLength(contributorKind) <= n2) continue;
                if (differenceBlock.getKind() == 2) {
                    return differenceBlock;
                }
                return null;
            }
            return null;
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            ContributorKind contributorKind;
            ContributorKind contributorKind2;
            DifferenceBlock differenceBlock = this.getBlockAtPoint(mouseEvent.getPoint());
            if (differenceBlock != null && WedgeCompareView.mav$hasDefaultEditAction(WedgeCompareView.this, contributorKind2 = this.getContributorAtPoint(mouseEvent.getPoint()), contributorKind = this.getAdjacentContributor(contributorKind2))) {
                Action action = WedgeCompareView.mav$getDefaultEditAction(WedgeCompareView.this, differenceBlock, contributorKind2, contributorKind);
                String string = (String)action.getValue("Name");
                return "<html><p>Click to " + string + "<br>Right click for other editing options</p></html>";
            }
            return null;
        }

        public ContributorKind getAdjacentContributor(ContributorKind contributorKind) {
            return contributorKind == this._leftContributor ? this._rightContributor : this._leftContributor;
        }

        public void paint(Graphics graphics) {
            if (WedgeCompareView.ra$_model(WedgeCompareView.this) == null) {
                return;
            }
            Rectangle rectangle = graphics.getClipBounds();
            this._gutterBounds.x = 0;
            this._gutterBounds.y = 0;
            this._gutterBounds.width = this.getWidth();
            this._gutterBounds.height = this.getHeight();
            rectangle = rectangle.intersection(this._gutterBounds);
            graphics.setColor(this.getBackground());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(UIManager.getColor("controlShadow"));
            graphics.drawLine(0, rectangle.y, 0, rectangle.y + rectangle.height);
            graphics.drawLine(this.getWidth() - 1, rectangle.y, this.getWidth() - 1, rectangle.y + rectangle.height);
            DifferenceBlock[] differenceBlockArray = WedgeCompareView.ra$_model(WedgeCompareView.this).getDifferenceBlocks();
            int n = 0;
            while (n < differenceBlockArray.length) {
                int n2;
                DifferenceBlock differenceBlock = differenceBlockArray[n];
                if (differenceBlock == WedgeCompareView.ra$_currentBlock(WedgeCompareView.this) && WedgeCompareView.ra$_model(WedgeCompareView.this).getType() == CompareType.TEXT) {
                    graphics.setColor(WedgeCompareView.ra$_leftPane(WedgeCompareView.this).getBlockHighlighter().getSeparatorStyle(true).getUnderlineColor());
                } else {
                    graphics.setColor(UIManager.getColor("controlShadow"));
                }
                int n3 = differenceBlock.getStart(this._leftContributor);
                int n4 = differenceBlock.getStart(this._rightContributor);
                int n5 = this.getLineYPos(n3) - 1;
                int n6 = this.getLineYPos(n4) - 1;
                int n7 = WedgeCompareView.mav$getViewPort((WedgeCompareView)WedgeCompareView.this, (ContributorKind)this._leftContributor).getViewPosition().y;
                int n8 = WedgeCompareView.mav$getViewPort((WedgeCompareView)WedgeCompareView.this, (ContributorKind)this._rightContributor).getViewPosition().y;
                n6 -= n8;
                if ((n5 -= n7) == -1) {
                    n5 = 0;
                }
                if (n6 == -1) {
                    n6 = 0;
                }
                if (!(n5 < 0 && n6 < 0 || n5 > (n2 = graphics.getClipBounds().height) && n6 > n2)) {
                    int n9 = n5;
                    int n10 = n6;
                    graphics.drawLine(0, n5, 16, n5);
                    int n11 = differenceBlock.getLength(this._leftContributor);
                    if (n11 > 0) {
                        int n12 = this.getLineYPos(n3 + n11) - n7 - 1;
                        n9 += (n12 - n5) / 2;
                        graphics.drawLine(0, n12, 16, n12);
                        Color color = graphics.getColor();
                        HighlightStyle highlightStyle = EditorHighlighter.getStyle(WedgeCompareView.ra$_model(WedgeCompareView.this), differenceBlock, this._leftContributor, this._rightContributor, this._leftContributor);
                        Color color2 = highlightStyle != null && highlightStyle.getEnabled() ? highlightStyle.getBackgroundColor() : WedgeCompareView.ra$_leftPane(WedgeCompareView.this).getBackground();
                        graphics.setColor(color2);
                        graphics.fillRect(0, n5 + 1, 16, n12 - n5 - 1);
                        graphics.setColor(color);
                        graphics.drawLine(16, n5, 16, n12);
                        Icon icon = WedgeCompareView.mav$getDefaultEditActionIcon(WedgeCompareView.this, differenceBlock, this._leftContributor, this._rightContributor, true);
                        if (icon != null) {
                            int n13 = (16 - icon.getIconWidth()) / 2;
                            icon.paintIcon(this, graphics, n13, n5 + 3);
                        }
                    }
                    graphics.drawLine(this.getWidth() - 16, n6, this.getWidth(), n6);
                    int n14 = differenceBlock.getLength(this._rightContributor);
                    if (n14 > 0) {
                        int n15 = this.getLineYPos(n4 + n14) - n8 - 1;
                        n10 += (n15 - n6) / 2;
                        graphics.drawLine(this.getWidth() - 16, n15, this.getWidth(), n15);
                        Color color = graphics.getColor();
                        HighlightStyle highlightStyle = EditorHighlighter.getStyle(WedgeCompareView.ra$_model(WedgeCompareView.this), differenceBlock, this._leftContributor, this._rightContributor, this._rightContributor);
                        Color color3 = highlightStyle != null && highlightStyle.getEnabled() ? highlightStyle.getBackgroundColor() : WedgeCompareView.ra$_rightPane(WedgeCompareView.this).getBackground();
                        graphics.setColor(color3);
                        graphics.fillRect(this.getWidth() - 16, n6 + 1, 16, n15 - n6 - 1);
                        graphics.setColor(color);
                        graphics.drawLine(this.getWidth() - 16, n6, this.getWidth() - 16, n15);
                        Icon icon = WedgeCompareView.mav$getDefaultEditActionIcon(WedgeCompareView.this, differenceBlock, this._rightContributor, this._leftContributor, false);
                        if (icon != null) {
                            int n16 = this.getWidth() - 16 + 1 + (16 - icon.getIconWidth()) / 2;
                            icon.paintIcon(this, graphics, n16, n6 + 3);
                        }
                    }
                    ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    graphics.drawLine(16, n9, this.getWidth() - 16, n10);
                    ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                }
                ++n;
            }
        }

        private int getLineYPos(int n) {
            return WedgeCompareView.ra$_leftEditor((WedgeCompareView)WedgeCompareView.this).getInsets().top - this.getInsets().top + n * WedgeCompareView.ra$_textPaneFontHeight(WedgeCompareView.this);
        }

        static ContributorKind mav$getLeftContributor(WedgeDiffGutter wedgeDiffGutter) {
            return wedgeDiffGutter.getLeftContributor();
        }

        static ContributorKind mav$getRightContributor(WedgeDiffGutter wedgeDiffGutter) {
            return wedgeDiffGutter.getRightContributor();
        }

        static DifferenceBlock mav$getBlockAtPoint(WedgeDiffGutter wedgeDiffGutter, Point point) {
            return wedgeDiffGutter.getBlockAtPoint(point);
        }

        static ContributorKind mav$getContributorAtPoint(WedgeDiffGutter wedgeDiffGutter, Point point) {
            return wedgeDiffGutter.getContributorAtPoint(point);
        }
    }

    private class CentralGutterMouseHandler
    extends MouseAdapter {
        private JPopupMenu _popupMenu;

        void $init$() {
            this._popupMenu = null;
        }

        private void performDefaultEditAction(WedgeDiffGutter wedgeDiffGutter, Point point) {
            ContributorKind contributorKind;
            DifferenceBlock differenceBlock = WedgeDiffGutter.mav$getBlockAtPoint(wedgeDiffGutter, point);
            if (differenceBlock == null) {
                return;
            }
            ContributorKind contributorKind2 = WedgeDiffGutter.mav$getContributorAtPoint(wedgeDiffGutter, point);
            Action action = WedgeCompareView.mav$getDefaultEditAction(WedgeCompareView.this, differenceBlock, contributorKind2, contributorKind = wedgeDiffGutter.getAdjacentContributor(contributorKind2));
            if (action != null) {
                action.actionPerformed(new ActionEvent(this, 1001, (String)action.getValue("ActionCommandKey")));
            }
        }

        private void showEditPopup(WedgeDiffGutter wedgeDiffGutter, Point point) {
            ContributorKind contributorKind;
            DifferenceBlock differenceBlock = WedgeDiffGutter.mav$getBlockAtPoint(wedgeDiffGutter, point);
            if (differenceBlock == null) {
                return;
            }
            ContributorKind contributorKind2 = WedgeDiffGutter.mav$getContributorAtPoint(wedgeDiffGutter, point);
            Action[] actionArray = WedgeCompareView.mav$getEditActions(WedgeCompareView.this, differenceBlock, contributorKind2, contributorKind = wedgeDiffGutter.getAdjacentContributor(contributorKind2));
            if (actionArray == null || actionArray.length == 0) {
                return;
            }
            this._popupMenu = new JPopupMenu();
            int n = 0;
            while (n < actionArray.length) {
                if (actionArray[n] == null) {
                    this._popupMenu.addSeparator();
                } else {
                    this._popupMenu.add(actionArray[n]);
                }
                ++n;
            }
            1 var8_8 = new 1();
            this._popupMenu.addPopupMenuListener(var8_8);
            MenuUtils.showPopupMenu((JPopupMenu)this._popupMenu, (Component)wedgeDiffGutter, (int)point.x, (int)point.y);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            WedgeDiffGutter wedgeDiffGutter = (WedgeDiffGutter)mouseEvent.getSource();
            if (mouseEvent.getClickCount() == 1) {
                if (mouseEvent.isPopupTrigger()) {
                    this.showEditPopup(wedgeDiffGutter, mouseEvent.getPoint());
                } else if (mouseEvent.getButton() == 1) {
                    this.performDefaultEditAction(wedgeDiffGutter, mouseEvent.getPoint());
                }
            }
        }

        private CentralGutterMouseHandler() {
            this.$init$();
        }

        CentralGutterMouseHandler(1 var2_2) {
            this();
        }

        static JPopupMenu ra$_popupMenu(CentralGutterMouseHandler centralGutterMouseHandler) {
            return centralGutterMouseHandler._popupMenu;
        }

        static void wa$_popupMenu(CentralGutterMouseHandler centralGutterMouseHandler, JPopupMenu jPopupMenu) {
            centralGutterMouseHandler._popupMenu = jPopupMenu;
        }

        public final class 1
        implements PopupMenuListener {
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                CentralGutterMouseHandler.ra$_popupMenu(CentralGutterMouseHandler.this).removePopupMenuListener(this);
                CentralGutterMouseHandler.ra$_popupMenu(CentralGutterMouseHandler.this).removeAll();
                CentralGutterMouseHandler.wa$_popupMenu(CentralGutterMouseHandler.this, null);
            }

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        }
    }

    private class OverviewComponentMouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        public void mouseReleased(MouseEvent mouseEvent) {
            OverviewComponent overviewComponent;
            DifferenceBlock differenceBlock;
            if (mouseEvent.getButton() == 1 && (differenceBlock = (overviewComponent = (OverviewComponent)mouseEvent.getSource()).getDifferenceForPosition(mouseEvent.getPoint())) != null) {
                WedgeCompareView.this.goToDifference(differenceBlock);
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            OverviewComponent overviewComponent = (OverviewComponent)mouseEvent.getSource();
            DifferenceBlock differenceBlock = overviewComponent.getDifferenceForPosition(mouseEvent.getPoint());
            if (differenceBlock == null) {
                overviewComponent.setCursor(Cursor.getPredefinedCursor(0));
            } else {
                overviewComponent.setCursor(Cursor.getPredefinedCursor(12));
            }
        }

        private OverviewComponentMouseHandler() {
        }

        OverviewComponentMouseHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class OverviewComponent
    extends JComponent {
        private final ContributorKind _firstContributor;
        private final ContributorKind _secondContributor;
        private boolean _isMasked;

        void $init$() {
            this._isMasked = false;
        }

        public OverviewComponent(ContributorKind contributorKind, ContributorKind contributorKind2) {
            this.$init$();
            this._firstContributor = contributorKind;
            this._secondContributor = contributorKind2;
            this.setPreferredSize(new Dimension(WedgeCompareView.ra$OVERVIEW_WIDTH(), 10));
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        public void setMasked(boolean bl) {
            this._isMasked = bl;
            this.repaint();
        }

        public boolean isMasked() {
            return this._isMasked;
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            DifferenceBlock differenceBlock;
            if (!this._isMasked && (differenceBlock = this.getDifferenceForPosition(mouseEvent.getPoint())) != null) {
                return this.getDescription(differenceBlock);
            }
            return super.getToolTipText(mouseEvent);
        }

        DifferenceBlock getDifferenceForPosition(Point point) {
            Insets insets = this.getInsets();
            int n = this.getHeight() - insets.top - insets.bottom;
            int n2 = WedgeCompareView.mav$getVirtualHeightLines(WedgeCompareView.this);
            float f = (float)n / (float)n2;
            int n3 = 0;
            Iterator iterator = WedgeCompareView.mav$getDiffBlockIterator(WedgeCompareView.this);
            while (iterator.hasNext()) {
                DifferenceBlock differenceBlock = (DifferenceBlock)iterator.next();
                int n4 = differenceBlock.getMaxLength();
                if (differenceBlock.getKind() == 2) {
                    int n5 = (int)((float)n3 * f) + insets.top;
                    int n6 = Math.max((int)((float)n4 * f), 1);
                    if (point.y >= n5 && point.y <= n5 + n6) {
                        return differenceBlock;
                    }
                }
                n3 += differenceBlock.getMaxLength();
            }
            return null;
        }

        private String getDescription(DifferenceBlock differenceBlock) {
            if (differenceBlock.isAddition(this._firstContributor, this._secondContributor)) {
                Object[] objectArray = new String[]{String.valueOf(differenceBlock.getStart(this._secondContributor) + 1), WedgeCompareView.mav$getContributor(WedgeCompareView.this, this._secondContributor).getShortLabel(), String.valueOf(differenceBlock.getLength(this._secondContributor))};
                return "<html><p>" + MessageFormat.format(WedgeCompareView.mav$getBundle(WedgeCompareView.this).getString("ADDITION_DESCRIPTION"), objectArray) + "</p></html>";
            }
            if (differenceBlock.isChange(this._firstContributor, this._secondContributor)) {
                Object[] objectArray = new String[]{String.valueOf(differenceBlock.getStart(this._firstContributor) + 1), String.valueOf(differenceBlock.getStart(this._firstContributor) + differenceBlock.getLength(this._firstContributor)), WedgeCompareView.mav$getContributor(WedgeCompareView.this, this._firstContributor).getShortLabel(), String.valueOf(differenceBlock.getStart(this._secondContributor) + 1), String.valueOf(differenceBlock.getStart(this._secondContributor) + differenceBlock.getLength(this._secondContributor)), WedgeCompareView.mav$getContributor(WedgeCompareView.this, this._secondContributor).getShortLabel()};
                return "<html><p>" + MessageFormat.format(WedgeCompareView.mav$getBundle(WedgeCompareView.this).getString("CHANGE_DESCRIPTION"), objectArray) + "</p></html>";
            }
            if (differenceBlock.isRemoval(this._firstContributor, this._secondContributor)) {
                Object[] objectArray = new String[]{String.valueOf(differenceBlock.getStart(this._firstContributor) + 1), WedgeCompareView.mav$getContributor(WedgeCompareView.this, this._firstContributor).getShortLabel(), String.valueOf(differenceBlock.getLength(this._firstContributor))};
                return "<html><p>" + MessageFormat.format(WedgeCompareView.mav$getBundle(WedgeCompareView.this).getString("REMOVAL_DESCRIPTION"), objectArray) + "</p></html>";
            }
            return null;
        }

        public void paint(Graphics graphics) {
            Insets insets = this.getInsets();
            int n = this.getWidth() - insets.left - insets.right;
            int n2 = this.getHeight() - insets.top - insets.bottom;
            if (n2 <= 0) {
                return;
            }
            graphics.setColor(this.getBackground());
            graphics.fillRect(insets.left, insets.right, n, n2);
            if (this._isMasked) {
                return;
            }
            graphics.translate(insets.left, insets.top);
            if (WedgeCompareView.ra$_model(WedgeCompareView.this) != null) {
                int n3 = WedgeCompareView.mav$getVirtualHeightLines(WedgeCompareView.this);
                float f = (float)n2 / (float)n3;
                int n4 = 0;
                Iterator iterator = WedgeCompareView.mav$getDiffBlockIterator(WedgeCompareView.this);
                while (iterator.hasNext()) {
                    DifferenceBlock differenceBlock = (DifferenceBlock)iterator.next();
                    int n5 = differenceBlock.getMaxLength();
                    if (differenceBlock.getKind() == 2) {
                        Color color;
                        Color color2;
                        int n6 = (int)((float)n4 * f);
                        int n7 = Math.max((int)((float)n5 * f), 1);
                        HighlightStyle highlightStyle = EditorHighlighter.getStyle(WedgeCompareView.ra$_model(WedgeCompareView.this), differenceBlock, this._firstContributor, this._secondContributor, null);
                        if (highlightStyle != null && highlightStyle.getEnabled()) {
                            color2 = highlightStyle.getBackgroundColor();
                            color = color2.darker();
                        } else {
                            color2 = Color.WHITE;
                            color = Color.BLACK;
                        }
                        if (n7 > 2) {
                            graphics.setColor(color2);
                        } else {
                            graphics.setColor(color);
                        }
                        graphics.fillRect(0, n6, n, n7);
                        if (n7 > 2) {
                            graphics.setColor(color);
                            graphics.drawRect(0, n6, n - 1, n7);
                            graphics.drawRect(1, n6 + 1, n - 3, n7 - 2);
                        }
                    }
                    n4 += differenceBlock.getMaxLength();
                }
            }
        }
    }

    private class MarkResolvedAction
    extends AbstractAction {
        private final OffsetDifferenceBlock _difference;

        public MarkResolvedAction(OffsetDifferenceBlock offsetDifferenceBlock) {
            super(WedgeCompareView.mav$getBundle(WedgeCompareView.this).getString("RESOLVE_ACTION_NAME"));
            this._difference = offsetDifferenceBlock;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this._difference.isResolved()) {
                return;
            }
            WedgeCompareMemento wedgeCompareMemento = WedgeCompareView.this.createMemento();
            this._difference.setResolved(true);
            WedgeCompareView.mav$updateModel(WedgeCompareView.this, WedgeCompareView.ra$_model(WedgeCompareView.this));
            WedgeCompareMemento wedgeCompareMemento2 = WedgeCompareView.this.createMemento();
            WedgeCompareView.mav$fireWedgeEditEvent(WedgeCompareView.this, new WedgeEditEvent(WedgeCompareView.this, 1, null, new WedgeEdit(WedgeCompareView.mav$getBundle(WedgeCompareView.this).getString("RESOLVE_ACTION_NAME"), WedgeCompareView.this, wedgeCompareMemento, wedgeCompareMemento2)));
            WedgeCompareView.this.updateOnEdit();
        }
    }

    private class MarkAllResolvedAction
    extends AbstractAction {
        private final CompareModel _compareModel;

        public MarkAllResolvedAction(CompareModel compareModel) {
            super(WedgeCompareView.mav$getBundle(WedgeCompareView.this).getString("RESOLVE_ALL_ACTION_NAME"));
            this._compareModel = compareModel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this._compareModel.getResolvedCount() >= this._compareModel.getConflictCount()) {
                return;
            }
            WedgeCompareMemento wedgeCompareMemento = WedgeCompareView.this.createMemento();
            DifferenceBlock[] differenceBlockArray = ((TextCompareModel)this._compareModel).getDifferenceBlocks();
            int n = 0;
            while (n < differenceBlockArray.length) {
                if (differenceBlockArray[n] instanceof OffsetDifferenceBlock) {
                    OffsetDifferenceBlock offsetDifferenceBlock = (OffsetDifferenceBlock)differenceBlockArray[n];
                    offsetDifferenceBlock.setResolved(true);
                }
                ++n;
            }
            WedgeCompareView.mav$updateModel(WedgeCompareView.this, WedgeCompareView.ra$_model(WedgeCompareView.this));
            WedgeCompareMemento wedgeCompareMemento2 = WedgeCompareView.this.createMemento();
            WedgeCompareView.mav$fireWedgeEditEvent(WedgeCompareView.this, new WedgeEditEvent(WedgeCompareView.this, 1, null, new WedgeEdit(WedgeCompareView.mav$getBundle(WedgeCompareView.this).getString("RESOLVE_ALL_ACTION_NAME"), WedgeCompareView.this, wedgeCompareMemento, wedgeCompareMemento2)));
            WedgeCompareView.this.updateOnEdit();
        }
    }

    private class DeleteBlockAction
    extends AbstractAction {
        private final DifferenceBlock _difference;
        private final ContributorKind _contributor;

        public DeleteBlockAction(ContributorKind contributorKind, DifferenceBlock differenceBlock) {
            super(WedgeCompareView.mav$getBundle(WedgeCompareView.this).getString("REMOVE_ACTION_NAME"));
            this._contributor = contributorKind;
            this._difference = differenceBlock;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WedgeCompareView.this.deleteBlock(this._difference, this._contributor);
            WedgeCompareView.this.updateOnEdit();
        }
    }

    private class InsertBlockAction
    extends AbstractAction {
        private final DifferenceBlock _difference;
        private final ContributorKind _sourceContributor;
        private final ContributorKind _destContributor;

        public InsertBlockAction(DifferenceBlock differenceBlock, ContributorKind contributorKind, ContributorKind contributorKind2) {
            super(WedgeCompareView.mav$getBundle(WedgeCompareView.this).getString("INSERT_ACTION_NAME"));
            this._difference = differenceBlock;
            this._sourceContributor = contributorKind;
            this._destContributor = contributorKind2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WedgeCompareView.this.insertBlockCopy(this._difference, this._sourceContributor, this._destContributor);
            WedgeCompareView.this.updateOnEdit();
        }
    }

    private class ReplaceBlockAction
    extends AbstractAction {
        private final DifferenceBlock _difference;
        private final ContributorKind _sourceContributor;
        private final ContributorKind _destContributor;

        public ReplaceBlockAction(DifferenceBlock differenceBlock, ContributorKind contributorKind, ContributorKind contributorKind2) {
            super(WedgeCompareView.mav$getBundle(WedgeCompareView.this).getString("REPLACE_ACTION_NAME"));
            this._difference = differenceBlock;
            this._sourceContributor = contributorKind;
            this._destContributor = contributorKind2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WedgeCompareView.this.replaceBlock(this._difference, this._sourceContributor, this._destContributor);
            WedgeCompareView.this.updateOnEdit();
        }
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ ContributorKind v$toContributor;
        final /* synthetic */ WedgeCompareView this$0;

        public void run() {
            WedgeCompareView.mav$getTextPane(this.this$0, this.v$toContributor).putClientProperty(WedgeCompareView.PROPERTY_UNDO_MOMENTO, null);
            WedgeCompareView.mav$getTextPane(this.this$0, this.v$toContributor).putClientProperty(WedgeCompareView.PROPERTY_REDO_MOMENTO, null);
        }

        public 1(WedgeCompareView wedgeCompareView, ContributorKind contributorKind) {
            this.v$toContributor = contributorKind;
            this.this$0 = wedgeCompareView;
        }
    }

    private class MergeEditState {
        private final int _startLine;
        private final int _length;

        MergeEditState(int n, int n2) {
            this._startLine = n;
            this._length = n2;
        }

        int getStartLine() {
            return this._startLine;
        }

        int getLength() {
            return this._length;
        }
    }
}

