/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.view.wedge;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import oracle.javatools.compare.view.wedge.WedgeCompareMemento;
import oracle.javatools.compare.view.wedge.WedgeCompareView;

class WedgeEdit
extends AbstractUndoableEdit {
    private final String _presentationName;
    private final UndoableEdit _undoableEdit;
    private final WedgeCompareView _compareView;
    private final WedgeCompareMemento _undoMemento;
    private final WedgeCompareMemento _redoMemento;

    public WedgeEdit(UndoableEdit undoableEdit) {
        this(undoableEdit, null, null, null);
    }

    public WedgeEdit(UndoableEdit undoableEdit, WedgeCompareView wedgeCompareView, WedgeCompareMemento wedgeCompareMemento, WedgeCompareMemento wedgeCompareMemento2) {
        this(null, undoableEdit, wedgeCompareView, wedgeCompareMemento, wedgeCompareMemento2);
    }

    public WedgeEdit(String string, WedgeCompareView wedgeCompareView, WedgeCompareMemento wedgeCompareMemento, WedgeCompareMemento wedgeCompareMemento2) {
        this(string, null, wedgeCompareView, wedgeCompareMemento, wedgeCompareMemento2);
    }

    private WedgeEdit(String string, UndoableEdit undoableEdit, WedgeCompareView wedgeCompareView, WedgeCompareMemento wedgeCompareMemento, WedgeCompareMemento wedgeCompareMemento2) {
        this._presentationName = string;
        this._undoableEdit = undoableEdit;
        this._compareView = wedgeCompareView;
        this._undoMemento = wedgeCompareMemento;
        this._redoMemento = wedgeCompareMemento2;
    }

    public void undo() throws CannotUndoException {
        if (this._undoableEdit != null) {
            this._undoableEdit.undo();
        }
        if (this._undoMemento != null) {
            this._compareView.setMemento(this._undoMemento);
        }
    }

    public boolean canUndo() {
        return super.canUndo() && (this._undoableEdit == null || this._undoableEdit.canUndo());
    }

    public void redo() throws CannotRedoException {
        if (this._undoableEdit != null) {
            this._undoableEdit.redo();
        }
        if (this._redoMemento != null) {
            this._compareView.setMemento(this._redoMemento);
        }
    }

    public boolean canRedo() {
        return super.canRedo() && (this._undoableEdit == null || this._undoableEdit.canRedo());
    }

    public String getPresentationName() {
        return this._undoableEdit != null ? this._undoableEdit.getPresentationName() : this._presentationName;
    }
}

