/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.controls;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JPanel;

public class GradientPanel
extends JPanel {
    private Color _gradientStartColor;
    private Color _gradientEndColor;
    private int _gradientDirection;

    public GradientPanel() {
        this(null, null, 3);
    }

    public GradientPanel(int n) {
        this(null, null, n);
    }

    public GradientPanel(Color color, int n) {
        this(color, null, n);
    }

    public GradientPanel(Color color, Color color2, int n) {
        this.setGradientStartColor(color);
        this.setGradientEndColor(color2);
        this.setGradientDirection(n);
    }

    public void setGradientStartColor(Color color) {
        this._gradientStartColor = color;
    }

    public Color getGradientStartColor() {
        return this._gradientStartColor != null ? this._gradientStartColor : this.getBackground().brighter().brighter();
    }

    public void setGradientEndColor(Color color) {
        this._gradientEndColor = color;
    }

    public Color getGradientEndColor() {
        return this._gradientEndColor != null ? this._gradientEndColor : this.getBackground();
    }

    public void setGradientDirection(int n) {
        if (n != 1 && n != 5 && n != 3 && n != 7 && n != 2 && n != 8 && n != 4 && n != 6) {
            throw new IllegalArgumentException("Invalid direction");
        }
        this._gradientDirection = n;
    }

    public int getGradientDirection() {
        return this._gradientDirection;
    }

    protected void paintComponent(Graphics graphics) {
        if (this.isOpaque()) {
            int n;
            int n2;
            int n3;
            int n4;
            Graphics2D graphics2D = (Graphics2D)graphics;
            int n5 = this.getWidth();
            int n6 = this.getHeight();
            Insets insets = this.getInsets();
            Rectangle rectangle = new Rectangle(insets.left, insets.top, n5 - insets.left - insets.right, n6 - insets.top - insets.bottom);
            switch (this.getGradientDirection()) {
                case 1: {
                    n4 = 0;
                    n3 = 0;
                    n2 = 0;
                    n = n6 - insets.top - insets.bottom;
                    break;
                }
                case 5: {
                    n = 0;
                    n3 = 0;
                    n2 = 0;
                    n4 = n6 - insets.top - insets.bottom;
                    break;
                }
                default: {
                    n4 = 0;
                    n = 0;
                    n2 = 0;
                    n3 = n5 - insets.left - insets.right;
                    break;
                }
                case 7: {
                    n4 = 0;
                    n = 0;
                    n3 = 0;
                    n2 = n5 - insets.left - insets.right;
                    break;
                }
                case 2: {
                    n4 = 0;
                    n2 = 0;
                    n = n6 - insets.top - insets.bottom;
                    n3 = n5 - insets.left - insets.right;
                    break;
                }
                case 8: {
                    n4 = 0;
                    n3 = 0;
                    n2 = n5 - insets.left - insets.right;
                    n = n6 - insets.top - insets.bottom;
                    break;
                }
                case 4: {
                    n = 0;
                    n2 = 0;
                    n3 = n5 - insets.left - insets.right;
                    n4 = n6 - insets.top - insets.bottom;
                    break;
                }
                case 6: {
                    n = 0;
                    n3 = 0;
                    n2 = n5 - insets.left - insets.right;
                    n4 = n6 - insets.top - insets.bottom;
                }
            }
            GradientPaint gradientPaint = new GradientPaint(n2, n, this.getGradientStartColor(), n3, n4, this.getGradientEndColor());
            graphics2D.setPaint(gradientPaint);
            graphics2D.fill(rectangle);
        }
    }
}

