/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.controls;

import com.sun.java.swing.plaf.motif.MotifButtonUI;
import com.sun.java.swing.plaf.motif.MotifLookAndFeel;
import com.sun.java.swing.plaf.windows.WindowsButtonUI;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalButtonUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import oracle.bali.ewt.olaf.OracleButtonUI;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.javatools.controls.PropertyChangeAdapter;
import oracle.javatools.util.SwingUtils;

public class HyperlinkButton
extends AbstractButton {
    private boolean m_mouseInside = false;
    private boolean m_armed = false;
    private boolean m_enabled = true;
    private boolean m_alwaysUnderline = true;
    private PropertyChangeListener _listener;
    private static Rectangle paintIconR = new Rectangle();
    private static Rectangle paintTextR = new Rectangle();
    private static Rectangle paintViewR = new Rectangle();
    private static final ComponentUI s_windowsUI = new WindowsHyperlinkButtonUI();
    private static final ComponentUI s_metalUI = new MetalHyperlinkButtonUI();
    private static final ComponentUI s_motifUI = new MotifHyperlinkButtonUI();
    private static final ComponentUI s_oracleUI = new OracleHyperlinkButtonUI();

    public HyperlinkButton(String string) {
        this();
        this.setText(string);
    }

    public HyperlinkButton() {
        this.setModel(new DefaultButtonModel());
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setBorderPainted(false);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.addMouseListener(new MouseMotionListener());
        this.setForeground(Color.blue);
        this.updateUI();
        this.setOpaque(false);
    }

    public HyperlinkButton(Action action) {
        this();
        String string = (String)action.getValue("ShortDescription");
        if (string != null) {
            this.setText(string);
        } else {
            this.setText((String)action.getValue("Name"));
        }
        this.setIcon((Icon)action.getValue("SmallIcon"));
        this.setEnabled(action.isEnabled());
        this._listener = new PropertyChangeAdapter(this, action);
        action.addPropertyChangeListener(this._listener);
        this.addActionListener(action);
    }

    public void setAction(Action action) {
        if (this._listener != null && this.getAction() != null) {
            this.getAction().removePropertyChangeListener(this._listener);
        }
        if (action != null) {
            this._listener = new PropertyChangeAdapter(this, action);
            action.addPropertyChangeListener(this._listener);
        }
        super.setAction(action);
    }

    public void updateUI() {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (lookAndFeel instanceof WindowsLookAndFeel) {
            this.setUI(s_windowsUI);
        } else if (lookAndFeel instanceof MetalLookAndFeel) {
            this.setUI(s_metalUI);
        } else if (lookAndFeel instanceof MotifLookAndFeel) {
            this.setUI(s_motifUI);
        } else if (lookAndFeel instanceof OracleLookAndFeel) {
            this.setUI(s_oracleUI);
        } else {
            this.setUI(s_metalUI);
        }
    }

    public String getUIClassID() {
        return "HyperlinkButtonUI";
    }

    public void setAlwaysUnderlined(boolean bl) {
        this.m_alwaysUnderline = bl;
        this.repaint();
    }

    public boolean isAlwaysUnderlined() {
        return this.m_alwaysUnderline;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleHyperlinkButton();
        }
        return this.accessibleContext;
    }

    private static void doPaint(Graphics graphics, JComponent jComponent, FocusPainter focusPainter) {
        HyperlinkButton hyperlinkButton = (HyperlinkButton)jComponent;
        Icon icon = hyperlinkButton.isEnabled() ? hyperlinkButton.getIcon() : hyperlinkButton.getDisabledIcon();
        Color color = graphics.getColor();
        Font font = graphics.getFont();
        graphics.setColor(hyperlinkButton.getForeground());
        graphics.setFont(hyperlinkButton.getFont());
        FontMetrics fontMetrics = graphics.getFontMetrics(hyperlinkButton.getFont());
        int n = fontMetrics.getHeight();
        HyperlinkButton.paintViewR.x = 0;
        HyperlinkButton.paintViewR.y = 0;
        HyperlinkButton.paintViewR.width = hyperlinkButton.getWidth();
        HyperlinkButton.paintViewR.height = hyperlinkButton.getHeight();
        HyperlinkButton.paintIconR.height = 0;
        HyperlinkButton.paintIconR.width = 0;
        HyperlinkButton.paintIconR.y = 0;
        HyperlinkButton.paintIconR.x = 0;
        HyperlinkButton.paintTextR.height = 0;
        HyperlinkButton.paintTextR.width = 0;
        HyperlinkButton.paintTextR.y = 0;
        HyperlinkButton.paintTextR.x = 0;
        String string = SwingUtilities.layoutCompoundLabel(hyperlinkButton, fontMetrics, hyperlinkButton.getText(), hyperlinkButton.getIcon(), 0, 2, 0, 4, paintViewR, paintIconR, paintTextR, 4);
        if (icon != null) {
            icon.paintIcon(hyperlinkButton, graphics, HyperlinkButton.paintIconR.x, HyperlinkButton.paintIconR.y);
        }
        int n2 = HyperlinkButton.paintTextR.x;
        int n3 = HyperlinkButton.paintTextR.y + fontMetrics.getAscent();
        if (!hyperlinkButton.isEnabled()) {
            Color color2 = hyperlinkButton.getBackground();
            graphics.setColor(color2.brighter());
            SwingUtils.drawString(graphics, string, n2 + 1, n3 + 1);
            graphics.setColor(color2.darker());
            SwingUtils.drawString(graphics, string, n2, n3);
        } else {
            graphics.setColor(hyperlinkButton.getForeground());
            SwingUtils.drawString(graphics, string, n2, n3);
        }
        if (hyperlinkButton.isAlwaysUnderlined() || hyperlinkButton.m_mouseInside && hyperlinkButton.isEnabled()) {
            int n4 = fontMetrics.stringWidth(string);
            int n5 = n3 + 1;
            graphics.drawLine(n2, n5, n2 + n4 - 1, n5);
        }
        if (hyperlinkButton.isFocusPainted() && hyperlinkButton.hasFocus()) {
            focusPainter.doPaintFocus(graphics, hyperlinkButton, paintViewR, paintTextR, paintIconR);
        }
        graphics.setColor(color);
        graphics.setFont(font);
    }

    static ComponentUI ra$s_oracleUI() {
        return s_oracleUI;
    }

    static void maS$doPaint(Graphics graphics, JComponent jComponent, FocusPainter focusPainter) {
        HyperlinkButton.doPaint(graphics, jComponent, focusPainter);
    }

    static ComponentUI ra$s_motifUI() {
        return s_motifUI;
    }

    static ComponentUI ra$s_metalUI() {
        return s_metalUI;
    }

    static ComponentUI ra$s_windowsUI() {
        return s_windowsUI;
    }

    static void wa$m_armed(HyperlinkButton hyperlinkButton, boolean bl) {
        hyperlinkButton.m_armed = bl;
    }

    static void wa$m_mouseInside(HyperlinkButton hyperlinkButton, boolean bl) {
        hyperlinkButton.m_mouseInside = bl;
    }

    private static class OracleHyperlinkButtonUI
    extends OracleButtonUI
    implements FocusPainter {
        public void paint(Graphics graphics, JComponent jComponent) {
            HyperlinkButton.maS$doPaint(graphics, jComponent, this);
        }

        public void doPaintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
            this.paintFocus(graphics, abstractButton, rectangle, rectangle2, rectangle3);
        }

        public static ComponentUI createUI(JComponent jComponent) {
            return HyperlinkButton.ra$s_oracleUI();
        }

        OracleHyperlinkButtonUI() {
        }
    }

    private static class MotifHyperlinkButtonUI
    extends MotifButtonUI
    implements FocusPainter {
        public void paint(Graphics graphics, JComponent jComponent) {
            HyperlinkButton.maS$doPaint(graphics, jComponent, this);
        }

        public void doPaintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
            this.paintFocus(graphics, abstractButton, rectangle, rectangle2, rectangle3);
        }

        public static ComponentUI createUI(JComponent jComponent) {
            return HyperlinkButton.ra$s_motifUI();
        }

        MotifHyperlinkButtonUI() {
        }
    }

    private static class MetalHyperlinkButtonUI
    extends MetalButtonUI
    implements FocusPainter {
        public void paint(Graphics graphics, JComponent jComponent) {
            HyperlinkButton.maS$doPaint(graphics, jComponent, this);
        }

        public void doPaintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
            this.paintFocus(graphics, abstractButton, rectangle, rectangle2, rectangle3);
        }

        public static ComponentUI createUI(JComponent jComponent) {
            return HyperlinkButton.ra$s_metalUI();
        }

        MetalHyperlinkButtonUI() {
        }
    }

    private static class WindowsHyperlinkButtonUI
    extends WindowsButtonUI
    implements FocusPainter {
        public void paint(Graphics graphics, JComponent jComponent) {
            HyperlinkButton.maS$doPaint(graphics, jComponent, this);
        }

        public void doPaintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
            this.dashedRectGapX = 0;
            this.dashedRectGapWidth = 0;
            this.paintFocus(graphics, abstractButton, rectangle, rectangle2, rectangle3);
        }

        public static ComponentUI createUI(JComponent jComponent) {
            return HyperlinkButton.ra$s_windowsUI();
        }

        WindowsHyperlinkButtonUI() {
        }
    }

    private static interface FocusPainter {
        public void doPaintFocus(Graphics var1, AbstractButton var2, Rectangle var3, Rectangle var4, Rectangle var5);
    }

    protected class AccessibleHyperlinkButton
    extends AbstractButton.AccessibleAbstractButton {
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PUSH_BUTTON;
        }

        protected AccessibleHyperlinkButton() {
            super(HyperlinkButton.this);
        }
    }

    private class MouseMotionListener
    extends MouseAdapter {
        public void mouseEntered(MouseEvent mouseEvent) {
            HyperlinkButton.wa$m_mouseInside(HyperlinkButton.this, true);
            HyperlinkButton.this.repaint();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            HyperlinkButton.wa$m_mouseInside(HyperlinkButton.this, false);
            HyperlinkButton.this.repaint();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            HyperlinkButton.wa$m_armed(HyperlinkButton.this, true);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            HyperlinkButton.wa$m_armed(HyperlinkButton.this, false);
        }

        MouseMotionListener() {
        }
    }
}

