/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.controls;

import java.awt.Component;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public final class JMenuSorter {
    private static final Adapter ADAPTER = new Adapter(null);

    private JMenuSorter() {
    }

    public static boolean isSorted(JMenu jMenu) {
        MenuListener[] menuListenerArray;
        if (jMenu != null && (menuListenerArray = jMenu.getMenuListeners()) != null) {
            int n = 0;
            while (n < menuListenerArray.length) {
                if (menuListenerArray[n] == ADAPTER) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public static void registerJMenu(JMenu jMenu) {
        jMenu.addMenuListener(ADAPTER);
        jMenu.getPopupMenu().addContainerListener(ADAPTER);
    }

    public static void unregisterJMenu(JMenu jMenu) {
        jMenu.removeMenuListener(ADAPTER);
        jMenu.getPopupMenu().removeContainerListener(ADAPTER);
    }

    public static void registerExclusionGroup(JMenu jMenu, Component component) {
        ADAPTER.addExclusion(jMenu, component);
    }

    public static void unregisterExclusionGroup(JMenu jMenu, Component component) {
        ADAPTER.removeExclusion(jMenu, component);
    }

    private static final class Adapter
    implements Comparator,
    MenuListener,
    ContainerListener {
        private static final String MENU_SORTED_PROPERTY = "menuSorted";
        private static final boolean SORT_SUBMENUS_BEFORE_ITEMS = false;
        private final Map exclusionMap;

        void $init$() {
            this.exclusionMap = new HashMap();
        }

        public void addExclusion(JMenu jMenu, Component component) {
            HashSet<Component> hashSet = (HashSet<Component>)this.exclusionMap.get(jMenu);
            if (hashSet == null) {
                hashSet = new HashSet<Component>();
                this.exclusionMap.put(jMenu, hashSet);
            }
            hashSet.add(component);
        }

        public void removeExclusion(JMenu jMenu, Component component) {
            Set set = (Set)this.exclusionMap.get(jMenu);
            if (set == null || !set.remove(component)) {
                throw new IllegalArgumentException("No such registered menu sorting exclusion");
            }
            if (set.isEmpty()) {
                this.exclusionMap.remove(jMenu);
            }
        }

        public void componentAdded(ContainerEvent containerEvent) {
            JPopupMenu jPopupMenu = (JPopupMenu)containerEvent.getSource();
            JMenu jMenu = (JMenu)jPopupMenu.getInvoker();
            jMenu.putClientProperty(MENU_SORTED_PROPERTY, null);
        }

        public void componentRemoved(ContainerEvent containerEvent) {
        }

        public void menuSelected(MenuEvent menuEvent) {
            JMenu jMenu = (JMenu)menuEvent.getSource();
            if (!Boolean.TRUE.equals(jMenu.getClientProperty(MENU_SORTED_PROPERTY))) {
                this.sortMenuGroups(jMenu);
                jMenu.putClientProperty(MENU_SORTED_PROPERTY, Boolean.TRUE);
            }
        }

        public void menuCanceled(MenuEvent menuEvent) {
        }

        public void menuDeselected(MenuEvent menuEvent) {
        }

        public int compare(Object object, Object object2) {
            Component component = (Component)object;
            Component component2 = (Component)object2;
            Comparable comparable = this.getComparable(component);
            Comparable comparable2 = this.getComparable(component2);
            return comparable.compareTo(comparable2);
        }

        private void sortMenuGroups(JMenu jMenu) {
            Component[] componentArray = jMenu.getMenuComponents();
            if (componentArray.length < 2) {
                return;
            }
            jMenu.removeAll();
            ArrayList<Component> arrayList = new ArrayList<Component>();
            int n = 0;
            while (n < componentArray.length) {
                boolean bl;
                Component component = componentArray[n];
                boolean bl2 = component instanceof JSeparator;
                boolean bl3 = bl = n == componentArray.length - 1;
                if (!bl2 || bl) {
                    arrayList.add(component);
                }
                if (bl2 || bl) {
                    if (arrayList.size() > 1 && !this.isExcluded(jMenu, arrayList)) {
                        Collections.sort(arrayList, this);
                    }
                    Iterator iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        jMenu.add((Component)iterator.next());
                    }
                    arrayList.clear();
                }
                if (bl2) {
                    jMenu.add(component);
                }
                ++n;
            }
        }

        private boolean isExcluded(JMenu jMenu, Collection collection) {
            Set set = (Set)this.exclusionMap.get(jMenu);
            if (set != null) {
                for (Object e : collection) {
                    if (!set.contains(e)) continue;
                    return true;
                }
            }
            return false;
        }

        private Comparable getComparable(Component component) {
            if (component instanceof AbstractButton) {
                return ((AbstractButton)component).getText();
            }
            return "";
        }

        private boolean isSubMenu(Component component) {
            return component instanceof JMenu && !((JMenu)component).isTopLevelMenu();
        }

        private Adapter() {
            this.$init$();
        }

        Adapter(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

