/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.controls;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;

public class PropertyChangeAdapter
implements PropertyChangeListener {
    private static ReferenceQueue _queue = new ReferenceQueue();
    private WeakAbstractButton _adapteeReference;

    public PropertyChangeAdapter(AbstractButton abstractButton, Action action) {
        PropertyChangeAdapter.clearQueue();
        this._adapteeReference = new WeakAbstractButton(abstractButton, action, this, _queue);
    }

    private static void clearQueue() {
        Reference reference;
        while ((reference = _queue.poll()) != null) {
            WeakAbstractButton weakAbstractButton = (WeakAbstractButton)reference;
            weakAbstractButton.clearReference();
        }
    }

    private boolean isDead() {
        return this._adapteeReference.get() == null;
    }

    protected AbstractButton getAdaptee() {
        return (AbstractButton)this._adapteeReference.get();
    }

    public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        PropertyChangeAdapter.clearQueue();
        if (!this.isDead()) {
            this._propertyChange(propertyChangeEvent);
        }
    }

    protected void _propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("Name")) {
            this.nameChanged(propertyChangeEvent);
        } else if (string.equals("ShortDescription")) {
            this.tooltipChanged(propertyChangeEvent);
        } else if (string.equals("enabled")) {
            this.enabledChanged(propertyChangeEvent);
        } else if (string.equals("SmallIcon")) {
            this.smallIconChanged(propertyChangeEvent);
        } else if (string.equals("MnemonicKey")) {
            this.mnemonicChanged(propertyChangeEvent);
        } else if (string.equals("State")) {
            this.stateChanged(propertyChangeEvent);
        }
    }

    protected void nameChanged(PropertyChangeEvent propertyChangeEvent) {
        AbstractButton abstractButton = this.getAdaptee();
        abstractButton.setText((String)propertyChangeEvent.getNewValue());
        abstractButton.repaint();
    }

    protected void tooltipChanged(PropertyChangeEvent propertyChangeEvent) {
        this.getAdaptee().setToolTipText((String)propertyChangeEvent.getNewValue());
    }

    protected void enabledChanged(PropertyChangeEvent propertyChangeEvent) {
        Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
        AbstractButton abstractButton = this.getAdaptee();
        abstractButton.setEnabled(bl);
        abstractButton.repaint();
    }

    protected void smallIconChanged(PropertyChangeEvent propertyChangeEvent) {
        AbstractButton abstractButton = this.getAdaptee();
        abstractButton.setIcon((Icon)propertyChangeEvent.getNewValue());
        abstractButton.invalidate();
        abstractButton.repaint();
    }

    protected void mnemonicChanged(PropertyChangeEvent propertyChangeEvent) {
        Integer n = (Integer)propertyChangeEvent.getNewValue();
        AbstractButton abstractButton = this.getAdaptee();
        abstractButton.setMnemonic(n);
        abstractButton.invalidate();
        abstractButton.repaint();
    }

    protected void stateChanged(PropertyChangeEvent propertyChangeEvent) {
    }

    public static class WeakAbstractButton
    extends WeakReference {
        protected PropertyChangeListener _listener;
        protected Action _action;

        public WeakAbstractButton(AbstractButton abstractButton, Action action, PropertyChangeListener propertyChangeListener, ReferenceQueue referenceQueue) {
            super(abstractButton, referenceQueue);
            this._action = action;
            this._listener = propertyChangeListener;
        }

        protected void clearReference() {
            this._action.removePropertyChangeListener(this._listener);
        }
    }
}

