/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.controls;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractListModel;

public class SimpleListModel
extends AbstractListModel {
    private final List m_delegate;

    public SimpleListModel() {
        this(new ArrayList());
    }

    public SimpleListModel(List list) {
        this.m_delegate = list;
    }

    public int getSize() {
        return this.m_delegate.size();
    }

    public Object getElementAt(int n) {
        return this.m_delegate.get(n);
    }

    public Iterator iterator() {
        return Collections.unmodifiableList(this.m_delegate).iterator();
    }

    public void addElements(Iterator iterator) {
        int n = this.m_delegate.size();
        while (iterator.hasNext()) {
            this.m_delegate.add(iterator.next());
        }
        if (this.getSize() != 0) {
            super.fireIntervalAdded(this, n, this.getSize() - 1);
        }
    }

    public void addElement(Object object) {
        this.m_delegate.add(object);
        super.fireIntervalAdded(this, this.getSize() - 1, this.getSize() - 1);
    }

    private void removeIndicesSlow(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n];
            Object object = this.getElementAt(n2 - n);
            this.removeElement(object);
            ++n;
        }
    }

    public void removeIndices(int[] nArray) {
        this.removeIndicesFast(nArray);
    }

    private void removeIndicesFast(int[] nArray) {
        if (nArray.length == 0) {
            return;
        }
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        while (n4 < nArray.length) {
            int n5 = nArray[n4];
            if (n4 == 0) {
                n = n5;
            }
            this.m_delegate.remove(n5 - n4);
            if (n2 != -1 && n5 - n2 > 1) {
                int n6 = n3 + 1;
                this.fireIntervalRemoved(this, n - n6, n2 - n6);
                n3 = n2;
                n = n5;
            }
            n2 = n5;
            ++n4;
        }
        int n7 = n3 + 1;
        this.fireIntervalRemoved(this, n - n7, n2 - n7);
    }

    public void removeElement(Object object) {
        int n = this.m_delegate.indexOf(object);
        this.m_delegate.remove(n);
        super.fireIntervalRemoved(this, n, n);
    }

    public void removeAll() {
        int n = this.getSize();
        if (n == 0) {
            return;
        }
        this.m_delegate.clear();
        super.fireIntervalRemoved(this, 0, n - 1);
    }

    public void changed(int n) {
        super.fireContentsChanged(this, n, n);
    }

    public void changed() {
        super.fireContentsChanged(this, 0, this.getSize() - 1);
    }

    public void moveUp(int n) {
        if (n > 0) {
            Object e = this.m_delegate.remove(n);
            super.fireIntervalRemoved(this, n, n);
            this.m_delegate.add(n - 1, e);
            super.fireIntervalAdded(this, n - 1, n - 1);
        }
    }

    public void moveDown(int n) {
        if (n < this.getSize() - 1) {
            Object e = this.m_delegate.remove(n);
            super.fireIntervalRemoved(this, n, n);
            this.m_delegate.add(n + 1, e);
            super.fireIntervalAdded(this, n + 1, n + 1);
        }
    }

    public void insertAt(int n, Object object) {
        this.m_delegate.add(n, object);
        super.fireIntervalAdded(this, n, n);
    }
}

