/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.controls;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import javax.swing.SwingUtilities;
import oracle.javatools.util.GraphicsUtils;

public class SplashScreen {
    private static SplashWindow splash;
    private static Frame splashFrame;
    protected static Image splashImage;
    private static final int progressOffsetStart = 20;
    private static int progressOffset;
    private static int msgCounter;
    private static int lastPos;
    private static final int defaultTotalMsgs = 153;
    private static int totalSqares;
    private static int totalMsgs;

    protected SplashScreen() {
    }

    public static void create(String string) {
        if (splashImage != null || !SplashScreen._fileExists(string)) {
            return;
        }
        splashImage = Toolkit.getDefaultToolkit().createImage(string);
        SplashScreen._create();
    }

    public static void create(String string, int n) {
        SplashScreen.create(string);
        totalMsgs = n;
    }

    public static int getCurrentMsgCounter() {
        return msgCounter;
    }

    public static void setVisible(boolean bl) {
        if (splash != null) {
            splash.setVisible(bl);
        }
    }

    public static void dismiss() {
        if (splash != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                SplashScreen._dismiss();
            } else {
                SwingUtilities.invokeLater(new 2());
            }
        }
    }

    static {
        progressOffset = 20;
        msgCounter = 0;
        lastPos = 0;
        totalSqares = 36;
        totalMsgs = 153;
    }

    public static void log(String string) {
        int n;
        if (splash == null) {
            return;
        }
        Graphics graphics = splash.getGraphics();
        if (graphics != null && lastPos != (n = ++msgCounter * totalSqares / totalMsgs) && progressOffset - 20 < 360) {
            lastPos = n;
            int n2 = progressOffset;
            progressOffset += 10;
            if (SwingUtilities.isEventDispatchThread()) {
                if (splash != null) {
                    graphics.setColor(Color.lightGray);
                    graphics.drawRect(19, 173, 360, 9);
                    graphics.setColor(Color.red);
                    int n3 = 20;
                    while (n3 <= n2) {
                        graphics.fillRect(n3, 174, 9, 8);
                        n3 += 10;
                    }
                }
            } else {
                SwingUtilities.invokeLater(new 1(graphics, n2));
            }
        }
    }

    protected static void _create() {
        if (splashImage == null || splash != null) {
            return;
        }
        try {
            splashFrame = new Frame();
            splash = new SplashWindow(splashFrame);
        }
        catch (Exception exception) {
            SplashScreen.dismiss();
        }
    }

    private static synchronized void _dismiss() {
        if (splash != null) {
            splash.dispose();
            splash = null;
        }
        if (splashFrame != null) {
            splashFrame.dispose();
            splashFrame = null;
        }
        if (splashImage != null) {
            splashImage.flush();
            splashImage = null;
        }
    }

    private static boolean _fileExists(String string) {
        return new File(string).exists();
    }

    static void maS$_dismiss() {
        SplashScreen._dismiss();
    }

    static SplashWindow ra$splash() {
        return splash;
    }

    static int ra$totalMsgs() {
        return totalMsgs;
    }

    static void wa$msgCounter(int n) {
        msgCounter = n;
    }

    public static final class 2
    implements Runnable {
        public void run() {
            SplashScreen.maS$_dismiss();
        }
    }

    public static final class 1
    implements Runnable {
        private final /* synthetic */ Graphics v$g;
        private final /* synthetic */ int v$offset;

        public void run() {
            if (SplashScreen.ra$splash() != null) {
                this.v$g.setColor(Color.lightGray);
                this.v$g.drawRect(19, 173, 360, 9);
                this.v$g.setColor(Color.red);
                int n = 20;
                while (n <= this.v$offset) {
                    this.v$g.fillRect(n, 174, 9, 8);
                    n += 10;
                }
            }
        }

        public 1(Graphics graphics, int n) {
            this.v$offset = n;
            this.v$g = graphics;
        }
    }

    private static final class SplashWindow
    extends Window
    implements Runnable,
    MouseListener {
        boolean waitForImage;

        void $init$() {
            this.waitForImage = true;
        }

        public void run() {
            this.setVisible(true);
            this.waitForImage = false;
            Graphics graphics = this.getGraphics();
            this.paint(graphics);
        }

        public SplashWindow(Frame frame) {
            super(frame);
            this.$init$();
            Toolkit.getDefaultToolkit().prepareImage(splashImage, -1, -1, this);
            this.addMouseListener(this);
            while (this.waitForImage) {
                try {
                    Thread.sleep(1L);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        public void paint(Graphics graphics) {
            graphics.drawImage(splashImage, 0, 0, this);
        }

        public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            if ((n & 0x20) != 0) {
                this.setSize(n4, n5);
                GraphicsUtils.centerWindowOnScreen(this);
                this.toFront();
                try {
                    SwingUtilities.invokeAndWait(this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return super.imageUpdate(image, n, n2, n3, n4, n5);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.removeMouseListener(this);
            SplashScreen.dismiss();
            SplashScreen.wa$msgCounter(SplashScreen.ra$totalMsgs());
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }
    }
}

