/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.controls;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.util.MenuUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.javatools.resource.ControlsBundle;

public class TextMenuPopupHandler
extends MouseAdapter
implements ActionListener {
    private JMenuItem m_menuCut;
    private JMenuItem m_menuCopy;
    private JMenuItem m_menuPaste;
    private JMenuItem m_menuSelAll;
    private JTextComponent comp;
    private JPopupMenu popup;
    private static final String CUT = "CUT";
    private static final String COPY = "COPY";
    private static final String PASTE = "PASTE";
    private static final String SELALL = "SELALL";

    public TextMenuPopupHandler(JTextComponent jTextComponent) {
        this.$init$();
        this.comp = jTextComponent;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent);
    }

    private static ResourceBundle getBundle() {
        return ResourceBundle.getBundle(ControlsBundle.class.getName());
    }

    private static Icon getIcon(ResourceBundle resourceBundle, String string) {
        return new ImageIcon(ControlsBundle.class.getResource(resourceBundle.getString(string)));
    }

    protected void maybeShowPopup(MouseEvent mouseEvent) {
        JTextComponent jTextComponent = (JTextComponent)mouseEvent.getComponent();
        if (mouseEvent.isPopupTrigger() && jTextComponent.isEnabled()) {
            if (this.popup == null) {
                this.popup = new JPopupMenu();
                String string = TextMenuPopupHandler.getBundle().getString(CUT);
                this.m_menuCut = new JMenuItem(StringUtils.stripMnemonic((String)string));
                this.m_menuCut.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
                this.m_menuCut.setIcon(TextMenuPopupHandler.getIcon(TextMenuPopupHandler.getBundle(), "CUT_ICON"));
                string = TextMenuPopupHandler.getBundle().getString(COPY);
                this.m_menuCopy = new JMenuItem(StringUtils.stripMnemonic((String)string));
                this.m_menuCopy.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
                this.m_menuCopy.setIcon(TextMenuPopupHandler.getIcon(TextMenuPopupHandler.getBundle(), "COPY_ICON"));
                string = TextMenuPopupHandler.getBundle().getString(PASTE);
                this.m_menuPaste = new JMenuItem(StringUtils.stripMnemonic((String)string));
                this.m_menuPaste.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
                this.m_menuPaste.setIcon(TextMenuPopupHandler.getIcon(TextMenuPopupHandler.getBundle(), "PASTE_ICON"));
                string = TextMenuPopupHandler.getBundle().getString("SELECT_ALL");
                this.m_menuSelAll = new JMenuItem(StringUtils.stripMnemonic((String)string));
                this.m_menuSelAll.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
                this.m_menuSelAll.setIcon(TextMenuPopupHandler.getIcon(TextMenuPopupHandler.getBundle(), "SELECT_ALL_ICON"));
                this.m_menuCut.addActionListener(this);
                this.m_menuCut.setActionCommand(CUT);
                this.m_menuCopy.addActionListener(this);
                this.m_menuCopy.setActionCommand(COPY);
                this.m_menuPaste.addActionListener(this);
                this.m_menuPaste.setActionCommand(PASTE);
                this.m_menuSelAll.addActionListener(this);
                this.m_menuSelAll.setActionCommand(SELALL);
                this.popup.add(this.m_menuCut);
                this.popup.add(this.m_menuCopy);
                this.popup.add(this.m_menuPaste);
                this.popup.addSeparator();
                this.popup.add(this.m_menuSelAll);
            }
            int n = jTextComponent.getSelectionEnd() - jTextComponent.getSelectionStart();
            this.m_menuCut.setEnabled(jTextComponent.isEditable() && n > 0);
            this.m_menuPaste.setEnabled(jTextComponent.isEditable());
            this.m_menuCopy.setEnabled(n > 0);
            this.m_menuSelAll.setEnabled(jTextComponent.getText().length() > 0);
            MenuUtils.showPopupMenu((JPopupMenu)this.popup, (Component)mouseEvent.getComponent(), (int)mouseEvent.getX(), (int)mouseEvent.getY());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(CUT)) {
            this.comp.cut();
        } else if (string.equals(COPY)) {
            this.comp.copy();
        } else if (string.equals(PASTE)) {
            this.comp.paste();
        } else if (string.equals(SELALL)) {
            this.comp.selectAll();
        }
    }

    void $init$() {
        this.comp = null;
        this.popup = null;
    }
}

