/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.controls.completionfield;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;
import oracle.javatools.controls.completionfield.FieldInsightProvider;
import oracle.javatools.dialogs.ExceptionDialog;

public class CompletionPopupHandler {
    private static final Color DEFAULT_BACKGROUND_COLOR = UIManager.getColor("window");
    private List _insightProviders;
    private boolean _insightActive;
    private Timer _timer;
    private JWindow _insightWindow;
    private JList _insightList;
    private JScrollPane _insightScrollPane;
    private Color _insightBackground;
    private ListDoubleClickListener _listListener;
    private FieldInsightProvider _activeProvider;
    private boolean _alignWithField;
    private boolean _widthOfField;
    private boolean _widthConstrained;
    private int _visibleRowCount;
    private Window _parentWindow;
    private ComponentListener _parentWindowListener;
    private static final String CANCEL_ACTION = "cancelInsight";
    private static final String COMPLETE_ACTION = "completeInsight";
    private Object[][] _actions;
    private static final int DEFAULT_DELAY = 750;
    private static int _delay = 750;
    public static final String SHOW_INSIGHT_ACTION_NAME = "show_field_insight";
    private boolean _insightLock;
    private final JTextComponent _textComponent;

    void $init$() {
        this._insightProviders = new ArrayList();
        this._insightActive = false;
        this._insightBackground = DEFAULT_BACKGROUND_COLOR;
        this._widthOfField = true;
        this._visibleRowCount = 8;
        this._actions = new Object[][]{{CANCEL_ACTION, KeyStroke.getKeyStroke("ESCAPE"), new CancelInsightAction(null)}, {COMPLETE_ACTION, KeyStroke.getKeyStroke("ENTER"), new CompleteInsightAction(null)}};
        this._insightLock = false;
    }

    public CompletionPopupHandler(JTextComponent jTextComponent) {
        this.$init$();
        this._textComponent = jTextComponent;
        DefaultCaret defaultCaret = new DefaultCaret();
        defaultCaret.setBlinkRate(UIManager.getInt("TextField.caretBlinkRate"));
        this._textComponent.setCaret(defaultCaret);
        if (_delay >= 0) {
            this._timer = new Timer(_delay, new ActionHandler(null));
            this._timer.setRepeats(false);
            this._textComponent.addCaretListener(new CaretHandler(null));
            this._textComponent.getDocument().addDocumentListener(new DocumentHandler(null));
            this._textComponent.addFocusListener(new FocusHandler(null));
        }
        this._textComponent.getInputMap(0).put(KeyStroke.getKeyStroke("control pressed SPACE"), SHOW_INSIGHT_ACTION_NAME);
        this._textComponent.getActionMap().put(SHOW_INSIGHT_ACTION_NAME, new ShowInsightAction());
    }

    public final JTextComponent getTextComponent() {
        return this._textComponent;
    }

    public final void acquireInsightLock() {
        this._insightLock = true;
    }

    public final void yieldInsightLock() {
        this._insightLock = false;
    }

    public final Color getCompletionBackground() {
        return this._insightBackground;
    }

    public final void setCompletionBackground(Color color) {
        this._insightBackground = color;
    }

    public final void setAlignWithField(boolean bl) {
        this._alignWithField = bl;
    }

    public final boolean isAlignWithField() {
        return this._alignWithField;
    }

    public final void setWidthOfField(boolean bl) {
        this._widthOfField = bl;
    }

    public final boolean isWidthOfField() {
        return this._widthOfField;
    }

    public final void setWidthConstrained(boolean bl) {
        this._widthConstrained = bl;
    }

    public final boolean isWidthConstrained() {
        return this._widthConstrained;
    }

    public final void setVisibleRowCount(int n) {
        if (this._visibleRowCount <= 0) {
            throw new IllegalArgumentException();
        }
        this._visibleRowCount = n;
    }

    public final int getVisibleRowCount() {
        return this._visibleRowCount;
    }

    public final void registerInsightProvider(FieldInsightProvider fieldInsightProvider) {
        this._insightProviders.add(fieldInsightProvider);
    }

    public final void unregisterInsightProvider(FieldInsightProvider fieldInsightProvider) {
        this._insightProviders.remove(fieldInsightProvider);
    }

    public final boolean isRegisteredInsightProvider(FieldInsightProvider fieldInsightProvider) {
        return this._insightProviders.contains(fieldInsightProvider);
    }

    public final void setInsightVisible(boolean bl) {
        if (bl) {
            this.showInsight();
        } else {
            this.hideInsight();
        }
    }

    public final boolean isInsightVisible() {
        return this._insightActive;
    }

    private FieldInsightProvider getHandlingProvider() {
        for (FieldInsightProvider fieldInsightProvider : this._insightProviders) {
            if (!fieldInsightProvider.handlesInsight(this._textComponent.getDocument(), this._textComponent.getCaretPosition())) continue;
            return fieldInsightProvider;
        }
        return null;
    }

    private boolean isPopupTriggerChar(char c) {
        for (FieldInsightProvider fieldInsightProvider : this._insightProviders) {
            if (!fieldInsightProvider.isAutoPopupChar(c)) continue;
            return true;
        }
        return false;
    }

    private void showInsight() {
        Rectangle rectangle;
        if (this._insightActive || !this._textComponent.isShowing()) {
            return;
        }
        this.stopTimer();
        if (!this._textComponent.isEditable()) {
            return;
        }
        this._parentWindow = SwingUtilities.getWindowAncestor(this._textComponent);
        if (this._parentWindow == null) {
            return;
        }
        int n = this._textComponent.getCaretPosition();
        try {
            rectangle = this._textComponent.getUI().modelToView(this._textComponent, n);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            return;
        }
        FieldInsightProvider fieldInsightProvider = this.getHandlingProvider();
        if (fieldInsightProvider != null) {
            this._insightActive = true;
            Object[] objectArray = fieldInsightProvider.getInsightData(this._textComponent.getDocument(), this._textComponent.getCaretPosition());
            if (objectArray == null) {
                this._insightActive = false;
                return;
            }
            this._activeProvider = fieldInsightProvider;
            this._insightList = new InsightList(null);
            this._insightList.setModel(new ArrayListModel(objectArray));
            this._insightList.setCellRenderer(fieldInsightProvider.getCellRenderer());
            this._insightList.setBackground(this._insightBackground);
            if (objectArray.length < this._visibleRowCount) {
                this._insightList.setVisibleRowCount(objectArray.length);
            } else {
                this._insightList.setVisibleRowCount(this._visibleRowCount);
            }
            this.redirectActions(this._textComponent);
            this._insightScrollPane = new JScrollPane(this._insightList);
            this._insightScrollPane.setBorder(UIManager.getBorder("ToolTip.border"));
            this._insightScrollPane.setHorizontalScrollBarPolicy(31);
            this._insightScrollPane.setMinimumSize(new Dimension(0, 0));
            this._insightWindow = new JWindow(this._parentWindow);
            this._insightWindow.setBackground(this._insightBackground);
            new FocusRedirector(this._insightWindow, this._textComponent, null);
            new FocusRedirector(this._insightList, this._textComponent, null);
            this.setWindowLocation(this._insightWindow, this._textComponent, rectangle);
            this._insightScrollPane.validate();
            Dimension dimension = this.getWindowSize();
            this._insightWindow.setSize(dimension);
            this._insightWindow.getContentPane().add(this._insightScrollPane);
            this._insightWindow.show();
            this._listListener = new ListDoubleClickListener(null);
            this._insightList.addMouseListener(this._listListener);
            if (this._insightList.getModel().getSize() > 0) {
                this._insightList.setSelectedIndex(0);
            }
            FocusRedirector focusRedirector = new FocusRedirector(null, this._textComponent, null);
            SwingUtilities.invokeLater(focusRedirector);
            this._parentWindowListener = new 1();
            this._parentWindow.addComponentListener(this._parentWindowListener);
        }
    }

    private Dimension getWindowSize() {
        if (this._insightScrollPane == null) {
            return null;
        }
        Dimension dimension = this._insightScrollPane.getPreferredSize();
        if (this._widthOfField) {
            dimension.width = Math.max(dimension.width, this._textComponent.getWidth());
        }
        if (this._widthConstrained) {
            dimension.width = Math.min(dimension.width, this._textComponent.getWidth());
        }
        return dimension;
    }

    private void setWindowLocation(JWindow jWindow, Component component, Rectangle rectangle) {
        int n;
        int n2;
        if (component.getParent() instanceof JViewport) {
            component = component.getParent();
        }
        Point point = component.getLocationOnScreen();
        if (this._alignWithField) {
            n2 = point.x;
            n = point.y + this.getVerticalPopupOffset(component);
        } else {
            rectangle.x += point.x;
            rectangle.y += point.y;
            n2 = rectangle.x;
            n = rectangle.y + this.getVerticalPopupOffset(component);
        }
        jWindow.setLocation(n2, n);
    }

    protected int getVerticalPopupOffset(Component component) {
        return component.getHeight();
    }

    private void hideInsight() {
        if (this._insightActive) {
            this._activeProvider = null;
            if (this._insightWindow != null) {
                this._insightWindow.dispose();
                this._insightList.removeMouseListener(this._listListener);
                this._listListener = null;
            }
            if (this._parentWindow != null) {
                if (this._parentWindowListener != null) {
                    this._parentWindow.removeComponentListener(this._parentWindowListener);
                    this._parentWindowListener = null;
                }
                this._parentWindow = null;
            }
            this._insightWindow = null;
            this._insightActive = false;
            this.removeActions(this._textComponent);
        }
    }

    private void updateInsight() {
        if (this._insightActive && this._activeProvider != null) {
            Object[] objectArray = this._activeProvider.getInsightData(this._textComponent.getDocument(), this._textComponent.getCaretPosition());
            if (objectArray != null && objectArray.length > 0) {
                this._insightList.setModel(new ArrayListModel(objectArray));
                if (objectArray.length < this._visibleRowCount) {
                    this._insightList.setVisibleRowCount(objectArray.length);
                } else {
                    this._insightList.setVisibleRowCount(this._visibleRowCount);
                }
                Dimension dimension = this.getWindowSize();
                Dimension dimension2 = this._insightWindow.getSize();
                if (!dimension2.equals(dimension)) {
                    int n = this._textComponent.getCaretPosition();
                    try {
                        Rectangle rectangle = this._textComponent.getUI().modelToView(this._textComponent, n);
                        this._insightWindow.setSize(dimension);
                        this.setWindowLocation(this._insightWindow, this._textComponent, rectangle);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
                this._insightWindow.validate();
                this._insightList.setSelectedIndex(0);
            } else {
                this.hideInsight();
            }
        }
    }

    private void removeActions(JComponent jComponent) {
        InputMap inputMap = jComponent.getInputMap();
        ActionMap actionMap = jComponent.getActionMap();
        int n = 0;
        while (n < this._actions.length) {
            inputMap.remove((KeyStroke)this._actions[n][1]);
            actionMap.remove(this._actions[n][0]);
            ++n;
        }
        inputMap.remove(KeyStroke.getKeyStroke("UP"));
        inputMap.remove(KeyStroke.getKeyStroke("DOWN"));
    }

    private void redirectActions(JComponent jComponent) {
        InputMap inputMap = jComponent.getInputMap();
        ActionMap actionMap = jComponent.getActionMap();
        int n = 0;
        while (n < this._actions.length) {
            inputMap.put((KeyStroke)this._actions[n][1], this._actions[n][0]);
            actionMap.put(this._actions[n][0], (Action)this._actions[n][2]);
            ++n;
        }
        inputMap.put(KeyStroke.getKeyStroke("UP"), "selectPreviousRow");
        Action action = this._insightList.getActionMap().get("selectPreviousRow");
        actionMap.put("selectPreviousRow", new ActionDelegator(this._insightList, action));
        inputMap.put(KeyStroke.getKeyStroke("DOWN"), "selectNextRow");
        action = this._insightList.getActionMap().get("selectNextRow");
        actionMap.put("selectNextRow", new ActionDelegator(this._insightList, action));
        inputMap.put(KeyStroke.getKeyStroke("PAGE_UP"), "scrollUp");
        action = this._insightList.getActionMap().get("scrollUp");
        actionMap.put("scrollUp", new ActionDelegator(this._insightList, action));
        inputMap.put(KeyStroke.getKeyStroke("PAGE_DOWN"), "scrollDown");
        action = this._insightList.getActionMap().get("scrollDown");
        actionMap.put("scrollDown", new ActionDelegator(this._insightList, action));
    }

    private void completeInsight() {
        try {
            this._insightLock = true;
            if (this._insightList != null && this._activeProvider != null) {
                this._activeProvider.completeInsight(this._textComponent.getDocument(), this._textComponent.getCaretPosition(), this._insightList.getSelectedValue());
            }
        }
        finally {
            this._insightLock = false;
        }
    }

    private void startTimer() {
        this._timer.restart();
    }

    private void stopTimer() {
        this._timer.stop();
    }

    static Window ra$_parentWindow(CompletionPopupHandler completionPopupHandler) {
        return completionPopupHandler._parentWindow;
    }

    static void wa$_parentWindowListener(CompletionPopupHandler completionPopupHandler, ComponentListener componentListener) {
        completionPopupHandler._parentWindowListener = componentListener;
    }

    static void mav$hideInsight(CompletionPopupHandler completionPopupHandler) {
        completionPopupHandler.hideInsight();
    }

    static void mav$completeInsight(CompletionPopupHandler completionPopupHandler) {
        completionPopupHandler.completeInsight();
    }

    static boolean ra$_insightActive(CompletionPopupHandler completionPopupHandler) {
        return completionPopupHandler._insightActive;
    }

    static void mav$updateInsight(CompletionPopupHandler completionPopupHandler) {
        completionPopupHandler.updateInsight();
    }

    static void mav$stopTimer(CompletionPopupHandler completionPopupHandler) {
        completionPopupHandler.stopTimer();
    }

    static boolean mav$isPopupTriggerChar(CompletionPopupHandler completionPopupHandler, char c) {
        return completionPopupHandler.isPopupTriggerChar(c);
    }

    static boolean ra$_insightLock(CompletionPopupHandler completionPopupHandler) {
        return completionPopupHandler._insightLock;
    }

    static void mav$startTimer(CompletionPopupHandler completionPopupHandler) {
        completionPopupHandler.startTimer();
    }

    static void mav$showInsight(CompletionPopupHandler completionPopupHandler) {
        completionPopupHandler.showInsight();
    }

    static JList ra$_insightList(CompletionPopupHandler completionPopupHandler) {
        return completionPopupHandler._insightList;
    }

    static JTextComponent ra$_textComponent(CompletionPopupHandler completionPopupHandler) {
        return completionPopupHandler._textComponent;
    }

    public final class 1
    implements ComponentListener {
        private void doit() {
            CompletionPopupHandler.ra$_parentWindow(CompletionPopupHandler.this).removeComponentListener(this);
            CompletionPopupHandler.wa$_parentWindowListener(CompletionPopupHandler.this, null);
            CompletionPopupHandler.mav$hideInsight(CompletionPopupHandler.this);
        }

        public void componentHidden(ComponentEvent componentEvent) {
            this.doit();
        }

        public void componentMoved(ComponentEvent componentEvent) {
            this.doit();
        }

        public void componentResized(ComponentEvent componentEvent) {
            this.doit();
        }

        public void componentShown(ComponentEvent componentEvent) {
        }
    }

    private class CancelInsightAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            CompletionPopupHandler.mav$hideInsight(CompletionPopupHandler.this);
        }

        private CancelInsightAction() {
        }

        CancelInsightAction(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class CompleteInsightAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            CompletionPopupHandler.mav$completeInsight(CompletionPopupHandler.this);
            CompletionPopupHandler.mav$hideInsight(CompletionPopupHandler.this);
        }

        private CompleteInsightAction() {
        }

        CompleteInsightAction(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class ArrayListModel
    extends AbstractListModel {
        Object[] _array;

        public ArrayListModel(Object[] objectArray) {
            this._array = objectArray;
        }

        public Object getElementAt(int n) {
            return this._array[n];
        }

        public int getSize() {
            return this._array.length;
        }
    }

    private class CaretHandler
    implements CaretListener {
        public void caretUpdate(CaretEvent caretEvent) {
            if (CompletionPopupHandler.ra$_insightActive(CompletionPopupHandler.this)) {
                CompletionPopupHandler.mav$updateInsight(CompletionPopupHandler.this);
            }
        }

        private CaretHandler() {
        }

        CaretHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class FocusHandler
    implements FocusListener {
        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            CompletionPopupHandler.mav$stopTimer(CompletionPopupHandler.this);
            if (!focusEvent.isTemporary()) {
                CompletionPopupHandler.mav$hideInsight(CompletionPopupHandler.this);
            }
        }

        private FocusHandler() {
        }

        FocusHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class DocumentHandler
    implements DocumentListener {
        public void insertUpdate(DocumentEvent documentEvent) {
            if (!CompletionPopupHandler.ra$_insightActive(CompletionPopupHandler.this)) {
                int n = documentEvent.getOffset();
                if (documentEvent.getLength() > 1) {
                    n += documentEvent.getLength() - 1;
                }
                try {
                    char c = documentEvent.getDocument().getText(n, 1).charAt(0);
                    if (CompletionPopupHandler.mav$isPopupTriggerChar(CompletionPopupHandler.this, c) && !CompletionPopupHandler.ra$_insightLock(CompletionPopupHandler.this)) {
                        CompletionPopupHandler.mav$startTimer(CompletionPopupHandler.this);
                    } else {
                        CompletionPopupHandler.mav$stopTimer(CompletionPopupHandler.this);
                    }
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            CompletionPopupHandler.mav$stopTimer(CompletionPopupHandler.this);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            CompletionPopupHandler.mav$stopTimer(CompletionPopupHandler.this);
        }

        private DocumentHandler() {
        }

        DocumentHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class ActionHandler
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            CompletionPopupHandler.mav$showInsight(CompletionPopupHandler.this);
        }

        private ActionHandler() {
        }

        ActionHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class FocusRedirector
    extends FocusAdapter
    implements Runnable {
        private Component component;

        private FocusRedirector(Component component, Component component2) {
            this.component = component2;
            if (component != null) {
                component.addFocusListener(this);
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            this.run();
        }

        public void run() {
            this.component.requestFocus();
        }

        FocusRedirector(Component component, Component component2, 1 var3_3) {
            this(component, component2);
        }

        public final class 1 {
        }
    }

    private class ActionDelegator
    extends AbstractAction {
        private JComponent _component;
        private Action _delegate;

        ActionDelegator(JComponent jComponent, Action action) {
            this._component = jComponent;
            this._delegate = action;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ActionEvent actionEvent2 = new ActionEvent(this._component, actionEvent.getID(), actionEvent.getActionCommand());
            this._delegate.actionPerformed(actionEvent2);
        }
    }

    private class ListDoubleClickListener
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            try {
                int n;
                if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2 && (n = CompletionPopupHandler.ra$_insightList(CompletionPopupHandler.this).locationToIndex(mouseEvent.getPoint())) != -1) {
                    CompletionPopupHandler.mav$completeInsight(CompletionPopupHandler.this);
                    CompletionPopupHandler.mav$hideInsight(CompletionPopupHandler.this);
                    CompletionPopupHandler.ra$_textComponent(CompletionPopupHandler.this).requestFocus();
                }
            }
            catch (RuntimeException runtimeException) {
                ExceptionDialog.showExceptionDialog(CompletionPopupHandler.ra$_textComponent(CompletionPopupHandler.this), (Throwable)runtimeException);
            }
        }

        private ListDoubleClickListener() {
        }

        ListDoubleClickListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class InsightList
    extends JList {
        public void requestTemporaryFocus() {
            this.requestFocus(true);
        }

        private InsightList() {
        }

        InsightList(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class ShowInsightAction
    extends AbstractAction {
        public ShowInsightAction() {
            super(CompletionPopupHandler.SHOW_INSIGHT_ACTION_NAME);
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CompletionPopupHandler.this.setInsightVisible(true);
        }
    }
}

