/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.controls.completionfield;

import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import oracle.javatools.controls.completionfield.CompletionPopupHandler;
import oracle.javatools.controls.completionfield.CompletionTextComponent;

public class CompletionTextArea
extends JTextArea
implements CompletionTextComponent {
    private final CompletionPopupHandler _popupHandler;

    public CompletionTextArea() {
        this._popupHandler = new TextAreaPopupHandler(this);
    }

    public CompletionTextArea(CompletionPopupHandler completionPopupHandler) {
        this._popupHandler = completionPopupHandler;
    }

    public CompletionPopupHandler getPopupHandler() {
        return this._popupHandler;
    }

    public void removeNotify() {
        super.removeNotify();
        this._popupHandler.setInsightVisible(false);
    }

    public void setText(String string) {
        this._popupHandler.acquireInsightLock();
        try {
            super.setText(string);
        }
        finally {
            this._popupHandler.yieldInsightLock();
        }
    }

    private static final class TextAreaPopupHandler
    extends CompletionPopupHandler {
        TextAreaPopupHandler(JTextArea jTextArea) {
            super(jTextArea);
        }

        protected int getVerticalPopupOffset(Component component) {
            JTextArea jTextArea = (JTextArea)this.getTextComponent();
            int n = jTextArea.getCaretPosition();
            try {
                Rectangle rectangle = jTextArea.modelToView(n);
                int n2 = rectangle.y + rectangle.height;
                return n2;
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
                int n3 = super.getVerticalPopupOffset(component);
                return n3;
            }
        }
    }
}

