/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.controls.completionfield;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import oracle.javatools.controls.completionfield.FieldInsightProvider;

public class FileSystemFieldInsightProvider
implements FieldInsightProvider {
    private static final boolean IS_FS_CASE_SENSITIVE;
    private boolean m_onlyDirectories;

    static {
        File file = new File("A");
        File file2 = new File("a");
        IS_FS_CASE_SENSITIVE = file.equals(file2) ^ true;
    }

    public FileSystemFieldInsightProvider(boolean bl) {
        this.m_onlyDirectories = bl;
    }

    public FileSystemFieldInsightProvider() {
        this(false);
    }

    public void setOnlyDirectories(boolean bl) {
        this.m_onlyDirectories = bl;
    }

    public boolean isOnlyDirectories() {
        return this.m_onlyDirectories;
    }

    protected boolean isValid(File file) {
        if (this.m_onlyDirectories) {
            return file.isDirectory();
        }
        return true;
    }

    public ListCellRenderer getCellRenderer() {
        return new 1();
    }

    private FileFragment getFileFragment(Document document, int n) {
        try {
            String string = document.getText(0, n);
            int n2 = -1;
            String string2 = null;
            int n3 = n - 1;
            while (n3 >= 0) {
                int n4;
                String string3;
                File file;
                char c = string.charAt(n3);
                if (n2 == -1 && File.separatorChar == c) {
                    n2 = n3 + 1;
                    string2 = string.substring(n2);
                }
                if (n2 != -1 && (Character.isWhitespace(c) || n3 == 0 || document.getLength() == 1) && (file = new File(string3 = string.substring(n4 = n3 == 0 || document.getLength() == 1 ? 0 : n3 + 1, n2))).exists() && this.isValid(file)) {
                    FileFragment fileFragment = new FileFragment(null);
                    fileFragment.baseFile = file;
                    fileFragment.fragment = string2;
                    fileFragment.startFile = n4;
                    fileFragment.startFragment = n2;
                    FileFragment fileFragment2 = fileFragment;
                    return fileFragment2;
                }
                --n3;
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        return null;
    }

    public boolean handlesInsight(Document document, int n) {
        return this.getFileFragment(document, n) != null;
    }

    public Object[] getInsightData(Document document, int n) {
        FileFragment fileFragment = this.getFileFragment(document, n);
        if (fileFragment != null) {
            File file;
            Object[] objectArray;
            boolean bl;
            ArrayList<File> arrayList = new ArrayList<File>();
            boolean bl2 = bl = fileFragment.fragment != null && fileFragment.fragment.length() > 0;
            if (this.m_onlyDirectories && !bl) {
                arrayList.add(fileFragment.baseFile);
            }
            if ((objectArray = File.separator.equals((file = fileFragment.baseFile).getName()) ? File.listRoots() : file.listFiles()) == null || objectArray.length == 0) {
                return null;
            }
            int n2 = 0;
            while (n2 < objectArray.length) {
                File file2 = objectArray[n2];
                if (this.isValid(file2)) {
                    if (fileFragment.fragment == null || fileFragment.fragment.length() == 0) {
                        arrayList.add(file2);
                    } else {
                        String string;
                        String string2;
                        if (!IS_FS_CASE_SENSITIVE) {
                            string2 = file2.getName().toUpperCase();
                            string = fileFragment.fragment.toUpperCase();
                        } else {
                            string2 = file2.getName();
                            string = fileFragment.fragment;
                        }
                        if (string2.startsWith(string)) {
                            arrayList.add(file2);
                        }
                    }
                }
                ++n2;
            }
            objectArray = new File[arrayList.size()];
            arrayList.toArray(objectArray);
            return objectArray;
        }
        return null;
    }

    public void completeInsight(Document document, int n, Object object) {
        File file = (File)object;
        if (file == null) {
            return;
        }
        String string = file.getPath();
        if (file.isDirectory()) {
            string = string + File.separatorChar;
        }
        try {
            FileFragment fileFragment = this.getFileFragment(document, n);
            document.remove(fileFragment.startFile, n - fileFragment.startFile);
            document.insertString(fileFragment.startFile, string, null);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public boolean isAutoPopupChar(char c) {
        return c == File.separatorChar;
    }

    public final class 1
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string;
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object instanceof File && ((File)object).isDirectory() && (string = String.valueOf(object)).charAt(string.length() - 1) != File.separatorChar) {
                this.setText(string + File.separator);
            }
            return component;
        }
    }

    private class FileFragment {
        File baseFile;
        String fragment;
        int startFile;
        int startFragment;

        private FileFragment() {
        }

        FileFragment(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

