/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.controls.nicetable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.TableUI;
import javax.swing.plaf.UIResource;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.bali.ewt.util.MenuUtils;
import oracle.javatools.border.JavatoolsBorderFactory;
import oracle.javatools.controls.nicetable.NiceTableAutoSizeModel;
import oracle.javatools.controls.nicetable.NiceTableCellRenderer;
import oracle.javatools.controls.nicetable.NiceTableHeaderRenderer;
import oracle.javatools.controls.nicetable.NiceTableModel;
import oracle.javatools.controls.nicetable.NiceTablePersistentSettings;
import oracle.javatools.controls.nicetable.NiceTableSortDecorator;
import oracle.javatools.controls.nicetable.NiceTableViewport;
import oracle.javatools.dialogs.ExceptionDialog;

public class NiceTable
extends JTable {
    private MouseListener m_resizeListener;
    private boolean m_showToolTips;
    private MouseListener m_columnSelectorListener;
    private Map m_hiddenColumns;
    private MouseInputListener m_sortListener;
    private int m_sortColumn;
    private boolean m_isAscendingSort;
    private Color m_sortColumnBackgroundColor;
    private static Color s_defaultSortColumnBackgroundColor = null;
    private static final int DC_THRESHOLD = 3;
    private static final int MIN_COL_WIDTH = 5;
    private boolean m_sortRetainsSelection;
    private static final TransferHandler s_defaultTransferHandler = new TableTransferHandler(null);
    private Boolean m_useTransferHandler;

    void $init$() {
        this.m_showToolTips = true;
        this.m_isAscendingSort = true;
        this.m_sortRetainsSelection = true;
        this.m_useTransferHandler = null;
        super.setDefaultRenderer(Object.class, new NiceTableCellRenderer());
        super.setShowGrid(false);
        super.setIntercellSpacing(new Dimension(0, 0));
        Border border = JavatoolsBorderFactory.createTopBottomBorder((Color)SystemColor.controlLtHighlight, SystemColor.controlShadow);
        super.getTableHeader().setBorder(border);
        super.getTableHeader().setDefaultRenderer(new NiceTableHeaderRenderer());
        super.setAutoResizeMode(1);
        this.setResizeColumnOnDoubleClick(true);
        this.setColumnSelectorAvailable(true);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.m_hiddenColumns = new HashMap();
    }

    public NiceTable() {
        this.$init$();
    }

    public NiceTable(TableModel tableModel) {
        super(tableModel);
        this.$init$();
    }

    public void setUI(TableUI tableUI) {
        super.setUI(tableUI);
        if (this.m_useTransferHandler == null) {
            this.m_useTransferHandler = Boolean.TRUE;
        }
        this.updateTransferHandler();
    }

    private void updateTransferHandler() {
        if (this.m_useTransferHandler.booleanValue()) {
            this.setTransferHandler(s_defaultTransferHandler);
        } else {
            this.setTransferHandler(null);
        }
    }

    public void setUseTransferHandler(boolean bl) {
        this.m_useTransferHandler = bl;
        this.updateTransferHandler();
    }

    public boolean getUseTransferHandler() {
        return this.m_useTransferHandler == null || this.m_useTransferHandler != false;
    }

    public void setSortRetainsSelection(boolean bl) {
        if (this.m_sortRetainsSelection != bl) {
            this.m_sortRetainsSelection = bl;
            this.firePropertyChange("sortRetainsSelection", bl ^ true, bl);
        }
    }

    public boolean getSortRetainsSelection() {
        return this.m_sortRetainsSelection;
    }

    public int convertRowToModelIndex(int n) {
        if (this.getModel() instanceof NiceTableSortDecorator) {
            return ((NiceTableSortDecorator)this.getModel()).getModelRow(n);
        }
        return n;
    }

    public int convertRowToViewIndex(int n) {
        if (!this.isSorted()) {
            return n;
        }
        return ((NiceTableSortDecorator)this.getModel()).getViewRow(n);
    }

    public Color getSortColumnBackgroundColor() {
        if (this.m_sortColumnBackgroundColor != null) {
            return this.m_sortColumnBackgroundColor;
        }
        if (s_defaultSortColumnBackgroundColor == null) {
            s_defaultSortColumnBackgroundColor = NiceTable.getDarker(this.getBackground());
        }
        return s_defaultSortColumnBackgroundColor;
    }

    public void setSortColumnBackgroundColor(Color color) {
        this.m_sortColumnBackgroundColor = color;
        this.repaint();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        s_defaultSortColumnBackgroundColor = null;
    }

    public void updateUI() {
        super.updateUI();
        s_defaultSortColumnBackgroundColor = null;
    }

    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        if (bl && n == 1 && (keyStroke.getKeyCode() == 27 || keyStroke.getKeyCode() == 10) && !this.isEditing()) {
            return false;
        }
        return super.processKeyBinding(keyStroke, keyEvent, n, bl);
    }

    public void setSorted(boolean bl) {
        if (bl && !(this.getModel() instanceof NiceTableModel)) {
            throw new IllegalArgumentException("Sorted NiceTable only supported with NiceTableModel");
        }
        if (bl) {
            this.setModel(new NiceTableSortDecorator((NiceTableModel)this.getModel()));
            if (this.m_sortListener == null) {
                this.m_sortListener = this.createSortListener();
                this.getTableHeader().addMouseListener(this.m_sortListener);
                this.getTableHeader().addMouseMotionListener(this.m_sortListener);
            }
        } else {
            if (this.getModel() instanceof NiceTableSortDecorator) {
                this.setModel(((NiceTableSortDecorator)this.getModel()).getRealModel());
            }
            if (this.m_sortListener != null) {
                this.getTableHeader().removeMouseListener(this.m_sortListener);
                this.getTableHeader().removeMouseMotionListener(this.m_sortListener);
                this.m_sortListener = null;
            }
        }
    }

    public boolean isSorted() {
        return this.m_sortListener != null;
    }

    public TableModel getBaseModel() {
        if (!this.isSorted() || !(this.getModel() instanceof NiceTableSortDecorator)) {
            return this.getModel();
        }
        return ((NiceTableSortDecorator)this.getModel()).getRealModel();
    }

    public int[] getSelectedRowsInModel() {
        if (!this.isSorted()) {
            return this.getSelectedRows();
        }
        int n = this.getSelectedRowCount();
        int[] nArray = this.getSelectedRows();
        int[] nArray2 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray2[n2] = ((NiceTableSortDecorator)this.getModel()).getModelRow(nArray[n2]);
            ++n2;
        }
        return nArray2;
    }

    public void setSelectedRowsInModel(int[] nArray) {
        try {
            this.getSelectionModel().setValueIsAdjusting(true);
            this.getSelectionModel().clearSelection();
            int n = 0;
            while (n < nArray.length) {
                int n2 = this.isSorted() ? this.convertRowToViewIndex(nArray[n]) : nArray[n];
                this.getSelectionModel().addSelectionInterval(n2, n2);
                ++n;
            }
        }
        finally {
            this.getSelectionModel().setValueIsAdjusting(false);
        }
    }

    public NiceTablePersistentSettings getPersistentSettings() {
        NiceTablePersistentSettings niceTablePersistentSettings = new NiceTablePersistentSettings();
        niceTablePersistentSettings.setHiddenColumns(this.getHiddenColumns());
        int[] nArray = new int[this.getModel().getColumnCount()];
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < this.getModel().getColumnCount()) {
            int n2 = this.convertColumnIndexToView(n);
            TableColumn tableColumn = n2 != -1 ? this.getTableHeader().getColumnModel().getColumn(n2) : (TableColumn)this.m_hiddenColumns.get(new Integer(n));
            nArray[n] = tableColumn.getWidth();
            ++n;
        }
        int n3 = 0;
        while (n3 < this.getColumnModel().getColumnCount()) {
            TableColumn tableColumn = this.getColumnModel().getColumn(n3);
            Object object = tableColumn.getIdentifier();
            arrayList.add(object);
            ++n3;
        }
        niceTablePersistentSettings.setColumnWidths(nArray);
        niceTablePersistentSettings.setColumnPositions(arrayList);
        niceTablePersistentSettings.setSorted(this.isSorted());
        niceTablePersistentSettings.setSortColumn(this.getSortColumn());
        niceTablePersistentSettings.setSortAscending(this.isSortAscending());
        return niceTablePersistentSettings;
    }

    public void setPersistentSettings(NiceTablePersistentSettings niceTablePersistentSettings) {
        this.setHiddenColumns(niceTablePersistentSettings.getHiddenColumns());
        int n = 0;
        while (n < niceTablePersistentSettings.getColumnWidths().length) {
            int n2 = this.convertColumnIndexToView(n);
            TableColumn tableColumn = n2 != -1 ? this.getTableHeader().getColumnModel().getColumn(n2) : (TableColumn)this.m_hiddenColumns.get(new Integer(n));
            tableColumn.setPreferredWidth(niceTablePersistentSettings.getColumnWidths()[n]);
            ++n;
        }
        List list = niceTablePersistentSettings.getColumnPositions();
        if (list != null) {
            int n3 = 0;
            while (n3 < list.size()) {
                int n4 = this.getColumnModel().getColumnIndex(list.get(n3));
                if (n4 != n3) {
                    this.getColumnModel().moveColumn(n4, n3);
                }
                ++n3;
            }
        }
    }

    public void setSortColumn(int n, boolean bl) {
        JScrollPane jScrollPane;
        JViewport jViewport;
        Container container;
        int n2;
        if (!this.isSorted()) {
            this.setSorted(true);
        }
        this.m_sortColumn = n;
        this.m_isAscendingSort = bl;
        int[] nArray = null;
        if (this.m_sortRetainsSelection) {
            nArray = this.getSelectedRowsInModel();
        }
        if ((n2 = this.convertColumnIndexToView(n)) >= 0 && n2 < this.getColumnCount()) {
            ((NiceTableSortDecorator)this.getModel()).sort(n, bl);
        }
        if (this.m_sortRetainsSelection) {
            this.setSelectedRowsInModel(nArray);
        }
        this.repaint();
        this.getTableHeader().repaint();
        Container container2 = this.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane && (jViewport = (jScrollPane = (JScrollPane)container).getViewport()) instanceof NiceTableViewport) {
            jViewport.repaint();
        }
        if (this.m_sortRetainsSelection) {
            this.scrollToSelection();
        }
    }

    public int getSortColumn() {
        return this.m_sortColumn;
    }

    public boolean isSortAscending() {
        return this.m_isAscendingSort;
    }

    public void reSort() {
        this.setSortColumn(this.getSortColumn(), this.isSortAscending());
    }

    public void setHiddenColumns(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n];
            int n3 = this.convertColumnIndexToView(n2);
            TableColumn tableColumn = this.getTableHeader().getColumnModel().getColumn(n3);
            this.setColumnVisible(tableColumn, n2, false);
            ++n;
        }
    }

    public int[] getHiddenColumns() {
        int[] nArray = new int[this.m_hiddenColumns.size()];
        int n = 0;
        Iterator iterator = this.m_hiddenColumns.keySet().iterator();
        while (iterator.hasNext()) {
            nArray[n++] = (Integer)iterator.next();
        }
        return nArray;
    }

    public void setColumnSelectorAvailable(boolean bl) {
        if (bl) {
            if (this.m_columnSelectorListener == null) {
                this.m_columnSelectorListener = this.createSelectorListener();
                this.getTableHeader().addMouseListener(this.m_columnSelectorListener);
            }
        } else if (this.m_columnSelectorListener != null) {
            this.getTableHeader().removeMouseListener(this.m_columnSelectorListener);
            this.m_columnSelectorListener = null;
        }
    }

    public boolean isColumnSelectorAvailable() {
        return this.m_columnSelectorListener != null;
    }

    private MouseListener createSelectorListener() {
        return new 4();
    }

    public JPopupMenu createSelectorMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        int n = 0;
        while (n < this.getModel().getColumnCount()) {
            boolean bl;
            TableColumn tableColumn;
            int n2 = this.convertColumnIndexToView(n);
            if (n2 > -1) {
                tableColumn = this.getTableHeader().getColumnModel().getColumn(n2);
                bl = true;
            } else {
                tableColumn = (TableColumn)this.m_hiddenColumns.get(new Integer(n));
                bl = false;
            }
            TableColumnToggleAction tableColumnToggleAction = new TableColumnToggleAction(tableColumn, n, bl, null);
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(tableColumnToggleAction);
            jCheckBoxMenuItem.setSelected(bl);
            if (n == 0) {
                jCheckBoxMenuItem.setEnabled(false);
            }
            jPopupMenu.add(jCheckBoxMenuItem);
            ++n;
        }
        return jPopupMenu;
    }

    private void setColumnVisible(TableColumn tableColumn, int n, boolean bl) {
        if (bl) {
            this.m_hiddenColumns.remove(new Integer(n));
            this.getTableHeader().getColumnModel().addColumn(tableColumn);
            int n2 = n < this.getTableHeader().getColumnModel().getColumnCount() ? n : this.getTableHeader().getColumnModel().getColumnCount() - 1;
            this.getTableHeader().getColumnModel().moveColumn(this.getTableHeader().getColumnModel().getColumnCount() - 1, n2);
        } else {
            this.getTableHeader().getColumnModel().removeColumn(tableColumn);
            this.m_hiddenColumns.put(new Integer(n), tableColumn);
            if (this.isSorted() && n == this.getSortColumn()) {
                this.setSortColumn(0, true);
            }
        }
    }

    public JScrollPane getScrollPaneForTable() {
        JScrollPane jScrollPane = new JScrollPane();
        NiceTableViewport niceTableViewport = new NiceTableViewport();
        niceTableViewport.setView(this);
        jScrollPane.setViewport(niceTableViewport);
        jScrollPane.setBackground(this.getBackground());
        jScrollPane.getViewport().setBackground(this.getBackground());
        jScrollPane.setCorner("UPPER_RIGHT_CORNER", new JPanel());
        jScrollPane.setCorner("LOWER_RIGHT_CORNER", new JPanel());
        return jScrollPane;
    }

    protected void configureEnclosingScrollPane() {
        Container container;
        Container container2 = this.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)container;
            jScrollPane.setBackground(this.getBackground());
            if (this.getTableHeader() != null && this.getTableHeader().isVisible()) {
                jScrollPane.setColumnHeaderView(this.getTableHeader());
            }
            jScrollPane.setCorner("UPPER_RIGHT_CORNER", new JPanel());
            jScrollPane.setCorner("LOWER_RIGHT_CORNER", new JPanel());
            Border border = jScrollPane.getBorder();
            if (border == null || border instanceof UIResource) {
                jScrollPane.setBorder(UIManager.getBorder("Table.scrollPaneBorder"));
            }
            EventQueue.invokeLater(new 3(this, container));
        }
    }

    public void setShowToolTips(boolean bl) {
        this.m_showToolTips = bl;
    }

    public boolean isShowToolTips() {
        return this.m_showToolTips;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (!this.m_showToolTips) {
            return super.getToolTipText(mouseEvent);
        }
        Point point = mouseEvent.getPoint();
        int n = this.columnAtPoint(point);
        int n2 = this.rowAtPoint(point);
        if (n != -1 && n2 != -1) {
            int n3 = this.convertColumnIndexToModel(n);
            Object object = this.getModel().getValueAt(n2, n3);
            if (object != null) {
                String string;
                TableCellRenderer tableCellRenderer = this.getCellRenderer(n2, n);
                Component component = tableCellRenderer.getTableCellRendererComponent(this, object, false, false, n2, n);
                Rectangle rectangle = this.getCellRect(n2, n, false);
                Dimension dimension = component.getPreferredSize();
                if (rectangle.width < dimension.width && (string = object.toString()).length() != 0) {
                    return string;
                }
            }
        }
        return super.getToolTipText(mouseEvent);
    }

    public void autoSizeColumnsToFit() {
        this.autoSizeColumnsToFit(null);
    }

    public void autoSizeColumnsToFit(Object[] objectArray) {
        int n = 0;
        while (n < this.getTableHeader().getColumnModel().getColumnCount()) {
            int n2;
            int n3 = 5;
            TableColumn tableColumn = this.getTableHeader().getColumnModel().getColumn(n);
            TableCellRenderer tableCellRenderer = null;
            if (tableCellRenderer == null) {
                tableCellRenderer = tableColumn.getHeaderRenderer();
            }
            if (tableCellRenderer == null) {
                tableCellRenderer = tableColumn.getCellRenderer();
            }
            if (tableCellRenderer == null) {
                tableCellRenderer = this.getTableHeader().getDefaultRenderer();
            }
            if (tableCellRenderer != null) {
                n3 = tableCellRenderer.getTableCellRendererComponent((JTable)this, (Object)tableColumn.getHeaderValue(), (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().width;
                if (this.getSortColumn() == n) {
                    n3 += NiceTableHeaderRenderer.SORT_ICON_SIZE.width + 5;
                }
            }
            if ((n2 = this.getModel().getRowCount()) <= 0 && objectArray != null && objectArray[n] != null) {
                TableCellRenderer tableCellRenderer2 = this.getDefaultRenderer(this.getModel().getColumnClass(n));
                n3 = Math.max(tableCellRenderer2.getTableCellRendererComponent((JTable)this, (Object)objectArray[n], (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().width, n3);
            }
            int n4 = 0;
            while (n4 < n2) {
                Object object = this.getModel().getValueAt(n4, n);
                TableCellRenderer tableCellRenderer3 = this.getCellRenderer(n4, n);
                if (tableCellRenderer3 != null && object != null) {
                    n3 = Math.max(tableCellRenderer3.getTableCellRendererComponent((JTable)this, (Object)object, (boolean)false, (boolean)false, (int)n4, (int)n).getPreferredSize().width, n3);
                }
                ++n4;
            }
            if (this.getModel() instanceof NiceTableAutoSizeModel) {
                NiceTableAutoSizeModel niceTableAutoSizeModel = (NiceTableAutoSizeModel)((Object)this.getModel());
                n3 = Math.min(n3, niceTableAutoSizeModel.getColumnAutoSizeMaximum(n));
            }
            tableColumn.setPreferredWidth(n3);
            ++n;
        }
    }

    public void setResizeColumnOnDoubleClick(boolean bl) {
        if (bl && this.getTableHeader().getResizingAllowed()) {
            if (this.m_resizeListener == null) {
                this.m_resizeListener = this.createResizeListener();
                this.getTableHeader().addMouseListener(this.m_resizeListener);
            }
        } else if (this.m_resizeListener != null) {
            this.getTableHeader().removeMouseListener(this.m_resizeListener);
            this.m_resizeListener = null;
        }
    }

    private MouseInputListener createSortListener() {
        2 var1_1 = new 2();
        return var1_1;
    }

    private MouseListener createResizeListener() {
        1 var1_1 = new 1();
        return var1_1;
    }

    public boolean isResizeColumnOnDoubleClick() {
        return this.m_resizeListener != null;
    }

    public void scrollToSelection() {
        if (!(this.getParent() instanceof JViewport)) {
            return;
        }
        JViewport jViewport = (JViewport)this.getParent();
        Rectangle rectangle = this.getCellRect(this.getSelectedRow(), this.getSelectedColumn(), true);
        Point point = jViewport.getViewPosition();
        rectangle.setLocation(rectangle.x - point.x, rectangle.y - point.y);
        jViewport.scrollRectToVisible(rectangle);
    }

    public String convertValueToText(Object object, boolean bl, boolean bl2, int n, int n2) {
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    private static Color getDarker(Color color) {
        return new Color(color.getRed() - 8, color.getGreen() - 8, color.getBlue() - 8);
    }

    static void mav$setColumnVisible(NiceTable niceTable, TableColumn tableColumn, int n, boolean bl) {
        niceTable.setColumnVisible(tableColumn, n, bl);
    }

    public final class 4
    extends MouseAdapter {
        private void doIt(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                JPopupMenu jPopupMenu = NiceTable.this.createSelectorMenu();
                MenuUtils.showPopupMenu((JPopupMenu)jPopupMenu, (Component)NiceTable.this.getTableHeader(), (int)mouseEvent.getX(), (int)mouseEvent.getY());
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.doIt(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.doIt(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.doIt(mouseEvent);
        }
    }

    private class TableColumnToggleAction
    extends AbstractAction {
        private final boolean m_visible;
        private final int m_modelColumn;
        private final TableColumn m_column;

        private TableColumnToggleAction(TableColumn tableColumn, int n, boolean bl) {
            this.putValue("Name", tableColumn.getHeaderValue().toString());
            this.m_column = tableColumn;
            this.m_modelColumn = n;
            this.m_visible = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NiceTable.mav$setColumnVisible(NiceTable.this, this.m_column, this.m_modelColumn, this.m_visible ^ true);
        }

        TableColumnToggleAction(TableColumn tableColumn, int n, boolean bl, 1 var5_5) {
            this(tableColumn, n, bl);
        }

        public final class 1 {
        }
    }

    public final class 3
    implements Runnable {
        private final /* synthetic */ Container v$sp;
        final /* synthetic */ NiceTable this$0;

        public void run() {
            JScrollPane jScrollPane = (JScrollPane)this.v$sp;
            JViewport jViewport = jScrollPane.getViewport();
            if (!(jScrollPane.getViewport() instanceof NiceTableViewport)) {
                jViewport = new NiceTableViewport();
                jScrollPane.setViewport(jViewport);
                jScrollPane.validate();
                jScrollPane.invalidate();
                jScrollPane.validate();
                jViewport.setBackground(this.this$0.getBackground());
            }
            if (jViewport.getView() != this.this$0) {
                jViewport.setView(this.this$0);
                jViewport.validate();
                jViewport.invalidate();
                jViewport.validate();
            }
        }

        public 3(NiceTable niceTable, Container container) {
            this.v$sp = container;
            this.this$0 = niceTable;
        }
    }

    public final class 2
    extends MouseInputAdapter {
        private int m_startX;
        private boolean m_isDragged;

        public void mousePressed(MouseEvent mouseEvent) {
            this.m_startX = mouseEvent.getX();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.m_isDragged = true;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.m_isDragged) {
                this.m_isDragged = false;
                if (Math.abs(mouseEvent.getX() - this.m_startX) >= 5) {
                    return;
                }
            }
            if (NiceTable.this.isEnabled() && mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 1) {
                TableColumnModel tableColumnModel = NiceTable.this.getColumnModel();
                int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                Rectangle rectangle = NiceTable.this.getTableHeader().getHeaderRect(n);
                if (mouseEvent.getX() <= rectangle.x + 3 || mouseEvent.getX() >= rectangle.x + rectangle.width - 3) {
                    return;
                }
                int n2 = NiceTable.this.convertColumnIndexToModel(n);
                if (NiceTable.this.getSortColumn() == n2) {
                    NiceTable.this.setSortColumn(n2, NiceTable.this.isSortAscending() ^ true);
                } else {
                    NiceTable.this.setSortColumn(n2, true);
                }
            }
        }
    }

    public final class 1
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            try {
                if (NiceTable.this.isEnabled() && mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1) {
                    int n = mouseEvent.getX();
                    int n2 = -1;
                    int n3 = 0;
                    while (n3 < NiceTable.this.getTableHeader().getColumnModel().getColumnCount()) {
                        Rectangle rectangle = NiceTable.this.getTableHeader().getHeaderRect(n3);
                        int n4 = rectangle.x;
                        if (n >= n4 - 3 && n <= n4 + 3 && n3 > 0) {
                            n2 = n3 - 1;
                            break;
                        }
                        n4 = rectangle.x + rectangle.width;
                        if (n >= n4 - 3 && n <= n4 + 3) {
                            n2 = n3;
                            break;
                        }
                        ++n3;
                    }
                    if (n2 != -1) {
                        int n5 = NiceTable.this.convertColumnIndexToModel(n2);
                        int n6 = 5;
                        int n7 = 0;
                        while (n7 < NiceTable.this.getModel().getRowCount()) {
                            Object object = NiceTable.this.getModel().getValueAt(n7, n5);
                            TableCellRenderer tableCellRenderer = NiceTable.this.getCellRenderer(n7, n2);
                            Component component = tableCellRenderer.getTableCellRendererComponent(NiceTable.this, object, false, false, n7, n2);
                            n6 = Math.max(component.getPreferredSize().width, n6);
                            ++n7;
                        }
                        NiceTable.this.getTableHeader().getColumnModel().getColumn(n2).setPreferredWidth(n6);
                        NiceTable.this.getTableHeader().resizeAndRepaint();
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                ExceptionDialog.showExceptionDialog(NiceTable.this, (Throwable)runtimeException);
            }
        }
    }

    private static class TableTransferHandler
    extends TransferHandler
    implements UIResource {
        protected Transferable createTransferable(JComponent jComponent) {
            if (jComponent instanceof JTable) {
                int[] nArray;
                int[] nArray2;
                JTable jTable = (JTable)jComponent;
                if (!jTable.getRowSelectionAllowed() && !jTable.getColumnSelectionAllowed()) {
                    return null;
                }
                if (!jTable.getRowSelectionAllowed()) {
                    int n = jTable.getRowCount();
                    nArray2 = new int[n];
                    int n2 = 0;
                    while (n2 < n) {
                        nArray2[n2] = n2;
                        ++n2;
                    }
                } else {
                    nArray2 = jTable.getSelectedRows();
                }
                if (!jTable.getColumnSelectionAllowed()) {
                    int n = jTable.getColumnCount();
                    nArray = new int[n];
                    int n3 = 0;
                    while (n3 < n) {
                        nArray[n3] = n3;
                        ++n3;
                    }
                } else {
                    nArray = jTable.getSelectedColumns();
                }
                if (nArray2 == null || nArray == null || nArray2.length == 0 || nArray.length == 0) {
                    return null;
                }
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer2.append("<html>\n<body>\n<table>\n");
                int n = 0;
                while (n < nArray2.length) {
                    stringBuffer2.append("<tr>\n");
                    int n4 = 0;
                    while (n4 < nArray.length) {
                        Object object = jTable.getValueAt(nArray2[n], nArray[n4]);
                        String string = null;
                        if (object != null && jTable instanceof NiceTable) {
                            string = ((NiceTable)jTable).convertValueToText(object, true, false, n, n4);
                        }
                        if (string == null) {
                            string = object == null ? "" : object.toString();
                        }
                        stringBuffer.append(string + "\t");
                        stringBuffer2.append("  <td>" + string + "</td>\n");
                        ++n4;
                    }
                    stringBuffer.deleteCharAt(stringBuffer.length() - 1).append("\n");
                    stringBuffer2.append("</tr>\n");
                    ++n;
                }
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                stringBuffer2.append("</table>\n</body>\n</html>");
                return new BasicTransferable(stringBuffer.toString(), stringBuffer2.toString());
            }
            return null;
        }

        public int getSourceActions(JComponent jComponent) {
            return 1;
        }

        private TableTransferHandler() {
        }

        TableTransferHandler(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class BasicTransferable
    implements UIResource,
    Transferable {
        protected String plainData;
        protected String htmlData;
        private static DataFlavor[] htmlFlavors;
        private static DataFlavor[] stringFlavors;
        private static DataFlavor[] plainFlavors;

        static {
            try {
                htmlFlavors = new DataFlavor[3];
                BasicTransferable.htmlFlavors[0] = new DataFlavor("text/html;class=java.lang.String");
                BasicTransferable.htmlFlavors[1] = new DataFlavor("text/html;class=java.io.Reader");
                BasicTransferable.htmlFlavors[2] = new DataFlavor("text/html;charset=unicode;class=java.io.InputStream");
                plainFlavors = new DataFlavor[3];
                BasicTransferable.plainFlavors[0] = new DataFlavor("text/plain;class=java.lang.String");
                BasicTransferable.plainFlavors[1] = new DataFlavor("text/plain;class=java.io.Reader");
                BasicTransferable.plainFlavors[2] = new DataFlavor("text/plain;charset=unicode;class=java.io.InputStream");
                stringFlavors = new DataFlavor[2];
                BasicTransferable.stringFlavors[0] = new DataFlavor("application/x-java-jvm-local-objectref;class=java.lang.String");
                BasicTransferable.stringFlavors[1] = DataFlavor.stringFlavor;
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
        }

        public BasicTransferable(String string, String string2) {
            this.plainData = string;
            this.htmlData = string2;
        }

        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] dataFlavorArray = this.getRicherFlavors();
            int n = dataFlavorArray != null ? dataFlavorArray.length : 0;
            int n2 = this.isHTMLSupported() ? htmlFlavors.length : 0;
            int n3 = this.isPlainSupported() ? plainFlavors.length : 0;
            int n4 = this.isPlainSupported() ? stringFlavors.length : 0;
            int n5 = n + n2 + n3 + n4;
            DataFlavor[] dataFlavorArray2 = new DataFlavor[n5];
            int n6 = 0;
            if (n > 0) {
                System.arraycopy(dataFlavorArray, 0, dataFlavorArray2, n6, n);
                n6 += n;
            }
            if (n2 > 0) {
                System.arraycopy(htmlFlavors, 0, dataFlavorArray2, n6, n2);
                n6 += n2;
            }
            if (n3 > 0) {
                System.arraycopy(plainFlavors, 0, dataFlavorArray2, n6, n3);
                n6 += n3;
            }
            if (n4 > 0) {
                System.arraycopy(stringFlavors, 0, dataFlavorArray2, n6, n4);
                n6 += n4;
            }
            return dataFlavorArray2;
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            DataFlavor[] dataFlavorArray = this.getTransferDataFlavors();
            int n = 0;
            while (n < dataFlavorArray.length) {
                if (dataFlavorArray[n].equals(dataFlavor)) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (this.isRicherFlavor(dataFlavor)) {
                return this.getRicherData(dataFlavor);
            }
            if (this.isHTMLFlavor(dataFlavor)) {
                String string = this.getHTMLData();
                String string2 = string = string == null ? "" : string;
                if (String.class.equals(dataFlavor.getRepresentationClass())) {
                    return string;
                }
                if (Reader.class.equals(dataFlavor.getRepresentationClass())) {
                    return new StringReader(string);
                }
                if (InputStream.class.equals(dataFlavor.getRepresentationClass())) {
                    return new ByteArrayInputStream(string.getBytes());
                }
            } else if (this.isPlainFlavor(dataFlavor)) {
                String string = this.getPlainData();
                String string3 = string = string == null ? "" : string;
                if (String.class.equals(dataFlavor.getRepresentationClass())) {
                    return string;
                }
                if (Reader.class.equals(dataFlavor.getRepresentationClass())) {
                    return new StringReader(string);
                }
                if (InputStream.class.equals(dataFlavor.getRepresentationClass())) {
                    return new ByteArrayInputStream(string.getBytes());
                }
            } else if (this.isStringFlavor(dataFlavor)) {
                String string = this.getPlainData();
                string = string == null ? "" : string;
                return string;
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }

        protected boolean isRicherFlavor(DataFlavor dataFlavor) {
            DataFlavor[] dataFlavorArray = this.getRicherFlavors();
            int n = dataFlavorArray != null ? dataFlavorArray.length : 0;
            int n2 = 0;
            while (n2 < n) {
                if (dataFlavorArray[n2].equals(dataFlavor)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        protected DataFlavor[] getRicherFlavors() {
            return null;
        }

        protected Object getRicherData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
            return null;
        }

        protected boolean isHTMLFlavor(DataFlavor dataFlavor) {
            DataFlavor[] dataFlavorArray = htmlFlavors;
            int n = 0;
            while (n < dataFlavorArray.length) {
                if (dataFlavorArray[n].equals(dataFlavor)) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        protected boolean isHTMLSupported() {
            return this.htmlData != null;
        }

        protected String getHTMLData() {
            return this.htmlData;
        }

        protected boolean isPlainFlavor(DataFlavor dataFlavor) {
            DataFlavor[] dataFlavorArray = plainFlavors;
            int n = 0;
            while (n < dataFlavorArray.length) {
                if (dataFlavorArray[n].equals(dataFlavor)) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        protected boolean isPlainSupported() {
            return this.plainData != null;
        }

        protected String getPlainData() {
            return this.plainData;
        }

        protected boolean isStringFlavor(DataFlavor dataFlavor) {
            DataFlavor[] dataFlavorArray = stringFlavors;
            int n = 0;
            while (n < dataFlavorArray.length) {
                if (dataFlavorArray[n].equals(dataFlavor)) {
                    return true;
                }
                ++n;
            }
            return false;
        }
    }
}

