/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.controls.nicetable;

import java.util.Arrays;
import java.util.Comparator;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import oracle.javatools.controls.nicetable.NiceTableAutoSizeModel;
import oracle.javatools.controls.nicetable.NiceTableModel;

class NiceTableSortDecorator
extends AbstractTableModel
implements NiceTableAutoSizeModel,
TableModelListener {
    private NiceTableModel m_realModel;
    private Integer[] m_indexes;
    private int[] m_reverseIndex;

    NiceTableSortDecorator(NiceTableModel niceTableModel) {
        this.setRealModel(niceTableModel);
    }

    void setRealModel(NiceTableModel niceTableModel) {
        if (this.m_realModel != null) {
            this.m_realModel.removeTableModelListener(this);
        }
        this.m_realModel = niceTableModel;
        if (niceTableModel == null) {
            this.m_indexes = null;
            return;
        }
        this.m_realModel.addTableModelListener(this);
        this.allocate();
    }

    int getModelRow(int n) {
        return this.m_indexes[n];
    }

    int getViewRow(int n) {
        if (this.m_reverseIndex == null) {
            this.m_reverseIndex = new int[this.m_indexes.length];
            int n2 = 0;
            while (n2 < this.m_indexes.length) {
                this.m_reverseIndex[this.m_indexes[n2].intValue()] = n2;
                ++n2;
            }
        }
        return this.m_reverseIndex[n];
    }

    private void allocate() {
        this.m_indexes = new Integer[this.m_realModel.getRowCount()];
        int n = 0;
        while (n < this.m_indexes.length) {
            this.m_indexes[n] = new Integer(n);
            ++n;
        }
        this.m_reverseIndex = null;
    }

    void sort(int n, boolean bl) {
        this.m_reverseIndex = null;
        int n2 = this.getRowCount();
        Comparator comparator = this.getComparator(n, bl);
        Arrays.sort(this.m_indexes, comparator);
        super.fireTableChanged(new TableModelEvent(this));
    }

    private Comparator getComparator(int n, boolean bl) {
        Comparator comparator = this.getRealModel().getColumnSortComparator(n);
        if (comparator == null) {
            comparator = new SafeObjectComparator(null);
        }
        return new SortComparator(comparator, n, bl);
    }

    NiceTableModel getRealModel() {
        return this.m_realModel;
    }

    public Object getValueAt(int n, int n2) {
        if (n >= this.m_indexes.length || n2 >= this.getColumnCount()) {
            return null;
        }
        return this.m_realModel.getValueAt(this.m_indexes[n], n2);
    }

    public void setValueAt(Object object, int n, int n2) {
        this.m_realModel.setValueAt(object, this.m_indexes[n], n2);
    }

    public int getRowCount() {
        if (this.m_indexes == null) {
            this.allocate();
        }
        return this.m_indexes.length;
    }

    public int getColumnCount() {
        return this.m_realModel.getColumnCount();
    }

    public String getColumnName(int n) {
        return this.m_realModel.getColumnName(n);
    }

    public Class getColumnClass(int n) {
        return this.m_realModel.getColumnClass(n);
    }

    public boolean isCellEditable(int n, int n2) {
        return this.m_realModel.isCellEditable(this.m_indexes[n], n2);
    }

    public void addTableModelListener(TableModelListener tableModelListener) {
        this.m_realModel.addTableModelListener(tableModelListener);
    }

    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.m_realModel.removeTableModelListener(tableModelListener);
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        this.allocate();
        super.fireTableChanged(tableModelEvent);
    }

    public int getColumnAutoSizeMaximum(int n) {
        if (this.m_realModel instanceof NiceTableAutoSizeModel) {
            return ((NiceTableAutoSizeModel)((Object)this.m_realModel)).getColumnAutoSizeMaximum(n);
        }
        return Integer.MAX_VALUE;
    }

    static NiceTableModel ra$m_realModel(NiceTableSortDecorator niceTableSortDecorator) {
        return niceTableSortDecorator.m_realModel;
    }

    private class SafeObjectComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            if (object == null && object2 == null) {
                return 0;
            }
            if (object == null) {
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            if (object instanceof Comparable && object2 instanceof Comparable) {
                return ((Comparable)object).compareTo((Comparable)object2);
            }
            return object.toString().compareTo(object2.toString());
        }

        public boolean equals(Object object) {
            return object instanceof SafeObjectComparator;
        }

        private SafeObjectComparator() {
        }

        SafeObjectComparator(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class SortComparator
    implements Comparator {
        private Comparator m_delegateComparator;
        private int m_column;
        private boolean m_ascending;

        SortComparator(Comparator comparator, int n, boolean bl) {
            this.m_delegateComparator = comparator;
            this.m_column = n;
            this.m_ascending = bl;
        }

        public int compare(Object object, Object object2) {
            if (object instanceof Integer && object2 instanceof Integer && object != null && object2 != null) {
                int n = (Integer)object;
                int n2 = (Integer)object2;
                Object object3 = NiceTableSortDecorator.ra$m_realModel(NiceTableSortDecorator.this).getValueAt(n, this.m_column);
                Object object4 = NiceTableSortDecorator.ra$m_realModel(NiceTableSortDecorator.this).getValueAt(n2, this.m_column);
                int n3 = this.m_delegateComparator.compare(object3, object4);
                if (!this.m_ascending) {
                    return -1 * n3;
                }
                return n3;
            }
            return 0;
        }

        public boolean equals(Object object) {
            return object != null && object instanceof SortComparator;
        }
    }
}

