/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.controls.nicetable;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import oracle.javatools.controls.nicetable.NiceTable;

public class NiceTableViewport
extends JViewport
implements TableColumnModelListener {
    public void setView(Component component) {
        if (!(component instanceof NiceTable)) {
            throw new IllegalArgumentException("Cannot setView() on NiceTableViewport unless view is a NiceTable");
        }
        if (this.getView() instanceof NiceTable) {
            ((NiceTable)this.getView()).getColumnModel().removeColumnModelListener(this);
        }
        super.setView(component);
        ((NiceTable)component).getColumnModel().addColumnModelListener(this);
    }

    public void setViewPosition(Point point) {
        super.setViewPosition(point);
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        NiceTable niceTable = (NiceTable)super.getView();
        if (niceTable.isSorted() && niceTable.getTableHeader() != null && niceTable.getTableHeader().isVisible()) {
            int n = niceTable.getSortColumn();
            n = niceTable.convertColumnIndexToView(n);
            Rectangle rectangle = niceTable.getTableHeader().getHeaderRect(n);
            graphics.setColor(niceTable.getSortColumnBackgroundColor());
            graphics.fillRect(rectangle.x, 0, rectangle.width, this.getHeight());
        }
    }

    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        this.repaint();
    }

    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        this.repaint();
    }

    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
        this.repaint();
    }

    public void columnMarginChanged(ChangeEvent changeEvent) {
        this.repaint();
    }

    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        this.repaint();
    }
}

