/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.data;

import java.net.URL;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.Structure;

public final class ChangeInfo {
    public static final int VALUE_MODIFIED = 0;
    public static final int VALUE_ADDED = 1;
    public static final int PLACEHOLDER_VALUE_ADDED = 2;
    public static final int VALUE_REMOVED = 3;
    public static final int HASH_STRUCTURE = 0;
    public static final int LIST_STRUCTURE = 1;
    public static final int UNKNOWN_STRUCTURE = -1;
    private final int _changeType;
    private final int _parentStructureType;
    private final String _propertyName;
    private final Structure _valueParent;
    private final Object _oldValue;
    private final Object _newValue;

    private ChangeInfo(int n, String string, Structure structure, Object object, Object object2) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this._changeType = n;
        this._parentStructureType = structure instanceof HashStructure ? 0 : (structure instanceof ListStructure ? 1 : -1);
        this._propertyName = string;
        this._valueParent = structure;
        this._oldValue = ChangeInfo.maybeCopyValue(object);
        this._newValue = ChangeInfo.maybeCopyValue(object2);
    }

    private ChangeInfo(String string, int n, int n2, Structure structure, Object object, Object object2) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this._propertyName = string;
        this._changeType = n;
        this._parentStructureType = n2;
        this._valueParent = structure;
        this._oldValue = object;
        this._newValue = object2;
    }

    ChangeInfo replaceName(String string) {
        return new ChangeInfo(string, this._changeType, this._parentStructureType, this._valueParent, this._oldValue, this._newValue);
    }

    private static Object maybeCopyValue(Object object) {
        if (object instanceof HashStructure) {
            return ((HashStructure)object).copyTo(null);
        }
        if (object instanceof ListStructure) {
            return ((ListStructure)object).copyTo(null);
        }
        return object;
    }

    static ChangeInfo valueModified(String string, Structure structure, Object object, Object object2) {
        return new ChangeInfo(0, string, structure, object, object2);
    }

    static ChangeInfo valueAdded(String string, Structure structure, Object object) {
        return new ChangeInfo(1, string, structure, null, object);
    }

    static ChangeInfo placeholderValueAdded(String string, Structure structure, Object object) {
        return new ChangeInfo(2, string, structure, null, object);
    }

    static ChangeInfo valueRemoved(String string, Structure structure, Object object) {
        return new ChangeInfo(3, string, structure, object, null);
    }

    public int getChangeType() {
        return this._changeType;
    }

    public int getParentStructureType() {
        return this._parentStructureType;
    }

    public String getPropertyName() {
        return this._propertyName;
    }

    public String getPropertyLocalName() {
        int n = this._propertyName.lastIndexOf(47);
        return this._propertyName.substring(n + 1);
    }

    public boolean isEventForList(String string) {
        if (this._parentStructureType == 0) {
            return this._propertyName.equals(string);
        }
        return this._parentStructureType == 1 && this._propertyName.startsWith(string + "/") && this._propertyName.lastIndexOf(47) == string.length();
    }

    public HashStructure getParentAsHashStructure() {
        return this._parentStructureType == 0 ? (HashStructure)this._valueParent : null;
    }

    public ListStructure getParentAsListStructure() {
        return this._parentStructureType == 1 ? (ListStructure)this._valueParent : null;
    }

    public String getOldValueAsString() {
        return ChangeInfo.toString(this._oldValue);
    }

    public int getOldValueAsInt() {
        return ChangeInfo.toInt(this._oldValue);
    }

    public long getOldValueAsLong() {
        return ChangeInfo.toLong(this._oldValue);
    }

    public float getOldValueAsFloat() {
        return ChangeInfo.toFloat(this._oldValue);
    }

    public double getOldValueAsDouble() {
        return ChangeInfo.toDouble(this._oldValue);
    }

    public URL getOldValueAsURL() {
        return ChangeInfo.toURL(this._oldValue);
    }

    public HashStructure getOldValueAsHashStructure() {
        return ChangeInfo.toHashStructure(this._oldValue);
    }

    public ListStructure getOldValueAsListStructure() {
        return ChangeInfo.toListStructure(this._oldValue);
    }

    public String getNewValueAsString() {
        return ChangeInfo.toString(this._newValue);
    }

    public Object getNewValue() {
        return this._newValue;
    }

    public int getNewValueAsInt() {
        return ChangeInfo.toInt(this._newValue);
    }

    public long getNewValueAsLong() {
        return ChangeInfo.toLong(this._newValue);
    }

    public float getNewValueAsFloat() {
        return ChangeInfo.toFloat(this._newValue);
    }

    public double getNewValueAsDouble() {
        return ChangeInfo.toDouble(this._newValue);
    }

    public URL getNewValueAsURL() {
        return ChangeInfo.toURL(this._newValue);
    }

    public HashStructure getNewValueAsHashStructure() {
        return ChangeInfo.toHashStructure(this._newValue);
    }

    public ListStructure getNewValueAsListStructure() {
        return ChangeInfo.toListStructure(this._newValue);
    }

    public String toString() {
        switch (this._changeType) {
            case 0: {
                return "VALUE_MODIFIED: name='" + this._propertyName + "', old='" + this.getOldValueAsString() + "', new='" + this.getNewValueAsString() + "'";
            }
            case 1: {
                return "VALUE_ADDED: name='" + this._propertyName + "', new='" + this.getNewValueAsString() + "'";
            }
            case 2: {
                return "PLACEHOLDER_VALUE_ADDED: name='" + this._propertyName + "', new='" + this.getNewValueAsString() + "'";
            }
            case 3: {
                return "VALUE_REMOVED: name='" + this._propertyName + "', old='" + this.getOldValueAsString() + "'";
            }
        }
        return super.toString();
    }

    private static String toString(Object object) {
        return object != null ? object.toString() : null;
    }

    private static int toInt(Object object) {
        return object != null ? Integer.parseInt(object.toString()) : 0;
    }

    private static long toLong(Object object) {
        return object != null ? Long.parseLong(object.toString()) : 0L;
    }

    private static float toFloat(Object object) {
        return object != null ? Float.parseFloat(object.toString()) : 0.0f;
    }

    private static double toDouble(Object object) {
        return object != null ? Double.parseDouble(object.toString()) : 0.0;
    }

    private static URL toURL(Object object) {
        return object instanceof URL ? (URL)object : null;
    }

    private static HashStructure toHashStructure(Object object) {
        return object instanceof HashStructure ? (HashStructure)object : null;
    }

    private static ListStructure toListStructure(Object object) {
        return object instanceof ListStructure ? (ListStructure)object : null;
    }
}

