/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.data;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.Dirtyable;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.Structure;

public abstract class HashStructure
extends Structure {
    public static final int NONEXISTENT = 0;
    public static final int PERSISTENT = 1;
    public static final int PLACEHOLDER = 2;

    private HashStructure() {
    }

    public static final HashStructure newInstance() {
        return new Impl(null);
    }

    public static final HashStructure newChainForStatusQuo(HashStructure[] hashStructureArray) {
        return new ChainForStatusQuo(hashStructureArray, null, null);
    }

    public static final HashStructure newChainForOverriding(HashStructure[] hashStructureArray) {
        return new ChainForOverriding(hashStructureArray, null, null);
    }

    public final String getString(String string) {
        Object object = this.getObject(string);
        return object != null ? object.toString() : null;
    }

    public final String getString(String string, String string2) {
        if (this.containsKey(string)) {
            Object object = this.getObject(string);
            return object != null ? object.toString() : null;
        }
        this.putPlaceholder(string, string2);
        return string2;
    }

    public final void putString(String string, String string2) {
        this.putObject(string, string2);
    }

    public final void putString(String string, String string2, boolean bl) {
        this.putObject(string, string2, bl);
    }

    public final boolean getBoolean(String string) {
        Object object = this.getObject(string);
        return object != null ? Boolean.valueOf(object.toString()) : false;
    }

    public final boolean getBoolean(String string, boolean bl) {
        Object object = this.getObject(string);
        if (object != null) {
            return Boolean.valueOf(object.toString());
        }
        this.putPlaceholder(string, Boolean.toString(bl));
        return bl;
    }

    public final void putBoolean(String string, boolean bl) {
        Boolean bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
        this.putString(string, bl2.toString());
    }

    public final int getInt(String string) {
        Object object = this.getObject(string);
        return object != null ? Integer.parseInt(object.toString()) : 0;
    }

    public final int getInt(String string, int n) {
        Object object = this.getObject(string);
        if (object != null) {
            return Integer.parseInt(object.toString());
        }
        this.putPlaceholder(string, Integer.toString(n));
        return n;
    }

    public final void putInt(String string, int n) {
        this.putString(string, Integer.toString(n));
    }

    public final long getLong(String string) {
        Object object = this.getObject(string);
        return object != null ? Long.parseLong(object.toString()) : 0L;
    }

    public final long getLong(String string, long l) {
        Object object = this.getObject(string);
        if (object != null) {
            return Long.parseLong(object.toString());
        }
        this.putPlaceholder(string, Long.toString(l));
        return l;
    }

    public final void putLong(String string, long l) {
        this.putString(string, Long.toString(l));
    }

    public final float getFloat(String string) {
        Object object = this.getObject(string);
        return object != null ? Float.parseFloat(object.toString()) : 0.0f;
    }

    public final float getFloat(String string, float f) {
        Object object = this.getObject(string);
        if (object != null) {
            return Float.parseFloat(object.toString());
        }
        this.putPlaceholder(string, Float.toString(f));
        return f;
    }

    public final void putFloat(String string, float f) {
        this.putString(string, Float.toString(f));
    }

    public final double getDouble(String string) {
        Object object = this.getObject(string);
        return object != null ? Double.parseDouble(object.toString()) : 0.0;
    }

    public final double getDouble(String string, double d) {
        Object object = this.getObject(string);
        if (object != null) {
            return Double.parseDouble(object.toString());
        }
        this.putPlaceholder(string, Double.toString(d));
        return d;
    }

    public final void putDouble(String string, double d) {
        this.putString(string, Double.toString(d));
    }

    public final URL getURL(String string) {
        return (URL)this.getObject(string);
    }

    public final URL getURL(String string, URL uRL) {
        if (this.containsKey(string)) {
            return (URL)this.getObject(string);
        }
        this.putPlaceholder(string, uRL);
        return uRL;
    }

    public final void putPlaceholderURL(String string, URL uRL) {
        this.putPlaceholder(string, uRL);
    }

    public final void putURL(String string, URL uRL) {
        this.putObject(string, uRL);
    }

    public final void putURL(String string, URL uRL, boolean bl) {
        this.putObject(string, uRL, bl);
    }

    public abstract Object getObject(String var1);

    public abstract Set keySet();

    public final void applyChange(ChangeInfo changeInfo) {
        if (changeInfo != null) {
            String string = changeInfo.getPropertyName();
            Structure structure = this;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/", true);
            boolean bl = false;
            String string2 = null;
            while (stringTokenizer.hasMoreTokens()) {
                if (structure == null) break;
                string2 = stringTokenizer.nextToken();
                if (!stringTokenizer.hasMoreTokens()) continue;
                if ("/".equals(string2)) {
                    if (bl) {
                        bl = false;
                        continue;
                    }
                    structure = this.descendStruct(structure, "");
                    continue;
                }
                structure = this.descendStruct(structure, string2);
                bl = true;
            }
            if (structure instanceof HashStructure) {
                HashStructure hashStructure = structure;
                switch (changeInfo.getChangeType()) {
                    case 0: 
                    case 1: {
                        hashStructure.putObject(string2, changeInfo.getNewValue());
                        break;
                    }
                    case 2: {
                        Object object = changeInfo.getNewValue();
                        if (object instanceof Structure) {
                            hashStructure.putStructure(string2, (Structure)object, "structure", true);
                            break;
                        }
                        hashStructure.putPlaceholder(string2, object);
                        break;
                    }
                    case 3: {
                        hashStructure.remove(string2);
                    }
                }
            } else if (structure instanceof ListStructure) {
                ListStructure listStructure = (ListStructure)structure;
                try {
                    int n = Integer.parseInt(string2);
                    switch (changeInfo.getChangeType()) {
                        case 0: {
                            listStructure.set(n, changeInfo.getNewValue());
                            break;
                        }
                        case 1: {
                            listStructure.add(n, changeInfo.getNewValue());
                            break;
                        }
                        case 2: {
                            listStructure.addPlaceholder(changeInfo.getNewValue());
                            break;
                        }
                        case 3: {
                            listStructure.remove(n);
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    public final void applyChanges(ChangeInfo[] changeInfoArray) {
        if (changeInfoArray != null) {
            int n = changeInfoArray.length;
            Pattern pattern = Pattern.compile("/\\d+(/|$)");
            HashSet<String> hashSet = new HashSet<String>();
            int n2 = n - 1;
            while (n2 >= 0) {
                ChangeInfo changeInfo = changeInfoArray[n2];
                String string = changeInfo.getPropertyName();
                Matcher matcher = pattern.matcher(string);
                if (!matcher.find()) {
                    if (hashSet.contains(string)) {
                        changeInfoArray[n2] = null;
                    } else {
                        hashSet.add(string);
                    }
                }
                --n2;
            }
            int n3 = 0;
            while (n3 < changeInfoArray.length) {
                this.applyChange(changeInfoArray[n3]);
                ++n3;
            }
        }
    }

    private Structure descendStruct(Structure structure, String string) {
        if (structure instanceof HashStructure) {
            HashStructure hashStructure = (HashStructure)structure;
            Object object = hashStructure.getObject(string);
            if (object != null) {
                return object instanceof Structure ? (Structure)object : null;
            }
        } else if (structure instanceof ListStructure) {
            ListStructure listStructure = (ListStructure)structure;
            try {
                int n = Integer.parseInt(string);
                Object object = listStructure.get(n);
                if (object != null) {
                    Structure structure2 = object instanceof Structure ? (Structure)object : null;
                    return structure2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public abstract Set persistentKeySet();

    public abstract int keyStatus(String var1);

    abstract HashStructure unchain();

    public final HashStructure getHashStructure(String string) {
        return (HashStructure)this.getObject(string);
    }

    public final HashStructure getOrCreateHashStructure(String string) {
        HashStructure hashStructure = this.getHashStructure(string);
        if (hashStructure == null) {
            hashStructure = HashStructure.newInstance();
            this.putStructure(string, hashStructure, "hash", true);
        }
        return hashStructure;
    }

    public final void putHashStructure(String string, HashStructure hashStructure) {
        this.putStructure(string, hashStructure, "hash", false);
    }

    public final void putPlaceholderHashStructure(String string, HashStructure hashStructure) {
        this.putStructure(string, hashStructure, "hash", true);
    }

    public final List getAsList(String string) {
        if (this.containsKey(string)) {
            Object object = this.getObject(string);
            if (object instanceof ListStructure) {
                return Collections.unmodifiableList((ListStructure)object);
            }
            return Collections.singletonList(object);
        }
        return null;
    }

    public final ListStructure getListStructure(String string) {
        return (ListStructure)this.getObject(string);
    }

    public final ListStructure getOrCreateListStructure(String string) {
        ListStructure listStructure = this.getListStructure(string);
        if (listStructure == null) {
            listStructure = ListStructure.newInstance();
            this.putStructure(string, listStructure, "list", true);
        }
        return listStructure;
    }

    public final void putListStructure(String string, ListStructure listStructure) {
        this.putStructure(string, listStructure, "list", false);
    }

    public final void putPlaceholderListStructure(String string, ListStructure listStructure) {
        this.putStructure(string, listStructure, "list", true);
    }

    public abstract void clear();

    public abstract boolean containsKey(String var1);

    public abstract void remove(String var1);

    public abstract int size();

    public abstract void setParentDirtyable(Dirtyable var1);

    public boolean isAnyValueOverridden(String[] stringArray) {
        return false;
    }

    public abstract void hideValues(String[] var1);

    public abstract void recoverValues(String[] var1);

    public HashStructure copyTo(HashStructure hashStructure, String[] stringArray) {
        HashStructure hashStructure2 = HashStructure.notNullOrCreate(hashStructure);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (this.containsKey(string)) {
                HashStructure.copyItem(this, hashStructure2, string);
            } else {
                hashStructure2.remove(string);
            }
            ++n2;
        }
        return hashStructure2;
    }

    public HashStructure copyTo(HashStructure hashStructure) {
        HashStructure hashStructure2 = HashStructure.notNullOrCreate(hashStructure);
        HashStructure.deepCopy(this, hashStructure2);
        return hashStructure2;
    }

    private static void deepCopy(HashStructure hashStructure, HashStructure hashStructure2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = hashStructure2.keySet().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            if (hashStructure.containsKey(string)) continue;
            arrayList.add(string);
        }
        Iterator iterator2 = arrayList.iterator();
        while (iterator2.hasNext()) {
            hashStructure2.remove(iterator2.next().toString());
        }
        for (Object e : hashStructure.keySet()) {
            String string = e.toString();
            HashStructure.copyItem(hashStructure, hashStructure2, string);
        }
    }

    private static void copyItem(HashStructure hashStructure, HashStructure hashStructure2, String string) {
        Object object = hashStructure.getObject(string);
        if (object instanceof HashStructure) {
            HashStructure hashStructure3;
            Object object2 = hashStructure2.getObject(string);
            if (object2 instanceof HashStructure) {
                hashStructure3 = (HashStructure)object2;
            } else {
                hashStructure3 = HashStructure.newInstance();
                hashStructure2.putHashStructure(string, hashStructure3);
            }
            HashStructure hashStructure4 = (HashStructure)object;
            hashStructure4.copyTo(hashStructure3);
        } else if (object instanceof ListStructure) {
            Object object3 = hashStructure2.getObject(string);
            ListStructure listStructure = (ListStructure)object;
            if (object3 instanceof ListStructure) {
                ListStructure listStructure2 = (ListStructure)object3;
                ListStructure.deepCopy(listStructure, listStructure2);
            } else {
                ListStructure listStructure3 = ListStructure.newInstance();
                ListStructure.deepCopy(listStructure, listStructure3);
                listStructure3.markDirty(false);
                hashStructure2.putListStructure(string, listStructure3);
            }
        } else {
            hashStructure2.putObject(string, object);
        }
    }

    abstract void putObject(String var1, Object var2);

    private void putObject(String string, Object object, boolean bl) {
        if (bl && object == null) {
            this.remove(string);
        } else {
            this.putObject(string, object);
        }
    }

    private static HashStructure notNullOrCreate(HashStructure hashStructure) {
        return hashStructure != null ? hashStructure : HashStructure.newInstance();
    }

    abstract void putPlaceholder(String var1, Object var2);

    abstract void putStructure(String var1, Structure var2, String var3, boolean var4);

    static HashStructure maS$notNullOrCreate(HashStructure hashStructure) {
        return HashStructure.notNullOrCreate(hashStructure);
    }

    HashStructure(1 var1_1) {
        this();
    }

    public static final class Impl
    extends HashStructure {
        final HashSet _placeholderKeys;
        private final HashMap _data;
        private Dirtyable _parentDirtyable;
        private static final int NO_CREATE = 0;
        private static final int CREATE_PLACEHOLDER = 1;
        private static final int CREATE_PERSISTENT = 2;

        void $init$() {
            this._placeholderKeys = new HashSet();
            this._data = new HashMap();
        }

        private Impl() {
            super(null);
            this.$init$();
        }

        public HashStructure copyTo(HashStructure hashStructure, String[] stringArray) {
            HashStructure hashStructure2 = HashStructure.maS$notNullOrCreate(hashStructure);
            if (stringArray != null && hashStructure2.getClass() == Impl.class) {
                Impl impl = (Impl)hashStructure2;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Impl impl2;
                    String string = stringArray[n2];
                    Impl impl3 = this.getKeyStruct(string, 0);
                    if (impl3 != null && (impl2 = impl.getKeyStruct(string, 0)) != null) {
                        String string2 = this.getLeafName(string);
                        if (impl3._placeholderKeys.contains(string2)) {
                            impl2._placeholderKeys.add(string2);
                        } else {
                            impl2._placeholderKeys.remove(string2);
                        }
                    }
                    ++n2;
                }
            }
            return super.copyTo(hashStructure2, stringArray);
        }

        public HashStructure copyTo(HashStructure hashStructure) {
            HashStructure hashStructure2 = HashStructure.maS$notNullOrCreate(hashStructure);
            if (hashStructure2.getClass() == Impl.class) {
                Impl impl = (Impl)hashStructure2;
                impl._placeholderKeys.clear();
                impl._placeholderKeys.addAll(this._placeholderKeys);
            }
            return super.copyTo(hashStructure2);
        }

        public Object getObject(String string) {
            Impl impl = this.getKeyStruct(string, 0);
            return impl != null ? impl._data.get(this.getLeafName(string)) : null;
        }

        public Set keySet() {
            return Collections.unmodifiableSet(this._data.keySet());
        }

        public Set persistentKeySet() {
            HashSet hashSet = new HashSet();
            for (Object k : this._data.keySet()) {
                if (this._placeholderKeys.contains(k)) continue;
                hashSet.add(k);
            }
            return hashSet;
        }

        public int keyStatus(String string) {
            Impl impl = this.getKeyStruct(string, 0);
            if (impl != null) {
                String string2 = this.getLeafName(string);
                if (impl._data.keySet().contains(string2)) {
                    if (impl._placeholderKeys.contains(string2)) {
                        return 2;
                    }
                    return 1;
                }
                return 0;
            }
            return 0;
        }

        HashStructure unchain() {
            return this;
        }

        public void clear() {
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(this._data.keySet());
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Impl.removeValueFromKeyStruct(this, (String)iterator.next());
            }
        }

        public boolean containsKey(String string) {
            Impl impl = this.getKeyStruct(string, 0);
            return impl != null ? impl._data.containsKey(this.getLeafName(string)) : false;
        }

        public void remove(String string) {
            Impl impl = this.getKeyStruct(string, 0);
            Impl.removeValueFromKeyStruct(impl, this.getLeafName(string));
        }

        private static void removeValueFromKeyStruct(Impl impl, String string) {
            if (impl != null && impl._data.containsKey(string)) {
                Object v = impl._data.remove(string);
                if (v instanceof Structure) {
                    ((Structure)v).setParent(null);
                }
                if (impl._placeholderKeys.contains(string)) {
                    impl._placeholderKeys.remove(string);
                } else {
                    impl.markDirty(true);
                }
                impl.fireValueRemoved(string, impl, v);
            }
        }

        public int size() {
            return this._data.size();
        }

        Dirtyable getParentDirtyable() {
            return this._parentDirtyable != null ? this._parentDirtyable : super.getParentDirtyable();
        }

        public void setParentDirtyable(Dirtyable dirtyable) {
            this._parentDirtyable = dirtyable;
        }

        public void hideValues(String[] stringArray) {
            if (stringArray != null) {
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    Impl impl = this.getKeyStruct(string, 0);
                    if (impl != null) {
                        String string2 = this.getLeafName(string);
                        String string3 = "hidden:" + string2;
                        if (impl.containsKey(string2)) {
                            Object object = impl.getObject(string2);
                            impl.remove(string2);
                            impl.putObject(string3, object);
                        }
                    }
                    ++n2;
                }
            }
        }

        public void recoverValues(String[] stringArray) {
            if (stringArray != null) {
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    Impl impl = this.getKeyStruct(string, 0);
                    if (impl != null) {
                        String string2 = this.getLeafName(string);
                        String string3 = "hidden:" + string2;
                        if (impl.containsKey(string3)) {
                            Object object = impl.getObject(string3);
                            impl.remove(string3);
                            impl.putObject(string2, object);
                        }
                    }
                    ++n2;
                }
            }
        }

        void removeChild(Structure structure) {
            for (Object k : this._data.keySet()) {
                Object v = this._data.get(k);
                if (v != structure) continue;
                Impl.removeValueFromKeyStruct(this, (String)k);
                break;
            }
        }

        public boolean equals(Object object) {
            if (object == null || object.getClass() != this.getClass()) {
                return false;
            }
            return this.equalsImpl((Impl)object);
        }

        private boolean equalsImpl(Impl impl) {
            Set set;
            Set set2 = this.persistentKeySet();
            if (!set2.equals(set = impl.persistentKeySet())) {
                return false;
            }
            for (Object e : set2) {
                Object v;
                Object v2 = this._data.get(e);
                if (!Impl.areDifferent(v2, v = impl._data.get(e))) continue;
                return false;
            }
            HashSet hashSet = new HashSet();
            hashSet.addAll(this._placeholderKeys);
            hashSet.addAll(impl._placeholderKeys);
            for (Object e : hashSet) {
                Object v;
                Object v3;
                if (!this._data.containsKey(e) || !impl._data.containsKey(e) || !Impl.areDifferent(v3 = this._data.get(e), v = impl._data.get(e))) continue;
                return false;
            }
            return true;
        }

        void putObject(String string, Object object) {
            Impl.checkNotNull(string, "name");
            this.putObject0(string, object, false);
        }

        void putPlaceholder(String string, Object object) {
            Impl.checkNotNull(string, "name");
            this.putObject0(string, object, true);
        }

        void putStructure(String string, Structure structure, String string2, boolean bl) {
            Impl.checkNotNull(string, "name");
            Impl.checkNotNull(structure, string2);
            this.putObject0(string, structure, bl);
        }

        private final Impl getKeyStruct(String string, boolean bl) {
            return this.getKeyStruct(string, bl ? 1 : 2);
        }

        private final Impl getKeyStruct(String string, int n) {
            Impl.checkNotNull(string, "name");
            HashStructure hashStructure = this;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/", true);
            boolean bl = false;
            String string2 = null;
            while (stringTokenizer.hasMoreTokens()) {
                if (hashStructure == null) break;
                string2 = stringTokenizer.nextToken();
                if (!stringTokenizer.hasMoreTokens()) continue;
                if ("/".equals(string2)) {
                    if (bl) {
                        bl = false;
                        continue;
                    }
                    hashStructure = Impl.descend(hashStructure, "", n);
                    continue;
                }
                hashStructure = Impl.descend(hashStructure, string2, n);
                bl = true;
            }
            return hashStructure;
        }

        private static HashStructure descend(HashStructure hashStructure, String string, int n) {
            HashStructure hashStructure2;
            switch (n) {
                case 0: {
                    hashStructure2 = hashStructure.getHashStructure(string);
                    break;
                }
                case 1: {
                    hashStructure2 = hashStructure.getOrCreateHashStructure(string);
                    break;
                }
                case 2: {
                    HashStructure hashStructure3 = hashStructure.getHashStructure(string);
                    if (hashStructure3 == null) {
                        hashStructure3 = HashStructure.newInstance();
                        hashStructure.putHashStructure(string, hashStructure3);
                    }
                    hashStructure2 = hashStructure3;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected mode in descend(..).");
                }
            }
            return hashStructure2;
        }

        private String getLeafName(String string) {
            return string.substring(string.lastIndexOf(47) + 1);
        }

        private void putObject0(String string, Object object, boolean bl) {
            Impl impl = this.getKeyStruct(string, bl);
            String string2 = this.getLeafName(string);
            if (object instanceof Structure) {
                impl.checkAndSetParent((Structure)object, string2);
            }
            Impl.putValueInKeyStruct(impl, string2, object, bl);
        }

        private static void putValueInKeyStruct(Impl impl, String string, Object object, boolean bl) {
            Object v = impl._data.get(string);
            boolean bl2 = impl._data.containsKey(string);
            if (Impl.areEqual(v, object) && (object != null || bl2)) {
                return;
            }
            impl._data.put(string, object);
            if (bl2) {
                impl.clearPlaceholderFlag(string);
                impl.markDirty(true);
                impl.fireValueModified(string, impl, v, object);
            } else if (bl) {
                impl._placeholderKeys.add(string);
                impl.firePlaceholderValueAdded(string, impl, object);
            } else if (impl._placeholderKeys.contains(string)) {
                impl.firePlaceholderValueAdded(string, impl, object);
            } else {
                impl.clearPlaceholderFlag(string);
                impl.markDirty(true);
                impl.fireValueAdded(string, impl, object);
            }
        }

        final void clearPlaceholderFlag(String string) {
            this._placeholderKeys.remove(string);
        }

        private static void checkNotNull(Object object, String string) {
            if (object == null) {
                throw new IllegalArgumentException("The '" + string + "' parameter must not be null.");
            }
        }

        Impl(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static abstract class BaseChain
    extends HashStructure {
        final HashStructure[] _hashes;
        private final String _prefix;

        private BaseChain(HashStructure[] hashStructureArray, String string) {
            super(null);
            if (hashStructureArray == null) {
                throw new IllegalArgumentException("hashes cannot be null");
            }
            int n = hashStructureArray.length;
            ArrayList<HashStructure> arrayList = new ArrayList<HashStructure>();
            int n2 = 0;
            while (n2 < n) {
                HashStructure hashStructure = hashStructureArray[n2];
                if (hashStructure != null) {
                    arrayList.add(hashStructure);
                }
                ++n2;
            }
            int n3 = arrayList.size();
            if (n3 < 1) {
                throw new IllegalArgumentException("hashes must contain at least one non-null element");
            }
            this._hashes = arrayList.toArray(new HashStructure[n3]);
            this._prefix = string == null ? "" : (string.endsWith("/") ? string : string + "/");
        }

        public String getStructName() {
            if ("".equals(this._prefix)) {
                return null;
            }
            int n = this._prefix.length() - 1;
            int n2 = this._prefix.lastIndexOf("/", n - 1);
            return this._prefix.substring(n2 + 1, n);
        }

        public String getFullName() {
            if ("".equals(this._prefix)) {
                return null;
            }
            int n = this._prefix.length() - 1;
            return this._prefix.substring(0, n);
        }

        public void applyBatchChanges(Runnable runnable) {
            this.applyBatchChangesImpl(0, runnable);
        }

        private void applyBatchChangesImpl(int n, Runnable runnable) {
            while (n < this._hashes.length) {
                HashStructure hashStructure;
                if ((hashStructure = this._hashes[n++]) == null) continue;
                int n2 = n;
                hashStructure.applyBatchChanges(new 1(this, n2, runnable));
                return;
            }
            super.applyBatchChanges(runnable);
        }

        void removeChild(Structure structure) {
            int n = this._hashes.length;
            int n2 = 0;
            while (n2 < n) {
                this._hashes[n2].removeChild(structure);
                ++n2;
            }
        }

        abstract HashStructure getChainedHashStructure(String var1);

        abstract ListStructure getChainedListStructure(ListStructure var1, String var2);

        public final Object getObject(String string) {
            String string2 = this.getFullName(string);
            int n = this._hashes.length;
            int n2 = 0;
            while (n2 < n) {
                HashStructure hashStructure = this._hashes[n2];
                if (hashStructure.containsKey(string2)) {
                    Object object = hashStructure.getObject(string2);
                    if (object instanceof HashStructure) {
                        return this.getChainedHashStructure(string2);
                    }
                    if (object instanceof ListStructure) {
                        return this.getChainedListStructure((ListStructure)object, string2);
                    }
                    return object;
                }
                ++n2;
            }
            return null;
        }

        public Set keySet() {
            HashSet hashSet = new HashSet();
            int n = this._hashes.length;
            int n2 = 0;
            while (n2 < n) {
                HashStructure hashStructure = this.getSubHashStructureAtPrefix(this._hashes[n2]);
                if (hashStructure != null) {
                    hashSet.addAll(hashStructure.keySet());
                }
                ++n2;
            }
            return hashSet;
        }

        public Set persistentKeySet() {
            HashSet hashSet = new HashSet();
            int n = this._hashes.length;
            int n2 = 0;
            while (n2 < n) {
                HashStructure hashStructure = this.getSubHashStructureAtPrefix(this._hashes[n2]);
                if (hashStructure != null) {
                    hashSet.addAll(hashStructure.persistentKeySet());
                }
                ++n2;
            }
            return hashSet;
        }

        public int keyStatus(String string) {
            HashSet hashSet = new HashSet();
            int n = this._hashes.length;
            int n2 = 0;
            while (n2 < n) {
                int n3;
                HashStructure hashStructure = this.getSubHashStructureAtPrefix(this._hashes[n2]);
                if (hashStructure != null && (n3 = hashStructure.keyStatus(string)) != 0) {
                    return n3;
                }
                ++n2;
            }
            return 0;
        }

        HashStructure unchain() {
            String string = this.getFullName();
            if (string != null) {
                int n = this._hashes.length;
                int n2 = 0;
                while (n2 < n) {
                    HashStructure hashStructure = this._hashes[n2];
                    if (hashStructure.containsKey(string)) {
                        HashStructure hashStructure2 = hashStructure.getHashStructure(string);
                        if (hashStructure2 != null) {
                            hashStructure2 = hashStructure2.unchain();
                        }
                        return hashStructure2;
                    }
                    ++n2;
                }
            } else {
                return this._hashes[0].unchain();
            }
            throw new IllegalStateException("Unable to unchain HashStructure.");
        }

        HashStructure getSubHashStructureAtPrefix(HashStructure hashStructure) {
            if ("".equals(this._prefix)) {
                return hashStructure;
            }
            String string = this._prefix.endsWith("/") ? this._prefix.substring(0, this._prefix.length() - 1) : this._prefix;
            try {
                HashStructure hashStructure2 = hashStructure.getHashStructure(string);
                return hashStructure2;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                HashStructure hashStructure3 = null;
                return hashStructure3;
            }
        }

        public boolean containsKey(String string) {
            String string2 = this.getFullName(string);
            int n = this._hashes.length;
            int n2 = 0;
            while (n2 < n) {
                HashStructure hashStructure = this._hashes[n2];
                if (hashStructure.containsKey(string2)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public int size() {
            return this.keySet().size();
        }

        public void setParentDirtyable(Dirtyable dirtyable) {
            throw new IllegalStateException("A chained HashStructure cannot be put into another HashStructure");
        }

        public final boolean isAnyValueOverridden(String[] stringArray) {
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = this.getFullName(stringArray[n2]);
                int n3 = this._hashes.length - 1;
                int n4 = 0;
                while (n4 < n3) {
                    HashStructure hashStructure = this._hashes[n4];
                    if (hashStructure.containsKey(string)) {
                        return true;
                    }
                    ++n4;
                }
                ++n2;
            }
            return false;
        }

        public void hideValues(String[] stringArray) {
            if (stringArray != null) {
                HashStructure hashStructure = this._hashes[0];
                String[] stringArray2 = this.toFullNames(stringArray);
                hashStructure.hideValues(stringArray2);
            }
        }

        public void recoverValues(String[] stringArray) {
            if (stringArray != null) {
                HashStructure hashStructure = this._hashes[0];
                String[] stringArray2 = this.toFullNames(stringArray);
                hashStructure.recoverValues(stringArray2);
            }
        }

        private String[] toFullNames(String[] stringArray) {
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (string != null) {
                    arrayList.add(this.getFullName(string));
                }
                ++n2;
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }

        void setParent(Structure structure) {
            throw new IllegalStateException("A chained HashStructure cannot have a parent.");
        }

        String getFullName(String string) {
            return this._prefix + string;
        }

        static void mav$applyBatchChangesImpl(BaseChain baseChain, int n, Runnable runnable) {
            baseChain.applyBatchChangesImpl(n, runnable);
        }

        BaseChain(HashStructure[] hashStructureArray, String string, 1 var3_3) {
            this(hashStructureArray, string);
        }

        public final class 1
        implements Runnable {
            private final /* synthetic */ int v$nextIndex;
            private final /* synthetic */ Runnable v$runnable;
            final /* synthetic */ BaseChain this$0;

            public void run() {
                BaseChain.mav$applyBatchChangesImpl(this.this$0, this.v$nextIndex, this.v$runnable);
            }

            public 1(BaseChain baseChain, int n, Runnable runnable) {
                this.v$runnable = runnable;
                this.v$nextIndex = n;
                this.this$0 = baseChain;
            }
        }
    }

    private static final class ChainForStatusQuo
    extends BaseChain {
        private ChainForStatusQuo(HashStructure[] hashStructureArray, String string) {
            super(hashStructureArray, string, null);
        }

        final HashStructure getChainedHashStructure(String string) {
            return new ChainForStatusQuo(this._hashes, string);
        }

        final ListStructure getChainedListStructure(ListStructure listStructure, String string) {
            return listStructure;
        }

        public void clear() {
            int n = this._hashes.length;
            int n2 = 0;
            while (n2 < n) {
                HashStructure hashStructure = this._hashes[n2];
                HashStructure hashStructure2 = this.getSubHashStructureAtPrefix(hashStructure);
                if (hashStructure2 != null) {
                    hashStructure2.clear();
                    break;
                }
                ++n2;
            }
        }

        public void remove(String string) {
            String string2 = this.getFullName(string);
            int n = this._hashes.length;
            int n2 = 0;
            while (n2 < n) {
                HashStructure hashStructure = this._hashes[n2];
                if (hashStructure.containsKey(string2)) {
                    hashStructure.remove(string2);
                    break;
                }
                ++n2;
            }
        }

        void putObject(String string, Object object) {
            String string2 = this.getFullName(string);
            HashStructure hashStructure = this.findHashStructureWithKey(string2);
            if (hashStructure != null) {
                hashStructure.putObject(string2, object);
            }
        }

        void putPlaceholder(String string, Object object) {
            String string2 = this.getFullName(string);
            HashStructure hashStructure = this.findHashStructureWithKey(string2);
            if (hashStructure != null) {
                hashStructure.putPlaceholder(string2, object);
            }
        }

        void putStructure(String string, Structure structure, String string2, boolean bl) {
            String string3 = this.getFullName(string);
            HashStructure hashStructure = this.findHashStructureWithKey(string3);
            if (hashStructure != null) {
                hashStructure.putStructure(string3, structure, string2, bl);
            }
        }

        private HashStructure findHashStructureWithKey(String string) {
            HashStructure hashStructure = null;
            int n = this._hashes.length;
            int n2 = 0;
            while (n2 < n) {
                hashStructure = this._hashes[n2];
                if (hashStructure.containsKey(string)) {
                    return hashStructure;
                }
                ++n2;
            }
            return hashStructure;
        }

        ChainForStatusQuo(HashStructure[] hashStructureArray, String string, 1 var3_3) {
            this(hashStructureArray, string);
        }

        public final class 1 {
        }
    }

    private static final class ChainForOverriding
    extends BaseChain {
        private final HashStructure _firstHash;

        private ChainForOverriding(HashStructure[] hashStructureArray, String string) {
            super(hashStructureArray, string, null);
            this._firstHash = this._hashes[0];
        }

        final HashStructure getChainedHashStructure(String string) {
            return new ChainForOverriding(this._hashes, string);
        }

        final ListStructure getChainedListStructure(ListStructure listStructure, String string) {
            HashStructure hashStructure = this.getSubHashStructureAtPrefix(this._firstHash);
            return ListStructure.newChainForOverriding(listStructure, this._firstHash, string);
        }

        public void clear() {
            HashStructure hashStructure = this.getSubHashStructureAtPrefix(this._firstHash);
            if (hashStructure != null) {
                hashStructure.clear();
            }
        }

        public void remove(String string) {
            String string2 = this.getFullName(string);
            this._firstHash.remove(string2);
        }

        void putObject(String string, Object object) {
            String string2 = this.getFullName(string);
            this._firstHash.putObject(string2, object);
        }

        void putPlaceholder(String string, Object object) {
            String string2 = this.getFullName(string);
            this._firstHash.putPlaceholder(string2, object);
        }

        void putStructure(String string, Structure structure, String string2, boolean bl) {
            String string3 = this.getFullName(string);
            this._firstHash.putStructure(string3, structure, string2, bl);
        }

        ChainForOverriding(HashStructure[] hashStructureArray, String string, 1 var3_3) {
            this(hashStructureArray, string);
        }

        public final class 1 {
        }
    }

    public final class 1 {
    }
}

