/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.data;

import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;

public class HashStructureAdapter {
    protected final HashStructure _hash;

    protected HashStructureAdapter(HashStructure hashStructure) {
        if (hashStructure == null) {
            throw new IllegalArgumentException();
        }
        this._hash = hashStructure;
    }

    protected static HashStructure findOrCreate(PropertyStorage propertyStorage, String string) {
        return propertyStorage != null ? propertyStorage.getProperties().getOrCreateHashStructure(string) : HashStructure.newInstance();
    }

    public Object copyTo(Object object) {
        if (!this.isSameTypeAs(object)) {
            throw new IllegalArgumentException("Attempt to copy from an object of type " + this.getClass().getName() + " to an object of type " + (object != null ? object.getClass().getName() : "<null>"));
        }
        this.copyToImpl((HashStructureAdapter)object);
        return object;
    }

    protected final void copyToImpl(HashStructureAdapter hashStructureAdapter) {
        this._hash.copyTo(hashStructureAdapter._hash);
    }

    public boolean containsKey(String string) {
        return this._hash.containsKey(string);
    }

    public boolean equals(Object object) {
        return this.isSameTypeAs(object) ? this.equalsImpl((HashStructureAdapter)object) : false;
    }

    protected final boolean equalsImpl(HashStructureAdapter hashStructureAdapter) {
        return this._hash.equals(hashStructureAdapter._hash);
    }

    private boolean isSameTypeAs(Object object) {
        return object != null && object.getClass() == this.getClass();
    }
}

