/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.data;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.Structure;

public class ListStructure
extends Structure
implements List {
    private final ArrayList _list;

    void $init$() {
        this._list = new ArrayList();
    }

    private ListStructure() {
        this.$init$();
    }

    public static final ListStructure newInstance() {
        return new ListStructure();
    }

    static final ListStructure newChainForOverriding(ListStructure listStructure, HashStructure hashStructure, String string) {
        return new ChainForOverriding(listStructure, hashStructure, string);
    }

    public void add(int n, Object object) {
        this.checkObjectForAdd(object);
        this._list.add(n, object);
        this.markDirty(true);
        this.fireValueAdded(Integer.toString(n), this, object);
    }

    public boolean add(Object object) {
        this.checkObjectForAdd(object);
        this._list.add(object);
        this.markDirty(true);
        this.fireValueAdded(Integer.toString(this._list.size() - 1), this, object);
        return true;
    }

    public boolean addPlaceholder(Object object) {
        this.checkObjectForAdd(object);
        this._list.add(object);
        this.firePlaceholderValueAdded(Integer.toString(this._list.size() - 1), this, object);
        return true;
    }

    public boolean addAll(int n, Collection arrayList) {
        boolean[] blArray = new boolean[]{false};
        if (arrayList != null) {
            if (arrayList instanceof ListStructure) {
                ArrayList arrayList2 = new ArrayList();
                arrayList2.addAll(arrayList);
                arrayList = arrayList2;
            }
            Iterator iterator = arrayList.iterator();
            Iterator iterator2 = arrayList.iterator();
            while (iterator.hasNext()) {
                this.checkObjectForAdd(iterator.next(), false);
            }
            this.applyBatchChanges(new 7(this, n, iterator2, blArray));
        }
        return blArray[0];
    }

    public boolean addAll(Collection collection) {
        return this.addAll(this.size(), collection);
    }

    public void clear() {
        int n = this.size();
        if (n > 0) {
            this.applyBatchChanges(new 6(this, n));
        }
    }

    public boolean contains(Object object) {
        return this._list.contains(object);
    }

    public boolean containsAll(Collection collection) {
        return this._list.containsAll(collection);
    }

    public Object get(int n) {
        return this._list.get(n);
    }

    public int indexOf(Object object) {
        if (object instanceof Structure) {
            int n = this.size();
            int n2 = 0;
            while (n2 < n) {
                Object object2 = this.get(n2);
                if (object2 == object) {
                    return n2;
                }
                ++n2;
            }
            return -1;
        }
        return this._list.indexOf(object);
    }

    public boolean isEmpty() {
        return this._list.isEmpty();
    }

    public Iterator iterator() {
        return new 5();
    }

    public int lastIndexOf(Object object) {
        if (object instanceof Structure) {
            int n = this.size();
            int n2 = n - 1;
            while (n2 >= 0) {
                Object object2 = this.get(n2);
                if (object2 == object) {
                    return n2;
                }
                --n2;
            }
            return -1;
        }
        return this._list.lastIndexOf(object);
    }

    public ListIterator listIterator() {
        throw new UnsupportedOperationException();
    }

    public ListIterator listIterator(int n) {
        throw new UnsupportedOperationException();
    }

    public Object remove(int n) {
        Object e = this._list.remove(n);
        this.dirtyAndMaybeDetach(e);
        this.fireValueRemoved(Integer.toString(n), this, e);
        return e;
    }

    public boolean remove(Object object) {
        int n = this.indexOf(object);
        if (n >= 0) {
            this.remove(n);
            return true;
        }
        return false;
    }

    public boolean removeAll(Collection collection) {
        boolean[] blArray = new boolean[]{false};
        if (collection != null) {
            Iterator iterator = collection.iterator();
            this.applyBatchChanges(new 4(this, iterator, blArray));
        }
        return blArray[0];
    }

    public boolean retainAll(Collection collection) {
        boolean[] blArray = new boolean[]{false};
        if (collection != null) {
            Iterator iterator = this.iterator();
            this.applyBatchChanges(new 3(this, iterator, collection, blArray));
        }
        return blArray[0];
    }

    public Object set(int n, Object object) {
        this.checkObjectForAdd(object);
        Object object2 = this._list.set(n, object);
        this.dirtyAndMaybeDetach(object2);
        this.fireValueModified(Integer.toString(n), this, object2, object);
        return object2;
    }

    public List subList(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    public int size() {
        return this._list.size();
    }

    public Object[] toArray() {
        return this._list.toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this._list.toArray(objectArray);
    }

    public boolean mirror(List list) {
        if (this != list) {
            boolean bl;
            int n = this.size();
            boolean bl2 = bl = list == null && n == 0 || list != null && n == list.size();
            if (bl) {
                Iterator iterator = this.iterator();
                Iterator iterator2 = list.iterator();
                while (iterator.hasNext()) {
                    if (!ListStructure.areDifferent(iterator.next(), iterator2.next())) continue;
                    bl = false;
                    break;
                }
            }
            if (!bl) {
                this.applyBatchChanges(new 2(this, list));
                return true;
            }
        }
        return false;
    }

    String getNameOfChild(Structure structure) {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            if (structure == this.get(n2)) {
                return Integer.toString(n2);
            }
            ++n2;
        }
        return null;
    }

    void removeChild(Structure structure) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != structure) continue;
            iterator.remove();
            break;
        }
    }

    public ListStructure copyTo(ListStructure listStructure) {
        ListStructure listStructure2 = listStructure != null ? listStructure : ListStructure.newInstance();
        listStructure2.applyBatchChanges(new 1(this, listStructure2));
        return listStructure2;
    }

    static void deepCopy(ListStructure listStructure, ListStructure listStructure2) {
        if (!listStructure.equalsImpl(listStructure2)) {
            listStructure2.clear();
            for (Object e : listStructure) {
                if (e instanceof HashStructure) {
                    HashStructure hashStructure = (HashStructure)e;
                    listStructure2.add(hashStructure.copyTo(null));
                    continue;
                }
                if (e instanceof ListStructure) {
                    ListStructure listStructure3 = (ListStructure)e;
                    listStructure2.add(listStructure3.copyTo(null));
                    continue;
                }
                listStructure2.add(e);
            }
        }
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((ListStructure)object);
    }

    protected boolean equalsImpl(ListStructure listStructure) {
        return this._list.equals(listStructure._list);
    }

    public int hashCode() {
        return this._list.hashCode();
    }

    private void dirtyAndMaybeDetach(Object object) {
        this.markDirty(true);
        this.maybeDetach(object);
    }

    private void maybeDetach(Object object) {
        if (object instanceof Structure) {
            ((Structure)object).setParent(null);
        }
    }

    private void checkObjectForAdd(Object object) {
        this.checkObjectForAdd(object, true);
    }

    private void checkObjectForAdd(Object object, boolean bl) {
        if (object != null) {
            Class<?> clazz = object.getClass();
            if (clazz == HashStructure.Impl.class || clazz == ListStructure.class) {
                if (bl) {
                    this.checkAndSetParent((Structure)object, null);
                } else {
                    this.checkForCycleWith((Structure)object);
                }
            } else if (clazz != String.class && clazz != Boolean.class && clazz != Integer.class && clazz != Long.class && clazz != Float.class && clazz != Double.class && clazz != URL.class) {
                throw new IllegalArgumentException("Type not supported by ListStructure: " + clazz.getName());
            }
        }
    }

    static void mav$dirtyAndMaybeDetach(ListStructure listStructure, Object object) {
        listStructure.dirtyAndMaybeDetach(object);
    }

    static ArrayList ra$_list(ListStructure listStructure) {
        return listStructure._list;
    }

    ListStructure(1 var1_1) {
        this();
    }

    public final class 7
    implements Runnable {
        private final /* synthetic */ int v$index;
        private final /* synthetic */ Iterator v$addIter;
        private final /* synthetic */ boolean[] v$modified;
        final /* synthetic */ ListStructure this$0;

        public void run() {
            int n = this.v$index;
            while (this.v$addIter.hasNext()) {
                this.this$0.add(n++, this.v$addIter.next());
                this.v$modified[0] = true;
            }
        }

        public 7(ListStructure listStructure, int n, Iterator iterator, boolean[] blArray) {
            this.v$modified = blArray;
            this.v$addIter = iterator;
            this.v$index = n;
            this.this$0 = listStructure;
        }
    }

    public final class 6
    implements Runnable {
        private final /* synthetic */ int v$n;
        final /* synthetic */ ListStructure this$0;

        public void run() {
            int n = this.v$n - 1;
            while (n >= 0) {
                this.this$0.remove(n);
                --n;
            }
        }

        public 6(ListStructure listStructure, int n) {
            this.v$n = n;
            this.this$0 = listStructure;
        }
    }

    public final class 5
    implements Iterator {
        private int _curIndex;
        private int _removeCount;
        private final Iterator _iter;
        private Object _cur;

        void $init$() {
            this._curIndex = -1;
            this._removeCount = 0;
            this._iter = ListStructure.ra$_list(ListStructure.this).iterator();
        }

        public boolean hasNext() {
            return this._iter.hasNext();
        }

        public Object next() {
            ++this._curIndex;
            this._cur = this._iter.next();
            return this._cur;
        }

        public void remove() {
            this._iter.remove();
            ListStructure.mav$dirtyAndMaybeDetach(ListStructure.this, this._cur);
            ListStructure.this.fireValueRemoved(Integer.toString(this._curIndex - this._removeCount++), ListStructure.this, this._cur);
        }

        public 5() {
            this.$init$();
        }
    }

    public final class 4
    implements Runnable {
        private final /* synthetic */ Iterator v$iter;
        private final /* synthetic */ boolean[] v$modified;
        final /* synthetic */ ListStructure this$0;

        public void run() {
            while (this.v$iter.hasNext()) {
                this.v$modified[0] = this.v$modified[0] | this.this$0.remove(this.v$iter.next());
            }
        }

        public 4(ListStructure listStructure, Iterator iterator, boolean[] blArray) {
            this.v$modified = blArray;
            this.v$iter = iterator;
            this.this$0 = listStructure;
        }
    }

    public final class 3
    implements Runnable {
        private final /* synthetic */ Iterator v$iter;
        private final /* synthetic */ Collection v$coll;
        private final /* synthetic */ boolean[] v$modified;
        final /* synthetic */ ListStructure this$0;

        public void run() {
            while (this.v$iter.hasNext()) {
                Object e = this.v$iter.next();
                if (this.v$coll.contains(e)) continue;
                this.v$iter.remove();
                this.v$modified[0] = true;
            }
        }

        public 3(ListStructure listStructure, Iterator iterator, Collection collection, boolean[] blArray) {
            this.v$modified = blArray;
            this.v$coll = collection;
            this.v$iter = iterator;
            this.this$0 = listStructure;
        }
    }

    public final class 2
    implements Runnable {
        private final /* synthetic */ List v$list;
        final /* synthetic */ ListStructure this$0;

        public void run() {
            this.this$0.clear();
            this.this$0.addAll((Collection)this.v$list);
        }

        public 2(ListStructure listStructure, List list) {
            this.v$list = list;
            this.this$0 = listStructure;
        }
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ ListStructure v$finalDest;
        final /* synthetic */ ListStructure this$0;

        public void run() {
            ListStructure.deepCopy(this.this$0, this.v$finalDest);
        }

        public 1(ListStructure listStructure, ListStructure listStructure2) {
            this.v$finalDest = listStructure2;
            this.this$0 = listStructure;
        }
    }

    private static final class ChainForOverriding
    extends ListStructure {
        private final ListStructure _found;
        private ListStructure _firstList;
        private final HashStructure _firstHash;
        private final String _fullName;

        ChainForOverriding(ListStructure listStructure, HashStructure hashStructure, String string) {
            super(null);
            this._found = listStructure;
            this._firstHash = hashStructure;
            this._fullName = string;
        }

        public void add(int n, Object object) {
            this.getWriteList().add(n, object);
        }

        public boolean add(Object object) {
            return this.getWriteList().add(object);
        }

        public boolean addAll(int n, Collection collection) {
            return this.getWriteList().addAll(n, collection);
        }

        public boolean addAll(Collection collection) {
            return this.getWriteList().addAll(collection);
        }

        public void clear() {
            this.getWriteList().clear();
        }

        public boolean contains(Object object) {
            return this.getReadList().contains(object);
        }

        public boolean containsAll(Collection collection) {
            return this.getReadList().containsAll(collection);
        }

        public Object get(int n) {
            if (this._firstList != null) {
                return this._firstList.get(n);
            }
            Object object = this._found.get(n);
            Iterator iterator = this._found.iterator();
            if (object instanceof HashStructure) {
                HashStructure hashStructure = (HashStructure)object;
                HashStructure hashStructure2 = hashStructure.copyTo(null);
                2DL dL = new 2DL(this, hashStructure2, iterator, n);
                hashStructure2.setParent(dL);
                return hashStructure2;
            }
            if (object instanceof ListStructure) {
                ListStructure listStructure = (ListStructure)object;
                ListStructure listStructure2 = listStructure.copyTo(null);
                2DL dL = new 2DL(this, listStructure2, iterator, n);
                listStructure2.setParent(dL);
                return listStructure2;
            }
            return object;
        }

        public int indexOf(Object object) {
            return this.getReadList().indexOf(object);
        }

        public boolean isEmpty() {
            return this.getReadList().isEmpty();
        }

        public Iterator iterator() {
            if (this._firstList != null) {
                return this._firstList.iterator();
            }
            ListStructure listStructure = this.getListCopy();
            1DL dL = new 1DL(this, listStructure);
            listStructure.setParent(dL);
            return listStructure.iterator();
        }

        public int lastIndexOf(Object object) {
            return this.getReadList().lastIndexOf(object);
        }

        public ListIterator listIterator() {
            if (this._firstList != null) {
                return this._firstList.listIterator();
            }
            throw new UnsupportedOperationException();
        }

        public ListIterator listIterator(int n) {
            if (this._firstList != null) {
                return this._firstList.listIterator(n);
            }
            throw new UnsupportedOperationException();
        }

        public Object remove(int n) {
            return this.getWriteList().remove(n);
        }

        public boolean remove(Object object) {
            return this.getWriteList().remove(object);
        }

        public boolean removeAll(Collection collection) {
            return this.getWriteList().removeAll(collection);
        }

        public boolean retainAll(Collection collection) {
            return this.getWriteList().retainAll(collection);
        }

        public Object set(int n, Object object) {
            return this.getWriteList().set(n, object);
        }

        public List subList(int n, int n2) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return this.getReadList().size();
        }

        public Object[] toArray() {
            return this.getListCopy().toArray();
        }

        public Object[] toArray(Object[] objectArray) {
            return this.getListCopy().toArray(objectArray);
        }

        protected boolean equalsImpl(ListStructure listStructure) {
            if (this._firstList == null) {
                return listStructure == null;
            }
            return this._firstList.equalsImpl(listStructure);
        }

        private ListStructure getWriteList() {
            if (this._firstList == null) {
                ListStructure listStructure = this._firstHash.getListStructure(this._fullName);
                if (listStructure != null) {
                    this._firstList = listStructure;
                } else {
                    this._firstList = this.getListCopy();
                    this._firstHash.putListStructure(this._fullName, this._firstList);
                }
            }
            return this._firstList;
        }

        private ListStructure getReadList() {
            return this._firstList != null ? this._firstList : this._found;
        }

        private ListStructure getListCopy() {
            return this.getReadList().copyTo(null);
        }

        static HashStructure ra$_firstHash(ChainForOverriding chainForOverriding) {
            return chainForOverriding._firstHash;
        }

        static String ra$_fullName(ChainForOverriding chainForOverriding) {
            return chainForOverriding._fullName;
        }

        public class 2DL
        extends Structure {
            private final Object _obj;
            private boolean _copyHappened;
            private final /* synthetic */ Iterator v$concurrentModDetector;
            private final /* synthetic */ int v$index;
            final /* synthetic */ ChainForOverriding this$0;

            2DL(ChainForOverriding chainForOverriding, Object object, Iterator iterator, int n) {
                this.v$index = n;
                this.v$concurrentModDetector = iterator;
                this.this$0 = chainForOverriding;
                this._obj = object;
            }

            public void markDirty(boolean bl) {
                if (!this._copyHappened && bl) {
                    if (!this.v$concurrentModDetector.hasNext()) {
                        throw new ConcurrentModificationException();
                    }
                    this.v$concurrentModDetector.next();
                    this.this$0.set(this.v$index, this._obj);
                    this._copyHappened = true;
                }
            }

            void removeChild(Structure structure) {
            }
        }

        public class 1DL
        extends Structure {
            private boolean _copyHappened;
            private final /* synthetic */ ListStructure v$copy;
            final /* synthetic */ ChainForOverriding this$0;

            public void markDirty(boolean bl) {
                if (!this._copyHappened && bl) {
                    ChainForOverriding.ra$_firstHash(this.this$0).putListStructure(ChainForOverriding.ra$_fullName(this.this$0), this.v$copy);
                    this._copyHappened = true;
                }
            }

            void removeChild(Structure structure) {
            }

            1DL(ChainForOverriding chainForOverriding, ListStructure listStructure) {
                this.v$copy = listStructure;
                this.this$0 = chainForOverriding;
            }
        }
    }
}

