/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.data;

import oracle.javatools.data.ChangeBuffer;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.Dirtyable;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.util.CopyOnWriteList;

public abstract class Structure
implements Dirtyable {
    private transient Structure _parent;
    private transient String _structName;
    private transient boolean _dirty;
    private final CopyOnWriteList _listeners;
    private final Object _changeBufferLock;
    private int _changeBufferDepth;
    private transient ChangeBuffer _changeBuffer;

    void $init$() {
        this._listeners = new CopyOnWriteList();
        this._changeBufferLock = new Object();
        this._changeBufferDepth = 0;
    }

    Structure() {
        this.$init$();
    }

    public final boolean isDirty() {
        Dirtyable dirtyable = this.getParentDirtyable();
        return dirtyable != null ? dirtyable.isDirty() : this._dirty;
    }

    public void markDirty(boolean bl) {
        Dirtyable dirtyable = this.getParentDirtyable();
        if (dirtyable != null) {
            dirtyable.markDirty(bl);
        } else {
            this._dirty = bl;
        }
        if (bl) {
            this.clearParentPlaceholderFlags();
        }
    }

    public String getStructName() {
        Structure structure;
        if (this._structName == null && this.getParent() != null && (structure = this.getParent()) != null) {
            return structure.getNameOfChild(this);
        }
        return this._structName;
    }

    public String getFullName() {
        Structure structure = this.getParent();
        if (structure != null) {
            String string = structure.getFullName();
            String string2 = this.getStructName();
            if (string == null) {
                return string2;
            }
            return string + "/" + string2;
        }
        return null;
    }

    public void addStructureChangeListener(StructureChangeListener structureChangeListener) {
        if (structureChangeListener != null) {
            this._listeners.addIfAbsent(structureChangeListener);
        }
    }

    public void removeStructureChangeListener(StructureChangeListener structureChangeListener) {
        if (structureChangeListener != null) {
            this._listeners.remove(structureChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyBatchChanges(Runnable runnable) {
        Object object = this._changeBufferLock;
        synchronized (object) {
            if (this._changeBuffer == null) {
                this._changeBuffer = new ChangeBuffer();
            }
            ++this._changeBufferDepth;
        }
        ChangeBuffer changeBuffer = null;
        try {
            try {
                runnable.run();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object object2 = this._changeBufferLock;
            synchronized (object2) {
                if (--this._changeBufferDepth == 0) {
                    changeBuffer = this._changeBuffer;
                    this._changeBuffer = null;
                }
            }
            throw throwable;
        }
        Object object3 = this._changeBufferLock;
        synchronized (object3) {
            if (--this._changeBufferDepth == 0) {
                changeBuffer = this._changeBuffer;
                this._changeBuffer = null;
            }
        }
        if (changeBuffer != null) {
            this.fireBatchEvent("", changeBuffer);
        }
    }

    private void clearParentPlaceholderFlags() {
        Structure structure = this.getParent();
        if (structure != null) {
            structure.clearPlaceholderFlag(this.getStructName());
        }
    }

    void clearPlaceholderFlag(String string) {
    }

    Dirtyable getParentDirtyable() {
        return this.getParent();
    }

    String getNameOfChild(Structure structure) {
        return null;
    }

    abstract void removeChild(Structure var1);

    final Structure getParent() {
        return this._parent;
    }

    private void setStructName(String string) {
        this._structName = string;
    }

    void setParent(Structure structure) {
        this._parent = structure;
    }

    final void checkAndSetParent(Structure structure, String string) {
        this.checkForCycleWith(structure);
        this.removeFromParent(structure);
        structure.setParent(this);
        structure.setStructName(string);
    }

    static boolean areDifferent(Object object, Object object2) {
        return Structure.areEqual(object, object2) ^ true;
    }

    static boolean areEqual(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        return object.equals(object2);
    }

    void checkForCycleWith(Structure structure) {
        Structure structure2 = this;
        while (structure2 != null) {
            if (structure2 == structure) {
                throw new IllegalStateException("Cyclical references are not allowed.");
            }
            structure2 = structure2.getParent();
        }
    }

    private void removeFromParent(Structure structure) {
        Structure structure2 = structure.getParent();
        if (structure2 != null) {
            structure2.removeChild(structure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void fireValueModified(String string, Structure structure, Object object, Object object2) {
        Structure structure2;
        Object object3 = this._changeBufferLock;
        synchronized (object3) {
            if (this._changeBuffer != null) {
                this._changeBuffer.addChangeInfo(ChangeInfo.valueModified(string, structure, object, object2));
                return;
            }
        }
        if (this._listeners.size() > 0) {
            ChangeInfo[] changeInfoArray = new ChangeInfo[]{ChangeInfo.valueModified(string, structure, object, object2)};
            this.fireStructureChangeEvent(changeInfoArray);
        }
        if ((structure2 = this.getParent()) != null) {
            String string2 = this.getNameInParent(string);
            structure2.fireValueModified(string2, structure, object, object2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void fireValueAdded(String string, Structure structure, Object object) {
        Structure structure2;
        Object object2 = this._changeBufferLock;
        synchronized (object2) {
            if (this._changeBuffer != null) {
                this._changeBuffer.addChangeInfo(ChangeInfo.valueAdded(string, structure, object));
                return;
            }
        }
        if (this._listeners.size() > 0) {
            ChangeInfo[] changeInfoArray = new ChangeInfo[]{ChangeInfo.valueAdded(string, structure, object)};
            this.fireStructureChangeEvent(changeInfoArray);
        }
        if ((structure2 = this.getParent()) != null) {
            String string2 = this.getNameInParent(string);
            structure2.fireValueAdded(string2, structure, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void firePlaceholderValueAdded(String string, Structure structure, Object object) {
        Structure structure2;
        Object object2 = this._changeBufferLock;
        synchronized (object2) {
            if (this._changeBuffer != null) {
                this._changeBuffer.addChangeInfo(ChangeInfo.placeholderValueAdded(string, structure, object));
                return;
            }
        }
        if (this._listeners.size() > 0) {
            ChangeInfo[] changeInfoArray = new ChangeInfo[]{ChangeInfo.placeholderValueAdded(string, structure, object)};
            this.fireStructureChangeEvent(changeInfoArray);
        }
        if ((structure2 = this.getParent()) != null) {
            String string2 = this.getNameInParent(string);
            structure2.firePlaceholderValueAdded(string2, structure, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void fireValueRemoved(String string, Structure structure, Object object) {
        Structure structure2;
        Object object2 = this._changeBufferLock;
        synchronized (object2) {
            if (this._changeBuffer != null) {
                this._changeBuffer.addChangeInfo(ChangeInfo.valueRemoved(string, structure, object));
                return;
            }
        }
        if (this._listeners.size() > 0) {
            ChangeInfo[] changeInfoArray = new ChangeInfo[]{ChangeInfo.valueRemoved(string, structure, object)};
            this.fireStructureChangeEvent(changeInfoArray);
        }
        if ((structure2 = this.getParent()) != null) {
            String string2 = this.getNameInParent(string);
            structure2.fireValueRemoved(string2, structure, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireBatchEvent(String string, ChangeBuffer changeBuffer) {
        Structure structure;
        Object object = this._changeBufferLock;
        synchronized (object) {
            if (this._changeBuffer != null) {
                this._changeBuffer.addChangeInfos(changeBuffer.getChangesWithPrefixApplied(string));
                return;
            }
        }
        if (this._listeners.size() > 0) {
            ChangeInfo[] changeInfoArray = changeBuffer.getChangesWithPrefixApplied(string);
            this.fireStructureChangeEvent(changeInfoArray);
        }
        if ((structure = this.getParent()) != null) {
            String string2 = this.getNameInParent(string);
            structure.fireBatchEvent(string2, changeBuffer);
        }
    }

    private String getNameInParent(String string) {
        return this.getStructName() + "/" + string;
    }

    private void fireStructureChangeEvent(ChangeInfo[] changeInfoArray) {
        StructureChangeEvent structureChangeEvent = new StructureChangeEvent((Object)this, changeInfoArray);
        Object[] objectArray = this._listeners.getItems();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            StructureChangeListener structureChangeListener = (StructureChangeListener)objectArray[n2];
            structureChangeListener.structureValuesChanged(structureChangeEvent);
            ++n2;
        }
    }
}

