/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.datatransfer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.datatransfer.AugmentableTransferable;
import oracle.javatools.datatransfer.DataTransferPlugin;
import oracle.javatools.datatransfer.DataTransferPluginFactory;
import oracle.javatools.logging.LogUtils;

public final class DataTransferPluginRegistry {
    private final List _factories;
    private static final DataTransferPluginRegistry _sGLOBAL = new DataTransferPluginRegistry();
    private static final Logger _LOGGER = Logger.getLogger(DataTransferPluginRegistry.class.getName());

    public static DataTransferPluginRegistry getGlobalInstance() {
        return _sGLOBAL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void performAugmentation(AugmentableTransferable augmentableTransferable, Collection collection) {
        long l = System.currentTimeMillis();
        LinkedList<DataTransferPlugin> linkedList = new LinkedList<DataTransferPlugin>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            DataTransferPluginRegistry dataTransferPluginRegistry;
            DataTransferPluginRegistry dataTransferPluginRegistry2 = dataTransferPluginRegistry = (DataTransferPluginRegistry)iterator.next();
            synchronized (dataTransferPluginRegistry2) {
                for (DataTransferPluginFactory dataTransferPluginFactory : dataTransferPluginRegistry._factories) {
                    DataTransferPlugin dataTransferPlugin = dataTransferPluginFactory.createPlugin(augmentableTransferable);
                    if (dataTransferPlugin == null) continue;
                    linkedList.add(dataTransferPlugin);
                }
            }
        }
        if (_LOGGER.isLoggable(Level.FINE)) {
            _LOGGER.log(Level.FINE, "About to performAugmentation; flavors={0} plugins={1}", new Object[]{Arrays.asList(augmentableTransferable.getTransferDataFlavors()), linkedList});
        }
        while (!linkedList.isEmpty()) {
            int n = augmentableTransferable.getModificationCount();
            Iterator iterator2 = linkedList.iterator();
            while (iterator2.hasNext()) {
                boolean bl;
                DataTransferPlugin dataTransferPlugin = (DataTransferPlugin)iterator2.next();
                if (_LOGGER.isLoggable(Level.FINER)) {
                    _LOGGER.log(Level.FINER, "Running plugin {0} on {1}, modCountNow={2} modCountBeforeRound={3}", new Object[]{dataTransferPlugin, augmentableTransferable, new Integer(augmentableTransferable.getModificationCount()), new Integer(n)});
                }
                if (!(bl = DataTransferPluginRegistry._runPlugin(dataTransferPlugin, augmentableTransferable))) continue;
                _LOGGER.log(Level.FINE, "Removing completed plugin from list: {0}", dataTransferPlugin);
                iterator2.remove();
            }
            int n2 = augmentableTransferable.getModificationCount();
            if (n == n2) break;
        }
        long l2 = System.currentTimeMillis();
        if (_LOGGER.isLoggable(Level.FINE)) {
            _LOGGER.log(Level.FINE, "Augmentation done in {0} ms; flavors={1}", new Object[]{new Long(l2 - l), Arrays.asList(augmentableTransferable.getTransferDataFlavors())});
        }
    }

    public synchronized void registerFactory(DataTransferPluginFactory dataTransferPluginFactory) {
        this._factories.add(dataTransferPluginFactory);
    }

    public synchronized void unregisterFactory(DataTransferPluginFactory dataTransferPluginFactory) {
        this._factories.remove(dataTransferPluginFactory);
    }

    private static boolean _runPlugin(DataTransferPlugin dataTransferPlugin, AugmentableTransferable augmentableTransferable) {
        try {
            boolean bl = dataTransferPlugin.augmentIfDesired(augmentableTransferable);
            return bl;
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            LogUtils.log(_LOGGER, Level.WARNING, "Plugin threw exception: {0}", dataTransferPlugin, throwable);
            return true;
        }
    }

    void $init$() {
        this._factories = new ArrayList();
    }

    public DataTransferPluginRegistry() {
        this.$init$();
    }
}

