/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.javatools.datatransfer.FetchMode;
import oracle.javatools.datatransfer.TransferDataInfo;
import oracle.javatools.datatransfer.TransferUtils;

public abstract class ExtendedTransferable
implements Transferable {
    public static final DataFlavor FLAVOR_EXTENDED_TRANSFERABLE;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        $assertionsDisabled = ExtendedTransferable.class.desiredAssertionStatus() ^ true;
        FLAVOR_EXTENDED_TRANSFERABLE = TransferUtils.createLocalJvmFlavor(ExtendedTransferable.class);
    }

    public static ExtendedTransferable getExtendedTransferable(Transferable transferable) {
        Object object = TransferUtils.getDataIfAvailable(transferable, FLAVOR_EXTENDED_TRANSFERABLE);
        if (object instanceof ExtendedTransferable) {
            return (ExtendedTransferable)object;
        }
        return null;
    }

    public final DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] dataFlavorArray = new DataFlavor[this.getFlavorCount() + 1];
        int n = 0;
        Iterator iterator = this.getOrderedFlavorIterator();
        while (iterator.hasNext()) {
            dataFlavorArray[n] = (DataFlavor)iterator.next();
            ++n;
        }
        if (!$assertionsDisabled && n != dataFlavorArray.length - 1) {
            throw new AssertionError();
        }
        dataFlavorArray[n] = FLAVOR_EXTENDED_TRANSFERABLE;
        return dataFlavorArray;
    }

    public final boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return FLAVOR_EXTENDED_TRANSFERABLE.equals(dataFlavor) || this.isFlavorSupported(dataFlavor);
    }

    public final Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (FLAVOR_EXTENDED_TRANSFERABLE.equals(dataFlavor)) {
            return this;
        }
        if (!this.isDataFlavorSupported(dataFlavor)) {
            throw new UnsupportedFlavorException(dataFlavor);
        }
        List list = this.getDataInfos(dataFlavor);
        if (list.isEmpty()) {
            return null;
        }
        TransferDataInfo transferDataInfo = (TransferDataInfo)list.get(0);
        return transferDataInfo.getData(FetchMode.STANDARD, false);
    }

    public final List getSupportedFlavors(Set set) {
        ArrayList arrayList = new ArrayList(set.size());
        Iterator iterator = this.getOrderedFlavorIterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!set.contains(e)) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    public final TransferDataInfo getHighestRankedData() {
        Iterator iterator = this.getOrderedFlavorIterator();
        while (iterator.hasNext()) {
            DataFlavor dataFlavor = (DataFlavor)iterator.next();
            TransferDataInfo transferDataInfo = this.getHighestRankedData(dataFlavor);
            if (transferDataInfo == null) continue;
            return transferDataInfo;
        }
        return null;
    }

    public final TransferDataInfo getHighestRankedData(DataFlavor dataFlavor) {
        List list = this.getDataInfos(dataFlavor);
        if (list.size() > 0) {
            return (TransferDataInfo)list.get(0);
        }
        return null;
    }

    public abstract List getDataInfos(DataFlavor var1);

    public abstract Iterator getOrderedFlavorIterator();

    public abstract String getShortDescription();

    public abstract String getMediumDescription();

    protected abstract int getFlavorCount();

    protected abstract boolean isFlavorSupported(DataFlavor var1);
}

