/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import oracle.javatools.datatransfer.AugmentableTransferable;
import oracle.javatools.datatransfer.ExtendedTransferable;
import oracle.javatools.datatransfer.TransferDataInfo;
import oracle.javatools.datatransfer.TransferUtils;
import oracle.javatools.datatransfer.TransferableBackedTransferDataInfo;

final class SimpleAugmentableTransferable
extends AugmentableTransferable {
    private int _modCount;
    private String _shortDesc;
    private String _mediumDesc;
    private final HashMap _map;
    private final ArrayList _sortedFlavorList;
    private final Comparator _comparator;
    private static final float _RANK_DELTA_WHEN_ADDING_TRANSFERABLE = 1.0E-4f;
    private static final float _DEFAULT_INITIAL_RANK_WHEN_ADDING_TRANSFERABLE = 0.5f;

    public SimpleAugmentableTransferable() {
        this.$init$();
    }

    public SimpleAugmentableTransferable(Transferable transferable) {
        this.$init$();
        if (transferable instanceof AugmentableTransferable) {
            throw new IllegalStateException("tried to create proxying transferable from already augmentable one: " + transferable);
        }
        this._augmentWithTransferable(transferable, false);
    }

    public static AugmentableTransferable createPrefetchedCopy(Transferable transferable) {
        SimpleAugmentableTransferable simpleAugmentableTransferable = new SimpleAugmentableTransferable();
        simpleAugmentableTransferable._augmentWithTransferable(transferable, true);
        return simpleAugmentableTransferable;
    }

    public AugmentableTransferable getCopy() {
        return new SimpleAugmentableTransferable(this);
    }

    public List getDataInfos(DataFlavor dataFlavor) {
        List list = (List)this._map.get(dataFlavor);
        if (list != null) {
            return list;
        }
        return Collections.EMPTY_LIST;
    }

    public String getShortDescription() {
        return this._shortDesc;
    }

    public String getMediumDescription() {
        return this._mediumDesc;
    }

    public void augment(TransferDataInfo transferDataInfo) {
        this._augmentHelper(transferDataInfo);
        this._sortFlavorList();
        ++this._modCount;
    }

    public int getModificationCount() {
        return this._modCount;
    }

    public Iterator getOrderedFlavorIterator() {
        return this._sortedFlavorList.iterator();
    }

    protected int getFlavorCount() {
        return this._map.size();
    }

    protected boolean isFlavorSupported(DataFlavor dataFlavor) {
        return this._map.containsKey(dataFlavor);
    }

    private List _findOrCreateList(DataFlavor dataFlavor) {
        LinkedList linkedList = this._findList(dataFlavor);
        if (linkedList == null) {
            linkedList = new LinkedList();
            this._map.put(dataFlavor, linkedList);
            this._sortedFlavorList.add(dataFlavor);
        }
        return linkedList;
    }

    private void _sortFlavorList() {
        Collections.sort(this._sortedFlavorList, this._comparator);
    }

    private void _augmentHelper(TransferDataInfo transferDataInfo) {
        Object object;
        Object object2;
        List list = this._findOrCreateList(transferDataInfo.getDataFlavor());
        if (list.isEmpty()) {
            list.add(transferDataInfo);
        } else {
            ListIterator<TransferDataInfo> listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                TransferDataInfo transferDataInfo2 = (TransferDataInfo)listIterator.next();
                if (transferDataInfo2.compareTo(transferDataInfo) <= 0) continue;
                listIterator.previous();
                break;
            }
            listIterator.add(transferDataInfo);
        }
        if (this._shortDesc == null && (object2 = transferDataInfo.getMetadata(TransferDataInfo.METADATA_SHORT_DESCRIPTION)) != null) {
            this._shortDesc = object2.toString();
        }
        if (this._mediumDesc == null && (object = transferDataInfo.getMetadata(TransferDataInfo.METADATA_MEDIUM_DESCRIPTION)) != null) {
            this._mediumDesc = object.toString();
        }
    }

    private void _augmentWithTransferable(Transferable transferable, boolean bl) {
        if (!bl && transferable instanceof ExtendedTransferable) {
            this._augmentWithExtendedTransferable((ExtendedTransferable)transferable);
        } else {
            this._augmentWithRegularTransferable(transferable, bl);
        }
        this._sortFlavorList();
        ++this._modCount;
    }

    private void _augmentWithRegularTransferable(Transferable transferable, boolean bl) {
        DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
        boolean bl2 = transferable.isDataFlavorSupported(TransferUtils.FLAVOR_SAFE_TO_FETCH_CONTENTS_EARLY_MARKER);
        float f = 0.5f;
        int n = 0;
        while (n < dataFlavorArray.length) {
            DataFlavor dataFlavor = dataFlavorArray[n];
            if (dataFlavor != TransferUtils.FLAVOR_SAFE_TO_FETCH_CONTENTS_EARLY_MARKER) {
                TransferDataInfo transferDataInfo = bl ? TransferUtils.createDataInfo(dataFlavor, TransferUtils.getDataIfAvailable(transferable, dataFlavor), f, null) : new TransferableBackedTransferDataInfo(transferable, dataFlavor, f, bl2);
                this._augmentHelper(transferDataInfo);
                f -= 1.0E-4f;
            }
            ++n;
        }
    }

    private void _augmentWithExtendedTransferable(ExtendedTransferable extendedTransferable) {
        Iterator iterator = extendedTransferable.getOrderedFlavorIterator();
        while (iterator.hasNext()) {
            List list = extendedTransferable.getDataInfos((DataFlavor)iterator.next());
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                this._augmentHelper((TransferDataInfo)iterator2.next());
            }
        }
    }

    private List _findList(DataFlavor dataFlavor) {
        return (List)this._map.get(dataFlavor);
    }

    private SimpleAugmentableTransferable(SimpleAugmentableTransferable simpleAugmentableTransferable) {
        this.$init$();
        this._modCount = simpleAugmentableTransferable._modCount;
        this._shortDesc = simpleAugmentableTransferable._shortDesc;
        this._mediumDesc = simpleAugmentableTransferable._mediumDesc;
        this._map.putAll(simpleAugmentableTransferable._map);
        this._sortedFlavorList.addAll(simpleAugmentableTransferable._sortedFlavorList);
    }

    void $init$() {
        this._modCount = 0;
        this._shortDesc = null;
        this._mediumDesc = null;
        this._map = new HashMap(17);
        this._sortedFlavorList = new ArrayList();
        this._comparator = new FlavorByHighestRankComparator(null);
    }

    static List mav$_findList(SimpleAugmentableTransferable simpleAugmentableTransferable, DataFlavor dataFlavor) {
        return simpleAugmentableTransferable._findList(dataFlavor);
    }

    private class FlavorByHighestRankComparator
    implements Comparator {
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            $assertionsDisabled = FlavorByHighestRankComparator.class.desiredAssertionStatus() ^ true;
        }

        public int compare(Object object, Object object2) {
            DataFlavor dataFlavor = (DataFlavor)object;
            DataFlavor dataFlavor2 = (DataFlavor)object2;
            List list = SimpleAugmentableTransferable.mav$_findList(SimpleAugmentableTransferable.this, dataFlavor);
            List list2 = SimpleAugmentableTransferable.mav$_findList(SimpleAugmentableTransferable.this, dataFlavor2);
            if (!$assertionsDisabled && list == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && list2 == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && list.isEmpty()) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && list2.isEmpty()) {
                throw new AssertionError();
            }
            Comparable comparable = (Comparable)list.get(0);
            Comparable comparable2 = (Comparable)list2.get(0);
            return comparable.compareTo(comparable2);
        }

        private FlavorByHighestRankComparator() {
        }

        FlavorByHighestRankComparator(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

