/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.io.IOException;
import oracle.javatools.datatransfer.FetchMode;
import oracle.javatools.datatransfer.TransferUtils;

public abstract class TransferDataInfo
implements Comparable {
    public static final Object METADATA_SHORT_DESCRIPTION = "shortDesc";
    public static final Object METADATA_MEDIUM_DESCRIPTION = "mediumDesc";
    public static final Object METADATA_LONG_DESCRIPTION = "longDesc";

    public abstract DataFlavor getDataFlavor();

    public abstract Object getData(FetchMode var1, boolean var2) throws IOException;

    public abstract float getSuitabilityRank();

    public Object getMetadata(Object object) {
        if (this.isDescriptionKey(object)) {
            return TransferUtils.inventDescription(this.getDataFlavor());
        }
        return null;
    }

    public final int compareTo(Object object) {
        TransferDataInfo transferDataInfo = (TransferDataInfo)object;
        float f = transferDataInfo.getSuitabilityRank() - this.getSuitabilityRank();
        if (f == 0.0f) {
            return 0;
        }
        if (f < 0.0f) {
            return -1;
        }
        return 1;
    }

    public final boolean isDescriptionKey(Object object) {
        return object == METADATA_SHORT_DESCRIPTION || object == METADATA_MEDIUM_DESCRIPTION || object == METADATA_LONG_DESCRIPTION;
    }

    protected TransferDataInfo() {
    }
}

