/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.datatransfer.AugmentableTransferable;
import oracle.javatools.datatransfer.DataTransferPluginFactory;
import oracle.javatools.datatransfer.ExtendedTransferable;
import oracle.javatools.datatransfer.FetchMode;
import oracle.javatools.datatransfer.ReflectiveDataTransferPluginFactory;
import oracle.javatools.datatransfer.SimpleAugmentableTransferable;
import oracle.javatools.datatransfer.SimpleTransferDataInfo;
import oracle.javatools.datatransfer.TransferDataInfo;

public final class TransferUtils {
    public static final DataFlavor FLAVOR_SAFE_TO_FETCH_CONTENTS_EARLY_MARKER = TransferUtils.createLocalJvmFlavor(SafeToFetchContentsEarlyMarker.class);
    private static final Logger _LOGGER = Logger.getLogger(TransferUtils.class.getName());

    public static Object getDataIfAvailable(Transferable transferable, DataFlavor dataFlavor) {
        if (transferable != null && transferable.isDataFlavorSupported(dataFlavor)) {
            try {
                Object object = transferable.getTransferData(dataFlavor);
                return object;
            }
            catch (IOException iOException) {
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Object getDataIfAvailable(Transferable transferable, DataFlavor dataFlavor, Class clazz) {
        return TransferUtils.getDataIfAvailable(transferable, dataFlavor, clazz, FetchMode.STANDARD);
    }

    public static Object getDataIfAvailable(Transferable transferable, DataFlavor dataFlavor, Class clazz, FetchMode fetchMode) {
        Object object = null;
        if (transferable instanceof ExtendedTransferable) {
            ExtendedTransferable extendedTransferable = (ExtendedTransferable)transferable;
            TransferDataInfo transferDataInfo = extendedTransferable.getHighestRankedData(dataFlavor);
            if (transferDataInfo != null) {
                try {
                    object = transferDataInfo.getData(fetchMode, false);
                }
                catch (IOException iOException) {
                    object = null;
                }
            }
        } else {
            object = TransferUtils.getDataIfAvailable(transferable, dataFlavor);
        }
        if (clazz.isInstance(object)) {
            return object;
        }
        return null;
    }

    public static DataFlavor createLocalJvmFlavor(Class clazz) {
        try {
            DataFlavor dataFlavor = new DataFlavor("application/x-java-jvm-local-objectref;class=" + clazz.getName());
            return dataFlavor;
        }
        catch (ClassNotFoundException classNotFoundException) {
            _LOGGER.log(Level.SEVERE, "Exception creating flavor for " + clazz, classNotFoundException);
            throw new RuntimeException(classNotFoundException);
        }
    }

    public static TransferDataInfo createDataInfo(DataFlavor dataFlavor, Object object, float f, Map map) {
        return new SimpleTransferDataInfo(dataFlavor, object, f, map);
    }

    public static String inventDescription(DataFlavor dataFlavor) {
        Class<?> clazz;
        String string = dataFlavor.getHumanPresentableName();
        if (string == null) {
            string = dataFlavor.getMimeType();
        }
        if (string == null && (clazz = dataFlavor.getRepresentationClass()) != null) {
            string = clazz.getName();
        }
        return string;
    }

    public static AugmentableTransferable createTransferable(Transferable transferable) {
        if (transferable instanceof AugmentableTransferable) {
            return ((AugmentableTransferable)transferable).getCopy();
        }
        return new SimpleAugmentableTransferable(transferable);
    }

    public static AugmentableTransferable createTransferable() {
        return new SimpleAugmentableTransferable();
    }

    public static AugmentableTransferable asAugmentableTransferable(Transferable transferable) {
        if (transferable instanceof AugmentableTransferable) {
            return (AugmentableTransferable)transferable;
        }
        return TransferUtils.createTransferable(transferable);
    }

    public static AugmentableTransferable prefetchTransferableContents(Transferable transferable) {
        if (transferable == null) {
            throw new IllegalArgumentException("null input");
        }
        return SimpleAugmentableTransferable.createPrefetchedCopy(transferable);
    }

    public static DataTransferPluginFactory createReflectivePluginFactory(Class clazz) {
        return new ReflectiveDataTransferPluginFactory(clazz);
    }

    public static float lowerRank(float f) {
        return f * 0.99f;
    }

    public static float higherRank(float f) {
        return f / 0.99f;
    }

    private TransferUtils() {
    }

    public static class SafeToFetchContentsEarlyMarker {
        private SafeToFetchContentsEarlyMarker() {
        }
    }
}

