/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.datatransfer.FetchMode;
import oracle.javatools.datatransfer.TransferDataInfo;
import oracle.javatools.logging.LogUtils;

final class TransferableBackedTransferDataInfo
extends TransferDataInfo {
    private transient Object _cached;
    private final Transferable _trans;
    private final DataFlavor _flavor;
    private final float _rank;
    private boolean _allowEarlyFetch;
    private static final Logger _LOGGER = Logger.getLogger(TransferableBackedTransferDataInfo.class.getName());

    public TransferableBackedTransferDataInfo(Transferable transferable, DataFlavor dataFlavor, float f, boolean bl) {
        this.$init$();
        this._trans = transferable;
        this._flavor = dataFlavor;
        this._rank = f;
        this._allowEarlyFetch = bl;
    }

    public DataFlavor getDataFlavor() {
        return this._flavor;
    }

    public Object getData(FetchMode fetchMode, boolean bl) throws IOException {
        block3: {
            if (this._cached == null && (this._allowEarlyFetch || fetchMode == FetchMode.STANDARD)) {
                try {
                    this._cached = this._trans.getTransferData(this._flavor);
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    if (!_LOGGER.isLoggable(Level.FINE)) break block3;
                    LogUtils.log(_LOGGER, Level.FINE, "Unsupported flavor that was in the list! transferable={0} flavor={1}", new Object[]{this._trans, this._flavor}, (Throwable)unsupportedFlavorException);
                }
            }
        }
        return this._cached;
    }

    public float getSuitabilityRank() {
        return this._rank;
    }

    void $init$() {
        this._cached = null;
    }
}

