/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.dialogs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.javatools.dialogs.MessagePanel;
import oracle.javatools.util.BundleLoader;

public class BaseMessageDialog
extends JEWTDialog {
    public static final int TYPE_APPLICATION_ERROR = 1;
    public static final int TYPE_INFORMATION = 2;
    public static final int TYPE_ALERT = 3;
    public static final int TYPE_CONFIRMATION = 4;
    public static final int TYPE_CONFIRM_OR_CANCEL = 5;
    private MessagePanel m_content;
    private JButton m_yesButton;
    private JButton m_noButton;
    private boolean m_yesClicked;
    private boolean m_noClicked;

    void $init$() {
        this.m_yesClicked = false;
        this.m_noClicked = false;
    }

    boolean isYesClicked() {
        return this.m_yesClicked;
    }

    boolean isNoClicked() {
        return this.m_noClicked;
    }

    JButton getYesButton() {
        return this.m_yesButton;
    }

    JButton getNoButton() {
        return this.m_noButton;
    }

    protected BaseMessageDialog(Frame frame, String string, int n) {
        super(frame, string, n);
        this.$init$();
        this.initContent();
    }

    protected BaseMessageDialog(Dialog dialog, String string, int n) {
        super(dialog, string, n);
        this.$init$();
        this.initContent();
    }

    static BaseMessageDialog createMessageDialogImpl(Component component, String string, int n) {
        BaseMessageDialog baseMessageDialog = null;
        while (component != null) {
            if (component instanceof Dialog) {
                baseMessageDialog = new BaseMessageDialog((Dialog)component, string, 7);
                break;
            }
            if (component instanceof Frame) {
                baseMessageDialog = new BaseMessageDialog((Frame)component, string, 7);
                break;
            }
            component = SwingUtilities.getWindowAncestor(component);
        }
        if (baseMessageDialog == null) {
            baseMessageDialog = new BaseMessageDialog((Frame)null, string, 7);
        }
        baseMessageDialog.setMessageType(n);
        return baseMessageDialog;
    }

    private void initContent() {
        this.m_content = new MessagePanel();
        this.setContent(this.m_content);
    }

    public void setMessage(Object object) {
        this.m_content.setMessage(object);
    }

    public void setMessageText(String string) {
        this.m_content.setMessageText(string);
    }

    public void setMessageText(String string, Object[] objectArray) {
        this.setMessageText(MessageFormat.format(string, objectArray));
    }

    public void setMessageType(int n) {
        ResourceBundle resourceBundle = BundleLoader.getBundle("oracle.javatools.resource.DialogsBundle");
        switch (n) {
            case 1: {
                this.setButtonMask(1);
                this.m_content.setMessageType(n);
                break;
            }
            case 2: {
                this.setButtonMask(1);
                this.m_content.setMessageType(n);
                break;
            }
            case 3: {
                this.setButtonMask(1);
                this.m_content.setMessageType(n);
                break;
            }
            case 4: {
                this.setButtonMask(3);
                this.setOKButtonText(resourceBundle.getString("MD_YES"));
                this.setOKButtonMnemonic(resourceBundle.getString("MD_YES_MNEMONIC").charAt(0));
                this.setCancelButtonText(resourceBundle.getString("MD_NO"));
                this.setCancelButtonMnemonic(resourceBundle.getString("MD_NO_MNEMONIC").charAt(0));
                this.m_content.setMessageType(n);
                break;
            }
            case 5: {
                this.setButtonMask(2);
                this.m_yesButton = new JButton();
                this.m_yesButton.setText(resourceBundle.getString("MD_YES"));
                this.m_yesButton.setMnemonic(resourceBundle.getString("MD_YES_MNEMONIC").charAt(0));
                this.m_noButton = new JButton();
                this.m_noButton.setText(resourceBundle.getString("MD_NO"));
                this.m_noButton.setMnemonic(resourceBundle.getString("MD_NO_MNEMONIC").charAt(0));
                this.m_yesClicked = false;
                this.m_noClicked = false;
                5 var3_3 = new 5();
                this.m_yesButton.addActionListener(var3_3);
                this.m_noButton.addActionListener(var3_3);
                this.addCustomButton(this.m_yesButton);
                this.addCustomButton(this.m_noButton);
                this.m_content.setMessageType(4);
            }
        }
    }

    void setDefaultButton(JButton jButton) {
        JButton jButton2 = this.getRootPane().getDefaultButton();
        if (jButton2 != null) {
            jButton2.setDefaultCapable(false);
        }
        this.getRootPane().setDefaultButton(jButton);
        if (jButton != null) {
            jButton.setDefaultCapable(true);
        }
    }

    public void setHelpTopic(String string) {
        HelpUtils.setHelpID((JComponent)this.m_content, (String)string);
    }

    protected boolean runActualDialog() {
        char c = (char)this.getOKButtonMnemonic();
        this.getContent().addKeyListener(new 4(this, c));
        c = (char)this.getCancelButtonMnemonic();
        this.getContent().addKeyListener(new 3(this, c));
        boolean bl = super.runDialog();
        EventQueue.invokeLater(new 2());
        return bl;
    }

    public boolean runDialog() {
        return this.doInvoke(new 1(this));
    }

    private boolean doInvoke(JEWTDialogInvoker jEWTDialogInvoker) {
        if (EventQueue.isDispatchThread()) {
            jEWTDialogInvoker.run();
        } else {
            try {
                EventQueue.invokeAndWait(jEWTDialogInvoker);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return jEWTDialogInvoker.getResponse();
    }

    static JButton ra$m_yesButton(BaseMessageDialog baseMessageDialog) {
        return baseMessageDialog.m_yesButton;
    }

    static void wa$m_yesClicked(BaseMessageDialog baseMessageDialog, boolean bl) {
        baseMessageDialog.m_yesClicked = bl;
    }

    static JButton ra$m_noButton(BaseMessageDialog baseMessageDialog) {
        return baseMessageDialog.m_noButton;
    }

    static void wa$m_noClicked(BaseMessageDialog baseMessageDialog, boolean bl) {
        baseMessageDialog.m_noClicked = bl;
    }

    static void wa$m_yesButton(BaseMessageDialog baseMessageDialog, JButton jButton) {
        baseMessageDialog.m_yesButton = jButton;
    }

    static void wa$m_noButton(BaseMessageDialog baseMessageDialog, JButton jButton) {
        baseMessageDialog.m_noButton = jButton;
    }

    static void mav$dismissDialog(BaseMessageDialog baseMessageDialog, boolean bl) {
        baseMessageDialog.dismissDialog(bl);
    }

    public final class 5
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            BaseMessageDialog.wa$m_yesClicked(BaseMessageDialog.this, actionEvent.getSource() == BaseMessageDialog.ra$m_yesButton(BaseMessageDialog.this));
            BaseMessageDialog.wa$m_noClicked(BaseMessageDialog.this, actionEvent.getSource() == BaseMessageDialog.ra$m_noButton(BaseMessageDialog.this));
            BaseMessageDialog.ra$m_yesButton(BaseMessageDialog.this).removeActionListener(this);
            BaseMessageDialog.ra$m_noButton(BaseMessageDialog.this).removeActionListener(this);
            BaseMessageDialog.wa$m_yesButton(BaseMessageDialog.this, null);
            BaseMessageDialog.wa$m_noButton(BaseMessageDialog.this, null);
            BaseMessageDialog.mav$dismissDialog(BaseMessageDialog.this, false);
        }
    }

    public final class 4
    extends SimpleKeyListener {
        public void doAction(KeyEvent keyEvent) {
            BaseMessageDialog.mav$dismissDialog(BaseMessageDialog.this, false);
        }

        public 4(BaseMessageDialog baseMessageDialog2, char c) {
            super(c);
        }
    }

    public final class 3
    extends SimpleKeyListener {
        public void doAction(KeyEvent keyEvent) {
            BaseMessageDialog.mav$dismissDialog(BaseMessageDialog.this, true);
        }

        public 3(BaseMessageDialog baseMessageDialog2, char c) {
            super(c);
        }
    }

    public final class 2
    implements Runnable {
        public void run() {
            BaseMessageDialog.this.dispose();
        }
    }

    public final class 1
    extends JEWTDialogInvoker {
        public boolean doIt() {
            return BaseMessageDialog.this.runActualDialog();
        }

        public 1(BaseMessageDialog baseMessageDialog2) {
            super(null);
        }
    }

    private abstract class JEWTDialogInvoker
    implements Runnable {
        private boolean m_response;

        public void run() {
            this.m_response = this.doIt();
        }

        public boolean getResponse() {
            return this.m_response;
        }

        public abstract boolean doIt();

        private JEWTDialogInvoker() {
        }

        JEWTDialogInvoker(1 var2_2) {
            this();
        }
    }

    private abstract class SimpleKeyListener
    extends KeyAdapter {
        private char m_key;

        SimpleKeyListener(char c) {
            this.m_key = c;
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (Character.toUpperCase(this.m_key) == Character.toUpperCase(keyEvent.getKeyChar())) {
                this.doAction(keyEvent);
            }
        }

        public abstract void doAction(KeyEvent var1);
    }
}

