/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.javatools.controls.TextMenuPopupHandler;
import oracle.javatools.dialogs.DetailDialog;
import oracle.javatools.dialogs.DialogUtil;
import oracle.javatools.dialogs.MessagePanel;
import oracle.javatools.resource.DialogsBundle;

public class ExceptionDialog {
    private JTextArea m_traceArea;
    private JButton m_prevButton;
    private JButton m_nextButton;
    private JLabel m_traceLabel;
    private JScrollPane m_traceScroller;
    private MessagePanel m_messagePanel;
    private JPanel m_detailsPanel;
    private boolean m_detailsShown;
    private Throwable m_throwable;
    private List m_throwableList;
    private int m_currentIndex;
    private DetailDialog m_dialog;
    private static final int TRACE_ROWS = 8;
    private static final List m_traversers = new ArrayList();

    void $init$() {
        this.m_traceArea = new JTextArea();
        this.m_prevButton = new JButton();
        this.m_nextButton = new JButton();
        this.m_traceLabel = new JLabel();
        this.m_traceScroller = new JScrollPane(this.m_traceArea);
        this.m_messagePanel = new MessagePanel();
        this.m_detailsPanel = new JPanel(new GridBagLayout());
        this.m_detailsShown = false;
        this.m_currentIndex = 0;
    }

    static {
        ExceptionDialog.registerThrowableChainTraverser(SQLException.class, new SQLExceptionTraverser(null));
    }

    private ExceptionDialog() {
        this.$init$();
        this.initializePanels();
        ActionController actionController = new ActionController(null);
        this.m_prevButton.addActionListener(actionController);
        this.m_nextButton.addActionListener(actionController);
        this.m_prevButton.setName("ExceptionPrevious");
        this.m_nextButton.setName("ExceptionNext");
        this.m_traceLabel.setName("ExceptionTraceLabel");
        this.m_detailsPanel.setName("ExceptionDetailsPanel");
        this.m_traceScroller.setName("ExceptionTraceScrollPane");
        this.m_traceArea.setName("ExceptionTrace");
    }

    private static ResourceBundle getBundle() {
        return ResourceBundle.getBundle(DialogsBundle.class.getName());
    }

    public static void showExceptionDialog(Component component, Throwable throwable) {
        ExceptionDialog.showExceptionDialog(component, throwable, null);
    }

    public static void showExceptionDialog(Component component, Throwable throwable, String string) {
        ExceptionDialog.showExceptionDialog(component, throwable, "", string, null);
    }

    public static void showExceptionDialog(Component component, Throwable throwable, String string, String string2, String string3) {
        if (throwable instanceof ThreadDeath) {
            throw (ThreadDeath)throwable;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            ExceptionDialog.reallyShowExceptionDialog(component, throwable, string, string2, string3);
        } else {
            try {
                SwingUtilities.invokeAndWait(new 1(component, throwable, string, string2, string3));
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.getTargetException().printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static void reallyShowExceptionDialog(Component component, Throwable throwable, String string, String string2, String string3) {
        Window window = null;
        if (component != null && (window = DialogUtil.getAncestorDialog(component)) == null) {
            window = DialogUtil.getAncestorFrame(component);
        }
        ExceptionDialog exceptionDialog = new ExceptionDialog();
        if (throwable != null) {
            exceptionDialog.setThrowable(throwable);
        }
        if (string2 != null) {
            exceptionDialog.setMessage(string2);
        }
        int n = 21;
        if (string2 != null && string3 == null) {
            n -= 4;
        }
        DetailDialog detailDialog = exceptionDialog.createDialog(component, string == null ? "" : string, n);
        detailDialog.setContent(exceptionDialog.m_messagePanel);
        detailDialog.setDetailContent(exceptionDialog.m_detailsPanel);
        detailDialog.setResizable(true);
        String string4 = string3;
        if (string3 == null) {
            string4 = "f1_idedjdevexception_html";
        }
        HelpUtils.setHelpID((JComponent)exceptionDialog.m_messagePanel, (String)string4);
        detailDialog.runDialog();
        detailDialog.dispose();
    }

    public static int showExceptionDialog(Window window, Exception exception, String string, String string2) {
        ExceptionDialog.showExceptionDialog(window, exception, string, string2, null);
        return 0;
    }

    public static int showExceptionDialog(Window window, Exception exception, String string) {
        return ExceptionDialog.showExceptionDialog(window, exception, ExceptionDialog.getBundle().getString("ED_DEFAULT_TITLE"), string);
    }

    public static int showExceptionDialog(Window window, Exception exception) {
        return ExceptionDialog.showExceptionDialog(window, exception, null);
    }

    public static void registerThrowableChainTraverser(Class clazz, ThrowableChainTraverser throwableChainTraverser) {
        Entry entry = new Entry(null);
        entry.tct = throwableChainTraverser;
        entry.clazz = clazz;
        m_traversers.add(entry);
    }

    public static void unregisterThrowableChainTraverser(ThrowableChainTraverser throwableChainTraverser) {
        Iterator iterator = m_traversers.iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            if (entry.tct != throwableChainTraverser) continue;
            iterator.remove();
        }
    }

    private DetailDialog createDialog(Component component, String string, int n) {
        this.m_dialog = DetailDialog.createDetailDialog(component, string, n);
        return this.m_dialog;
    }

    private void initializePanels() {
        this.m_messagePanel.setMessageType(1);
        this.m_messagePanel.setMessageText(ExceptionDialog.getBundle().getString("ED_DEFAULT_MESSAGE"));
        this.m_traceArea.setTabSize(2);
        this.m_traceArea.addMouseListener(new TextMenuPopupHandler(this.m_traceArea));
        String string = ExceptionDialog.getBundle().getString("ED_PREVIOUS");
        this.m_prevButton.setText(StringUtils.stripMnemonic((String)string));
        this.m_prevButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        this.m_prevButton.setDefaultCapable(false);
        string = ExceptionDialog.getBundle().getString("ED_NEXT");
        this.m_nextButton.setText(StringUtils.stripMnemonic((String)string));
        this.m_nextButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        this.m_nextButton.setDefaultCapable(false);
        string = ExceptionDialog.getBundle().getString("ED_TRACE_SINGLE");
        this.m_traceLabel.setText(StringUtils.stripMnemonic((String)string));
        this.m_traceLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        this.m_traceLabel.setLabelFor(this.m_traceArea);
        this.m_traceArea.setBackground(this.m_messagePanel.getBackground());
        this.m_detailsPanel.add((Component)this.m_traceScroller, new GridBagConstraints(0, 1, 4, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.m_detailsPanel.add((Component)this.m_prevButton, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.m_detailsPanel.add((Component)this.m_nextButton, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.m_detailsPanel.add((Component)this.m_traceLabel, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 18, 0, new Insets(0, 5, 5, 0), 0, 0));
        int n = Math.max(this.m_prevButton.getPreferredSize().width, this.m_nextButton.getPreferredSize().width);
        this.m_prevButton.setPreferredSize(new Dimension(n, this.m_prevButton.getPreferredSize().height));
        this.m_nextButton.setPreferredSize(new Dimension(n, this.m_nextButton.getPreferredSize().height));
        this.m_traceArea.setEditable(false);
        this.m_traceArea.setRows(8);
    }

    private void setThrowable(Throwable throwable) {
        if (throwable == null) {
            throw new IllegalArgumentException("Throwable for ExceptionDialog must not be null");
        }
        this.m_throwable = throwable;
        if (this.isChainedThrowable(throwable)) {
            List list = this.getThrowableChain(throwable);
            this.m_throwableList = list.size() == 0 ? null : list;
            this.m_currentIndex = 0;
        } else {
            String string = ExceptionDialog.getBundle().getString("ED_TRACE_SINGLE");
            this.m_traceLabel.setText(StringUtils.stripMnemonic((String)string));
            this.m_traceLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        }
        this.m_prevButton.setVisible(this.m_detailsShown && this.m_throwableList != null);
        this.m_nextButton.setVisible(this.m_detailsShown && this.m_throwableList != null);
        this.updateNextPrevButtonEnablement();
        this.showCurrentStack();
    }

    private void updateNextPrevButtonEnablement() {
        this.m_prevButton.setEnabled(this.m_throwableList != null && this.m_currentIndex > 0);
        this.m_nextButton.setEnabled(this.m_throwableList != null && this.m_currentIndex < this.m_throwableList.size() - 1);
    }

    private void nextStack() {
        ++this.m_currentIndex;
        this.showCurrentStack();
        this.updateNextPrevButtonEnablement();
    }

    private void previousStack() {
        --this.m_currentIndex;
        this.showCurrentStack();
        this.updateNextPrevButtonEnablement();
    }

    private void showCurrentStack() {
        Throwable throwable;
        if (this.m_throwableList != null) {
            throwable = (Throwable)this.m_throwableList.get(this.m_currentIndex);
            this.m_traceLabel.setText(MessageFormat.format(ExceptionDialog.getBundle().getString("ED_TRACE_MULTIPLE"), String.valueOf(this.m_currentIndex + 1), String.valueOf(this.m_throwableList.size())));
        } else {
            throwable = this.m_throwable;
        }
        this.m_traceArea.setText("");
        if (throwable != null) {
            this.m_traceArea.append(ExceptionDialog.getStackTrace(throwable));
            this.m_traceArea.setCaretPosition(0);
        }
        this.m_traceScroller.setPreferredSize(new Dimension(0, this.m_traceScroller.getPreferredSize().height));
    }

    private void setMessage(String string) {
        this.m_messagePanel.setMessageText(string);
    }

    private ThrowableChainTraverser getTraverser(Throwable throwable) {
        for (Entry entry : m_traversers) {
            if (!entry.clazz.isAssignableFrom(throwable.getClass())) continue;
            return entry.tct;
        }
        return null;
    }

    protected boolean isChainedThrowable(Throwable throwable) {
        return this.getTraverser(throwable) != null;
    }

    protected List getThrowableChain(Throwable throwable) {
        ThrowableChainTraverser throwableChainTraverser = this.getTraverser(throwable);
        if (throwableChainTraverser != null) {
            return throwableChainTraverser.getThrowableChain(throwable);
        }
        return null;
    }

    private static final String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter(1024);
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    static void maS$reallyShowExceptionDialog(Component component, Throwable throwable, String string, String string2, String string3) {
        ExceptionDialog.reallyShowExceptionDialog(component, throwable, string, string2, string3);
    }

    static JButton ra$m_nextButton(ExceptionDialog exceptionDialog) {
        return exceptionDialog.m_nextButton;
    }

    static void mav$nextStack(ExceptionDialog exceptionDialog) {
        exceptionDialog.nextStack();
    }

    static JButton ra$m_prevButton(ExceptionDialog exceptionDialog) {
        return exceptionDialog.m_prevButton;
    }

    static void mav$previousStack(ExceptionDialog exceptionDialog) {
        exceptionDialog.previousStack();
    }

    public static final class 1
    implements Runnable {
        private final /* synthetic */ Component v$parent;
        private final /* synthetic */ Throwable v$t;
        private final /* synthetic */ String v$title;
        private final /* synthetic */ String v$message;
        private final /* synthetic */ String v$helpTopicID;

        public void run() {
            ExceptionDialog.maS$reallyShowExceptionDialog(this.v$parent, this.v$t, this.v$title, this.v$message, this.v$helpTopicID);
        }

        public 1(Component component, Throwable throwable, String string, String string2, String string3) {
            this.v$helpTopicID = string3;
            this.v$message = string2;
            this.v$title = string;
            this.v$t = throwable;
            this.v$parent = component;
        }
    }

    private class ActionController
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Object object = actionEvent.getSource();
                if (object == ExceptionDialog.ra$m_nextButton(ExceptionDialog.this)) {
                    ExceptionDialog.mav$nextStack(ExceptionDialog.this);
                } else if (object == ExceptionDialog.ra$m_prevButton(ExceptionDialog.this)) {
                    ExceptionDialog.mav$previousStack(ExceptionDialog.this);
                }
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
            }
        }

        private ActionController() {
        }

        ActionController(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    public static interface ThrowableChainTraverser {
        public List getThrowableChain(Throwable var1);
    }

    private static class SQLExceptionTraverser
    implements ThrowableChainTraverser {
        public List getThrowableChain(Throwable throwable) {
            ArrayList<SQLException> arrayList = null;
            if (throwable instanceof SQLException) {
                arrayList = new ArrayList<SQLException>();
                SQLException sQLException = (SQLException)throwable;
                arrayList.add(sQLException);
                while (sQLException.getNextException() != null) {
                    sQLException = sQLException.getNextException();
                    arrayList.add(sQLException);
                }
            }
            return arrayList;
        }

        private SQLExceptionTraverser() {
        }

        SQLExceptionTraverser(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class Entry {
        ThrowableChainTraverser tct;
        Class clazz;

        private Entry() {
        }

        Entry(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

