/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.dialogs;

import java.awt.Component;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import oracle.bali.share.nls.StringUtils;
import oracle.javatools.dialogs.BaseMessageDialog;
import oracle.javatools.dialogs.MessageDialogPersistence;
import oracle.javatools.dialogs.MessageUtil;
import oracle.javatools.util.BundleLoader;
import oracle.javatools.util.SwingUtils;

public final class MessageDialog {
    public static final int CONFIRM_CANCEL = -1;
    public static final int CONFIRM_NO = 0;
    public static final int CONFIRM_YES = 1;
    private static MessageDialogPersistence _persistence;

    private MessageDialog() {
    }

    public static void setPersistence(MessageDialogPersistence messageDialogPersistence) {
        _persistence = messageDialogPersistence;
    }

    public static void resetSkippedMessages() {
        MessageDialog.getPersistence().clearSettings();
    }

    public static MessageDialogPersistence getPersistence() {
        if (_persistence == null) {
            _persistence = new MessageDialogPersistence();
        }
        return _persistence;
    }

    private static String getDefaultTitle(int n) {
        ResourceBundle resourceBundle = BundleLoader.getBundle("oracle.javatools.resource.DialogsBundle");
        switch (n) {
            case 3: {
                return resourceBundle.getString("MD_DEFAULT_ERROR");
            }
            case 2: {
                return resourceBundle.getString("MD_DEFAULT_INFORMATION");
            }
            case 1: {
                return resourceBundle.getString("MD_DEFAULT_CRITICAL");
            }
            case 4: {
                return resourceBundle.getString("MD_DEFAULT_CONFIRM");
            }
        }
        return "";
    }

    private static boolean runDialog(Component component, Object object, String string, String string2, int n, int n2, String string3, String string4) {
        BaseMessageDialog baseMessageDialog = BaseMessageDialog.createMessageDialogImpl(component == null ? SwingUtils.getMainWindow() : component, string == null ? MessageDialog.getDefaultTitle(n) : string, n);
        baseMessageDialog.setMessage(object);
        if (string2 != null) {
            baseMessageDialog.setHelpTopic(string2);
            baseMessageDialog.setButtonMask(baseMessageDialog.getButtonMask() + 4);
        }
        baseMessageDialog.setDefaultButton(n2);
        if (string3 != null) {
            int n3 = StringUtils.getMnemonicKeyCode((String)string3);
            if (n3 == 0) {
                baseMessageDialog.setOKButtonText(string3);
            } else {
                baseMessageDialog.setOKButtonText(StringUtils.stripMnemonic((String)string3));
                baseMessageDialog.setOKButtonMnemonic(n3);
            }
        }
        if (string4 != null) {
            int n4 = StringUtils.getMnemonicKeyCode((String)string4);
            if (n4 == 0) {
                baseMessageDialog.setCancelButtonText(string4);
            } else {
                baseMessageDialog.setCancelButtonText(StringUtils.stripMnemonic((String)string4));
                baseMessageDialog.setCancelButtonMnemonic(n4);
            }
        }
        return baseMessageDialog.runDialog();
    }

    private static boolean runDialog(Component component, Object object, String string, String string2, int n, int n2) {
        return MessageDialog.runDialog(component, object, string, string2, n, n2, null, null);
    }

    public static void error(Component component, Object object, String string, String string2) {
        MessageDialog.runDialog(component, object, string, string2, 3, 1);
    }

    public static boolean optionalConfirm(String string, Component component, String string2, String string3, String string4) {
        if (MessageDialog.getPersistence().isHidden(string)) {
            return true;
        }
        JCheckBox jCheckBox = new JCheckBox();
        Component component2 = MessageUtil.createOptionalMessage(string2, jCheckBox);
        boolean bl = MessageDialog.confirm(component, component2, string3, string4, false);
        if (bl && jCheckBox.isSelected()) {
            MessageDialog.getPersistence().setHidden(string, true);
        }
        return bl;
    }

    public static boolean confirm(Component component, Object object, String string, String string2) {
        return MessageDialog.confirm(component, object, string, string2, false);
    }

    public static boolean confirm(Component component, Object object, String string, String string2, boolean bl) {
        return MessageDialog.confirm(component, object, string, string2, bl, null, null);
    }

    public static boolean confirm(Component component, Object object, String string, String string2, boolean bl, String string3, String string4) {
        return MessageDialog.runDialog(component, object, string, string2, 4, bl ? 2 : 1, string3, string4);
    }

    public static int confirmOrCancel(Component component, Object object, String string) {
        return MessageDialog.confirmOrCancel(component, object, string, null);
    }

    public static int confirmOrCancel(Component component, Object object, String string, String string2) {
        return MessageDialog.confirmOrCancel(component, object, string, string2, false);
    }

    public static int confirmOrCancel(Component component, Object object, String string, String string2, boolean bl) {
        BaseMessageDialog baseMessageDialog = BaseMessageDialog.createMessageDialogImpl(component == null ? SwingUtils.getMainWindow() : component, string == null ? MessageDialog.getDefaultTitle(4) : string, 5);
        baseMessageDialog.setMessage(object);
        if (string2 != null) {
            baseMessageDialog.setHelpTopic(string2);
            baseMessageDialog.setButtonMask(baseMessageDialog.getButtonMask() + 4);
        }
        baseMessageDialog.setDefaultButton(bl ? baseMessageDialog.getNoButton() : baseMessageDialog.getYesButton());
        boolean bl2 = baseMessageDialog.runDialog();
        if (bl2) {
            return baseMessageDialog.isYesClicked() ? 1 : 0;
        }
        return -1;
    }

    public static void optionalInformation(String string, Component component, String string2, String string3, String string4) {
        if (!MessageDialog.getPersistence().isHidden(string)) {
            JCheckBox jCheckBox = new JCheckBox();
            Component component2 = MessageUtil.createOptionalMessage(string2, jCheckBox);
            MessageDialog.runDialog(component, component2, string3, string4, 2, 1);
            if (jCheckBox.isSelected()) {
                MessageDialog.getPersistence().setHidden(string, true);
            }
        }
    }

    public static void information(Component component, Object object, String string, String string2) {
        MessageDialog.runDialog(component, object, string, string2, 2, 1);
    }

    public static void critical(Component component, Object object, String string, String string2) {
        MessageDialog.runDialog(component, object, string, string2, 1, 1);
    }
}

