/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.dialogs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import oracle.javatools.dialogs.ExceptionDialog;

public class MessageDialogPersistence {
    private Map _settings;
    private static final String PERSISTENCE_FILE = ".oracle_javatools_msgdlg.properties";

    private Map getSettings() {
        if (this._settings == null) {
            try {
                this._settings = this.loadSettings();
            }
            catch (IOException iOException) {
                this.handleError(iOException);
                this._settings = Collections.EMPTY_MAP;
            }
        }
        return this._settings;
    }

    public final boolean isHidden(String string) {
        String string2 = String.valueOf(this.getSettings().get(string));
        return Boolean.valueOf(string2);
    }

    public final void setHidden(String string, boolean bl) {
        Map map = this.getSettings();
        map.put(string, String.valueOf(bl));
        this.safeSave(map);
    }

    final void clearSettings() {
        this._settings = new Properties();
        this.safeSave(this._settings);
    }

    private void safeSave(Map map) {
        try {
            this.saveSettings(map);
        }
        catch (IOException iOException) {
            this.handleError(iOException);
        }
    }

    protected Map loadSettings() throws IOException {
        File file = new File(this.getUserDirectory(), PERSISTENCE_FILE);
        if (!file.exists()) {
            return new Properties();
        }
        Properties properties = new Properties();
        FileInputStream fileInputStream = new FileInputStream(file);
        properties.load(fileInputStream);
        ((InputStream)fileInputStream).close();
        return properties;
    }

    protected void saveSettings(Map map) throws IOException {
        if (map == Collections.EMPTY_MAP) {
            return;
        }
        File file = new File(this.getUserDirectory(), PERSISTENCE_FILE);
        PrintWriter printWriter = new PrintWriter(new FileWriter(file));
        if (map instanceof Properties) {
            ((Properties)map).list(printWriter);
        } else {
            Properties properties = new Properties();
            for (Object k : map.keySet()) {
                Object v = map.get(k);
                properties.setProperty(String.valueOf(k), String.valueOf(v));
            }
            properties.list(printWriter);
        }
        printWriter.close();
    }

    protected File getUserDirectory() {
        return new File(System.getProperty("user.home"));
    }

    protected void handleError(Exception exception) {
        ExceptionDialog.showExceptionDialog(null, exception);
    }
}

