/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.javatools.controls.HyperlinkButton;

public class MessagePanel
extends JComponent
implements Accessible {
    private JLabel m_icon;
    private JPanel m_msgArea;
    private MultiLineLabel m_text;
    private JLabel m_titleLabel;
    public static final int TYPE_APPLICATION_ERROR = 1;
    public static final int TYPE_INFORMATION = 2;
    public static final int TYPE_ALERT = 3;
    public static final int TYPE_CONFIRMATION = 4;
    private static final int BORDER_INSET = 5;
    private static final int ICON_TEXT_GAP = 20;
    private static final int HORIZONTAL_STRUT = 350;
    private boolean m_hasComponents;
    private JPanel m_componentPanel;

    void $init$() {
        this.m_hasComponents = false;
    }

    public MessagePanel() {
        this.$init$();
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.m_icon = new JLabel();
        this.m_text = new MultiLineLabel();
        this.m_text.setTextWrapper(WordWrapper.getTextWrapper());
        this.m_text.setPreferredAspectRatio(5.0f);
        this.m_msgArea = new JPanel();
        this.m_msgArea.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        this.m_msgArea.setOpaque(false);
        this.m_titleLabel = new JLabel();
        this.m_titleLabel.setVisible(false);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.m_icon, new GridBagConstraints(0, 0, 1, 3, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 20), 0, 0));
        this.add((Component)this.m_titleLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 15, 0), 0, 0));
        this.add((Component)this.m_msgArea, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 350, 0));
        this.setName("MessagePanel");
        this.m_icon.setName("MessagePanelIcon");
        this.m_msgArea.setName("MessageArea");
        this.m_text.setName("MessageText");
        this.m_titleLabel.setName("MessageTitleLabel");
    }

    public void setTitle(String string) {
        this.m_titleLabel.setVisible(true);
        Font font = this.m_titleLabel.getFont();
        font = font.deriveFont(1);
        this.m_titleLabel.setFont(font);
        this.m_titleLabel.setText(string);
        this.validate();
    }

    public void addMessageComponent(Component component) {
        if (!this.m_hasComponents) {
            this.m_componentPanel = new JPanel();
            this.m_componentPanel.setOpaque(false);
            this.m_componentPanel.setLayout(new BoxLayout(this.m_componentPanel, 1));
            JPanel jPanel = new JPanel();
            jPanel.setOpaque(false);
            jPanel.setPreferredSize(new Dimension(5, 5));
            this.m_componentPanel.add(jPanel);
            this.m_msgArea.add((Component)this.m_componentPanel, "South");
            this.m_hasComponents = true;
        }
        Box box = Box.createHorizontalBox();
        box.add(component);
        box.add(Box.createHorizontalGlue());
        this.m_componentPanel.add(box);
    }

    public void addHyperAction(Action action) {
        this.addMessageComponent(new HyperlinkButton(action));
    }

    public void setMessage(Object object) {
        if (object instanceof Component) {
            this.m_msgArea.add((Component)object, "Center");
        } else {
            this.setMessageText(object != null ? object.toString() : null);
        }
    }

    public void setMessageText(String string) {
        if (string != null) {
            this.getAccessibleContext().setAccessibleName(string);
        }
        this.m_msgArea.add((Component)this.m_text, "Center");
        this.m_text.setText(string);
    }

    public void setMessageType(int n) {
        this.m_icon.setVisible(true);
        switch (n) {
            case 1: {
                this.m_icon.setIcon(UIManager.getIcon("OptionPane.errorIcon"));
                break;
            }
            case 2: {
                this.m_icon.setIcon(UIManager.getIcon("OptionPane.informationIcon"));
                break;
            }
            case 3: {
                this.m_icon.setIcon(UIManager.getIcon("OptionPane.errorIcon"));
                break;
            }
            case 4: {
                this.m_icon.setIcon(UIManager.getIcon("OptionPane.warningIcon"));
                break;
            }
            default: {
                this.m_icon.setVisible(false);
            }
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleMessagePane();
        }
        return this.accessibleContext;
    }

    protected class AccessibleMessagePane
    extends JComponent.AccessibleJComponent {
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.ALERT;
        }

        protected AccessibleMessagePane() {
            super(MessagePanel.this);
        }
    }
}

