/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.dialogs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.UIManager;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.util.WindowUtils;
import oracle.javatools.dialogs.DetailDialog;
import oracle.javatools.dialogs.DialogUtil;

public class ProgressMonitor {
    private JProgressBar _myBar;
    private JLabel _noteLabel;
    private Component _parentComponent;
    private String _note;
    private Object _message;
    private long _T0;
    private int _millisToDecideToPopup;
    private int _millisToPopup;
    private int _min;
    private int _max;
    private int _v;
    private int _lastDisp;
    private int _reportDelta;
    private JEWTDialog _dialog;
    private String _title;
    private Component _detailContent;
    private boolean _barVisible;
    private boolean _indeterminate;
    private boolean _cancellable;

    public ProgressMonitor(Component component, String string, Object object, String string2, int n, int n2) {
        this._min = n;
        this._max = n2;
        this._parentComponent = component;
        this._title = string;
        this._barVisible = true;
        this._reportDelta = (this._max - this._min) / 100;
        if (this._reportDelta < 1) {
            this._reportDelta = 1;
        }
        this._v = this._min;
        this._message = object;
        this._note = string2;
        this._cancellable = true;
        this._T0 = System.currentTimeMillis();
    }

    public ProgressMonitor(Component component, String string, String string2, String string3, int n, int n2) {
        this(component, string, (Object)string2, string3, n, n2);
    }

    public ProgressMonitor(Component component, String string, int n, int n2) {
        this(component, string, "", "", n, n2);
    }

    public void setProgress(int n) {
        if (EventQueue.isDispatchThread()) {
            new IllegalStateException("Cannot update progress monitor from the AWT event thread.").printStackTrace();
        }
        if (this._indeterminate || this._max <= this._min) {
            this.display();
            return;
        }
        this._v = n;
        if (n >= this._max) {
            this.close();
        } else if (n >= this._lastDisp + this._reportDelta) {
            this._lastDisp = n;
            if (this._myBar != null) {
                this._myBar.setValue(n);
            } else {
                int n2;
                long l = System.currentTimeMillis();
                long l2 = (int)(l - this._T0);
                if (l2 >= (long)this._millisToDecideToPopup && (n2 = n > this._min ? (int)(l2 * (long)(this._max - this._min) / (long)(n - this._min)) : this._millisToPopup) >= this._millisToPopup) {
                    this.display();
                }
            }
        }
    }

    public void close() {
        if (this._dialog != null) {
            this.hideDialogLater((Dialog)this._dialog);
            this._dialog = null;
        }
        if (this._myBar != null) {
            this._myBar = null;
        }
        if (this._noteLabel != null) {
            this._noteLabel = null;
        }
    }

    public int getMinimum() {
        return this._min;
    }

    public void setMinimum(int n) {
        this._min = n;
    }

    public int getMaximum() {
        return this._max;
    }

    public void setMaximum(int n) {
        this._max = n;
    }

    public boolean isCanceled() {
        return this._dialog != null && this._dialog.isCancelled();
    }

    public void setMillisToDecideToPopup(int n) {
        this._millisToDecideToPopup = n;
    }

    public int getMillisToDecideToPopup() {
        return this._millisToDecideToPopup;
    }

    public void setMillisToPopup(int n) {
        this._millisToPopup = n;
    }

    public int getMillisToPopup() {
        return this._millisToPopup;
    }

    public void setNote(String string) {
        this._note = string;
        if (this._noteLabel != null) {
            this._noteLabel.setText(string);
        }
    }

    public void setMessage(String string) {
        if (this._message instanceof JLabel) {
            ((JLabel)this._message).setText(string);
        }
    }

    public String getNote() {
        return this._note;
    }

    public void setDetailContent(Component component) {
        this._detailContent = component;
    }

    public Component getDetailContent() {
        return this._detailContent;
    }

    public void setBarVisible(boolean bl) {
        this._barVisible = bl;
    }

    public boolean isBarVisible() {
        return this._barVisible;
    }

    public void setIndeterminate(boolean bl) {
        this._indeterminate = bl;
    }

    public boolean isIndeterminate() {
        return this._indeterminate;
    }

    public void setCancellable(boolean bl) {
        this._cancellable = bl;
    }

    public boolean isCancellable() {
        return this._cancellable;
    }

    public void display() {
        if (EventQueue.isDispatchThread()) {
            new IllegalStateException("Cannot display progress monitor from the AWT event thread.").printStackTrace();
        }
        if (this._dialog != null) {
            return;
        }
        this._dialog = this.createDialog();
        this.showDialogLater((Dialog)this._dialog);
    }

    private ProgressDialog createDialog() {
        ProgressDialog progressDialog = this.createDialogImpl();
        progressDialog.setContent(this.createDialogContent());
        progressDialog.setDetailContent(this._detailContent);
        progressDialog.pack();
        progressDialog.setMinimumSize(progressDialog.getPreferredSize());
        progressDialog.setLocationRelativeTo(this._parentComponent);
        return progressDialog;
    }

    private ProgressDialog createDialogImpl() {
        Frame frame;
        int n = 0;
        if (this._cancellable) {
            n |= 2;
        }
        if (this._detailContent != null) {
            n |= 0x10;
        }
        ProgressDialog progressDialog = null;
        Dialog dialog = DialogUtil.getAncestorDialog(this._parentComponent);
        if (dialog != null) {
            progressDialog = new ProgressDialog(dialog, this._title, n, null);
        }
        if (progressDialog == null && (frame = DialogUtil.getAncestorFrame(this._parentComponent)) != null) {
            progressDialog = new ProgressDialog(frame, this._title, n, null);
        }
        if (progressDialog == null) {
            throw new IllegalStateException();
        }
        return progressDialog;
    }

    private Component createDialogContent() {
        this._myBar = new JProgressBar();
        this._myBar.setIndeterminate(this._indeterminate || this._max <= this._min);
        this._myBar.setMinimum(this._min);
        this._myBar.setMaximum(this._max);
        this._myBar.setValue(this._v);
        if (this._note != null) {
            this._noteLabel = new JLabel(this._note);
        }
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0);
        Component component = this._message instanceof Component ? (Component)this._message : new JLabel(this._message.toString());
        this._message = component;
        jPanel.add(component, gridBagConstraints);
        if (this._barVisible) {
            ++gridBagConstraints.gridy;
            jPanel.add((Component)this._myBar, gridBagConstraints);
        }
        if (this._noteLabel != null) {
            ++gridBagConstraints.gridy;
            jPanel.add((Component)this._noteLabel, gridBagConstraints);
        }
        ++gridBagConstraints.gridy;
        jPanel.add(Box.createHorizontalStrut(300), gridBagConstraints);
        return jPanel;
    }

    private void showDialogLater(Dialog dialog) {
        if (EventQueue.isDispatchThread()) {
            return;
        }
        EventQueue.invokeLater(new 2(this, dialog));
    }

    private void hideDialogLater(Dialog dialog) {
        if (EventQueue.isDispatchThread()) {
            dialog.hide();
            WindowUtils.unregisterWindow((Window)dialog);
            dialog.dispose();
            return;
        }
        EventQueue.invokeLater(new 1(this, dialog));
    }

    static void mav$hideDialogLater(ProgressMonitor progressMonitor, Dialog dialog) {
        progressMonitor.hideDialogLater(dialog);
    }

    public final class 2
    implements Runnable {
        private final /* synthetic */ Dialog v$d;
        final /* synthetic */ ProgressMonitor this$0;

        public final void run() {
            WindowUtils.registerWindow((Window)this.v$d);
            this.v$d.show();
        }

        public 2(ProgressMonitor progressMonitor, Dialog dialog) {
            this.v$d = dialog;
            this.this$0 = progressMonitor;
        }
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ Dialog v$d;
        final /* synthetic */ ProgressMonitor this$0;

        public final void run() {
            ProgressMonitor.mav$hideDialogLater(this.this$0, this.v$d);
        }

        public 1(ProgressMonitor progressMonitor, Dialog dialog) {
            this.v$d = dialog;
            this.this$0 = progressMonitor;
        }
    }

    private static class ProgressDialog
    extends DetailDialog {
        private boolean _cancelled;
        private JButton _cancelButton;

        private ProgressDialog(Dialog dialog, String string, int n) {
            super(dialog, string, ProgressDialog.adjustButtonMask(n));
            this.initializeDialog(n);
        }

        private ProgressDialog(Frame frame, String string, int n) {
            super(frame, string, ProgressDialog.adjustButtonMask(n));
            this.initializeDialog(n);
        }

        public boolean isCancelled() {
            return this._cancelled;
        }

        protected void dismissDialog(boolean bl) {
        }

        private void initializeDialog(int n) {
            this.setResizable(true);
            this.setDefaultCloseOperation(0);
            if ((n & 2) <= 0) {
                return;
            }
            this._cancelButton = new JButton((String)UIManager.get("OptionPane.cancelButtonText"));
            this.addCustomButton(this._cancelButton);
            this._cancelButton.addActionListener(new 1());
        }

        private JButton getCancelButton() {
            return this._cancelButton;
        }

        private static int adjustButtonMask(int n) {
            return (n & 2) > 0 ? n ^ 2 : n;
        }

        ProgressDialog(Dialog dialog, String string, int n, 1 var4_4) {
            this(dialog, string, n);
        }

        ProgressDialog(Frame frame, String string, int n, 1 var4_4) {
            this(frame, string, n);
        }

        static void wa$_cancelled(ProgressDialog progressDialog, boolean bl) {
            progressDialog._cancelled = bl;
        }

        static JButton mav$getCancelButton(ProgressDialog progressDialog) {
            return progressDialog.getCancelButton();
        }

        public final class 1
        implements ActionListener {
            public final void actionPerformed(ActionEvent actionEvent) {
                ProgressDialog.wa$_cancelled(ProgressDialog.this, true);
                ProgressDialog.mav$getCancelButton(ProgressDialog.this).setEnabled(false);
            }
        }
    }
}

