/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.dialogs.progress;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JProgressBar;
import javax.swing.UIManager;
import oracle.bali.ewt.util.WindowUtils;
import oracle.javatools.dialogs.DetailDialog;
import oracle.javatools.dialogs.DialogUtil;
import oracle.javatools.dialogs.progress.ProgressPanel;
import oracle.javatools.resource.ProgressBundle;

class AbstractProgressMonitor {
    private ProgressPanel _panel;
    private ProgressDialog _dialog;
    private Component _parentComponent;
    private String _title;
    private Component _detailContent;
    private int _millisToPopup;
    private boolean _cancellable;
    private boolean _closeOnFinish;
    private boolean _detailVisible;
    private boolean _barVisible;

    AbstractProgressMonitor(Component component, String string, Object object, String string2) {
        this._panel = new ProgressPanel(object, string2);
        this._parentComponent = component;
        this._title = string;
        this._cancellable = true;
        this._barVisible = true;
        this._closeOnFinish = true;
    }

    public void setCloseOnFinish(boolean bl) {
        this._closeOnFinish = bl;
    }

    public boolean getCloseOnFinish() {
        return this._closeOnFinish;
    }

    public synchronized void finish() {
        this.finishImpl(this._panel != null ? this._panel.getProgressBar() : null);
        if (this._closeOnFinish) {
            this.close();
        } else {
            this.changeToCloseState();
        }
    }

    public synchronized void close() {
        this.closeImpl();
    }

    public boolean isCanceled() {
        return this._dialog != null && this._dialog.isCancelled();
    }

    public void setMillisToPopup(int n) {
        this._millisToPopup = n;
    }

    public int getMillisToPopup() {
        return this._millisToPopup;
    }

    public void setDetailContent(Component component) {
        this._detailContent = component;
    }

    public Component getDetailContent() {
        return this._detailContent;
    }

    public void setDetailVisible(boolean bl) {
        this._detailVisible = bl;
    }

    public boolean isDetailVisible() {
        return this._detailVisible;
    }

    public void setBarVisible(boolean bl) {
        this._barVisible = bl;
    }

    public boolean isBarVisible() {
        return this._barVisible;
    }

    public void setCancellable(boolean bl) {
        this._cancellable = bl;
    }

    public boolean isCancellable() {
        return this._cancellable;
    }

    public synchronized void display() {
        if (this._dialog != null) {
            return;
        }
        this.displayImpl();
    }

    public Component getComponent() {
        return this._dialog;
    }

    public boolean isCancelled() {
        return this._dialog != null && this._dialog.isCancelled();
    }

    public void uncancel() {
        if (this._dialog != null) {
            this._dialog.setCancelled(false);
        }
    }

    public ProgressPanel getPanel() {
        return this._panel;
    }

    protected JProgressBar createProgressBar() {
        return new JProgressBar();
    }

    protected void displayImpl() {
        if (EventQueue.isDispatchThread()) {
            new IllegalStateException("Cannot display progress monitor from the AWT event thread.").printStackTrace();
        }
        this._dialog = this.createDialog();
        this.showDialogLater((Dialog)((Object)this._dialog));
    }

    protected void finishImpl(JProgressBar jProgressBar) {
    }

    protected void closeImpl() {
        if (this._dialog != null) {
            this.hideDialog((Dialog)((Object)this._dialog));
            this._dialog = null;
        }
        if (this._panel != null) {
            this._panel = null;
        }
    }

    private ProgressDialog createDialog() {
        if (this._barVisible) {
            this._panel.setProgressBar(this.createProgressBar());
        }
        ProgressDialog progressDialog = this.createDialogImpl();
        progressDialog.setContent(this._panel.getGUI());
        progressDialog.setDetailContent(this._detailContent);
        progressDialog.pack();
        progressDialog.setMinimumSize(progressDialog.getPreferredSize());
        progressDialog.setLocationRelativeTo(this._parentComponent);
        return progressDialog;
    }

    private ProgressDialog createDialogImpl() {
        Frame frame;
        int n = 0;
        if (this._cancellable) {
            n |= 2;
        }
        if (this._detailContent != null) {
            n |= 0x10;
        }
        DetailDialog detailDialog = null;
        Dialog dialog = DialogUtil.getAncestorDialog(this._parentComponent);
        if (dialog != null) {
            detailDialog = new ProgressDialog(dialog, this._title, n, this._closeOnFinish, null);
        }
        if (detailDialog == null && (frame = DialogUtil.getAncestorFrame(this._parentComponent)) != null) {
            detailDialog = new ProgressDialog(frame, this._title, n, this._closeOnFinish, null);
        }
        if (detailDialog == null) {
            throw new IllegalStateException("Parent for progress dialog not found.");
        }
        detailDialog.setDetailVisible(this._detailVisible);
        ((ProgressDialog)detailDialog).setCloseListener(new 3());
        return detailDialog;
    }

    private void showDialogLater(Dialog dialog) {
        if (EventQueue.isDispatchThread()) {
            return;
        }
        EventQueue.invokeLater(new 2(this, dialog));
    }

    private void hideDialog(Dialog dialog) {
        if (EventQueue.isDispatchThread()) {
            dialog.dispose();
            try {
                Thread.sleep(50);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return;
        }
        EventQueue.invokeLater(new 1(this, dialog));
    }

    private void changeToCloseState() {
        if (this._dialog != null) {
            this._dialog.changeToCloseState();
        }
    }

    private static ResourceBundle getBundle() {
        return ResourceBundle.getBundle(ProgressBundle.class.getName());
    }

    static void mav$hideDialog(AbstractProgressMonitor abstractProgressMonitor, Dialog dialog) {
        abstractProgressMonitor.hideDialog(dialog);
    }

    static ResourceBundle maS$getBundle() {
        return AbstractProgressMonitor.getBundle();
    }

    final class 3
    implements ActionListener {
        public final void actionPerformed(ActionEvent actionEvent) {
            AbstractProgressMonitor.this.close();
        }
    }

    final class 2
    implements Runnable {
        private final /* synthetic */ Dialog v$d;
        final /* synthetic */ AbstractProgressMonitor this$0;

        public final void run() {
            if (!this.v$d.getOwner().isVisible()) {
                return;
            }
            WindowUtils.registerWindow((Window)this.v$d);
            this.v$d.show();
        }

        public 2(AbstractProgressMonitor abstractProgressMonitor, Dialog dialog) {
            this.v$d = dialog;
            this.this$0 = abstractProgressMonitor;
        }
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ Dialog v$d;
        final /* synthetic */ AbstractProgressMonitor this$0;

        public final void run() {
            AbstractProgressMonitor.mav$hideDialog(this.this$0, this.v$d);
        }

        public 1(AbstractProgressMonitor abstractProgressMonitor, Dialog dialog) {
            this.v$d = dialog;
            this.this$0 = abstractProgressMonitor;
        }
    }

    private static final class ProgressDialog
    extends DetailDialog {
        private boolean _cancellable;
        private boolean _cancelled;
        private JButton _customButton;
        private boolean _closeState;
        private ActionListener _closeListener;
        private boolean _disposed;

        private ProgressDialog(Dialog dialog, String string, int n, boolean bl) {
            super(dialog, string, ProgressDialog.adjustButtonMask(n));
            this.initializeDialog(n, bl);
        }

        private ProgressDialog(Frame frame, String string, int n, boolean bl) {
            super(frame, string, ProgressDialog.adjustButtonMask(n));
            this.initializeDialog(n, bl);
        }

        public void setContent(Component component) {
            if (component != null) {
                super.setContent(component);
            }
        }

        public void dispose() {
            if (this._disposed) {
                return;
            }
            WindowUtils.unregisterWindow((Window)((Object)this));
            super.dispose();
            this._disposed = true;
        }

        void setCloseListener(ActionListener actionListener) {
            this._closeListener = actionListener;
        }

        public boolean isCancelled() {
            return this._cancelled;
        }

        void setCancelled(boolean bl) {
            if (!this._cancellable) {
                return;
            }
            this._cancelled = bl;
            if (this._closeState) {
                return;
            }
            if (this._customButton != null) {
                this._customButton.setEnabled(this._cancelled ^ true);
            }
        }

        void changeToCloseState() {
            if (this._closeState) {
                return;
            }
            if (this._customButton != null) {
                this._customButton.setEnabled(false);
            }
            this._closeState = true;
            this.changeToCloseButton();
        }

        protected void dismissDialog(boolean bl) {
        }

        private static final int adjustButtonMask(int n) {
            return (n & 2) > 0 ? n ^ 2 : n;
        }

        private void initializeDialog(int n, boolean bl) {
            this._cancellable = (n & 2) > 0;
            this.setResizable(true);
            this.setDefaultCloseOperation(0);
            if (!this._cancellable && bl) {
                return;
            }
            this._customButton = new JButton((String)UIManager.get("OptionPane.cancelButtonText"));
            this.addCustomButton(this._customButton);
            this._customButton.setEnabled(this._cancellable);
            this._customButton.addActionListener(new 2());
        }

        private void changeToCloseButton() {
            if (EventQueue.isDispatchThread()) {
                if (this._customButton != null) {
                    this._customButton.setText(AbstractProgressMonitor.maS$getBundle().getString("CLOSE_BUTTON_TEXT"));
                    this._customButton.setMnemonic(AbstractProgressMonitor.maS$getBundle().getString("CLOSE_BUTTON_MNEMONIC").charAt(0));
                    this._customButton.setEnabled(true);
                }
                return;
            }
            EventQueue.invokeLater(new 1());
        }

        ProgressDialog(Dialog dialog, String string, int n, boolean bl, 1 var5_5) {
            this(dialog, string, n, bl);
        }

        ProgressDialog(Frame frame, String string, int n, boolean bl, 1 var5_5) {
            this(frame, string, n, bl);
        }

        static boolean ra$_closeState(ProgressDialog progressDialog) {
            return progressDialog._closeState;
        }

        static ActionListener ra$_closeListener(ProgressDialog progressDialog) {
            return progressDialog._closeListener;
        }

        static void mav$changeToCloseButton(ProgressDialog progressDialog) {
            progressDialog.changeToCloseButton();
        }

        final class 2
        implements ActionListener {
            public final void actionPerformed(ActionEvent actionEvent) {
                if (ProgressDialog.ra$_closeState(ProgressDialog.this)) {
                    if (ProgressDialog.ra$_closeListener(ProgressDialog.this) != null) {
                        ProgressDialog.ra$_closeListener(ProgressDialog.this).actionPerformed(actionEvent);
                    }
                    return;
                }
                ProgressDialog.this.setCancelled(true);
            }
        }

        final class 1
        implements Runnable {
            public final void run() {
                ProgressDialog.mav$changeToCloseButton(ProgressDialog.this);
            }
        }
    }
}

