/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.dialogs.progress;

import java.awt.Component;
import java.awt.EventQueue;
import javax.swing.JProgressBar;
import oracle.javatools.dialogs.progress.AbstractProgressMonitor;

public class DeterminateProgressMonitor
extends AbstractProgressMonitor {
    private int _min;
    private int _max;
    private int _v;
    private int _millisToDecideToPopup;
    private int _reportDelta;
    private int _lastDisp;
    private long _T0;

    public DeterminateProgressMonitor(Component component, String string) {
        this(component, string, null, null, 0, 0);
    }

    public DeterminateProgressMonitor(Component component, String string, int n, int n2) {
        this(component, string, null, null, n, n2);
    }

    public DeterminateProgressMonitor(Component component, String string, Object object, String string2) {
        this(component, string, object, string2, 0, 0);
    }

    public DeterminateProgressMonitor(Component component, String string, Object object, String string2, int n, int n2) {
        super(component, string, object, string2);
        this._min = n;
        this._max = n2;
        this._v = this._min;
        this.recalculateReportDelta();
        this._T0 = System.currentTimeMillis();
    }

    public int getProgress() {
        return this._v;
    }

    public void incProgress() {
        this.incProgress(1);
    }

    public void incProgress(int n) {
        this.setProgress(this._v + n);
    }

    public void setProgress(int n) {
        if (EventQueue.isDispatchThread()) {
            new IllegalStateException("Cannot update progress monitor from the AWT event thread.").printStackTrace();
        }
        if (this._max <= this._min) {
            this.display();
            return;
        }
        this._v = n;
        if (n >= this._max) {
            this.finish();
            return;
        }
        if (n >= this._lastDisp + this._reportDelta) {
            this._lastDisp = n;
            JProgressBar jProgressBar = this.getPanel().getProgressBar();
            if (jProgressBar != null) {
                jProgressBar.setValue(n);
            } else {
                int n2;
                int n3;
                long l = System.currentTimeMillis();
                long l2 = (int)(l - this._T0);
                if (l2 >= (long)this._millisToDecideToPopup && (n3 = n > this._min ? (int)(l2 * (long)(this._max - this._min) / (long)(n - this._min)) : n2) >= (n2 = this.getMillisToPopup())) {
                    this.display();
                }
            }
        }
    }

    public int getMinimum() {
        return this._min;
    }

    public void setMinimum(int n) {
        this._min = n;
        JProgressBar jProgressBar = this.getPanel().getProgressBar();
        if (jProgressBar != null) {
            jProgressBar.setMaximum(n);
        }
        this.recalculateReportDelta();
    }

    public int getMaximum() {
        return this._max;
    }

    public void setMaximum(int n) {
        this._max = n;
        JProgressBar jProgressBar = this.getPanel().getProgressBar();
        if (jProgressBar != null) {
            jProgressBar.setMaximum(n);
        }
        this.recalculateReportDelta();
    }

    public void setMillisToDecideToPopup(int n) {
        this._millisToDecideToPopup = n;
    }

    public int getMillisToDecideToPopup() {
        return this._millisToDecideToPopup;
    }

    protected JProgressBar createProgressBar() {
        JProgressBar jProgressBar = super.createProgressBar();
        jProgressBar.setIndeterminate(false);
        jProgressBar.setMinimum(this._min);
        jProgressBar.setMaximum(this._max);
        jProgressBar.setValue(this._v);
        return jProgressBar;
    }

    protected void finishImpl(JProgressBar jProgressBar) {
        super.finishImpl(jProgressBar);
        if (jProgressBar == null) {
            return;
        }
        jProgressBar.setValue(jProgressBar.getMaximum());
    }

    private void recalculateReportDelta() {
        this._reportDelta = (this._max - this._min) / 100;
        if (this._reportDelta < 1) {
            this._reportDelta = 1;
        }
    }
}

