/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.dialogs.progress;

import java.awt.Component;
import javax.swing.JProgressBar;
import oracle.javatools.dialogs.progress.AbstractProgressMonitor;
import oracle.javatools.dialogs.progress.StoppableJProgressBar;

public class IndeterminateProgressMonitor
extends AbstractProgressMonitor {
    private boolean _started;
    private DelayThread _delayThread;

    public IndeterminateProgressMonitor(Component component, String string) {
        this(component, string, null, null);
    }

    public IndeterminateProgressMonitor(Component component, String string, Object object, String string2) {
        super(component, string, object, string2);
    }

    public synchronized void start() {
        if (this._started) {
            return;
        }
        this._started = true;
        int n = this.getMillisToPopup();
        if (n <= 0) {
            this.display();
            return;
        }
        this._delayThread = new 1(n);
        this._delayThread.start();
    }

    protected JProgressBar createProgressBar() {
        StoppableJProgressBar stoppableJProgressBar = new StoppableJProgressBar();
        stoppableJProgressBar.setIndeterminate(true);
        return stoppableJProgressBar;
    }

    protected void displayImpl() {
        super.displayImpl();
        this.stop();
    }

    protected void finishImpl(JProgressBar jProgressBar) {
        super.finishImpl(jProgressBar);
        this.stop();
        if (jProgressBar == null) {
            return;
        }
        ((StoppableJProgressBar)jProgressBar).stop();
    }

    protected void closeImpl() {
        super.closeImpl();
        this.stop();
    }

    private synchronized void stop() {
        if (this._delayThread == null) {
            return;
        }
        this._delayThread.exit();
        this._delayThread = null;
    }

    public final class 1
    extends DelayThread {
        protected final void runDelayed() {
            IndeterminateProgressMonitor.this.display();
        }

        public 1(int n) {
            super(n);
        }
    }

    private static abstract class DelayThread
    extends Thread {
        private final int _millisToPopup;
        private boolean _exit;

        DelayThread(int n) {
            this._millisToPopup = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            try {
                DelayThread delayThread = this;
                synchronized (delayThread) {
                    this.wait(this._millisToPopup);
                }
                Thread.yield();
                DelayThread delayThread2 = this;
                synchronized (delayThread2) {
                    if (this._exit) {
                        return;
                    }
                }
                this.runDelayed();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void exit() {
            DelayThread delayThread = this;
            synchronized (delayThread) {
                this._exit = true;
                this.notify();
            }
        }

        protected abstract void runDelayed();
    }
}

