/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.dialogs.progress;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.javatools.resource.ProgressBundle;

public class ProgressChecklist {
    private static final int MAXIMUM_TABLE_HEIGHT = 350;
    private static final int ICON_SIZE = 16;
    private static final int[] ADDITIONAL_CELL_SPACING = new int[]{0, 5, 5};
    private static final Icon CURRENT_ICON = new ImageIcon(ProgressBundle.class.getResource(ProgressChecklist.getBundle().getString("CURRENT_ICON")));
    private static final Icon TICK_ICON = new ImageIcon(ProgressBundle.class.getResource(ProgressChecklist.getBundle().getString("TICK_ICON")));
    private static final Icon FAILED_ICON = new ImageIcon(ProgressBundle.class.getResource(ProgressChecklist.getBundle().getString("FAILED_ICON")));
    private final JPanel _panel;
    private final ChecklistTable _table;
    private final JScrollPane _scrollPane;
    private final TableColumn _statusColumn;
    private final int _rowCount;
    private int _stepPosition;

    public ProgressChecklist(Object object, String[] stringArray) {
        Insets insets = new Insets(2, 2, 2, 2);
        JPanel jPanel = null;
        JPanel jPanel2 = new JPanel(new BorderLayout());
        if (object != null) {
            jPanel = new JPanel(new BorderLayout());
            Component component = object instanceof Component ? (Component)object : new JLabel(object.toString());
            jPanel.add(component, "North");
            jPanel.add(Box.createVerticalStrut(10), "Center");
        }
        JLabel jLabel = new JLabel(ProgressChecklist.getBundle().getString("STATUS_LABEL_TEXT"));
        jLabel.setDisplayedMnemonic((int)ProgressChecklist.getBundle().getString("STATUS_LABEL_MNEMONIC").charAt(0));
        this._rowCount = stringArray.length;
        Object[][] objectArray = new Object[this._rowCount][];
        int n = 0;
        while (n < objectArray.length) {
            objectArray[n] = new Object[]{null, stringArray[n], null};
            ++n;
        }
        DefaultTableModel defaultTableModel = new DefaultTableModel(objectArray, new Object[3]);
        this._table = new ChecklistTable(defaultTableModel);
        this._table.setShowGrid(true);
        this._table.setTableHeader(null);
        this._table.setDefaultRenderer(Object.class, new ChecklistTableCellRenderer());
        this._table.setAutoResizeMode(0);
        this._statusColumn = this._table.getColumnModel().getColumn(2);
        jLabel.setLabelFor(this._table);
        this._scrollPane = new JScrollPane(this._table);
        this._scrollPane.getViewport().setBackground(this._table.getBackground());
        jPanel2.add((Component)jLabel, "North");
        jPanel2.add((Component)this._scrollPane, "Center");
        JPanel jPanel3 = new JPanel();
        Dimension dimension = new Dimension(350, 0);
        this._panel = new JPanel(new BorderLayout());
        if (jPanel != null) {
            this._panel.add((Component)jPanel, "North");
        }
        this._panel.add((Component)jPanel2, "Center");
        this.reset();
        this.initializePreferredSize();
    }

    public Component getComponent() {
        return this._panel;
    }

    public void reset() {
        this._stepPosition = 0;
        int n = 0;
        while (n < this._rowCount) {
            this.setModelIconImpl(n, n == 0 ? CURRENT_ICON : new EmptyIcon(null));
            this.setModelStatusImpl(n, ProgressChecklist.getBundle().getString(n == 0 ? "STATUS_COLUMN_TEXT_IN_PROGRESS" : "STATUS_COLUMN_TEXT_PENDING"));
            ++n;
        }
        this._table.autoSizeColumnsToFit(ADDITIONAL_CELL_SPACING);
    }

    public void nextStep(boolean bl) {
        if (this._stepPosition >= this._rowCount) {
            return;
        }
        this.setModelIcon(this._stepPosition, bl ? TICK_ICON : FAILED_ICON);
        this.setModelStatus(this._stepPosition, ProgressChecklist.getBundle().getString(bl ? "STATUS_COLUMN_TEXT_SUCCEEDED" : "STATUS_COLUMN_TEXT_FAILED"));
        this.nextPosition();
    }

    public void abortSteps() {
        while (!this.isFinished()) {
            this.nextStep(false);
        }
    }

    public void setStatusColumnVisible(boolean bl) {
        EventQueue.invokeLater(new 3(this, bl));
    }

    private boolean isFinished() {
        return this._stepPosition >= this._rowCount;
    }

    private void nextPosition() {
        if (++this._stepPosition >= this._rowCount) {
            return;
        }
        this.setModelIcon(this._stepPosition, CURRENT_ICON);
        this.setModelStatus(this._stepPosition, ProgressChecklist.getBundle().getString("STATUS_COLUMN_TEXT_IN_PROGRESS"));
    }

    private void setModelIcon(int n, Icon icon) {
        EventQueue.invokeLater(new 2(this, n, icon));
    }

    private void setModelStatus(int n, String string) {
        EventQueue.invokeLater(new 1(this, n, string));
    }

    private void setModelIconImpl(int n, Icon icon) {
        this._table.getModel().setValueAt(icon, n, 0);
    }

    private void setModelStatusImpl(int n, String string) {
        this._table.getModel().setValueAt(string, n, 2);
    }

    private void initializePreferredSize() {
        Insets insets = this._scrollPane.getInsets();
        int n = this._table.getPreferredSize().width;
        n += this._scrollPane.getVerticalScrollBar().getPreferredSize().width;
        n += insets.left;
        n += insets.right;
        n = Math.max(n, 350);
        int n2 = this._table.getPreferredSize().height;
        n2 += insets.top;
        this._scrollPane.setPreferredSize(new Dimension(n, Math.min(n2 += insets.bottom, 350)));
    }

    private static ResourceBundle getBundle() {
        return ResourceBundle.getBundle(ProgressBundle.class.getName());
    }

    static ChecklistTable ra$_table(ProgressChecklist progressChecklist) {
        return progressChecklist._table;
    }

    static TableColumn ra$_statusColumn(ProgressChecklist progressChecklist) {
        return progressChecklist._statusColumn;
    }

    static void mav$setModelIconImpl(ProgressChecklist progressChecklist, int n, Icon icon) {
        progressChecklist.setModelIconImpl(n, icon);
    }

    static void mav$setModelStatusImpl(ProgressChecklist progressChecklist, int n, String string) {
        progressChecklist.setModelStatusImpl(n, string);
    }

    public final class 3
    implements Runnable {
        private final /* synthetic */ boolean v$visible;
        final /* synthetic */ ProgressChecklist this$0;

        public final void run() {
            ProgressChecklist.ra$_table(this.this$0).getColumnModel().removeColumn(ProgressChecklist.ra$_statusColumn(this.this$0));
            if (this.v$visible) {
                ProgressChecklist.ra$_table(this.this$0).getColumnModel().addColumn(ProgressChecklist.ra$_statusColumn(this.this$0));
            }
        }

        public 3(ProgressChecklist progressChecklist, boolean bl) {
            this.v$visible = bl;
            this.this$0 = progressChecklist;
        }
    }

    public final class 2
    implements Runnable {
        private final /* synthetic */ int v$row;
        private final /* synthetic */ Icon v$icon;
        final /* synthetic */ ProgressChecklist this$0;

        public final void run() {
            ProgressChecklist.mav$setModelIconImpl(this.this$0, this.v$row, this.v$icon);
        }

        public 2(ProgressChecklist progressChecklist, int n, Icon icon) {
            this.v$icon = icon;
            this.v$row = n;
            this.this$0 = progressChecklist;
        }
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ int v$row;
        private final /* synthetic */ String v$status;
        final /* synthetic */ ProgressChecklist this$0;

        public final void run() {
            ProgressChecklist.mav$setModelStatusImpl(this.this$0, this.v$row, this.v$status);
        }

        public 1(ProgressChecklist progressChecklist, int n, String string) {
            this.v$status = string;
            this.v$row = n;
            this.this$0 = progressChecklist;
        }
    }

    private static final class ChecklistTable
    extends NiceTable {
        private static final int MINIMUM_COLUMN_WIDTH = 5;

        ChecklistTable(TableModel tableModel) {
            super(tableModel);
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public void autoSizeColumnsToFit(int[] nArray) {
            int n = 0;
            while (n < this.getColumnModel().getColumnCount()) {
                int n2 = 5;
                TableColumn tableColumn = this.getColumnModel().getColumn(n);
                int n3 = 0;
                while (n3 < this.getModel().getRowCount()) {
                    Object object = this.getModel().getValueAt(n3, n);
                    TableCellRenderer tableCellRenderer = this.getCellRenderer(n3, n);
                    if (tableCellRenderer != null || object != null) {
                        int n4 = tableCellRenderer.getTableCellRendererComponent((JTable)this, (Object)object, (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().width;
                        if (nArray != null) {
                            n4 += nArray[n];
                        }
                        n2 = Math.max(n4, n2);
                    }
                    ++n3;
                }
                tableColumn.setPreferredWidth(n2);
                ++n;
            }
        }
    }

    private static final class ChecklistTableCellRenderer
    extends DefaultTableCellRenderer {
        private JLabel _iconRenderer;

        void $init$() {
            this._iconRenderer = new JLabel("");
        }

        ChecklistTableCellRenderer() {
            this.$init$();
            this._iconRenderer.setPreferredSize(new Dimension(16, 16));
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof Icon) {
                this._iconRenderer.setIcon((Icon)object);
                return this._iconRenderer;
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }

    private static final class EmptyIcon
    implements Icon {
        public int getIconHeight() {
            return 16;
        }

        public int getIconWidth() {
            return 16;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }

        private EmptyIcon() {
        }

        EmptyIcon(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

